@extends('layouts.employee')

@section('title', 'Operative Dossier')

@section('content')
    <div class="max-w-5xl mx-auto space-y-8">
        <form action="{{ route('employee.profile.update') }}" method="POST" class="space-y-8" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            @if ($errors->any())
                <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg shadow-sm">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-bold text-red-800 uppercase tracking-tight">System Alerts Detected</h3>
                            <div class="mt-2 text-xs text-red-700 font-semibold space-y-1">
                                <ul class="list-disc pl-5">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if (session('success'))
                <div class="bg-emerald-50 border-l-4 border-emerald-500 p-4 rounded-lg shadow-sm">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-bold text-emerald-800 uppercase tracking-tight">{{ session('success') }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Personal Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-8 py-6 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
                    <div>
                        <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Personal Information</h3>
                        <p class="text-xs text-gray-500 font-bold tracking-widest uppercase mt-1">General Identification &
                            Contact</p>
                    </div>
                    <!-- Profile Status Badge -->
                    <div class="flex items-center gap-2 bg-white px-3 py-1.5 rounded-lg border border-gray-200 shadow-sm">
                        <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                        <span class="text-[10px] font-bold text-gray-700 uppercase tracking-widest">Active Operative</span>
                    </div>
                </div>

                <div class="p-8 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- Locked Fields -->
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Operative ID
                            (Locked)</label>
                        <div
                            class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold flex items-center justify-between">
                            {{ $employee->employee_id }}
                            <svg class="w-4 h-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                </path>
                            </svg>
                        </div>
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Tactical
                            Email (Locked)</label>
                        <div
                            class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold flex items-center justify-between">
                            {{ $employee->email }}
                            <svg class="w-4 h-4 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                </path>
                            </svg>
                        </div>
                    </div>

                    <div>
                        <label
                            class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Designation</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold">
                            {{ $employee->jobRole->name ?? 'Unassigned' }}
                        </div>
                    </div>

                    <!-- Editable Fields -->
                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">First
                            Name</label>
                        <input type="text" name="first_name" value="{{ old('first_name', $employee->first_name) }}"
                            class="block w-full px-4 py-3 bg-white border @error('first_name') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('first_name')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Middle
                            Name</label>
                        <input type="text" name="middle_name" value="{{ old('middle_name', $employee->middle_name) }}"
                            class="block w-full px-4 py-3 bg-white border @error('middle_name') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('middle_name')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Last
                            Name</label>
                        <input type="text" name="last_name" value="{{ old('last_name', $employee->last_name) }}"
                            class="block w-full px-4 py-3 bg-white border @error('last_name') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('last_name')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>


                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Emergency
                            Contact</label>
                        <input type="text" name="emergency_number"
                            value="{{ old('emergency_number', $employee->emergency_number) }}"
                            class="block w-full px-4 py-3 bg-white border @error('emergency_number') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('emergency_number')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label
                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Gender</label>
                        <select name="gender"
                            class="block w-full px-4 py-3 bg-white border @error('gender') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm appearance-none">
                            <option value="Male" {{ $employee->gender == 'Male' ? 'selected' : '' }}>Male</option>
                            <option value="Female" {{ $employee->gender == 'Female' ? 'selected' : '' }}>Female</option>
                            <option value="Other" {{ $employee->gender == 'Other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('gender')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Date of
                            Birth</label>
                        <input type="date" name="dob" value="{{ old('dob', $employee->dob ? $employee->dob->format('Y-m-d') : '') }}"
                            class="block w-full px-4 py-3 bg-white border @error('dob') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('dob')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Marital
                            Status</label>
                        <select name="marital_status"
                            class="block w-full px-4 py-3 bg-white border @error('marital_status') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm appearance-none">
                            <option value="Single" {{ $employee->marital_status == 'Single' ? 'selected' : '' }}>Single
                            </option>
                            <option value="Married" {{ $employee->marital_status == 'Married' ? 'selected' : '' }}>Married
                            </option>
                            <option value="Divorced" {{ $employee->marital_status == 'Divorced' ? 'selected' : '' }}>Divorced
                            </option>
                            <option value="Widowed" {{ $employee->marital_status == 'Widowed' ? 'selected' : '' }}>Widowed
                            </option>
                        </select>
                        @error('marital_status')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Headquarters / Address -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Permanent Address</h3>
                    <p class="text-xs text-gray-500 font-bold tracking-widest uppercase mt-1">Permanent Physical Location
                    </p>
                </div>

                <div class="p-8 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Address Line
                            1</label>
                        <input type="text" name="permanent_address_line_1"
                            value="{{ old('permanent_address_line_1', $employee->permanent_address_line_1) }}"
                            class="block w-full px-4 py-3 bg-white border @error('permanent_address_line_1') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('permanent_address_line_1')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Address Line
                            2 (Optional)</label>
                        <input type="text" name="permanent_address_line_2"
                            value="{{ old('permanent_address_line_2', $employee->permanent_address_line_2) }}"
                            class="block w-full px-4 py-3 bg-white border @error('permanent_address_line_2') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('permanent_address_line_2')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">City</label>
                        <input type="text" name="permanent_city"
                            value="{{ old('permanent_city', $employee->permanent_city) }}"
                            class="block w-full px-4 py-3 bg-white border @error('permanent_city') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('permanent_city')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">State /
                            Province</label>
                        <select name="permanent_state_id"
                            class="block w-full px-4 py-3 bg-white border @error('permanent_state_id') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm appearance-none">
                            @foreach($states as $state)
                                <option value="{{ $state->id }}" {{ $employee->permanent_state_id == $state->id ? 'selected' : '' }}>{{ $state->name }}</option>
                            @endforeach
                        </select>
                        @error('permanent_state_id')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label
                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Country</label>
                        <select name="permanent_country_id"
                            class="block w-full px-4 py-3 bg-white border @error('permanent_country_id') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm appearance-none">
                            @foreach($countries as $country)
                                <option value="{{ $country->id }}" {{ $employee->permanent_country_id == $country->id ? 'selected' : '' }}>{{ $country->name }}</option>
                            @endforeach
                        </select>
                        @error('permanent_country_id')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Postal / Zip
                            Code</label>
                        <input type="text" name="permanent_zip_code"
                            value="{{ old('permanent_zip_code', $employee->permanent_zip_code) }}"
                            class="block w-full px-4 py-3 bg-white border @error('permanent_zip_code') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('permanent_zip_code')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Alternative Logistics / Corresponding Address -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Corresponding Address</h3>
                    <p class="text-xs text-gray-500 font-bold tracking-widest uppercase mt-1">Corresponding / Current Address
                    </p>
                </div>

                <div class="p-8 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Address Line
                            1</label>
                        <input type="text" name="corresponding_address_line_1"
                            value="{{ old('corresponding_address_line_1', $employee->corresponding_address_line_1) }}"
                            class="block w-full px-4 py-3 bg-white border @error('corresponding_address_line_1') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('corresponding_address_line_1')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Address Line
                            2 (Optional)</label>
                        <input type="text" name="corresponding_address_line_2"
                            value="{{ old('corresponding_address_line_2', $employee->corresponding_address_line_2) }}"
                            class="block w-full px-4 py-3 bg-white border @error('corresponding_address_line_2') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('corresponding_address_line_2')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">City</label>
                        <input type="text" name="corresponding_city"
                            value="{{ old('corresponding_city', $employee->corresponding_city) }}"
                            class="block w-full px-4 py-3 bg-white border @error('corresponding_city') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('corresponding_city')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">State /
                            Province</label>
                        <select name="corresponding_state_id"
                            class="block w-full px-4 py-3 bg-white border @error('corresponding_state_id') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm appearance-none">
                            <option value="">Select State</option>
                            @foreach($states as $state)
                                <option value="{{ $state->id }}" {{ $employee->corresponding_state_id == $state->id ? 'selected' : '' }}>{{ $state->name }}</option>
                            @endforeach
                        </select>
                        @error('corresponding_state_id')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label
                            class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Country</label>
                        <select name="corresponding_country_id"
                            class="block w-full px-4 py-3 bg-white border @error('corresponding_country_id') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm appearance-none">
                            <option value="">Select Country</option>
                            @foreach($countries as $country)
                                <option value="{{ $country->id }}" {{ $employee->corresponding_country_id == $country->id ? 'selected' : '' }}>{{ $country->name }}</option>
                            @endforeach
                        </select>
                        @error('corresponding_country_id')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Postal / Zip
                            Code</label>
                        <input type="text" name="corresponding_zip_code"
                            value="{{ old('corresponding_zip_code', $employee->corresponding_zip_code) }}"
                            class="block w-full px-4 py-3 bg-white border @error('corresponding_zip_code') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                        @error('corresponding_zip_code')
                            <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Skills & Qualifications -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Operational Qualifications</h3>
                    <p class="text-xs text-gray-500 font-bold tracking-widest uppercase mt-1">Verified Tactical Skills</p>
                </div>

                <div class="p-8">
                    @if($employee->skills->count() > 0)
                        <div class="flex flex-wrap gap-3">
                            @foreach($employee->skills as $skill)
                                <div
                                    class="px-4 py-2 bg-slate-100 rounded-lg border border-slate-200 text-slate-700 font-bold text-xs uppercase tracking-wider flex items-center gap-2">
                                    <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    {{ $skill->name }}
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-6 bg-gray-50 rounded-xl border border-dashed border-gray-200">
                            <p class="text-gray-400 text-xs font-bold uppercase tracking-widest">No verified skills recorded</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Licenses & Verification -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-8 py-6 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
                    <div>
                        <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Credential Verification</h3>
                        <p class="text-xs text-gray-500 font-bold tracking-widest uppercase mt-1">Licenses & Identification
                        </p>
                    </div>
                    <a href="{{ route('employee.profile.id_card') }}" target="_blank"
                        class="px-4 py-2 bg-slate-900 text-white text-[10px] font-bold uppercase tracking-widest rounded-lg hover:bg-black transition-colors flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0a2 2 0 104 0m-5 8a2 2 0 100-4 2 2 0 000 4zm0 0c1.306 0 2.417.835 2.83 2M9 14a3.001 3.001 0 00-2.83 2M15 11h3m-3 4h2">
                            </path>
                        </svg>
                        Digital ID Card
                    </a>
                </div>

                <div class="p-8 space-y-8">
                    <!-- Contact Numbers in Credential Verification as requested -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Primary Phone</label>
                            <input type="text" name="phone_number" value="{{ old('phone_number', $employee->phone_number) }}"
                                class="block w-full px-4 py-3 bg-white border @error('phone_number') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                            @error('phone_number')
                                <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Cell Number</label>
                            <input type="text" name="cell_number" value="{{ old('cell_number', $employee->cell_number) }}"
                                class="block w-full px-4 py-3 bg-white border @error('cell_number') border-red-300 @else border-gray-300 @enderror rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                            @error('cell_number')
                                <p class="mt-1 text-[10px] text-red-500 font-bold uppercase tracking-widest">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Main License -->
                    <div>
                        <h4 class="text-xs font-black text-slate-800 uppercase tracking-widest mb-4">Primary Security
                            License</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label
                                    class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">License
                                    Number</label>
                                <input type="text" name="license_number"
                                    value="{{ old('license_number', $employee->license_number) }}"
                                    class="block w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                            </div>
                            <div>
                                <label
                                    class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Expiry
                                    Date</label>
                                <div class="relative">
                                    <input type="date" name="license_expiry"
                                        value="{{ old('license_expiry', $employee->license_expiry) }}"
                                        class="block w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-gray-900 text-sm font-semibold focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm">
                                    @if($employee->license_expiry && \Carbon\Carbon::parse($employee->license_expiry)->isPast())
                                        <div class="absolute inset-y-0 right-0 pr-10 flex items-center pointer-events-none">
                                            <span
                                                class="text-[10px] text-red-500 font-black uppercase tracking-widest">Expired</span>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div>
                                <label
                                    class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Update
                                    License File</label>
                                <input type="file" name="file_license" accept=".pdf,.jpg,.jpeg,.png"
                                    class="block w-full px-4 py-2.5 bg-white border border-gray-300 rounded-lg text-gray-700 text-sm focus:outline-none focus:ring-2 focus:ring-slate-900/10 focus:border-slate-900 transition-all shadow-sm file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-xs file:font-semibold file:bg-gray-100 file:text-gray-700 hover:file:bg-gray-200">
                                @if($employee->file_license)
                                    <p class="mt-2 text-[10px] text-gray-500 font-medium">
                                        Current File: <a href="{{ asset('storage/' . $employee->file_license) }}"
                                            target="_blank" class="text-blue-600 hover:underline">View License</a>
                                    </p>
                                @endif
                            </div>

                            <div>
                                <label
                                    class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Issuing
                                    Authority</label>
                                <div
                                    class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-600 font-bold text-sm">
                                    {{ $employee->licence_issuing_province ?? 'N/A' }}
                                    <span class="text-[10px] text-gray-400 font-normal italic ml-2">(Contact Admin to
                                        change)</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Identifications -->
                    @if($employee->identifications->count() > 0)
                        <div class="border-t border-gray-100 pt-8">
                            <h4 class="text-xs font-black text-slate-800 uppercase tracking-widest mb-4">Additional Credentials
                            </h4>
                            <div class="grid grid-cols-1 gap-4">
                                @foreach($employee->identifications as $id)
                                    <div
                                        class="flex items-center justify-between p-4 bg-white border border-gray-200 rounded-lg hover:border-slate-300 transition-colors">
                                        <div>
                                            <p class="font-bold text-slate-800 text-sm">{{ $id->type }}</p>
                                            <p class="text-xs text-slate-500 font-medium mt-1">ID: {{ $id->identification_number }}
                                            </p>
                                        </div>
                                        <div class="text-right">
                                            <p class="text-[10px] font-black text-gray-400 uppercase tracking-widest mb-1">Expires
                                            </p>
                                            <div class="flex items-center gap-2 justify-end">
                                                <span class="text-xs font-bold text-slate-700">{{ $id->expiry_date }}</span>
                                                @if($id->expiry_date && \Carbon\Carbon::parse($id->expiry_date)->isPast())
                                                    <span class="w-2 h-2 rounded-full bg-red-500" title="Expired"></span>
                                                @else
                                                    <span class="w-2 h-2 rounded-full bg-emerald-500" title="Valid"></span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Work Fields (Read Only) -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Work Fields</h3>
                    <p class="text-xs text-gray-500 font-bold tracking-widest uppercase mt-1">Administrative Employment Data (Read Only)</p>
                </div>

                <div class="p-8 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Hiring Date</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold text-sm">
                            {{ $employee->employment_date ?? 'Not Set' }}
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Termination Date</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold text-sm">
                            {{ $employee->terminated_date ?? 'Active' }}
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Reporting Manager</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold text-sm">
                            {{ $employee->reporting_manager ?? 'N/A' }}
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">SIN Number</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold text-sm">
                            {{ $employee->sin_number ?? 'N/A' }}
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Fax</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold text-sm">
                            {{ $employee->fax ?? 'N/A' }}
                        </div>
                    </div>
                    <div>
                        <label class="block text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Tags</label>
                        <div class="px-4 py-3 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-bold text-sm">
                            {{ $employee->tags ?? 'N/A' }}
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end pt-2">
                <button type="submit"
                    class="bg-slate-900 hover:bg-black text-white font-bold px-8 py-4 rounded-xl shadow-sm active:scale-[0.98] transition-all flex items-center gap-3 uppercase tracking-widest text-xs">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    Update Profile
                </button>
            </div>
        </form>
    </div>
@endsection
