<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class EmployeePayoutController extends Controller
{
    use \App\Traits\CalculatesEarnings;

    public function index()
    {
        $employee = Auth::guard('employee')->user();

        // Fetch completed jobs with necessary pivot data (paginated)
        $payouts = $employee->schedules()
            ->whereNotNull('employee_schedule.actual_end_at')
            ->orderBy('employee_schedule.actual_end_at', 'desc')
            ->paginate(15);

        // Calculate total historical earnings (all time)
        $allCompleted = $employee->schedules()
            ->whereNotNull('employee_schedule.actual_end_at')
            ->whereNotNull('employee_schedule.actual_start_at')
            ->get();

        $totalEarnings = $allCompleted->sum(function ($schedule) {
            return $this->calculateGuardEarnings($schedule);
        });

        return view('employee.payouts', compact('payouts', 'totalEarnings'));
    }
}
