<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmployeeRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use App\Notifications\NewEmployeeRequestNotification;

class EmployeeRequestController extends Controller
{
    public function index()
    {
        $company_id = session('selected_company_id');
        $requests = EmployeeRequest::where('company_id', $company_id)
            ->with(['employee'])
            ->latest()
            ->paginate(20);

        return view('admin.employee-requests.index', compact('requests'));
    }

    public function show(EmployeeRequest $employeeRequest)
    {
        $employeeRequest->load(['replies.user', 'employee']);
        return view('admin.employee-requests.show', compact('employeeRequest'));
    }

    public function reply(Request $request, EmployeeRequest $employeeRequest)
    {
        $request->validate(['message' => 'required|string']);

        $employeeRequest->replies()->create([
            'user_id' => auth()->id(),
            'is_employee_reply' => false,
            'message' => $request->message
        ]);

        $employeeRequest->update(['status' => 'replied']);

        // Create notification for employee
        \App\Models\Notification::create([
            'company_id' => $employeeRequest->company_id,
            'employee_id' => $employeeRequest->employee_id,
            'title' => 'New Reply to Your Request',
            'message' => 'An administrator has replied to your request: ' . $employeeRequest->subject,
            'url' => route('employee.requests.show', $employeeRequest->id),
        ]);

        return back()->with('success', 'Reply sent.');
    }

    public function updateStatus(Request $request, EmployeeRequest $employeeRequest)
    {
        $request->validate(['status' => 'required|in:pending,replied,approved,rejected']);
        $employeeRequest->update(['status' => $request->status]);

        // Create notification for employee
        \App\Models\Notification::create([
            'company_id' => $employeeRequest->company_id,
            'employee_id' => $employeeRequest->employee_id,
            'title' => 'Request Status Updated',
            'message' => 'The status of your request "' . $employeeRequest->subject . '" has been updated to ' . $request->status . '.',
            'url' => route('employee.requests.show', $employeeRequest->id),
        ]);

        return back()->with('success', 'Status updated.');
    }
}
