<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmailSignature;
use App\Models\Company;
use Illuminate\Http\Request;

class EmailSignatureController extends Controller
{
    public function index(Request $request)
    {
        $query = EmailSignature::with('company');

        if ($request->company_id) {
            $query->where('company_id', $request->company_id);
        }

        $signatures = $query->paginate(100);
        $companies = Company::where('active', true)->orderBy('name')->get();

        return view('admin.email-signatures.index', compact('signatures', 'companies'));
    }

    public function create()
    {
        $companies = Company::where('active', true)->orderBy('name')->get();
        return view('admin.email-signatures.create', compact('companies'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'company_id' => 'required|exists:companies,id',
            'name' => 'required|string|max:255',
            'content' => 'required|string',
            'is_default' => 'boolean'
        ]);

        if ($request->is_default) {
            EmailSignature::where('company_id', $request->company_id)->update(['is_default' => false]);
        }

        EmailSignature::create($request->all());

        return redirect()->route('admin.email-signatures.index')->with('success', 'Email signature created successfully.');
    }

    public function edit(EmailSignature $emailSignature)
    {
        $companies = Company::where('active', true)->orderBy('name')->get();
        return view('admin.email-signatures.edit', compact('emailSignature', 'companies'));
    }

    public function update(Request $request, EmailSignature $emailSignature)
    {
        $request->validate([
            'company_id' => 'required|exists:companies,id',
            'name' => 'required|string|max:255',
            'content' => 'required|string',
            'is_default' => 'boolean'
        ]);

        if ($request->is_default) {
            EmailSignature::where('company_id', $request->company_id)
                ->where('id', '!=', $emailSignature->id)
                ->update(['is_default' => false]);
        }

        $emailSignature->update($request->all());

        return redirect()->route('admin.email-signatures.index')->with('success', 'Email signature updated successfully.');
    }

    public function destroy(EmailSignature $emailSignature)
    {
        $emailSignature->delete();
        return redirect()->route('admin.email-signatures.index')->with('success', 'Email signature deleted successfully.');
    }
}
