<?php

namespace App\Http\Controllers;

use App\Models\Notification;
use App\Models\Employee;
use App\Models\Schedule;
use App\Models\PatrollerSchedule;
use Illuminate\Http\Request;

class LocationRequestController extends Controller
{
    /**
     * Send location request notification to employee
     */
    public function sendRequest(Request $request)
    {
        $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'type' => 'required|in:static,patrol',
            'job_id' => 'required|integer',
        ]);

        $employee = Employee::findOrFail($request->employee_id);
        $companyId = session('selected_company_id');
        $userId = auth()->id();

        // Get job details
        if ($request->type === 'static') {
            $job = Schedule::findOrFail($request->job_id);
            $jobName = $job->site->name ?? 'Unknown Site';
            $jobRef = $job->duty_number;
        } else {
            $job = PatrollerSchedule::findOrFail($request->job_id);
            $jobName = $job->route->name ?? 'Unknown Route';
            $jobRef = $job->duty_number;
        }

        // Create notification
        Notification::create([
            'company_id' => $companyId,
            'user_id' => $userId,
            'employee_id' => $employee->id,
            'type' => 'location_request',
            'title' => '📍 Location & Evidence Request',
            'message' => "Please share your current location and upload evidence photos for {$jobName} ({$jobRef})",
            'url' => route('employee.location-request.show', [
                'employee_id' => $employee->id,
                'type' => $request->type,
                'job_id' => $request->job_id,
            ]),
            'is_read' => false,
        ]);

        return back()->with('success', "Location request sent to {$employee->first_name} {$employee->last_name}");
    }
}
