@extends('layouts.employee')

@section('title', 'Operational Reports')

@section('content')
    <div class="space-y-6">
        <!-- Filters and Actions -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('employee.reports.index') }}" class="flex flex-col gap-4">
                <input type="hidden" name="type" value="{{ $reportType }}">
                
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <!-- Date Range -->
                    <div>
                        <label class="block text-xs font-medium text-gray-500 mb-1">Start Date</label>
                        <input type="date" name="start_date" value="{{ request('start_date') }}" 
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-slate-500 focus:ring-slate-500">
                    </div>
                    <div>
                        <label class="block text-xs font-medium text-gray-500 mb-1">End Date</label>
                        <input type="date" name="end_date" value="{{ request('end_date') }}" 
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-slate-500 focus:ring-slate-500">
                    </div>

                    <!-- Site Filter -->
                    <div>
                        <label class="block text-xs font-medium text-gray-500 mb-1">Site</label>
                        <select name="site_id" class="w-full text-sm rounded-lg border-gray-300 focus:border-slate-500 focus:ring-slate-500">
                            <option value="">All Sites</option>
                            @foreach($sites as $site)
                                <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                    {{ $site->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Search -->
                    <div>
                        <label class="block text-xs font-medium text-gray-500 mb-1">Search or Duty #</label>
                        <div class="relative">
                            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search Duty #..."
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-slate-500 focus:ring-slate-500 pl-8">
                            <svg class="w-4 h-4 text-gray-400 absolute left-2.5 top-2.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row items-center justify-between gap-4 pt-2 border-t border-gray-100 mt-2">
                    <button type="submit" class="w-full md:w-auto px-6 py-2 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors">
                        Apply Filters
                    </button>
                    
                    <div class="flex gap-2 w-full md:w-auto">
                        <a href="{{ route('employee.reports.export.excel', request()->all()) }}" 
                           class="flex-1 md:flex-none flex items-center justify-center gap-2 px-4 py-2 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors">
                            <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            Export Excel
                        </a>
                        <a href="{{ route('employee.reports.export.pdf', request()->all()) }}" 
                           class="flex-1 md:flex-none flex items-center justify-center gap-2 px-4 py-2 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors">
                            <svg class="w-4 h-4 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            </svg>
                            Export PDF
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-gray-100 p-1 rounded-xl w-fit">
            @php
                // Preserve existing query params for tabs
                $queryParams = request()->except('type'); 
            @endphp
            <a href="{{ route('employee.reports.index', array_merge($queryParams, ['type' => 'checkin'])) }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'checkin' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Check-in Report
            </a>
            <a href="{{ route('employee.reports.index', array_merge($queryParams, ['type' => 'checkout'])) }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'checkout' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Checkout Report
            </a>
            <a href="{{ route('employee.reports.index', array_merge($queryParams, ['type' => 'combined'])) }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'combined' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Check-IN/OUT Report
            </a>
            <a href="{{ route('employee.reports.index', array_merge($queryParams, ['type' => 'scans'])) }}"
               class="px-4 py-2 text-sm font-medium rounded-lg transition-all {{ $reportType === 'scans' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700' }}">
                Checkpoint Scans
            </a>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            @if($reportType === 'scans_history')
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Time / Date</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Job / Site</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Checkpoint Info</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Scan Data / Evidence</th>
                            @else
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Job / Site</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Scheduled Start</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Scheduled End</th>
                                
                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Actual Infiltration (Start)</th>
                
                @if($reportType === 'checkout' || $reportType === 'combined' || $reportType === 'scans')
                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Actual Extraction (End)</th>
                @endif
                
                @if($reportType === 'scans')
                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Total Scans</th>
                @endif
                
                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Status</th>

                @if($reportType === 'scans')
                <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Detailed History</th>
                @endif
                            @endif
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($reports as $item)
                            @if($reportType === 'scans_history')
                                <tr class="hover:bg-gray-50/80 transition-colors">
                                    <td class="px-6 py-4 align-top">
                                        <div class="text-sm font-black text-gray-900">{{ $item->scanned_at->format('H:i:s') }}</div>
                                        <div class="text-[10px] font-bold text-gray-400 uppercase">{{ $item->scanned_at->format('M d, Y') }}</div>
                                    </td>
                                    <td class="px-6 py-4 align-top text-xs">
                                        <div class="font-bold text-gray-800">{{ $item->schedule->site->name ?? 'N/A' }}</div>
                                        <div class="mt-1 inline-flex items-center px-2 py-0.5 bg-slate-100 text-slate-500 rounded text-[9px] font-bold border border-slate-200">
                                            #{{ $item->schedule->duty_number ?? 'N/A' }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 align-top">
                                        <div class="flex flex-col gap-1">
                                            <span class="text-xs font-black text-blue-600 uppercase">{{ $item->checkpoint->name ?? 'Unknown Checkpoint' }}</span>
                                            <div class="flex items-center gap-2">
                                                @if($item->is_manual)
                                                    <span class="text-[8px] font-black bg-slate-100 text-slate-500 px-1.5 py-0.5 rounded border border-slate-200">MANUAL SCAN</span>
                                                @else
                                                    <span class="text-[8px] font-black bg-emerald-50 text-emerald-600 px-1.5 py-0.5 rounded border border-emerald-100 italic">VERIFIED QR</span>
                                                @endif
                                                @php
                                                    $opts = is_string($item->checkpoint->extra_scan_options) ? json_decode($item->checkpoint->extra_scan_options, true) : $item->checkpoint->extra_scan_options;
                                                    $type = $opts['type'] ?? 'log_only';
                                                @endphp
                                                <span class="text-[8px] font-black uppercase tracking-tighter opacity-40">{{ str_replace('_', ' ', $type) }}</span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 align-top">
                                        @if($type === 'message' && $item->employee_message)
                                            <div class="p-3 bg-blue-50/50 border border-blue-100 rounded-lg max-w-sm">
                                                <p class="text-xs text-blue-900 font-medium italic">"{{ $item->employee_message }}"</p>
                                            </div>
                                        @endif

                                        @if($type === 'photo')
                                            <div class="flex flex-wrap gap-2">
                                                @if($item->evidence_image)
                                                    <a href="{{ asset('storage/' . $item->evidence_image) }}" target="_blank" class="group relative">
                                                        <img src="{{ asset('storage/' . $item->evidence_image) }}" class="w-12 h-12 object-cover rounded-lg border-2 border-white shadow-sm group-hover:scale-110 transition-transform">
                                                    </a>
                                                @endif
                                                @if($item->additional_photos)
                                                    @foreach($item->additional_photos as $photo)
                                                        <a href="{{ asset('storage/' . $photo) }}" target="_blank" class="group relative">
                                                            <img src="{{ asset('storage/' . $photo) }}" class="w-12 h-12 object-cover rounded-lg border-2 border-white shadow-sm group-hover:scale-110 transition-transform">
                                                        </a>
                                                    @endforeach
                                                @endif
                                                @if(!$item->evidence_image && empty($item->additional_photos))
                                                    <span class="text-[10px] text-gray-400 italic">No photos attached</span>
                                                @endif
                                            </div>
                                        @endif

                                        @if($type === 'log_only')
                                            <span class="text-[10px] font-bold text-gray-300 uppercase tracking-widest italic">Protocol: Secure Log Only</span>
                                        @endif
                                    </td>
                                </tr>
                            @else
                                @php $item = (object) $item; @endphp
                                <tr class="hover:bg-gray-50/80 transition-colors">
                                    <td class="px-6 py-4 align-top text-xs">
                                        <div class="text-sm font-bold text-gray-900">{{ $item->site_name }}</div>
                                        <div class="flex items-center gap-1 mt-1">
                                            <span class="px-2 py-0.5 bg-gray-100 text-gray-500 rounded text-[10px] font-bold border border-gray-200">
                                                #{{ $item->duty_number }}
                                            </span>
                                            <span class="px-2 py-0.5 {{ $item->type === 'Guard' ? 'bg-blue-50 text-blue-600 border-blue-100' : 'bg-purple-50 text-purple-600 border-purple-100' }} rounded text-[10px] font-bold border">
                                                {{ $item->type }}
                                            </span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 align-top text-xs">
                                        <div class="font-medium text-gray-700">
                                            {{ \Carbon\Carbon::parse($item->from_datetime)->format('M d, Y H:i') }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 align-top text-xs">
                                        <div class="font-medium text-gray-700">
                                            {{ \Carbon\Carbon::parse($item->to_datetime)->format('M d, Y H:i') }}
                                        </div>
                                    </td>

                                    <td class="px-6 py-4 align-top text-xs">
                                        @if($item->actual_start_at)
                                            <div class="font-bold text-emerald-700 bg-emerald-50 px-2 py-1 rounded w-fit border border-emerald-100">
                                                {{ \Carbon\Carbon::parse($item->actual_start_at)->format('M d, Y H:i') }}
                                            </div>
                                        @else
                                            <span class="text-xs text-gray-400 italic">Pending</span>
                                        @endif
                                    </td>

                                    @if($reportType === 'checkout' || $reportType === 'combined' || $reportType === 'scans')
                                    <td class="px-6 py-4 align-top text-xs">
                                        @if($item->actual_end_at)
                                            <div class="font-bold text-indigo-700 bg-indigo-50 px-2 py-1 rounded w-fit border border-indigo-100">
                                                {{ \Carbon\Carbon::parse($item->actual_end_at)->format('M d, Y H:i') }}
                                            </div>
                                        @else
                                            <span class="text-xs text-gray-400 italic">In Progress</span>
                                        @endif
                                    </td>
                                    @endif

                                    @if($reportType === 'scans')
                                    <td class="px-6 py-4 align-top text-center text-xs">
                                        <div class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-blue-50 text-blue-700 font-black border border-blue-100 shadow-sm">
                                            {{ $item->scans_count }}
                                        </div>
                                    </td>
                                    @endif

                                    <td class="px-6 py-4 align-top text-xs">
                                        @php
                                            $statusConfig = [
                                                'completed' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'label' => 'Completed'],
                                                'active' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-700', 'label' => 'Active'],
                                                'upcoming' => ['bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'label' => 'Upcoming'],
                                                'missed' => ['bg' => 'bg-red-100', 'text' => 'text-red-700', 'label' => 'Missed'],
                                            ];
                                            $label = $item->status;
                                            $config = $statusConfig[$label] ?? ['bg' => 'bg-gray-100', 'text' => 'text-gray-700', 'label' => ucfirst($label)];
                                        @endphp
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $config['bg'] }} {{ $config['text'] }}">
                                            {{ $config['label'] }}
                                        </span>
                                    </td>

                                    @if($reportType === 'scans')
                                    <td class="px-6 py-4 align-top text-xs">
                                        @if($item->type === 'Guard')
                                        <div class="flex items-center gap-2">
                                            <a href="{{ route('employee.reports.index', ['type' => 'scans_history', 'schedule_id' => $item->id]) }}" 
                                               class="flex items-center gap-1.5 px-3 py-1.5 bg-blue-600 text-white rounded-lg font-black text-[9px] uppercase tracking-wider hover:bg-blue-700 transition-all shadow-sm shadow-blue-200">
                                                <span>VIEW SCANS</span>
                                            </a>
                                            <a href="{{ route('employee.reports.export.pdf', ['type' => 'scans_history', 'schedule_id' => $item->id]) }}" 
                                               class="p-1.5 bg-emerald-50 text-emerald-600 rounded-lg hover:bg-emerald-100 transition-all border border-emerald-100 shadow-sm"
                                               title="Download PDF">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                </svg>
                                            </a>
                                        </div>
                                        @else
                                            <span class="text-[10px] text-gray-400 italic">No scans for patroller</span>
                                        @endif
                                    </td>
                                    @endif
                                </tr>
                            @endif
                        @empty
                            <tr>
                                <td colspan="9" class="px-6 py-12 text-center text-gray-400">
                                    <div class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 border border-gray-200">
                                        <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    </div>
                                    <p class="text-xs font-bold uppercase tracking-wider">No records found for this report type</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($reports->hasPages())
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    {{ $reports->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection