<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

echo "Starting data truncation...\n\n";

try {
    // Disable foreign key checks
    DB::statement('SET FOREIGN_KEY_CHECKS=0');

    // Truncate schedules and related tables
    echo "Truncating schedules...\n";
    DB::table('schedules')->truncate();

    echo "Truncating employee_schedule (pivot table)...\n";
    DB::table('employee_schedule')->truncate();

    // Truncate incidents
    echo "Truncating incidents...\n";
    DB::table('incidents')->truncate();

    // Truncate activity logs related to schedules and incidents
    echo "Truncating activity logs for schedules and incidents...\n";
    DB::table('activity_logs')
        ->whereIn('subject_type', ['App\\Models\\Schedule', 'App\\Models\\Incident'])
        ->delete();

    // Re-enable foreign key checks
    DB::statement('SET FOREIGN_KEY_CHECKS=1');

    echo "\n✓ Successfully truncated all schedules, incidents, and related data!\n";
    echo "\nSummary:\n";
    echo "- Schedules: Cleared\n";
    echo "- Employee-Schedule assignments: Cleared\n";
    echo "- Incidents: Cleared\n";
    echo "- Related activity logs: Cleared\n";

} catch (\Exception $e) {
    DB::statement('SET FOREIGN_KEY_CHECKS=1');
    echo "\n✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
