

<?php $__env->startSection('title', 'Patroller Schedule Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="p-6">
        <div class="mb-6 flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Patroller Schedule Details</h1>
                <p class="text-gray-500">Details for Duty #<?php echo e($patrollerSchedule->duty_number); ?></p>
            </div>
            <div class="flex gap-3">
                <?php if(!$patrollerSchedule->isJobStarted() && $patrollerSchedule->job_status !== 'cancelled'): ?>
                <a href="<?php echo e(route('patroller-schedules.edit', $patrollerSchedule)); ?>"
                    class="px-6 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all flex items-center gap-2 text-sm shadow-md shadow-blue-500/20">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Edit Duty
                </a>
                
                <form action="<?php echo e(route('patroller-schedules.cancel', $patrollerSchedule)); ?>" method="POST"
                    onsubmit="return confirm('Are you sure you want to cancel this schedule?');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <button type="submit"
                        class="px-6 py-2 bg-red-50 text-red-600 font-bold rounded-lg hover:bg-red-100 transition-all text-sm border border-red-100">
                        Cancel Duty
                    </button>
                </form>
                <?php endif; ?>
                <a href="<?php echo e(route('patroller-schedules.index')); ?>"
                    class="px-6 py-2 bg-gray-100 text-gray-600 font-bold rounded-lg hover:bg-gray-200 transition-all text-sm">
                    Back to List
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Details Card -->
            <div class="lg:col-span-2 space-y-6">
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div class="space-y-4">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest">Duty Information</h3>
                            <div class="flex items-center gap-4">
                                <div>
                                    <div class="text-[10px] font-bold text-gray-400 uppercase">Status</div>
                                    <span class="px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-wider <?php echo e($patrollerSchedule->status_classes); ?>"><?php echo e($patrollerSchedule->calculated_status); ?></span>
                                </div>
                                <div>
                                    <div class="text-[10px] font-bold text-gray-400 uppercase">Schedule Date</div>
                                    <div class="text-sm font-bold text-gray-900"><?php echo e($patrollerSchedule->scheduled_date->format('M d, Y')); ?></div>
                                </div>
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <div class="text-[10px] font-bold text-gray-400 uppercase">Scheduled Start</div>
                                    <div class="text-sm font-bold text-gray-900">
                                        <?php echo e($patrollerSchedule->from_time->format('h:i A')); ?>

                                    </div>
                                </div>
                                <div>
                                    <div class="text-[10px] font-bold text-gray-400 uppercase">Scheduled End</div>
                                    <div class="text-sm font-bold text-gray-900">
                                        <?php echo e($patrollerSchedule->to_time->format('h:i A')); ?>

                                    </div>
                                </div>
                                <?php if($patrollerSchedule->job_started_at): ?>
                                <div>
                                    <div class="text-[10px] font-bold text-emerald-600 uppercase">Actual Start</div>
                                    <div class="text-sm font-bold text-gray-900">
                                        <?php echo e($patrollerSchedule->job_started_at->format('M d, h:i A')); ?>

                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if($patrollerSchedule->job_ended_at): ?>
                                <div>
                                    <div class="text-[10px] font-bold text-emerald-600 uppercase">Actual End</div>
                                    <div class="text-sm font-bold text-gray-900">
                                        <?php echo e($patrollerSchedule->job_ended_at->format('M d, h:i A')); ?>

                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Duration</div>
                                <div class="text-sm font-bold text-purple-600">
                                    <?php
                                        $duration = $patrollerSchedule->from_time->diffInMinutes($patrollerSchedule->to_time) / 60;
                                        $h = floor($duration);
                                        $m = round(($duration - $h) * 60);
                                    ?>
                                    <?php echo e($h); ?>h <?php echo e($m); ?>m (<?php echo e(number_format($duration, 2)); ?> hrs)
                                </div>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest">Billing Details</h3>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Route Rate</div>
                                <div class="text-sm font-bold text-emerald-600">$<?php echo e(number_format($patrollerSchedule->route_rate, 2)); ?> /hr</div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Total Billing (Est.)</div>
                                <div class="text-lg font-black text-slate-900">$<?php echo e(number_format($duration * $patrollerSchedule->route_rate, 2)); ?></div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Customer Ref</div>
                                <div class="text-sm font-bold text-gray-900"><?php echo e($patrollerSchedule->customer_reference ?: 'None'); ?></div>
                            </div>
                        </div>

                        <!-- Job Execution Report (Tickets & Sites) -->
                        <div class="md:col-span-2 border-t border-gray-100 pt-8 mt-4">
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <!-- Sites Visited -->
                                <div>
                                    <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-4">Sites Visited (<?php echo e($patrollerSchedule->jobSites->where('status', '!=', 'pending')->count()); ?>)</h3>
                                    <div class="space-y-3">
                                        <?php $__empty_1 = true; $__currentLoopData = $patrollerSchedule->jobSites->where('status', '!=', 'pending'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobSite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="bg-white rounded-xl border border-gray-100 p-3 shadow-sm hover:shadow-md transition-shadow relative overflow-hidden group">
                                                <?php if($jobSite->status == 'checked_in'): ?>
                                                    <div class="absolute top-0 right-0 w-2 h-2 bg-emerald-500 rounded-full m-2 animate-pulse" title="Personally Checked In"></div>
                                                <?php endif; ?>
                                                
                                                <div class="flex items-center gap-2 mb-2">
                                                    <div class="p-1 bg-gray-50 rounded-md text-gray-400 group-hover:bg-blue-50 group-hover:text-blue-500 transition-colors">
                                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                                    </div>
                                                    <div class="text-xs font-bold text-gray-900 line-clamp-1" title="<?php echo e(optional($jobSite->site)->name); ?>"><?php echo e(optional($jobSite->site)->name ?? 'Unknown Site'); ?></div>
                                                </div>

                                                <div class="flex justify-between items-end border-t border-gray-50 pt-2">
                                                    <div class="space-y-1.5">
                                                        <div class="flex items-center gap-1.5 text-[10px] text-gray-500">
                                                            <div class="w-4 flex justify-center"><span class="w-1.5 h-1.5 rounded-full bg-emerald-500"></span></div>
                                                            <span class="font-medium w-6">IN:</span>
                                                            <span class="text-gray-900 font-bold bg-emerald-50 px-1.5 rounded text-[10px]"><?php echo e($jobSite->checked_in_at ? $jobSite->checked_in_at->format('h:i A') : '--'); ?></span>
                                                        </div>
                                                        <div class="flex items-center gap-1.5 text-[10px] text-gray-500">
                                                            <div class="w-4 flex justify-center"><span class="w-1.5 h-1.5 rounded-full bg-slate-400"></span></div>
                                                            <span class="font-medium w-6">OUT:</span>
                                                            <span class="text-gray-900 font-bold bg-slate-50 px-1.5 rounded text-[10px]"><?php echo e($jobSite->checked_out_at ? $jobSite->checked_out_at->format('h:i A') : '--'); ?></span>
                                                        </div>
                                                    </div>
                                                    
                                                    <?php if($jobSite->checked_in_at && $jobSite->checked_out_at): ?>
                                                         <div class="text-[9px] text-gray-400 font-medium bg-gray-50 px-1.5 py-0.5 rounded border border-gray-100 whitespace-nowrap">
                                                            <?php echo e(number_format($jobSite->checked_in_at->floatDiffInMinutes($jobSite->checked_out_at), 2)); ?> min
                                                         </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <p class="text-xs text-gray-400 italic">No sites visited yet.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Tickets Issued -->
                                <div>
                                    <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-4">Tickets Issued (<?php echo e($patrollerSchedule->issueTickets->count()); ?>)</h3>
                                    <div class="space-y-3">
                                        <?php $__empty_1 = true; $__currentLoopData = $patrollerSchedule->issueTickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="bg-white rounded-xl border border-red-100 p-4 shadow-sm hover:shadow-md transition-shadow">
                                                <div class="flex items-start gap-3 mb-3">
                                                    <div class="w-8 h-8 rounded-full bg-red-50 text-red-500 flex items-center justify-center shrink-0">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v22m0-22l-2-2m2 2l2-2M5 5a2 2 0 012-2h10a2 2 0 012 2v14l-5-5l-5 5V5z"></path></svg>
                                                    </div>
                                                    <div class="flex-1 min-w-0">
                                                        <div class="flex justify-between items-start">
                                                            <h4 class="text-sm font-bold text-gray-900">Ticket #<?php echo e($ticket->ticket_number ?? $ticket->id); ?></h4>
                                                            <span class="text-[10px] font-bold text-red-600 bg-red-50 px-2 py-1 rounded-full"><?php echo e($ticket->created_at->format('h:i A')); ?></span>
                                                        </div>
                                                        <div class="text-xs text-gray-500 mt-1">
                                                            <span class="font-medium text-gray-400 uppercase text-[10px]">Site:</span> 
                                                            <span class="font-bold text-gray-800"><?php echo e(optional($ticket->site)->name ?? 'Unknown Site'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>

                                                <?php if($ticket->description): ?>
                                                    <div class="p-3 bg-gray-50 rounded-lg text-xs text-gray-600 italic mb-3 border border-gray-100 leading-relaxed">
                                                        "<?php echo e($ticket->description); ?>"
                                                    </div>
                                                <?php endif; ?>

                                                <?php if(!empty($ticket->images) && is_array($ticket->images)): ?>
                                                    <div class="mt-3">
                                                        <div class="text-[10px] font-bold text-gray-400 uppercase mb-2">Evidence Images</div>
                                                        <div class="flex gap-2 overflow-x-auto pb-1">
                                                            <?php $__currentLoopData = $ticket->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <a href="<?php echo e(asset('storage/'.$image)); ?>" target="_blank" class="shrink-0 block w-16 h-16 rounded-lg overflow-hidden border border-gray-200 shadow-sm group">
                                                                    <img src="<?php echo e(asset('storage/'.$image)); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                                                                </a>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <p class="text-xs text-gray-400 italic">No tickets issued.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                             </div>
                        </div>

                        <!-- Personnel & Individual Rates Table -->
                        <div class="md:col-span-2 border-t border-gray-100 pt-8">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-6">Assigned Patrollers & Rates</h3>
                            <div class="space-y-6">
                                <?php $__currentLoopData = $patrollerSchedule->employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="bg-purple-50/50 rounded-3xl p-6 border border-purple-100">
                                        <div class="flex flex-col md:flex-row md:items-center justify-between gap-6">
                                            <!-- Patroller Identity -->
                                            <div class="flex items-center gap-4">
                                                <?php if($employee->profile_picture): ?>
                                                    <img src="<?php echo e(asset('storage/' . $employee->profile_picture)); ?>" class="w-12 h-12 rounded-full object-cover ring-4 ring-white shadow-sm">
                                                <?php else: ?>
                                                    <div class="w-12 h-12 rounded-full bg-purple-200 text-purple-600 flex items-center justify-center font-bold text-xs border border-white shadow-sm">
                                                        <?php echo e(substr($employee->first_name, 0, 1)); ?><?php echo e(substr($employee->last_name, 0, 1)); ?>

                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <div class="text-sm font-bold text-gray-900"><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></div>
                                                    <div class="text-[10px] text-gray-400 font-bold uppercase"><?php echo e($employee->employee_id); ?></div>
                                                </div>
                                            </div>

                                            <!-- Rates Row -->
                                            <div class="flex items-center gap-8 border-l border-purple-200 pl-8">
                                                <?php
                                                    $employeeWageTypes = json_decode($employee->pivot->wage_types, true) ?: [];
                                                    $totalPatrollerPayout = 0;
                                                    foreach($employeeWageTypes as $ewt) {
                                                        $totalPatrollerPayout += ($ewt['rate'] ?? 0) * ($ewt['allocated_hours'] ?? 0);
                                                    }
                                                    $totalPatrollerPayout += ($employee->pivot->gas_rate ?? 0);
                                                    $totalPatrollerPayout += ($employee->pivot->allowance ?? 0);
                                                    $totalPatrollerPayout += ($employee->pivot->other_expense ?? 0);
                                                ?>
                                                <div>
                                                    <div class="text-[10px] font-bold text-gray-400 uppercase mb-1">Total Payout</div>
                                                    <div class="text-sm font-bold text-purple-600">$<?php echo e(number_format($totalPatrollerPayout, 2)); ?></div>
                                                </div>

                                                <?php if($employee->pivot->gas_rate): ?>
                                                    <div>
                                                        <div class="text-[10px] font-bold text-gray-400 uppercase mb-1">GAS Rate</div>
                                                        <div class="text-sm font-bold text-amber-600">$<?php echo e(number_format($employee->pivot->gas_rate, 2)); ?></div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if($employee->pivot->allowance): ?>
                                                    <div>
                                                        <div class="text-[10px] font-bold text-gray-400 uppercase mb-1">Allowance</div>
                                                        <div class="text-sm font-bold text-blue-600">$<?php echo e(number_format($employee->pivot->allowance, 2)); ?></div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <!-- Wage Components List -->
                                        <?php if(!empty($employeeWageTypes)): ?>
                                            <div class="mt-6 pt-4 border-t border-purple-100/50">
                                                <div class="text-[10px] font-bold text-gray-400 uppercase mb-3 px-1">Active Components</div>
                                                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3">
                                                    <?php $__currentLoopData = $employeeWageTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ewt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="p-3 bg-white border border-purple-100 rounded-xl shadow-sm space-y-2">
                                                            <div class="flex justify-between items-center">
                                                                <span class="text-[11px] font-bold text-gray-700"><?php echo e($ewt['name'] ?? 'Wage Component'); ?></span>
                                                                <span class="text-[10px] font-bold text-purple-500">$<?php echo e(number_format($ewt['rate'], 2)); ?>/hr</span>
                                                            </div>
                                                            <div class="flex justify-between items-center text-[10px]">
                                                                <span class="text-gray-400 uppercase font-bold">Allocation</span>
                                                                <span class="text-gray-900 font-bold"><?php echo e($ewt['allocated_hours'] ?? 0); ?> hrs</span>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <?php if($patrollerSchedule->comments): ?>
                            <div class="md:col-span-2 border-t border-gray-100 pt-6">
                                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Instructions / Comments</h3>
                                <div class="p-4 bg-amber-50 text-amber-800 rounded-xl text-sm italic border border-amber-100">
                                    "<?php echo e($patrollerSchedule->comments); ?>"
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Sidebar Info -->
            <div class="space-y-6">
                <!-- Route Card -->
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-4 bg-purple-800 text-white font-bold text-xs uppercase tracking-widest">Route Information</div>
                    <div class="p-8">
                        <div class="w-12 h-12 bg-purple-50 text-purple-600 rounded-xl flex items-center justify-center font-bold text-lg mb-4">
                            <?php echo e(substr($patrollerSchedule->route->name, 0, 1)); ?>

                        </div>
                        <h4 class="text-lg font-bold text-gray-900 mb-2"><?php echo e($patrollerSchedule->route->name); ?></h4>
                        <?php
                            $description = $patrollerSchedule->route->description ?? '';
                            $isPlaceholder = empty($description) || 
                                           stripos($description, 'lorem') !== false || 
                                           stripos($description, 'ipsum') !== false ||
                                           stripos($description, 'dolor') !== false;
                        ?>
                        <?php if(!$isPlaceholder): ?>
                        <div class="flex items-start gap-2 text-gray-500 mb-6">
                             <svg class="w-4 h-4 mt-0.5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"></path></svg>
                             <p class="text-xs leading-relaxed"><?php echo e($description); ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if($patrollerSchedule->route->route_id): ?>
                        <div class="p-4 bg-gray-50 rounded-xl flex justify-between items-center mb-4">
                            <span class="text-[10px] font-bold text-gray-400 uppercase">Route ID</span>
                            <span class="text-xs font-bold text-gray-900"><?php echo e($patrollerSchedule->route->route_id); ?></span>
                        </div>
                        <?php endif; ?>

                        <?php if($patrollerSchedule->route->sites && $patrollerSchedule->route->sites->count() > 0): ?>
                        <div class="border-t border-gray-100 pt-4 mt-4">
                            <h5 class="text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-3">Sites on Route (<?php echo e($patrollerSchedule->route->sites->count()); ?>)</h5>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $patrollerSchedule->route->sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-start gap-2 p-2 bg-purple-50/50 rounded-lg border border-purple-100/50 hover:bg-purple-50 transition-colors">
                                        <div class="w-6 h-6 bg-purple-100 text-purple-600 rounded flex items-center justify-center font-bold text-[10px] shrink-0 mt-0.5">
                                            <?php echo e(substr($site->name, 0, 1)); ?>

                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <div class="text-xs font-bold text-gray-900 truncate"><?php echo e($site->name); ?></div>
                                            <?php if($site->address_line_1 || $site->city): ?>
                                            <div class="text-[10px] text-gray-500 truncate">
                                                <?php echo e($site->address_line_1); ?><?php echo e($site->city ? ', ' . $site->city : ''); ?>

                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/patroller-schedules/show.blade.php ENDPATH**/ ?>