<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Operational Report #<?php echo e($report->duty_number); ?></title>
    <style>
        body {
            font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
            line-height: 1.5;
            color: #333;
        }

        .header {
            border-bottom: 2px solid #1e293b;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #1e293b;
            text-transform: uppercase;
        }

        .title {
            font-size: 18px;
            font-weight: bold;
            margin-top: 10px;
            color: #64748b;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
            color: #64748b;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 5px;
            margin-bottom: 15px;
        }

        .grid {
            width: 100%;
            border-collapse: collapse;
        }

        .grid td {
            vertical-align: top;
            padding: 5px 0;
        }

        .label {
            font-weight: bold;
            color: #64748b;
            width: 140px;
        }

        .value {
            color: #0f172a;
            font-weight: 500;
        }

        .status-badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .status-badge.completed {
            background-color: #d1fae5;
            color: #047857;
        }

        .status-badge.active {
            background-color: #dbeafe;
            color: #1e40af;
        }

        .images-grid {
            width: 100%;
            margin-top: 10px;
        }

        .images-grid td {
            width: 33.33%;
            padding: 5px;
            text-align: center;
        }

        .evidence-img {
            width: 100%;
            height: auto;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
        }

        .no-image {
            padding: 30px;
            background: #f8fafc;
            color: #94a3b8;
            font-style: italic;
            text-align: center;
            border-radius: 4px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 10px;
            text-align: center;
            color: #94a3b8;
            border-top: 1px solid #e2e8f0;
            padding-top: 10px;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="logo"><?php echo e($company->name ?? 'Vanguard Security'); ?></div>
        <div class="title">
            <?php if(isset($reportType) && $reportType === 'scans_history'): ?>
                Checkpoint Scan History Detail
            <?php else: ?>
                Operational Shift Report
            <?php endif; ?>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Schedule Information</div>
        <table class="grid">
            <tr>
                <td class="label">Duty Number:</td>
                <td class="value">#<?php echo e($report->duty_number); ?></td>
                <td class="label">Status:</td>
                <td class="value">
                    <span class="status-badge <?php echo e($report->status); ?>"><?php echo e(ucfirst($report->status)); ?></span>
                </td>
            </tr>
            <tr>
                <td class="label">Date:</td>
                <td class="value"><?php echo e(\Carbon\Carbon::parse($report->schedule_date)->format('F d, Y')); ?></td>
                <td class="label">Site:</td>
                <td class="value"><?php echo e($report->site_name); ?></td>
            </tr>
            <tr>
                <td class="label">Scheduled Time:</td>
                <td class="value">
                    <?php echo e(\Carbon\Carbon::parse($report->from_datetime)->format('H:i')); ?> -
                    <?php echo e(\Carbon\Carbon::parse($report->to_datetime)->format('H:i')); ?>

                </td>
                <td class="label">Location:</td>
                <td class="value"><?php echo e($report->site_address ?? 'N/A'); ?></td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Operative Details</div>
        <table class="grid">
            <tr>
                <td class="label">Employee Name:</td>
                <td class="value"><?php echo e($report->first_name); ?> <?php echo e($report->last_name); ?></td>
            </tr>
            <tr>
                <td class="label">Employee ID:</td>
                <td class="value"><?php echo e($report->employee_id); ?></td>
            </tr>
            <tr>
                <td class="label">Role:</td>
                <td class="value"><?php echo e($report->job_role ?? 'Security Officer'); ?></td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Attendance & Timestamps</div>
        <table class="grid">
            <tr>
                <td class="label">Actual Start:</td>
                <td class="value">
                    <?php if($report->actual_start_at): ?>
                        <?php echo e(\Carbon\Carbon::parse($report->actual_start_at)->format('M d, Y H:i:s')); ?>

                    <?php else: ?>
                        --
                    <?php endif; ?>
                </td>
                <td class="label">Check-in Location:</td>
                <td class="value"><?php echo e($report->checkin_coordinates ?? 'GPS Not Recorded'); ?></td>
            </tr>
            <tr>
                <td class="label">Actual End:</td>
                <td class="value">
                    <?php if($report->actual_end_at): ?>
                        <?php echo e(\Carbon\Carbon::parse($report->actual_end_at)->format('M d, Y H:i:s')); ?>

                    <?php else: ?>
                        --
                    <?php endif; ?>
                </td>
                <td class="label">Checkout Location:</td>
                <td class="value"><?php echo e($report->checkout_coordinates ?? 'GPS Not Recorded'); ?></td>
            </tr>
            <tr>
                <td class="label">Total Duration:</td>
                <td class="value">
                    <?php if($report->actual_start_at && $report->actual_end_at): ?>
                        <?php echo e(round(\Carbon\Carbon::parse($report->actual_start_at)->diffInMinutes($report->actual_end_at) / 60, 2)); ?>

                        Hours
                    <?php else: ?>
                        --
                    <?php endif; ?>
                </td>
            </tr>
        </table>
    </div>

    <?php if(isset($reportType) && $reportType === 'scans_history'): ?>
        <div class="section">
            <div class="section-title">Scan History</div>
            <?php if(isset($scans) && count($scans) > 0): ?>
                <table class="grid" style="border: 1px solid #e2e8f0;">
                    <thead>
                        <tr style="background-color: #f8fafc; border-bottom: 2px solid #e2e8f0;">
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 10%;">
                                TIME / DATE</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 20%;">
                                MISSION / SITE</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 15%;">
                                CHECKPOINT</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 10%;">
                                METHOD</th>
                            <th
                                style="padding: 8px; text-align: left; font-size: 10px; color: #64748b; font-weight: bold; width: 45%;">
                                SCAN PROTOCOL DATA</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $scans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr style="border-bottom: 1px solid #e2e8f0;">
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-weight: bold; color: #0f172a;">
                                        <?php echo e(\Carbon\Carbon::parse($scan->scanned_at)->format('H:i:s')); ?>

                                    </div>
                                    <div style="font-size: 10px; color: #64748b;">
                                        <?php echo e(\Carbon\Carbon::parse($scan->scanned_at)->format('M d, Y')); ?>

                                    </div>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-weight: bold; color: #0f172a;"><?php echo e($report->site_name); ?></div>
                                    <div style="font-size: 10px; color: #64748b;">Duty #<?php echo e($report->duty_number); ?></div>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-weight: bold; color: #0f172a;"><?php echo e($scan->checkpoint_name); ?></div>
                                    <?php if($scan->tour_route_name): ?>
                                        <div style="font-size: 10px; color: #64748b;">Route: <?php echo e($scan->tour_route_name); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <div style="font-size: 10px; font-weight: bold; color: #475569; text-transform: uppercase;">
                                        <?php echo e($scan->is_manual ? 'MANUAL' : 'SCAN'); ?>

                                    </div>
                                </td>
                                <td style="padding: 8px; vertical-align: top;">
                                    <?php if($scan->employee_message): ?>
                                        <div
                                            style="margin-bottom: 5px; font-style: italic; color: #334155; background: #f1f5f9; padding: 5px; border-radius: 4px;">
                                            <span style="font-weight: bold; font-size: 9px; color: #64748b;">OBSERVATION:</span><br>
                                            <?php echo e($scan->employee_message); ?>

                                        </div>
                                    <?php endif; ?>

                                    <?php
                                        $scanImages = json_decode($scan->additional_photos ?? '[]', true);
                                    ?>
                                    <?php if(!empty($scanImages)): ?>
                                        <div style="display: block;">
                                            <?php $__currentLoopData = $scanImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <img src="<?php echo e(storage_path('app/public/' . $img)); ?>"
                                                    style="width: 80px; height: auto; border: 1px solid #ccc; border-radius: 3px; display: inline-block; margin-right: 5px; margin-bottom: 5px;">
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(empty($scan->employee_message) && empty($scanImages)): ?>
                                        <div style="font-size: 10px; color: #94a3b8; font-style: italic;">Verified Log Only</div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="no-image">No checkpoint scans recorded for this schedule.</div>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="section">
            <div class="section-title">Check-in Evidence</div>
            <?php
                $checkinImages = json_decode($report->checkin_images, true);
                $webpSupported = function_exists('imagecreatefromwebp');
            ?>
            <?php if(!empty($checkinImages)): ?>
                <table class="images-grid">
                    <tr>
                        <?php $__currentLoopData = $checkinImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php
                                    $path = storage_path('app/public/' . $img);
                                    $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
                                    $isWebP = $ext === 'webp';
                                    $fileOk = file_exists($path);
                                ?>

                                <?php if($fileOk): ?>
                                    <?php if($isWebP && !$webpSupported): ?>
                                        <div class="no-image" style="font-size: 10px; color: #ef4444;">
                                            Image format (WebP) not supported by server.<br>
                                            Please contact admin to enable php_gd webp support.
                                        </div>
                                    <?php else: ?>
                                        <img src="<?php echo e($path); ?>" class="evidence-img">
                                    <?php endif; ?>
                                <?php else: ?>
                                    <div class="no-image">Image Not Found</div>
                                <?php endif; ?>
                            </td>
                            <?php if(($loop->index + 1) % 3 == 0 && !$loop->last): ?>
                                </tr>
                                <tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </table>
            <?php else: ?>
                <div class="no-image">No check-in evidence photos recorded.</div>
            <?php endif; ?>
        </div>

        <div class="section">
            <div class="section-title">Checkout Evidence</div>
            <?php
                $checkoutImages = json_decode($report->checkout_evidence, true);
            ?>
            <?php if(!empty($checkoutImages)): ?>
                <table class="images-grid">
                    <tr>
                        <?php $__currentLoopData = $checkoutImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php
                                    $path = storage_path('app/public/' . $img);
                                    $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
                                    $isWebP = $ext === 'webp';
                                    $fileOk = file_exists($path);
                                ?>

                                <?php if($fileOk): ?>
                                    <?php if($isWebP && !$webpSupported): ?>
                                        <div class="no-image" style="font-size: 10px; color: #ef4444;">
                                            Image format (WebP) not supported by server.<br>
                                            Please contact admin to enable php_gd webp support.
                                        </div>
                                    <?php else: ?>
                                        <img src="<?php echo e($path); ?>" class="evidence-img">
                                    <?php endif; ?>
                                <?php else: ?>
                                    <div class="no-image">Image Not Found</div>
                                <?php endif; ?>
                            </td>
                            <?php if(($loop->index + 1) % 3 == 0 && !$loop->last): ?>
                                </tr>
                                <tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </table>
            <?php else: ?>
                <div class="no-image">No checkout evidence photos recorded.</div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <div class="footer">
        Generated on <?php echo e(now()->format('M d, Y H:i')); ?> | <?php echo e($company->name ?? 'Vanguard Security'); ?>

    </div>
</body>

</html><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/reports/operational/single_pdf.blade.php ENDPATH**/ ?>