

<?php $__env->startSection('title', 'Route Payout Report'); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $routePrefix = request()->routeIs('admin.*') ? 'admin.reports.patroller' : 'reports.patroller';
    ?>

    <div class="space-y-6">
        <!-- Navigation Tabs -->
        <div class="flex space-x-2 border-b border-gray-200 pb-2 overflow-x-auto">
            <a href="<?php echo e(route($routePrefix . '.index')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.index') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                In/Out Report
            </a>
            <a href="<?php echo e(route($routePrefix . '.tickets')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Ticket Reports
            </a>
            <a href="<?php echo e(route($routePrefix . '.monthly_tickets')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.monthly_tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Monthly Ticket Chart
            </a>
            <a href="<?php echo e(route($routePrefix . '.payout')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Patroller Payout
            </a>
            <a href="<?php echo e(route($routePrefix . '.route_payout')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.route_payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Route Payout
            </a>
            <a href="<?php echo e(route($routePrefix . '.route_margin')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.route_margin') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Route Margin
            </a>
        </div>

        <!-- Filters -->
        <div class="bg-white p-6 rounded-lg shadow-sm border border-gray-200">
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Route Payout Report</h2>

            <form method="GET" action="<?php echo e(route($routePrefix . '.route_payout')); ?>" class="flex items-end gap-4">
                <!-- Start Date -->
                <div class="w-40">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                    <input type="date" name="start_date"
                        value="<?php echo e(request('start_date', now()->startOfMonth()->format('Y-m-d'))); ?>"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                </div>

                <!-- End Date -->
                <div class="w-40">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                    <input type="date" name="end_date" value="<?php echo e(request('end_date', now()->format('Y-m-d'))); ?>"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                </div>

                
                <div class="flex-none">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Report Type</label>
                    <div class="flex items-center gap-4 h-[38px]">
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="radio" name="report_type" value="actual" 
                                <?php echo e(request('report_type', 'actual') == 'actual' ? 'checked' : ''); ?>

                                class="text-purple-600 focus:ring-purple-500">
                            <span class="text-sm text-gray-700">Actual Hours</span>
                        </label>
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="radio" name="report_type" value="scheduled" 
                                <?php echo e(request('report_type') == 'scheduled' ? 'checked' : ''); ?>

                                class="text-purple-600 focus:ring-purple-500">
                            <span class="text-sm text-gray-700">Scheduled Hours</span>
                        </label>
                    </div>
                </div>

                <!-- Route Filter -->
                <div class="w-64">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Route</label>
                    <select name="route_id"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        <option value="">All Routes</option>
                        <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($route->id); ?>" <?php echo e(request('route_id') == $route->id ? 'selected' : ''); ?>>
                                <?php echo e($route->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <button type="submit"
                    class="h-[38px] px-6 bg-purple-600 text-white text-sm font-medium rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
                    Generate Report
                </button>

                <div class="h-8 w-px bg-gray-200 mx-1"></div>

                <!-- Export Buttons -->
                <div class="flex gap-2">
                    <a href="javascript:void(0)" id="exportRoutePayoutExcelBtn" title="Export Excel"
                        class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-green-600 transition-colors shadow-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                    </a>
                    <a href="javascript:void(0)" id="exportRoutePayoutPdfBtn" title="Export PDF"
                        class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-red-600 transition-colors shadow-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                            </path>
                        </svg>
                    </a>
                </div>
            </form>
        </div>

        <div class="flex justify-end mb-4">
            <label class="flex items-center gap-2 bg-white px-4 py-2 rounded-lg border border-gray-200 shadow-sm cursor-pointer hover:bg-gray-50 transition-colors">
                <input type="checkbox" id="selectAll" class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                <span class="text-sm font-bold text-gray-700">Select All Records</span>
            </label>
        </div>

        <!-- Route Payout Data -->
        <?php if(count($payoutData) > 0): ?>
            <?php $__currentLoopData = $payoutData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routeId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden mb-6">
                    <!-- Route Header -->
                    <div class="bg-gray-50 px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-bold text-gray-900"><?php echo e($data['route_code']); ?> - <?php echo e($data['route_name']); ?></h3>
                    </div>

                    <!-- Employees Table -->
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead class="bg-gray-100 border-b border-gray-200">
                                <tr>
                                    <th class="px-4 py-3 w-10"></th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Employee</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Duty Number
                                    </th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">In Time</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Out Time</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                        Pay Rate</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-center">
                                        Total Hrs</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                        Total Amount</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                <?php $__currentLoopData = $data['employees']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-4 py-3">
                                            <input type="checkbox" name="selected_ids[]" value="<?php echo e($employee['record_id']); ?>" class="row-checkbox rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                        </td>
                                        <td class="px-4 py-3 text-sm text-gray-900"><?php echo e($employee['employee_name']); ?></td>
                                        <td class="px-4 py-3 text-xs font-mono text-purple-600 font-bold">
                                            #<?php echo e($employee['duty_number']); ?></td>
                                        <td class="px-4 py-3 text-xs text-gray-600"><?php echo e($employee['in_time']); ?></td>
                                        <td class="px-4 py-3 text-xs text-gray-600"><?php echo e($employee['out_time']); ?></td>
                                        <td class="px-4 py-3 text-sm text-right font-semibold text-gray-900">
                                            $<?php echo e(number_format($employee['pay_rate'], 2)); ?></td>
                                        <td class="px-4 py-3 text-sm text-center font-semibold text-gray-900">
                                            <?php echo e($employee['total_hours']); ?>

                                        </td>
                                        <td class="px-4 py-3 text-sm text-right font-bold text-blue-700">
                                            $<?php echo e(number_format($employee['total_amount'], 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <!-- Route Total Row -->
                                <tr class="bg-blue-50 font-bold">
                                    <td colspan="6" class="px-4 py-3 text-sm text-right text-gray-900">Route Total:</td>
                                    <td class="px-4 py-3 text-sm text-center text-gray-900"><?php echo e($data['total_hours_formatted']); ?></td>
                                    <td class="px-4 py-3 text-sm text-right text-blue-700">
                                        $<?php echo e(number_format($data['total_amount'], 2)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-12 text-center">
                <p class="text-gray-400 text-sm font-bold uppercase tracking-wider">No payout data found for the selected period
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('select[name="route_id"]').select2({
                placeholder: 'All Routes',
                allowClear: true,
                width: '100%'
            });

            // Select All functionality
            $('#selectAll').on('change', function() {
                $('.row-checkbox').prop('checked', $(this).prop('checked'));
            });

            $('.row-checkbox').on('change', function() {
                if (!$(this).prop('checked')) $('#selectAll').prop('checked', false);
                if ($('.row-checkbox:checked').length === $('.row-checkbox').length) $('#selectAll').prop('checked', true);
            });

            // Handle Export Excel
            $('#exportRoutePayoutExcelBtn').on('click', function() {
                let selectedIds = [];
                $('.row-checkbox:checked').each(function() {
                    selectedIds.push($(this).val());
                });

                let baseUrl = "<?php echo e(route($routePrefix . '.route_payout.export')); ?>";
                let params = new URLSearchParams(window.location.search);
                if (selectedIds.length > 0) params.set('ids', selectedIds.join(','));
                window.location.href = baseUrl + '?' + params.toString();
            });

            // Handle Export PDF
            $('#exportRoutePayoutPdfBtn').on('click', function() {
                let selectedIds = [];
                $('.row-checkbox:checked').each(function() {
                    selectedIds.push($(this).val());
                });

                let baseUrl = "<?php echo e(route($routePrefix . '.route_payout.export.pdf')); ?>";
                let params = new URLSearchParams(window.location.search);
                if (selectedIds.length > 0) params.set('ids', selectedIds.join(','));
                window.location.href = baseUrl + '?' + params.toString();
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/admin/reports/patroller/route_payout.blade.php ENDPATH**/ ?>