<?php $__env->startSection('title', 'Consolidated Report'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <!-- Header -->
        <h1 class="text-2xl font-bold text-gray-800">Consolidated Operational Report</h1>

        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="<?php echo e(route('reports.operational.consolidated')); ?>" class="space-y-6">
                <div class="flex flex-wrap gap-6 items-end">

                    
                    <div class="flex-none flex items-center gap-2">
                        <a href="<?php echo e(route('reports.operational.consolidated.export.pdf')); ?>?<?php echo e(http_build_query(request()->all())); ?>"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
                            Export PDF
                        </a>
                        <a href="<?php echo e(route('reports.operational.consolidated.export.excel')); ?>?<?php echo e(http_build_query(request()->all())); ?>"
                            class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            Export Excel
                        </a>
                    </div>

                    <div class="w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                        <input type="date" name="start_date" value="<?php echo e(request('start_date', $startDate)); ?>"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <div class="w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                        <input type="date" name="end_date" value="<?php echo e(request('end_date', $endDate)); ?>"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <!-- Employee Filter -->
                    <div class="w-64" x-data="searchableSelect({
                                    options: <?php echo e($employees->map(fn($e) => ['value' => $e->id, 'label' => 'FE' . $e->id . ' ' . $e->first_name . ' ' . $e->last_name . ' - ' . $e->email])->values()->toJson()); ?>,
                                    value: '<?php echo e(request('employee_id')); ?>',
                                    placeholder: 'All Employees'
                                })" @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                        <div class="relative">
                            <div @click="open = !open"
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="employee_id" :value="value">

                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search employee..."
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Employees'})"
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Employees
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                            x-text="option.label">
                                        </li>
                                    </template>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <button type="submit"
                        class="h-[38px] px-6 bg-black text-white text-sm font-bold rounded-lg hover:bg-gray-800 transition-colors whitespace-nowrap shadow-sm">
                        Search
                    </button>
                </div>
            </form>
        </div>

        <?php $__empty_1 = true; $__currentLoopData = $groupedConsolidated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empHeader => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
                <!-- Group Header -->
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                    <h3 class="font-bold text-gray-800 text-lg"><?php echo e($empHeader); ?></h3>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left border border-gray-300">
                        <thead class="bg-gray-50/50">
                            <tr>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider border border-gray-300">Site/Route
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider border border-gray-300">Role</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider border border-gray-300">Duty Number
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider border border-gray-300">Start Duty
                                    Time</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider border border-gray-300">End Duty Time
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider border border-gray-300">Pay Type</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right border border-gray-300">
                                    Actual Hrs</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right border border-gray-300">
                                    Sin Rate</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right border border-gray-300">
                                    Other Rate</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right border border-gray-300">
                                    Gas</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right border border-gray-300">
                                    Allowance</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-center border border-gray-300">
                                    Tickets Count</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right border border-gray-300">
                                    Total Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $totalHrs = 0;
                                $totalGas = 0;
                                $totalAllowance = 0;
                                $totalTickets = 0;
                                $totalAmount = 0;
                            ?>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $totalHrs += $row->actual_hrs;
                                    $totalGas += $row->gas;
                                    $totalAllowance += $row->allowance;
                                    $totalTickets += $row->tickets_count;
                                    $totalAmount += $row->total_amount;
                                ?>
                                <tr class="hover:bg-gray-50/50 text-sm text-gray-600">
                                    <td class="px-4 py-3 border border-gray-300"><?php echo e($row->site_route); ?></td>
                                    <td class="px-4 py-3 capitalize border border-gray-300"><?php echo e($row->role); ?></td>
                                    <td class="px-4 py-3 font-mono text-xs border border-gray-300"><?php echo e($row->duty_number); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap border border-gray-300">
                                        <?php echo e($row->start_time ? $row->start_time->format('Y-m-d h:i A') : '-'); ?></td>
                                    <td class="px-4 py-3 whitespace-nowrap border border-gray-300">
                                        <?php echo e($row->end_time ? $row->end_time->format('Y-m-d h:i A') : '-'); ?></td>
                                    <td class="px-4 py-3 uppercase border border-gray-300"><?php echo e($row->pay_type); ?></td>
                                    <td class="px-4 py-3 text-right font-medium border border-gray-300"><?php echo e(number_format($row->actual_hrs, 2)); ?></td>
                                    <td class="px-4 py-3 text-right border border-gray-300">$<?php echo e(number_format($row->sin_rate, 2)); ?></td>
                                    <td class="px-4 py-3 text-right border border-gray-300">$<?php echo e(number_format($row->other_rate, 2)); ?></td>
                                    <td class="px-4 py-3 text-right border border-gray-300"><?php echo e($row->gas ? number_format($row->gas, 0) : '0'); ?></td>
                                    <td class="px-4 py-3 text-right border border-gray-300"><?php echo e($row->allowance ? number_format($row->allowance, 0) : '0'); ?>

                                    </td>
                                    <td class="px-4 py-3 text-center border border-gray-300"><?php echo e($row->tickets_count); ?></td>
                                    <td class="px-4 py-3 text-right font-bold text-gray-800 border border-gray-300">
                                        $<?php echo e(number_format($row->total_amount, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- Grand Total Row -->
                            <tr class="bg-gray-100 font-bold border-t-2 border-gray-300">
                                <td colspan="6" class="px-4 py-3 text-right uppercase tracking-wide text-gray-600 border border-gray-300">Grand Total</td>
                                <td class="px-4 py-3 text-right border border-gray-300"><?php echo e(number_format($totalHrs, 2)); ?></td>
                                <td class="px-4 py-3 text-right border border-gray-300">-</td>
                                <td class="px-4 py-3 text-right border border-gray-300">-</td>
                                <td class="px-4 py-3 text-right border border-gray-300"><?php echo e(number_format($totalGas, 0)); ?></td>
                                <td class="px-4 py-3 text-right border border-gray-300"><?php echo e(number_format($totalAllowance, 0)); ?></td>
                                <td class="px-4 py-3 text-center border border-gray-300"><?php echo e($totalTickets); ?></td>
                                <td class="px-4 py-3 text-right text-gray-900 border border-gray-300">$<?php echo e(number_format($totalAmount, 2)); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8 text-center text-gray-500">
                No records found for the selected period.
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/reports/operational/consolidated.blade.php ENDPATH**/ ?>