

<?php $__env->startSection('title', 'Patroller Reports'); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $routePrefix = request()->routeIs('admin.*') ? 'admin.reports.patroller' : 'reports.patroller';
    ?>

    <div class="space-y-6">

        <!-- Navigation Tabs -->
        <div class="flex space-x-2 border-b border-gray-200 pb-2 overflow-x-auto">
            <a href="<?php echo e(route($routePrefix . '.index')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.index') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                In/Out Report
            </a>
            <a href="<?php echo e(route($routePrefix . '.tickets')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Ticket Reports
            </a>
            <a href="<?php echo e(route($routePrefix . '.monthly_tickets')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.monthly_tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Monthly Ticket Chart
            </a>
            <a href="<?php echo e(route($routePrefix . '.payout')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Patroller Payout
            </a>
            <a href="<?php echo e(route($routePrefix . '.route_payout')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.route_payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Route Payout
            </a>
            <a href="<?php echo e(route($routePrefix . '.route_margin')); ?>"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors <?php echo e(request()->routeIs($routePrefix . '.route_margin') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50'); ?>">
                Route Margin
            </a>
            <!-- Placeholders -->
        </div>

        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="<?php echo e(route($routePrefix . '.index')); ?>" class="space-y-6">

                <div class="flex flex-col gap-6">
                    <!-- Filters Row -->
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Date Range -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start
                                Date</label>
                            <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        </div>
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End
                                Date</label>
                            <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Route Filter -->
                        <div class="w-full md:w-48">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Route</label>
                            <select name="route_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                                <option value="">All Routes</option>
                                <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($route->id); ?>" <?php echo e(request('route_id') == $route->id ? 'selected' : ''); ?>>
                                        <?php echo e($route->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Employee Filter -->
                        <div class="w-full md:w-48">
                            <label
                                class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Patroller</label>
                            <select name="employee_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                                <option value="">All Patrollers</option>
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($emp->id); ?>" <?php echo e(request('employee_id') == $emp->id ? 'selected' : ''); ?>>
                                        <?php echo e($emp->first_name); ?> <?php echo e($emp->last_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Actions -->
                        <div class="flex items-end ml-auto">
                            <button type="submit"
                                class="h-[38px] px-6 bg-purple-600 text-white text-sm font-medium rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
                                Apply Filters
                            </button>

                            <div class="h-8 w-px bg-gray-200 mx-3"></div>

                            <div class="flex gap-2">
                                <button type="button" id="exportExcelBtn" title="Export Excel"
                                    class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors shadow-sm">
                                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                </button>
                                <button type="button" id="exportPdfBtn" title="Export PDF"
                                    class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors shadow-sm">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse" id="reportsTable">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4">
                                <input type="checkbox" id="selectAll"
                                    class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Patroller
                                Name</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Route</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty Number
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Scheduled In
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Scheduled Out
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Actual In
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Actual Out
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Total Hrs
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Tickets</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-6 py-4">
                                    <input type="checkbox" name="selected_ids[]" value="<?php echo e($row->record_id); ?>"
                                        class="row-checkbox rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900">
                                    <?php echo e($row->employee_name); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                    <?php echo e($row->route_name); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs font-mono text-purple-600 font-bold">
                                    #<?php echo e($row->duty_number); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-600 font-medium">
                                    <?php echo e(\Carbon\Carbon::parse($row->from_time)->format('d M H:i')); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-600 font-medium">
                                    <?php echo e(\Carbon\Carbon::parse($row->to_time)->format('d M H:i')); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($row->actual_start_at): ?>
                                        <span
                                            class="text-xs font-bold text-emerald-700 bg-emerald-50 px-2 py-1 rounded border border-emerald-100">
                                            <?php echo e(\Carbon\Carbon::parse($row->actual_start_at)->format('d M H:i')); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-300">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($row->actual_end_at): ?>
                                        <span
                                            class="text-xs font-bold text-indigo-700 bg-indigo-50 px-2 py-1 rounded border border-indigo-100">
                                            <?php echo e(\Carbon\Carbon::parse($row->actual_end_at)->format('d M H:i')); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-300">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                    <?php if($row->actual_start_at && $row->actual_end_at): ?>
                                        <?php echo e(number_format(\Carbon\Carbon::parse($row->actual_start_at)->diffInMinutes(\Carbon\Carbon::parse($row->actual_end_at)) / 60, 2)); ?>

                                        hrs
                                    <?php else: ?>
                                        <span class="text-gray-300">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php if($row->tickets_count > 0): ?>
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold bg-red-100 text-red-800">
                                            <?php echo e($row->tickets_count); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-400">0</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="px-6 py-12 text-center text-gray-400">
                                    <p class="text-xs font-bold uppercase tracking-wider">No patroller activity found</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($reports->hasPages()): ?>
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    <?php echo e($reports->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function () {
            // Initialize Select2 for Route dropdown
            $('select[name="route_id"]').select2({
                placeholder: 'All Routes',
                allowClear: true,
                width: '100%'
            });

            // Initialize Select2 for Patroller dropdown
            $('select[name="employee_id"]').select2({
                placeholder: 'All Patrollers',
                allowClear: true,
                width: '100%'
            });

            // Select All functionality
            $('#selectAll').on('change', function() {
                $('.row-checkbox').prop('checked', $(this).prop('checked'));
            });

            // If any individual checkbox is unchecked, uncheck the select all checkbox
            $('.row-checkbox').on('change', function() {
                if (!$(this).prop('checked')) {
                    $('#selectAll').prop('checked', false);
                }
                
                if ($('.row-checkbox:checked').length === $('.row-checkbox').length) {
                    $('#selectAll').prop('checked', true);
                }
            });

            function handleExport(isExcel) {
                let selectedIds = [];
                $('.row-checkbox:checked').each(function() {
                    selectedIds.push($(this).val());
                });

                let baseUrl = isExcel 
                    ? "<?php echo e(route($routePrefix . '.export.excel')); ?>" 
                    : "<?php echo e(route($routePrefix . '.export.pdf')); ?>";
                let params = new URLSearchParams(window.location.search);
                
                if (selectedIds.length > 0) {
                    params.set('ids', selectedIds.join(','));
                }

                window.location.href = baseUrl + '?' + params.toString();
            }

            $('#exportPdfBtn').on('click', function() {
                handleExport(false);
            });

            $('#exportExcelBtn').on('click', function() {
                handleExport(true);
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/admin/reports/patroller/index.blade.php ENDPATH**/ ?>