<!DOCTYPE html>
<html>

<head>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 10px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        h2 {
            margin-bottom: 0px;
        }

        p {
            margin-top: 5px;
            color: #666;
            font-size: 12px;
        }

        .meta {
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <div class="meta">
        <h2>Operational Report: <?php echo e(ucfirst($reportType)); ?></h2>
        <p>Employee: <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?> (<?php echo e($employee->employee_id ?? 'N/A'); ?>)</p>
        <p>Date Generated: <?php echo e(now()->format('M d, Y H:i')); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Duty #</th>
                <th>Site</th>
                <th>Sched. Start</th>
                <th>Sched. End</th>
                <th>Act. Start</th>
                <th>Act. End</th>
                <?php if($reportType === 'scans'): ?>
                    <th>Scans</th>
                <?php endif; ?>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php 
                    $schedule = (object) $schedule; 
                    $fromDate = \Carbon\Carbon::parse($schedule->from_datetime);
                    $toDate = \Carbon\Carbon::parse($schedule->to_datetime);
                ?>
                <tr>
                    <td><?php echo e($fromDate->format('M d, Y')); ?></td>
                    <td><?php echo e($schedule->duty_number); ?> (<?php echo e($schedule->type); ?>)</td>
                    <td><?php echo e($schedule->site_name); ?></td>
                    <td><?php echo e($fromDate->format('H:i')); ?></td>
                    <td><?php echo e($toDate->format('H:i')); ?></td>
                    <td>
                        <?php echo e($schedule->actual_start_at ? \Carbon\Carbon::parse($schedule->actual_start_at)->format('H:i') : '--'); ?>

                    </td>
                    <td>
                        <?php echo e($schedule->actual_end_at ? \Carbon\Carbon::parse($schedule->actual_end_at)->format('H:i') : '--'); ?>

                    </td>
                    <?php if($reportType === 'scans'): ?>
                        <td><?php echo e($schedule->scans_count); ?></td>
                    <?php endif; ?>
                    <td><?php echo e(ucfirst($schedule->status)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/employee/reports/pdf.blade.php ENDPATH**/ ?>