<?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="relative pl-8 pb-6 last:pb-0">
        <!-- Timeline Line -->
        <?php if(!$loop->last): ?>
            <div class="absolute left-[11px] top-6 bottom-0 w-px bg-slate-100"></div>
        <?php endif; ?>

        <!-- Timeline Icon -->
        <div class="absolute left-0 top-1 w-6 h-6 rounded-full flex items-center justify-center ring-4 ring-white shadow-sm
                            <?php if($activity['type'] === 'note'): ?> bg-blue-50 text-blue-600
                            <?php elseif($activity['type'] === 'incident'): ?> bg-red-50 text-red-600
                            <?php elseif($activity['type'] === 'checkin'): ?> bg-emerald-50 text-emerald-600
                            <?php elseif($activity['type'] === 'checkout'): ?> bg-gray-50 text-gray-600
                            <?php elseif($activity['type'] === 'patrol_start'): ?> bg-violet-50 text-violet-600
                            <?php elseif($activity['type'] === 'patrol_end'): ?> bg-pink-50 text-pink-600
                            <?php elseif($activity['type'] === 'patrol_ticket'): ?> bg-orange-50 text-orange-600
                            <?php elseif($activity['type'] === 'patrol_site_checkin'): ?> bg-teal-50 text-teal-600
                        <?php elseif($activity['type'] === 'patrol_site_checkout'): ?> bg-slate-50 text-slate-600
                        <?php else: ?> bg-cyan-50 text-cyan-600 <?php endif; ?>">
            <?php if($activity['type'] === 'note'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                    </path>
                </svg>
            <?php elseif($activity['type'] === 'incident'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                    </path>
                </svg>
            <?php elseif($activity['type'] === 'checkin' || $activity['type'] === 'patrol_site_checkin'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                </svg>
            <?php elseif($activity['type'] === 'checkout' || $activity['type'] === 'patrol_site_checkout'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                </svg>
            <?php elseif($activity['type'] === 'patrol_start'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M13 10V3L4 14h7v7l9-11h-7z">
                    </path>
                </svg>
            <?php elseif($activity['type'] === 'patrol_end'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M3 21v-8a2 2 0 012-2h10a2 2 0 012 2v8m2-8a2 2 0 012 2v8m-4-6a2 2 0 012 2v2m-6-2a2 2 0 012 2v2m-6-2a2 2 0 012 2v2">
                    </path>
                </svg>
            <?php elseif($activity['type'] === 'patrol_ticket'): ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M15 5v2m0 4v22m0-22l-2-2m2 2l2-2M5 5a2 2 0 012-2h10a2 2 0 012 2v14l-5-5l-5 5V5z"></path>
                </svg>
            <?php else: ?>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            <?php endif; ?>
        </div>

        <div class="flex flex-col gap-1">
            <div class="flex items-center justify-between gap-4">
                <h4 class="text-xs font-black text-slate-800 tracking-tight leading-none uppercase"><?php echo e($activity['title']); ?>

                </h4>
                <span
                    class="text-[9px] font-bold text-slate-400 uppercase tracking-tighter whitespace-nowrap"><?php echo e($activity['timestamp']->diffForHumans()); ?></span>
            </div>

            <p class="text-[11px] text-slate-500 font-medium leading-relaxed italic line-clamp-2">
                "<?php echo e($activity['content']); ?>"
            </p>

            <div class="flex items-center justify-between mt-1">
                <div class="flex items-center gap-1.5">
                    <div
                        class="w-4 h-4 rounded-md bg-slate-100 flex items-center justify-center text-[8px] font-black text-slate-500 border border-slate-200 uppercase">
                        <?php echo e(substr($activity['employee'], 0, 1)); ?>

                    </div>
                    <span class="text-[10px] font-bold text-slate-600"><?php echo e($activity['employee']); ?></span>
                </div>

                <?php if($activity['image']): ?>
                    <a href="<?php echo e($activity['image']); ?>" target="_blank"
                        class="block h-8 w-8 rounded overflow-hidden border border-slate-200 shadow-sm transition-transform hover:scale-105">
                        <img src="<?php echo e($activity['image']); ?>" class="w-full h-full object-cover" alt="Activity Evidence">
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="flex flex-col items-center justify-center py-10 opacity-40">
        <svg class="w-10 h-10 text-slate-300 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
        </svg>
        <p class="text-[10px] font-black uppercase text-slate-400">No live activity detected</p>
    </div>
<?php endif; ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/partials/activity-feed.blade.php ENDPATH**/ ?>