<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Patroller Schedule Report - <?php echo e($schedule->duty_number); ?></title>
    <style>
        @page {
            margin: 15mm;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 9pt;
            color: #1f2937;
            line-height: 1.4;
        }

        /* Header Styles */
        .report-header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 4px solid #2563eb;
        }

        .company-name {
            font-size: 20pt;
            font-weight: bold;
            color: #1e3a8a;
            margin-bottom: 5px;
            letter-spacing: 0.5px;
        }

        .report-title {
            font-size: 16pt;
            font-weight: bold;
            color: #374151;
            margin: 8px 0;
        }

        .report-subtitle {
            font-size: 9pt;
            color: #6b7280;
            margin-top: 5px;
        }

        /* Info Box Styles */
        .info-box {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .info-grid {
            width: 100%;
            border-collapse: collapse;
        }

        .info-row {
            border-bottom: 1px solid #e5e7eb;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: bold;
            color: #4b5563;
            padding: 8px 10px;
            width: 22%;
            font-size: 8pt;
            text-transform: uppercase;
            letter-spacing: 0.3px;
            background: #f1f5f9;
        }

        .info-value {
            padding: 8px 10px;
            width: 28%;
            color: #1f2937;
            font-size: 9pt;
        }

        /* Section Styles */
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }

        .section-header {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            color: white;
            padding: 10px 15px;
            font-size: 11pt;
            font-weight: bold;
            border-radius: 4px;
            margin-bottom: 12px;
            letter-spacing: 0.3px;
        }

        .section-count {
            float: right;
            background: rgba(255, 255, 255, 0.2);
            padding: 2px 10px;
            border-radius: 12px;
            font-size: 9pt;
        }

        /* Timeline Styles */
        .timeline-container {
            position: relative;
            padding-left: 25px;
        }

        .timeline-item {
            position: relative;
            margin-bottom: 15px;
            padding: 12px 15px;
            background: #f0fdf4;
            border-left: 4px solid #10b981;
            border-radius: 4px;
            page-break-inside: avoid;
        }

        .timeline-item:before {
            content: '';
            position: absolute;
            left: -14px;
            top: 18px;
            width: 10px;
            height: 10px;
            background: #10b981;
            border-radius: 50%;
            border: 2px solid white;
        }

        .timeline-site {
            font-size: 10pt;
            font-weight: bold;
            color: #065f46;
            margin-bottom: 6px;
        }

        .timeline-detail {
            font-size: 8pt;
            color: #374151;
            margin: 3px 0;
        }

        .timeline-label {
            font-weight: bold;
            color: #059669;
            min-width: 70px;
            display: inline-block;
        }

        .timeline-duration {
            margin-top: 6px;
            padding: 4px 8px;
            background: #d1fae5;
            color: #065f46;
            font-size: 8pt;
            border-radius: 3px;
            display: inline-block;
        }

        /* Ticket Styles */
        .ticket-card {
            background: white;
            border: 2px solid #fbbf24;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 15px;
            page-break-inside: avoid;
        }

        .ticket-header {
            background: #fffbeb;
            margin: -15px -15px 12px -15px;
            padding: 10px 15px;
            border-bottom: 2px solid #fbbf24;
            border-radius: 4px 4px 0 0;
        }

        .ticket-number {
            font-size: 10pt;
            font-weight: bold;
            color: #92400e;
        }

        .ticket-body {
            padding: 5px 0;
        }

        .ticket-field {
            margin: 6px 0;
            font-size: 8.5pt;
        }

        .ticket-field-label {
            font-weight: bold;
            color: #4b5563;
            min-width: 80px;
            display: inline-block;
        }

        .ticket-description {
            background: #f9fafb;
            padding: 8px;
            border-left: 3px solid #d1d5db;
            margin: 8px 0;
            font-size: 8.5pt;
            color: #374151;
            border-radius: 3px;
        }

        /* Image Gallery */
        .image-gallery {
            margin-top: 12px;
            padding-top: 12px;
            border-top: 1px solid #e5e7eb;
        }

        .image-gallery-title {
            font-weight: bold;
            color: #4b5563;
            margin-bottom: 8px;
            font-size: 9pt;
        }

        .image-grid {
            display: table;
            width: 100%;
        }

        .image-item {
            display: inline-block;
            margin: 5px;
            text-align: center;
            vertical-align: top;
            width: 180px;
        }

        .image-item img {
            max-width: 180px;
            max-height: 180px;
            border: 2px solid #d1d5db;
            border-radius: 4px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .image-caption {
            font-size: 7pt;
            color: #6b7280;
            margin-top: 4px;
            word-wrap: break-word;
        }

        /* Badge Styles */
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 7.5pt;
            font-weight: bold;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }

        .badge-success {
            background: #d1fae5;
            color: #065f46;
            border: 1px solid #10b981;
        }

        .badge-warning {
            background: #fef3c7;
            color: #92400e;
            border: 1px solid #fbbf24;
        }

        .badge-info {
            background: #dbeafe;
            color: #1e40af;
            border: 1px solid #3b82f6;
        }

        /* Summary Box */
        .summary-box {
            background: #f8fafc;
            border: 2px solid #cbd5e1;
            border-radius: 6px;
            padding: 15px;
            margin-top: 20px;
        }

        .summary-grid {
            width: 100%;
            border-collapse: collapse;
        }

        .summary-item {
            padding: 10px;
            text-align: center;
            border-right: 1px solid #e2e8f0;
        }

        .summary-item:last-child {
            border-right: none;
        }

        .summary-value {
            font-size: 16pt;
            font-weight: bold;
            color: #2563eb;
            display: block;
            margin-bottom: 4px;
        }

        .summary-label {
            font-size: 8pt;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        /* Utility Classes */
        .text-muted {
            color: #9ca3af;
            font-style: italic;
        }

        .no-data {
            text-align: center;
            padding: 20px;
            color: #9ca3af;
            font-style: italic;
            background: #f9fafb;
            border-radius: 4px;
        }

        /* Page Break Control */
        .page-break {
            page-break-after: always;
        }

        .no-break {
            page-break-inside: avoid;
        }
    </style>
</head>

<body>
<!-- Header -->
<div class="report-header">
    <div class="company-name"><?php echo e(session('company_name') ?? 'Security Company'); ?></div>
    <div class="report-title">Patroller Duty Report</div>
    <div class="report-subtitle">
        Duty #<?php echo e($schedule->duty_number); ?> | Generated: <?php echo e(now()->format('F d, Y \a\t h:i A')); ?>

    </div>
</div>

<!-- Schedule Information -->
<div class="info-box no-break">
    <table class="info-grid">
        <tr class="info-row">
            <td class="info-label">Duty Number</td>
            <td class="info-value"><strong><?php echo e($schedule->duty_number); ?></strong></td>
            <td class="info-label">Route</td>
            <td class="info-value"><strong><?php echo e($schedule->route->name ?? 'N/A'); ?></strong></td>
        </tr>
        <tr class="info-row">
            <td class="info-label">Scheduled Date</td>
            <td class="info-value"><?php echo e($schedule->scheduled_date->format('F d, Y')); ?></td>
            <td class="info-label">Status</td>
            <td class="info-value">
                <span class="badge badge-success"><?php echo e(ucfirst(str_replace('_', ' ', $schedule->job_status))); ?></span>
            </td>
        </tr>
        <tr class="info-row">
            <td class="info-label">Scheduled In</td>
            <td class="info-value"><?php echo e($schedule->from_time->format('M d, Y h:i A')); ?></td>
            <td class="info-label">Scheduled Out</td>
            <td class="info-value"><?php echo e($schedule->to_time->format('M d, Y h:i A')); ?></td>
        </tr>
        <tr class="info-row">
            <td class="info-label">Actual In</td>
            <td class="info-value">
                <?php if($schedule->job_started_at): ?>
                    <strong
                        style="color: #059669;"><?php echo e(\Carbon\Carbon::parse($schedule->job_started_at)->format('M d, Y h:i A')); ?></strong>
                <?php else: ?>
                    <span class="text-muted">Not started</span>
                <?php endif; ?>
            </td>
            <td class="info-label">Actual Out</td>
            <td class="info-value">
                <?php if($schedule->job_ended_at): ?>
                    <strong
                        style="color: #dc2626;"><?php echo e(\Carbon\Carbon::parse($schedule->job_ended_at)->format('M d, Y h:i A')); ?></strong>
                <?php else: ?>
                    <span class="text-muted">Not ended</span>
                <?php endif; ?>
            </td>
        </tr>
        <tr class="info-row">
            <td class="info-label">Customer Ref</td>
            <td class="info-value"><?php echo e($schedule->customer_reference ?? 'N/A'); ?></td>
            <td class="info-label">Comments</td>
            <td class="info-value"><?php echo e($schedule->comments ?? 'N/A'); ?></td>
        </tr>
        <tr class="info-row">
            <td class="info-label">Assigned Staff</td>
            <td class="info-value" colspan="3">
                <?php if($schedule->employees->count() > 0): ?>
                    <?php $__currentLoopData = $schedule->employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($emp->user->name ?? ($emp->first_name . ' ' . $emp->last_name)); ?><?php if(!$loop->last): ?>, <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <span class="text-muted">Unassigned</span>
                <?php endif; ?>
            </td>
        </tr>
    </table>
</div>

<!-- Timeline Section -->
<div class="section">
    <div class="section-header">
        Site Visit Timeline
        <span class="section-count"><?php echo e($schedule->jobSites->whereNotNull('checked_in_at')->count()); ?> /
                <?php echo e($schedule->jobSites->count()); ?> Visited</span>
    </div>
    <?php if($schedule->jobSites->count() > 0): ?>
        <div class="timeline-container">
            <?php $__currentLoopData = $schedule->jobSites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobSite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="timeline-item">
                    <div class="timeline-site"><?php echo e($jobSite->site->name ?? 'Unknown Site'); ?></div>
                    <?php if($jobSite->checked_in_at): ?>
                        <div class="timeline-detail">
                            <span class="timeline-label">Check-In:</span>
                            <?php echo e(\Carbon\Carbon::parse($jobSite->checked_in_at)->format('M d, Y h:i A')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($jobSite->checked_out_at): ?>
                        <div class="timeline-detail">
                            <span class="timeline-label">Check-Out:</span>
                            <?php echo e(\Carbon\Carbon::parse($jobSite->checked_out_at)->format('M d, Y h:i A')); ?>

                        </div>
                        <?php if($jobSite->checked_in_at): ?>
                            <div class="timeline-duration">
                                ⏱ Duration:
                                <?php echo e(number_format(\Carbon\Carbon::parse($jobSite->checked_in_at)->floatDiffInMinutes($jobSite->checked_out_at), 0)); ?>

                                minutes
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="timeline-detail text-muted">Not checked out</div>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="no-data">No site visits recorded for this duty.</div>
    <?php endif; ?>
</div>

<!-- Tickets Section -->
<div class="section">
    <div class="section-header">
        Issue Tickets
        <span class="section-count"><?php echo e($schedule->issueTickets->count()); ?> Total</span>
    </div>
    <?php if($schedule->issueTickets->count() > 0): ?>
        <?php $__currentLoopData = $schedule->issueTickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="ticket-card">
                <div class="ticket-header">
                    <span class="ticket-number">Ticket #<?php echo e($ticket->ticket_number); ?></span>
                    <span class="badge <?php echo e($ticket->status === 'good' ? 'badge-success' : 'badge-warning'); ?>"
                          style="float: right;">
                            <?php echo e($ticket->status === 'good' ? '✓ GOOD' : '⚠ BAD'); ?>

                        </span>
                </div>
                <div class="ticket-body">
                    <div class="ticket-field">
                        <span class="ticket-field-label">Site:</span>
                        <?php echo e($ticket->site->name ?? 'N/A'); ?>

                    </div>
                    <div class="ticket-field">
                        <span class="ticket-field-label">Reported:</span>
                        <?php echo e($ticket->created_at->format('F d, Y \a\t h:i A')); ?>

                    </div>
                    <div class="ticket-field">
                        <span class="ticket-field-label">Reported By:</span>
                        <?php echo e($ticket->employee->user->name ?? ($ticket->employee->first_name . ' ' . $ticket->employee->last_name) ?? 'Unknown'); ?>

                    </div>
                    <div class="ticket-description">
                        <strong>Description:</strong><br>
                        <?php echo e($ticket->description ?? 'No description provided'); ?>

                    </div>

                    <?php if($ticket->images && count($ticket->images) > 0): ?>
                        <div class="image-gallery">
                            <div class="image-gallery-title">📸 Evidence Images (<?php echo e(count($ticket->images)); ?>)</div>
                            <div class="image-grid">
                                <?php $__currentLoopData = $ticket->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagePath): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $fullPath = storage_path('app/public/' . $imagePath);
                                    ?>
                                    <?php if(file_exists($fullPath)): ?>
                                        <div class="image-item">
                                            <img src="<?php echo e($fullPath); ?>" alt="Evidence" />
                                            <div class="image-caption"><?php echo e(basename($imagePath)); ?></div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <div class="no-data">No tickets reported during this duty.</div>
    <?php endif; ?>
</div>

<!-- Summary Section -->
<div class="summary-box no-break">
    <table class="summary-grid">
        <tr>
            <td class="summary-item">
                <span class="summary-value"><?php echo e($schedule->jobSites->count()); ?></span>
                <span class="summary-label">Total Sites</span>
            </td>
            <td class="summary-item">
                <span class="summary-value"><?php echo e($schedule->jobSites->whereNotNull('checked_in_at')->count()); ?></span>
                <span class="summary-label">Sites Visited</span>
            </td>
            <td class="summary-item">
                <span class="summary-value"><?php echo e($schedule->issueTickets->count()); ?></span>
                <span class="summary-label">Tickets Issued</span>
            </td>
            <td class="summary-item">
                    <span class="summary-value">
                        <?php if($schedule->job_started_at && $schedule->job_ended_at): ?>
                            <?php echo e(number_format(\Carbon\Carbon::parse($schedule->job_started_at)->floatDiffInMinutes($schedule->job_ended_at) / 60, 1)); ?>h
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </span>
                <span class="summary-label">Total Duration</span>
            </td>
        </tr>
    </table>
</div>
</body>

</html>
<?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/patroller-schedules/single-pdf.blade.php ENDPATH**/ ?>