

<?php $__env->startSection('title', 'Patroller Schedules'); ?>

<?php $__env->startSection('content'); ?>
    <div class="p-6" x-data="patrollerScheduleList()">
        <form id="exportForm" action="<?php echo e(route('patroller-schedules.export-pdf')); ?>" method="POST" class="hidden">
            <?php echo csrf_field(); ?>
            <template x-for="id in selected">
                <input type="hidden" name="ids[]" :value="id">
            </template>
        </form>

        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Patroller Schedules</h1>
                <p class="text-gray-500">Manage and track patroller duties across all routes.</p>
            </div>

            <div class="flex items-center gap-4">
                <button type="button"
                    @click="submitExport('<?php echo e(route('patroller-schedules.export-pdf')); ?>')"
                    class="px-4 py-2 bg-white border border-gray-200 text-gray-700 font-bold rounded-lg hover:bg-gray-50 transition-all shadow-sm flex items-center gap-2">
                    <svg class="w-5 h-5 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Export PDF
                    <span x-show="selected.length > 0" x-text="'(' + selected.length + ')'"
                        class="text-xs bg-gray-100 px-2 py-0.5 rounded-full ml-1"></span>
                </button>

                <button type="button"
                    @click="submitExport('<?php echo e(route('patroller-schedules.export-excel')); ?>')"
                    class="px-4 py-2 bg-white border border-gray-200 text-gray-700 font-bold rounded-lg hover:bg-gray-50 transition-all shadow-sm flex items-center gap-2">
                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Export Excel
                    <span x-show="selected.length > 0" x-text="'(' + selected.length + ')'"
                        class="text-xs bg-gray-100 px-2 py-0.5 rounded-full ml-1"></span>
                </button>

                <a href="<?php echo e(route('patroller-schedules.create')); ?>"
                    class="px-6 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20 flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    Create New Schedule
                </a>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Status Tabs -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 mb-6">
            <div class="flex border-b border-gray-100 overflow-x-auto whitespace-nowrap scrollbar-hide">
                <?php
                    $tabs = [
                        'all' => 'All',
                        'active' => 'Active',
                        'upcoming' => 'Upcoming',
                        'completed' => 'Completed',
                        'missed' => 'Missed',
                        'cancelled' => 'Cancelled'
                    ];
                ?>
                <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('patroller-schedules.index', array_merge(request()->query(), ['type' => $key]))); ?>"
                        class="px-6 py-4 text-sm font-bold border-b-2 transition-all <?php echo e($type === $key ? 'border-blue-600 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:bg-gray-50'); ?>">
                        <?php echo e($label); ?>

                        <span
                            class="ml-2 px-2 py-0.5 rounded-full text-xs <?php echo e($type === $key ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-600'); ?>">
                            <?php echo e($counts[$key] ?? 0); ?>

                        </span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Filter & Export Toolbar -->
        <div class="flex flex-col md:flex-row justify-between items-center gap-4 mb-6 bg-white p-4 rounded-xl border border-gray-100 shadow-sm"
            x-data="{
                                                                                                                                                        routeFilter: { open: false, search: '', selected: '<?php echo e(request('route_id') ? $routes->firstWhere('id', request('route_id'))->name ?? '' : ''); ?>', value: '<?php echo e(request('route_id') ?? ''); ?>' },
                                                                                                                                                        employeeFilter: { open: false, search: '', selected: '<?php echo e(request('employee_id') ? $employees->firstWhere('id', request('employee_id'))->first_name . ' ' . $employees->firstWhere('id', request('employee_id'))->last_name ?? '' : ''); ?>', value: '<?php echo e(request('employee_id') ?? ''); ?>' }
                                                                                                                                                    }">
            <form method="GET" action="<?php echo e(route('patroller-schedules.index')); ?>" id="filterForm"
                class="flex flex-wrap items-center gap-4 w-full md:w-auto">
                <input type="hidden" name="type" value="<?php echo e($type); ?>">

                <!-- Route Filter (Searchable) -->
                <div class="relative" @click.outside="routeFilter.open = false">
                    <label class="text-[10px] font-bold text-gray-500 uppercase mb-1 block">Route</label>
                    <input type="hidden" name="route_id" x-model="routeFilter.value">
                    <button type="button" @click="routeFilter.open = !routeFilter.open"
                        class="w-full min-w-[200px] text-sm border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 py-2 px-3 bg-gray-50 transition-all text-left flex justify-between items-center h-[38px]">
                        <span x-text="routeFilter.selected || 'All Routes'"
                            :class="{'text-gray-400': !routeFilter.selected, 'text-gray-700 font-bold': routeFilter.selected}"></span>
                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>

                    <div x-show="routeFilter.open" x-cloak
                        class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-lg shadow-xl z-50 max-h-60 overflow-hidden flex flex-col">
                        <div class="p-2 border-b border-gray-100">
                            <input type="text" x-model="routeFilter.search" placeholder="Search routes..."
                                class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                        </div>
                        <ul class="overflow-y-auto flex-1 p-1">
                            <li @click="routeFilter.selected = 'All Routes'; routeFilter.value = ''; routeFilter.open = false; $nextTick(() => document.getElementById('filterForm').submit())"
                                class="px-3 py-2 hover:bg-blue-50 hover:text-blue-700 rounded text-sm cursor-pointer text-gray-600 transition-colors">
                                All Routes
                            </li>
                            <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li x-show="'<?php echo e(strtolower($route->name)); ?>'.includes(routeFilter.search.toLowerCase())"
                                    @click="routeFilter.selected = '<?php echo e($route->name); ?>'; routeFilter.value = '<?php echo e($route->id); ?>'; routeFilter.open = false; $nextTick(() => document.getElementById('filterForm').submit())"
                                    class="px-3 py-2 hover:bg-blue-50 hover:text-blue-700 rounded text-sm cursor-pointer text-gray-600 transition-colors">
                                    <?php echo e($route->name); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>

                <!-- Employee Filter (Searchable) -->
                <div class="relative" @click.outside="employeeFilter.open = false">
                    <label class="text-[10px] font-bold text-gray-500 uppercase mb-1 block">Employee</label>
                    <input type="hidden" name="employee_id" x-model="employeeFilter.value">
                    <button type="button" @click="employeeFilter.open = !employeeFilter.open"
                        class="w-full min-w-[200px] text-sm border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 py-2 px-3 bg-gray-50 transition-all text-left flex justify-between items-center h-[38px]">
                        <span x-text="employeeFilter.selected || 'All Employees'"
                            :class="{'text-gray-400': !employeeFilter.selected, 'text-gray-700 font-bold': employeeFilter.selected}"></span>
                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>

                    <div x-show="employeeFilter.open" x-cloak
                        class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-lg shadow-xl z-50 max-h-60 overflow-hidden flex flex-col">
                        <div class="p-2 border-b border-gray-100">
                            <input type="text" x-model="employeeFilter.search" placeholder="Search employees..."
                                class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                        </div>
                        <ul class="overflow-y-auto flex-1 p-1">
                            <li @click="employeeFilter.selected = 'All Employees'; employeeFilter.value = ''; employeeFilter.open = false; document.getElementById('filterForm').submit()"
                                class="px-3 py-2 hover:bg-blue-50 hover:text-blue-700 rounded text-sm cursor-pointer text-gray-600 transition-colors">
                                All Employees
                            </li>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li x-show="'<?php echo e(strtolower($emp->first_name . ' ' . $emp->last_name . ' ' . ($emp->employee_id ?? ''))); ?>'.includes(employeeFilter.search.toLowerCase())"
                                    @click="employeeFilter.selected = '<?php echo e($emp->first_name); ?> <?php echo e($emp->last_name); ?>'; employeeFilter.value = '<?php echo e($emp->id); ?>'; employeeFilter.open = false; document.getElementById('filterForm').submit()"
                                    class="px-3 py-2 hover:bg-blue-50 hover:text-blue-700 rounded text-sm cursor-pointer text-gray-600 transition-colors flex justify-between items-center">
                                    <div class="flex flex-col">
                                        <span class="font-bold"><?php echo e($emp->first_name); ?> <?php echo e($emp->last_name); ?></span>
                                        <span class="text-xs text-gray-400">ID: <?php echo e($emp->employee_id ?? '#' . $emp->id); ?></span>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>

                <!-- Per Page Selector -->
                <div class="relative w-24">
                    <select name="per_page" onchange="this.form.submit()"
                        class="w-full h-[42px] pl-3 pr-8 text-sm font-bold text-gray-700 bg-white border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 appearance-none cursor-pointer">
                        <option value="50" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50</option>
                        <option value="100" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100</option>
                        <option value="all" <?php echo e(request('per_page') == 'all' ? 'selected' : ''); ?>>All</option>
                    </select>
                    <div class="absolute inset-y-0 right-0 flex items-center px-2 pointer-events-none text-gray-500">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </div>
                </div>

                <!-- Date Range Filter -->
                <div class="flex items-center gap-2">
                    <div class="relative">
                        <input type="date" name="from_date" value="<?php echo e($fromDate); ?>"
                            class="pl-4 pr-4 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 w-full min-w-[160px]"
                            placeholder="From Date">
                    </div>
                    <span class="text-gray-400 font-bold">-</span>
                    <div class="relative">
                        <input type="date" name="to_date" value="<?php echo e($toDate); ?>"
                            class="pl-4 pr-4 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 w-full min-w-[160px]"
                            placeholder="To Date">
                    </div>

                    <button type="submit"
                        class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-all shadow-sm flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        <span class="text-xs font-bold uppercase tracking-wider">Search</span>
                    </button>

                    <!-- Quick Date Filters -->
                    <div class="flex items-center gap-1 ml-2 bg-gray-50 rounded-lg p-1 border border-gray-200">
                        <?php
                            $rangeFilters = ['today' => 'Today', 'this_week' => 'This Week', 'this_month' => 'This Month'];
                        ?>
                        <?php $__currentLoopData = $rangeFilters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('patroller-schedules.index', array_merge(request()->query(), ['type' => $key]))); ?>"
                                class="px-2 py-1 text-[10px] font-bold uppercase tracking-wider rounded transition-colors <?php echo e($type === $key ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-500 hover:text-gray-700 hover:bg-gray-100'); ?>">
                                <?php echo e($label); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <a href="<?php echo e(route('patroller-schedules.index', ['type' => $type])); ?>"
                    class="text-sm font-bold text-red-400 hover:text-red-600" title="Clear Filters">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </a>
            </form>
        </div>

        <!-- Schedules Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead class="bg-gray-50 border-b border-gray-100">
                    <tr>
                        <th class="pl-6 pr-2 py-4 w-4">
                            <input type="checkbox" @click="toggleAll()" x-model="allSelected"
                                class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                        </th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'route', 'direction' => request('sort') === 'route' && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                class="flex items-center gap-1 hover:text-gray-600 transition-colors">
                                Route
                                <?php if(request('sort') === 'route'): ?>
                                    <svg class="w-3 h-3 text-gray-900 <?php echo e(request('direction') === 'asc' ? 'rotate-180' : ''); ?>"
                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                <?php else: ?>
                                    <svg class="w-3 h-3 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 9l4-4 4 4m0 6l-4 4-4-4"></path>
                                    </svg>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Employees</th>
                        <?php if($type === 'completed'): ?>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Sched In</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Sched Out</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Actual In</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Actual Out</th>
                        <?php else: ?>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Sched In</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Sched Out</th>
                        <?php endif; ?>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'status', 'direction' => request('sort') === 'status' && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                class="flex items-center gap-1 hover:text-gray-600 transition-colors">
                                Status
                                <?php if(request('sort') === 'status'): ?>
                                    <svg class="w-3 h-3 text-gray-900 <?php echo e(request('direction') === 'asc' ? 'rotate-180' : ''); ?>"
                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                <?php else: ?>
                                    <svg class="w-3 h-3 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 9l4-4 4 4m0 6l-4 4-4-4"></path>
                                    </svg>
                                <?php endif; ?>
                            </a>
                        </th>
                        <?php if($type === 'completed'): ?>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Tickets</th>
                        <?php endif; ?>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider text-right">
                            Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 transition-colors group">
                            <td class="pl-6 pr-2 py-4">
                                <input type="checkbox" value="<?php echo e($schedule->id); ?>" x-model="selected"
                                    class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm font-bold text-gray-900"><?php echo e($schedule->duty_number); ?></span>
                                <?php if($schedule->customer_reference): ?>
                                    <div class="text-xs text-gray-400 mt-0.5">Ref: <?php echo e($schedule->customer_reference); ?></div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-8 h-8 rounded-lg bg-blue-50 text-blue-600 flex items-center justify-center font-bold text-xs">
                                        <?php echo e(substr($schedule->route->name, 0, 1)); ?>

                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-gray-900"><?php echo e($schedule->route->name); ?></div>
                                        <div class="text-[10px] text-gray-400 font-medium">$<?php echo e($schedule->route_rate); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex flex-col gap-2">
                                    <?php $__currentLoopData = $schedule->employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-center gap-2">
                                            <?php if($employee->profile_picture): ?>
                                                <img src="<?php echo e(asset('storage/' . $employee->profile_picture)); ?>"
                                                    class="h-8 w-8 rounded-full border border-slate-100 object-cover shrink-0">
                                            <?php else: ?>
                                                <div
                                                    class="h-8 w-8 rounded-full bg-slate-100 text-slate-500 border border-slate-200 flex items-center justify-center font-bold text-[10px] uppercase shrink-0">
                                                    <?php echo e(substr($employee->first_name, 0, 1)); ?><?php echo e(substr($employee->last_name, 0, 1)); ?>

                                                </div>
                                            <?php endif; ?>
                                            <div>
                                                <div class="text-xs font-bold text-slate-700 leading-tight">
                                                    <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

                                                </div>
                                                <div class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">
                                                    <?php echo e($employee->employee_id ?? 'ID: ' . $employee->id); ?>

                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($schedule->employees->count() === 0): ?>
                                        <span class="text-xs font-bold text-slate-400 italic">Unassigned</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <?php if($type === 'completed'): ?>
                                <!-- Sched In -->
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-700 font-bold"><?php echo e($schedule->from_time->format('M d, Y')); ?></div>
                                    <div class="text-[11px] text-gray-500 font-medium italic">
                                        <?php echo e($schedule->from_time->format('h:i A')); ?>

                                    </div>
                                </td>
                                <!-- Sched Out -->
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-700 font-bold"><?php echo e($schedule->to_time->format('M d, Y')); ?></div>
                                    <div class="text-[11px] text-gray-500 font-medium italic">
                                        <?php echo e($schedule->to_time->format('h:i A')); ?>

                                    </div>
                                </td>
                                <!-- Actual In -->
                                <td class="px-6 py-4 bg-emerald-50/20">
                                    <?php if(!empty($schedule->job_started_at)): ?>
                                        <?php $start = \Carbon\Carbon::parse($schedule->job_started_at); ?>
                                        <div class="text-sm text-emerald-700 font-bold"><?php echo e($start->format('M d, Y')); ?></div>
                                        <div class="text-[11px] text-emerald-600 font-medium">
                                            <?php echo e($start->format('h:i A')); ?>

                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 italic font-medium text-xs">--</span>
                                    <?php endif; ?>
                                </td>
                                <!-- Actual Out -->
                                <td class="px-6 py-4 bg-slate-50/30">
                                    <?php if(!empty($schedule->job_ended_at)): ?>
                                        <?php $end = \Carbon\Carbon::parse($schedule->job_ended_at); ?>
                                        <div class="text-sm text-slate-700 font-bold"><?php echo e($end->format('M d, Y')); ?></div>
                                        <div class="text-[11px] text-slate-600 font-medium">
                                            <?php echo e($end->format('h:i A')); ?>

                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 italic font-medium text-xs">--</span>
                                    <?php endif; ?>
                                </td>
                            <?php else: ?>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-700 font-bold"><?php echo e($schedule->from_time->format('M d, Y')); ?></div>
                                    <div class="text-[11px] text-gray-500 font-medium italic">
                                        <?php echo e($schedule->from_time->format('h:i A')); ?>

                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-700 font-bold"><?php echo e($schedule->to_time->format('M d, Y')); ?></div>
                                    <div class="text-[11px] text-gray-500 font-medium italic">
                                        <?php echo e($schedule->to_time->format('h:i A')); ?>

                                    </div>
                                </td>
                            <?php endif; ?>
                            <td class="px-6 py-4">
                                <span
                                    class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-wider <?php echo e($schedule->status_classes); ?>">
                                    <span class="w-1.5 h-1.5 rounded-full <?php echo e($schedule->status_dot_classes); ?>"></span>
                                    <?php echo e($schedule->calculated_status); ?>

                                </span>
                            </td>
                            <?php if($type === 'completed'): ?>
                                <td class="px-6 py-4">
                                    <span
                                        class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full text-xs font-bold bg-orange-100 text-orange-700">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z">
                                            </path>
                                        </svg>
                                        <?php echo e($schedule->issueTickets->count()); ?>

                                    </span>
                                </td>
                            <?php endif; ?>
                            <td class="px-6 py-4 text-right">
                                <div class="flex justify-end gap-1">
                                    <?php if($schedule->isJobCompleted() || $schedule->isJobInProgress()): ?>
                                        <a href="<?php echo e(route('patroller-schedules.show', $schedule)); ?>"
                                            class="p-2 text-blue-500 hover:text-blue-700 hover:bg-blue-50 rounded-xl transition-all group/tooltip relative">
                                            <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                            <span
                                                class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">View
                                                Details</span>
                                        </a>

                                        <button type="button" @click="viewLocations(<?php echo e($schedule->id); ?>)"
                                            class="p-2 text-cyan-500 hover:text-cyan-700 hover:bg-cyan-50 rounded-xl transition-all group/tooltip relative">
                                            <svg class="w-4.5 h-4.5 pointer-events-none" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                                </path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            </svg>
                                            <span
                                                class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">View
                                                Location</span>
                                        </button>

                                        <a href="<?php echo e(route('patroller-schedules.export-single-pdf', $schedule)); ?>"
                                            class="p-2 text-red-500 hover:text-red-700 hover:bg-red-50 rounded-xl transition-all group/tooltip relative">
                                            <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                </path>
                                            </svg>
                                            <span
                                                class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Download
                                                PDF</span>
                                        </a>

                                        <?php if($schedule->issueTickets->count() > 0): ?>
                                            <a href="<?php echo e(route('patroller-schedules.export-images', $schedule)); ?>"
                                                class="p-2 text-purple-500 hover:text-purple-700 hover:bg-purple-50 rounded-xl transition-all group/tooltip relative">
                                                <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Download
                                                    Images ZIP</span>
                                            </a>
                                        <?php endif; ?>
                                    <?php elseif($type !== 'active'): ?>
                                        <?php if($schedule->job_status !== 'cancelled'): ?>
                                            <a href="<?php echo e(route('patroller-schedules.edit', $schedule)); ?>"
                                                class="p-2 text-amber-500 hover:text-amber-700 hover:bg-amber-50 rounded-xl transition-all group/tooltip relative">
                                                <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Edit
                                                    Schedule</span>
                                            </a>
                                        <?php endif; ?>
                                        <?php if($schedule->job_status !== 'cancelled'): ?>
                                            <form action="<?php echo e(route('patroller-schedules.cancel', $schedule)); ?>" method="POST"
                                                class="inline-block"
                                                onsubmit="return confirm('Are you sure you want to cancel this schedule?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <button type="submit"
                                                    class="p-2 text-red-400 hover:text-red-600 hover:bg-red-50 rounded-xl transition-all group/tooltip relative">
                                                    <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M6 18L18 6M6 6l12 12" />
                                                    </svg>
                                                    <span
                                                        class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Cancel
                                                        Schedule</span>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <form action="<?php echo e(route('patroller-schedules.destroy', $schedule)); ?>" method="POST"
                                            class="inline-block"
                                            onsubmit="return confirm('Are you sure you want to delete this schedule?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit"
                                                class="p-2 text-rose-500 hover:text-rose-700 hover:bg-red-50 rounded-xl transition-all group/tooltip relative">
                                                <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                                <span
                                                    class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-slate-900 text-white text-[10px] font-bold rounded opacity-0 group-hover/tooltip:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">Delete</span>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center text-gray-400 italic">
                                No schedules found for this category.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-6">
            <?php echo e($schedules->appends(request()->query())->links()); ?>

        </div>
        <!-- Map Modal -->
        <div x-show="showMapModal" class="fixed inset-0 z-50 flex items-center justify-center p-4" x-cloak
            style="display: none;">
            <div class="absolute inset-0 bg-slate-900/50 backdrop-blur-sm" @click="showMapModal = false"></div>
            <div class="relative bg-white rounded-3xl shadow-xl w-full max-w-4xl h-[600px] flex flex-col overflow-hidden">
                <div class="p-4 border-b border-gray-100 flex justify-between items-center bg-gray-50/50">
                    <h2 class="text-xl font-bold text-gray-900">Location History</h2>
                    <button type="button" @click="showMapModal = false" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                            </path>
                        </svg>
                    </button>
                </div>
                <div class="flex-1 relative bg-slate-50">
                    <div id="map" class="absolute inset-0 z-10 w-full h-full"></div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" crossorigin="" />
        <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" crossorigin=""></script>
        <script>
            function patrollerScheduleList() {
                return {
                    selected: [],
                    allSelected: false,
                    showMapModal: false,
                    map: null,

                    toggleAll() {
                        this.allSelected = !this.allSelected;
                        if (this.allSelected) {
                            this.selected = [<?php echo e(implode(',', $schedules->pluck('id')->toArray())); ?>];
                        } else {
                            this.selected = [];
                        }
                    },

                    viewLocations(scheduleId) {
                        console.log('Opening map for patroller schedule:', scheduleId);
                        this.showMapModal = true;
                        this.$nextTick(() => {
                            if (!this.map) {
                                if (typeof L === 'undefined') {
                                    console.error('Leaflet L is undefined');
                                    alert('Map library not loaded. Please refresh.');
                                    return;
                                }
                                this.map = L.map('map').setView([0, 0], 2);
                                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                                    attribution: '&copy; OpenStreetMap contributors'
                                }).addTo(this.map);
                            }

                            // Clear layers
                            this.map.eachLayer((layer) => {
                                if (layer instanceof L.Marker || layer instanceof L.Polyline) {
                                    this.map.removeLayer(layer);
                                }
                            });

                            fetch(`/patroller-schedules/${scheduleId}/locations`)
                                .then(response => response.json())
                                .then(locations => {
                                    if (locations.length === 0) {
                                        alert('No location data available for this schedule.');
                                        return;
                                    }

                                    const bounds = L.latLngBounds();
                                    const pathCoordinates = [];

                                    locations.forEach(loc => {
                                        const latLng = [loc.lat, loc.lng];
                                        pathCoordinates.push(latLng);
                                        bounds.extend(latLng);

                                        let iconColor = loc.type === 'checkin' ? 'green' : 'red';

                                        // Simple custom marker (optional, defaulting to standard for now or simple circle)
                                        const marker = L.circleMarker(latLng, {
                                            color: iconColor,
                                            fillColor: iconColor,
                                            fillOpacity: 0.8,
                                            radius: 8
                                        }).addTo(this.map);

                                        marker.bindPopup(`
                                                                                    <div class="text-sm font-sans">
                                                                                        <div class="font-bold text-slate-800">${loc.site_name}</div>
                                                                                        <div class="text-xs text-slate-500 mb-1">${loc.time}</div>
                                                                                        <div class="text-xs font-medium ${loc.type === 'checkin' ? 'text-emerald-600' : 'text-red-600'} uppercase">${loc.type.replace('_', ' ')}</div>
                                                                                    </div>
                                                                                `);
                                    });

                                    if (pathCoordinates.length > 0) {
                                        // Draw a simple line connecting points in order (though they might be jumping between sites)
                                        // For patrollers, sorting by time is important. The controller returns them flatmapped, 
                                        // we should ensure they sort by time if we want a path.
                                        // Assuming controller returns rough order.

                                        // L.polyline(pathCoordinates, { color: 'blue', weight: 3, opacity: 0.6, dashArray: '10, 10' }).addTo(this.map);
                                        this.map.fitBounds(bounds, { padding: [50, 50] });
                                    }
                                })
                                .catch(err => {
                                    console.error('Error fetching locations:', err);
                                    alert('Failed to load location history.');
                                });
                        });
                    },

                    submitExport(url) {
                        if (this.selected.length === 0) {
                            alert('Please select records to export.');
                            return;
                        }
                        const form = document.getElementById('exportForm');
                        form.action = url;
                        form.submit();
                    }
                }
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/patroller-schedules/index.blade.php ENDPATH**/ ?>