<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Payout Report</title>
    <style>
        body {
            font-family: sans-serif;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #eee;
            padding-bottom: 15px;
        }

        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #111827;
            margin-bottom: 5px;
        }

        .meta {
            color: #6b7280;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 11px;
        }

        th {
            background: #f9fafb;
            padding: 10px;
            text-transform: uppercase;
            color: #6b7280;
            font-size: 9px;
            letter-spacing: 0.05em;
            border-bottom: 1px solid #e5e7eb;
            text-align: left;
        }

        td {
            padding: 12px 10px;
            border-bottom: 1px solid #f3f4f6;
            color: #374151;
            vertical-align: top;
        }

        .total-box {
            margin-top: 20px;
            text-align: right;
            background: #f9fafb;
            padding: 15px;
            border-radius: 6px;
        }

        .amount {
            color: #059669;
            font-weight: bold;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 9px;
            text-align: center;
            color: #9ca3af;
            padding: 10px;
            border-top: 1px solid #eee;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="logo">Falcon Security Services</div>
        <div class="meta">Payout Report &bull; Generated on <?php echo e(now()->format('M d, Y H:i')); ?></div>
        <div class="meta">Employee: <?php echo e($employee->full_name); ?> (ID: <?php echo e($employee->employee_id ?? 'N/A'); ?>)</div>
    </div>

    <table>
        <thead>
            <tr>
                <th width="20%">Date / Time</th>
                <th width="25%">Site / Duty #</th>
                <th width="15%">Duration</th>
                <th width="20%" style="text-align: right;">Rate</th>
                <th width="20%" style="text-align: right;">Earned</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $payouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <strong><?php echo e($item->date->format('M d, Y')); ?></strong><br>
                        <span style="color: #9ca3af; font-size: 9px;">
                            <?php echo e($item->start_time); ?> - <?php echo e($item->end_time); ?>

                        </span>
                    </td>
                    <td>
                        <?php echo e($item->site_name); ?><br>
                        <div style="margin-top: 4px;">
                            <span
                                style="background: #f3f4f6; padding: 2px 4px; border-radius: 3px; font-size: 8px; color: #6b7280; border: 1px solid #e5e7eb;">#<?php echo e($item->duty_number); ?></span>
                            <span
                                style="background: <?php echo e($item->type === 'Guard' ? '#eff6ff' : '#f5f3ff'); ?>; padding: 2px 4px; border-radius: 3px; font-size: 8px; color: <?php echo e($item->type === 'Guard' ? '#2563eb' : '#7c3aed'); ?>; border: 1px solid <?php echo e($item->type === 'Guard' ? '#dbeafe' : '#ede9fe'); ?>; margin-left: 2px;"><?php echo e($item->type); ?></span>
                        </div>
                    </td>
                    <td><?php echo e(number_format($item->hours, 2)); ?> hrs</td>
                    <td align="right">
                        $<?php echo e(number_format($item->rate, 2)); ?>/hr
                    </td>
                    <td align="right" class="amount">$<?php echo e(number_format($item->total, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="total-box">
        <span style="font-size: 14px; font-weight: bold; color: #374151; margin-right: 15px;">Total Earnings:</span>
        <span style="font-size: 18px;" class="amount">$<?php echo e(number_format($totalEarnings, 2)); ?></span>
    </div>

    <div class="footer">
        FALCON SECURITY SERVICES &bull; CONFIDENTIAL FINANCIAL DOCUMENT
    </div>
</body>

</html><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/employee/reports/payouts_pdf.blade.php ENDPATH**/ ?>