<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Consolidated Operational Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
            color: #333;
        }

        .header {
            margin-bottom: 20px;
        }

        .title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .meta {
            font-size: 12px;
            color: #666;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f3f4f6;
            font-weight: bold;
            text-transform: uppercase;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .employee-header {
            background-color: #e5e7eb;
            font-weight: bold;
            padding: 8px;
            margin-top: 15px;
            margin-bottom: 5px;
            border: 1px solid #ddd;
        }

        .grand-total {
            background-color: #f3f4f6;
            font-weight: bold;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>

<body>
    <div style="margin-bottom: 20px;">
        <?php if($company): ?>
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;"><?php echo e($company->name); ?></h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    <?php echo e($company->address_1); ?><?php echo e($company->address_2 ? ', ' . $company->address_2 : ''); ?>

                </p>
            </div>
        <?php endif; ?>
        <h3 style="margin: 0; color: #334155;">Consolidated Operational Report</h3>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Period:
            <?php echo e(\Carbon\Carbon::parse($startDate)->format('M d, Y')); ?> -
            <?php echo e(\Carbon\Carbon::parse($endDate)->format('M d, Y')); ?>

        </p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: <?php echo e(auth()->user()->name); ?></p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: <?php echo e(now()->format('M d, Y H:i')); ?></p>
    </div>

    <?php $__empty_1 = true; $__currentLoopData = $groupedConsolidated; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empHeader => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="employee-section">
            <div class="employee-header"><?php echo e($empHeader); ?></div>

            <table>
                <thead>
                    <tr>
                        <th style="width: 12%;">Site/Route</th>
                        <th style="width: 8%;">Role</th>
                        <th style="width: 8%;">Duty #</th>
                        <th style="width: 10%;">Start</th>
                        <th style="width: 10%;">End</th>
                        <th style="width: 8%;">Type</th>
                        <th class="text-right" style="width: 6%;">Hrs</th>
                        <th class="text-right" style="width: 7%;">SIN Rate</th>
                        <th class="text-right" style="width: 7%;">Other Rate</th>
                        <th class="text-right" style="width: 6%;">Gas</th>
                        <th class="text-right" style="width: 6%;">Allow</th>
                        <th class="text-center" style="width: 5%;">Tkts</th>
                        <th class="text-right" style="width: 7%;">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $totalHrs = 0;
                        $totalGas = 0;
                        $totalAllowance = 0;
                        $totalTickets = 0;
                        $totalAmount = 0;
                    ?>
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $totalHrs += $row->actual_hrs;
                            $totalGas += $row->gas;
                            $totalAllowance += $row->allowance;
                            $totalTickets += $row->tickets_count;
                            $totalAmount += $row->total_amount;
                        ?>
                        <tr>
                            <td><?php echo e($row->site_route); ?></td>
                            <td style="text-transform: capitalize;"><?php echo e($row->role); ?></td>
                            <td><?php echo e($row->duty_number); ?></td>
                            <td><?php echo e($row->start_time ? $row->start_time->format('m-d H:i') : '-'); ?></td>
                            <td><?php echo e($row->end_time ? $row->end_time->format('m-d H:i') : '-'); ?></td>
                            <td style="text-transform: uppercase;"><?php echo e($row->pay_type); ?></td>
                            <td class="text-right"><?php echo e(number_format($row->actual_hrs, 2)); ?></td>
                            <td class="text-right"><?php echo e(number_format($row->sin_rate, 2)); ?></td>
                            <td class="text-right"><?php echo e(number_format($row->other_rate, 2)); ?></td>
                            <td class="text-right"><?php echo e($row->gas ? number_format($row->gas, 0) : '0'); ?></td>
                            <td class="text-right"><?php echo e($row->allowance ? number_format($row->allowance, 0) : '0'); ?></td>
                            <td class="text-center"><?php echo e($row->tickets_count); ?></td>
                            <td class="text-right bold"><?php echo e(number_format($row->total_amount, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr class="grand-total">
                        <td colspan="6" class="text-right">Grand Total</td>
                        <td class="text-right"><?php echo e(number_format($totalHrs, 2)); ?></td>
                        <td class="text-right">-</td>
                        <td class="text-right">-</td>
                        <td class="text-right"><?php echo e(number_format($totalGas, 0)); ?></td>
                        <td class="text-right"><?php echo e(number_format($totalAllowance, 0)); ?></td>
                        <td class="text-center"><?php echo e($totalTickets); ?></td>
                        <td class="text-right"><?php echo e(number_format($totalAmount, 2)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p>No records found for the selected period.</p>
    <?php endif; ?>
</body>

</html><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/reports/operational/consolidated_pdf.blade.php ENDPATH**/ ?>