

<?php $__env->startSection('title', 'Guard Payout Summary'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <!-- Dashboard Header -->
        <h1 class="text-2xl font-bold text-gray-800">Guard Payout Report</h1>

        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="<?php echo e(route('reports.operational.guard_payouts')); ?>" class="space-y-6">
                <div class="flex flex-col md:flex-row gap-6 items-end">

                    
                    <div class="flex-none flex items-center gap-2">
                        <a href="#" id="exportGuardPayoutPdfBtn" class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
                            Export PDF
                        </a>
                        <a href="#" id="exportGuardPayoutExcelBtn" class="h-[38px] px-4 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                            <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            Export Excel
                        </a>
                    </div>

                    
                    <div class="flex-none">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Report Type</label>
                        <div class="flex items-center gap-4 h-[38px]">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="radio" name="report_type" value="actual" 
                                    <?php echo e(request('report_type', 'actual') == 'actual' ? 'checked' : ''); ?>

                                    class="text-blue-600 focus:ring-blue-500">
                                <span class="text-sm text-gray-700">Actual Hours</span>
                            </label>
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="radio" name="report_type" value="scheduled" 
                                    <?php echo e(request('report_type') == 'scheduled' ? 'checked' : ''); ?>

                                    class="text-blue-600 focus:ring-blue-500">
                                <span class="text-sm text-gray-700">Scheduled Hours</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex-grow"></div> <!-- Spacer -->

                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                        <input type="date" name="start_date"
                            value="<?php echo e(request('start_date', now()->startOfMonth()->format('Y-m-d'))); ?>"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <div class="w-full md:w-40">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                        <input type="date" name="end_date" value="<?php echo e(request('end_date', now()->format('Y-m-d'))); ?>"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <!-- Guard Filter (Searchable) -->
                    <div class="w-full md:w-64" 
                        x-data="searchableSelect({
                            options: <?php echo e($employees->map(fn($e) => ['value' => $e->id, 'label' => $e->first_name . ' ' . $e->last_name])->values()->toJson()); ?>,
                            value: '<?php echo e(request('employee_id')); ?>',
                            placeholder: 'All Guards'
                        })" 
                        @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Guard</label>
                        <div class="relative">
                            <div @click="open = !open" 
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="employee_id" :value="value">
                            
                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search guard..." 
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Guards'})" 
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Guards
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)" 
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}" 
                                            x-text="option.label">
                                        </li>
                                    </template>
                                    <li x-show="filteredOptions.length === 0" class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                        No guards found
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center gap-2 h-[38px] pb-1">
                        <input type="checkbox" name="split_shifts" id="split_shifts" value="1" <?php echo e(request('split_shifts') ? 'checked' : ''); ?> class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                        <label for="split_shifts" class="text-xs font-bold text-gray-600 uppercase tracking-wide cursor-pointer">Split 12-12</label>
                    </div>

                    <button type="submit"
                        class="h-[38px] px-6 bg-slate-100 text-slate-600 text-sm font-bold rounded-lg hover:bg-slate-200 transition-colors whitespace-nowrap shadow-sm border border-slate-200">
                        Search
                    </button>
                </div>
            </form>
        </div>

        <!-- Data Content -->
        <?php $__empty_1 = true; $__currentLoopData = $groupedPayouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empName => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
                <!-- Group Header -->
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                    <h3 class="font-bold text-gray-800"><?php echo e($empName); ?></h3>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead class="bg-gray-50/50 border-b border-gray-100">
                            <tr>
                                <th class="px-4 py-3 w-10">
                                    <input type="checkbox" class="select-all-group rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Site</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Site ID</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Duty Number</th>
                                <?php if(request('report_type') == 'scheduled'): ?>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sch. In Time</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sch. Out Time</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sch. Total Hrs</th>
                                <?php else: ?>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. In Time</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. Out Time</th>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. Worked Hrs</th>
                                <?php endif; ?>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Wage Components</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">Total Amount</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            <?php $__currentLoopData = $group['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-gray-50/50">
                                    <td class="px-4 py-3">
                                        <input type="checkbox" value="<?php echo e($row->id); ?>" class="row-checkbox rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($row->site_name); ?></td>
                                    <td class="px-4 py-3 text-xs font-mono text-gray-500"><?php echo e($row->site_custom_id); ?></td>
                                    <td class="px-4 py-3 text-xs text-gray-600">
                                        <?php echo e($row->duty_number); ?>

                                        <?php if(isset($row->stat_multiplier) && $row->stat_multiplier > 1): ?>
                                            <span class="ml-1 inline-flex items-center px-1.5 py-0.5 rounded text-[8px] font-bold uppercase tracking-wider bg-purple-100 text-purple-700 border border-purple-200" title="<?php echo e($row->stat_holiday_name ?? 'Stat Holiday'); ?> (<?php echo e($row->stat_multiplier); ?>x)">
                                                STAT
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    
                                    <?php if(request('report_type') == 'scheduled'): ?>
                                        
                                        <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                            <?php echo e(\Carbon\Carbon::parse($row->display_sched_in)->format('Y-m-d H:i')); ?>

                                        </td>
                                        <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                            <?php echo e(\Carbon\Carbon::parse($row->display_sched_out)->format('Y-m-d H:i')); ?>

                                        </td>
                                        <td class="px-4 py-3 text-xs text-gray-600 font-medium">
                                            <?php echo e(number_format($row->display_sched_hours, 2)); ?>

                                        </td>
                                    <?php else: ?>
                                        
                                        <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                            <?php echo e(\Carbon\Carbon::parse($row->display_act_in)->format('Y-m-d H:i')); ?>

                                        </td>
                                        <td class="px-4 py-3 text-xs text-gray-600 whitespace-nowrap">
                                            <?php echo e(\Carbon\Carbon::parse($row->display_act_out)->format('Y-m-d H:i')); ?>

                                        </td>
                                        <td class="px-4 py-3 text-xs font-bold text-gray-800">
                                            <?php echo e(number_format($row->display_act_hours, 2)); ?>

                                        </td>
                                    <?php endif; ?>

                                    <td class="px-4 py-3">
                                        <?php
                                            $wageTypes = json_decode($row->wage_types, true) ?: [];
                                            $gasRate = $row->gas_rate > 0 ? $row->gas_rate : 0;
                                        ?>
                                        
                                        <?php if(!empty($wageTypes) || $gasRate > 0): ?>
                                            <div class="space-y-1.5">
                                                <?php $__currentLoopData = $wageTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wageType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $componentHours = $wageType['allocated_hours'] ?? 0;
                                                        $componentRate = $wageType['rate'] ?? 0;
                                                        $componentPay = $componentHours * $componentRate;
                                                    ?>
                                                    <div class="flex items-center justify-between gap-4 text-xs bg-blue-50/50 px-2 py-1 rounded border border-blue-100">
                                                        <span class="font-bold text-blue-700 uppercase text-[10px]"><?php echo e($wageType['name'] ?? 'Wage'); ?></span>
                                                        <div class="flex items-center gap-2 text-[10px]">
                                                            <span class="text-gray-600"><?php echo e(number_format($componentHours, 2)); ?> hrs</span>
                                                            <span class="text-gray-400">×</span>
                                                            <span class="text-gray-600">$<?php echo e(number_format($componentRate, 2)); ?></span>
                                                            <span class="text-gray-400">=</span>
                                                            <span class="font-bold text-blue-700">$<?php echo e(number_format($componentPay, 2)); ?></span>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <?php if($gasRate > 0): ?>
                                                    <div class="flex items-center justify-between gap-4 text-xs bg-amber-50/50 px-2 py-1 rounded border border-amber-100">
                                                        <span class="font-bold text-amber-700 uppercase text-[10px]">GAS/CASH</span>
                                                        <div class="flex items-center gap-2 text-[10px]">
                                                            <span class="font-bold text-amber-700">$<?php echo e(number_format($gasRate, 2)); ?></span>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400 italic">No wage data</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-right">
                                        <div class="text-sm font-black text-gray-900">$<?php echo e(number_format($row->total_amount, 2)); ?></div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <!-- Subtotal Row -->
                            <tr class="bg-gray-50 font-bold border-t border-gray-200">
                                <td colspan="7" class="px-4 py-3 text-right text-xs uppercase tracking-wide text-gray-500">Total</td>
                                <td class="px-4 py-3 text-sm text-gray-900"><?php echo e(number_format($group['total_hours'], 2)); ?> hrs</td>
                                <td></td>
                                <td class="px-4 py-3 text-right text-sm text-gray-900">$<?php echo e(number_format($group['total_amount'], 2)); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-8 text-center text-gray-500">
                No payout records found for the selected period.
            </div>
        <?php endif; ?>
    </div>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Selection logic for groups
            const groupSelectAlls = document.querySelectorAll('.select-all-group');
            groupSelectAlls.forEach(selectAll => {
                selectAll.addEventListener('change', function() {
                    const groupTable = this.closest('table');
                    const checkboxes = groupTable.querySelectorAll('.row-checkbox');
                    checkboxes.forEach(cb => cb.checked = this.checked);
                });
            });

            // Export handlers
            const exportExcelBtn = document.getElementById('exportGuardPayoutExcelBtn');
            const exportPdfBtn = document.getElementById('exportGuardPayoutPdfBtn');

            function handleExport(isExcel) {
                const selectedIds = Array.from(document.querySelectorAll('.row-checkbox:checked'))
                    .map(cb => cb.value);

                const baseUrl = isExcel
                    ? "<?php echo e(route('reports.operational.guard_payouts.export.excel')); ?>"
                    : "<?php echo e(route('reports.operational.guard_payouts.export.pdf')); ?>";

                const params = new URLSearchParams(window.location.search);
                if (selectedIds.length > 0) {
                    params.set('ids', selectedIds.join(','));
                }

                window.location.href = baseUrl + '?' + params.toString();
            }

            if (exportExcelBtn) {
                exportExcelBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    handleExport(true);
                });
            }
            if (exportPdfBtn) {
                exportPdfBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    handleExport(false);
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/reports/operational/guard_payouts.blade.php ENDPATH**/ ?>