<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="relative bg-[#1e293b] overflow-hidden">
        <!-- Background Decoration -->
        <div class="absolute inset-0 z-0">
            <div class="absolute inset-0 bg-gradient-to-r from-gray-900 to-blue-900 opacity-90"></div>
            <!-- Decorative circle -->
            <div
                class="absolute top-0 right-0 -mt-20 -mr-20 w-96 h-96 bg-blue-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob">
            </div>
            <div
                class="absolute bottom-0 left-0 -mb-20 -ml-20 w-96 h-96 bg-purple-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-2000">
            </div>
        </div>

        <div
            class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 py-32 md:py-48 flex flex-col items-center text-center">
            <span
                class="inline-block py-1 px-3 rounded-full bg-blue-500/20 border border-blue-400/30 text-blue-300 text-sm font-semibold mb-6 backdrop-blur-sm">
                Next Gen Security Management
            </span>
            <h1 class="text-5xl md:text-7xl font-bold text-white tracking-tight mb-8 leading-tight">
                Secure Your World with <br>
                <span class="text-transparent bg-clip-text bg-gradient-to-br from-blue-400 to-cyan-300">Shift Matrix</span>
            </h1>
            <p class="text-xl text-gray-300 max-w-2xl mb-10 leading-relaxed">
                Connect with professional security personnel, manage schedules efficiently, and ensure safety with our
                state-of-the-art platform.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 w-full sm:w-auto">
                <a href="<?php echo e(route('become-guard')); ?>"
                    class="px-8 py-4 rounded-full bg-blue-600 text-white font-bold text-lg shadow-xl shadow-blue-500/20 hover:bg-blue-500 hover:scale-105 transition-all duration-300">
                    Apply Now to Guard
                </a>
                <a href="<?php echo e(route('contact')); ?>"
                    class="px-8 py-4 rounded-full bg-white/10 backdrop-blur-md border border-white/20 text-white font-semibold text-lg hover:bg-white/20 hover:border-white/30 transition-all duration-300">
                    Contact Sales
                </a>
            </div>

            <!-- App Download Links -->
            <div class="mt-12 flex flex-wrap justify-center gap-6">
                <a href="#"
                    class="flex items-center gap-3 px-6 py-3 bg-black text-white rounded-2xl hover:bg-gray-800 transition-all border border-gray-700 shadow-lg group">
                    <svg class="w-8 h-8 group-hover:scale-110 transition-transform" viewBox="0 0 384 512"
                        fill="currentColor">
                        <path
                            d="M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z" />
                    </svg>
                    <div class="text-left">
                        <div class="text-[10px] uppercase font-bold text-gray-400 leading-tight">Download on the</div>
                        <div class="text-lg font-bold leading-tight">App Store</div>
                    </div>
                </a>
                <a href="#"
                    class="flex items-center gap-3 px-6 py-3 bg-black text-white rounded-2xl hover:bg-gray-800 transition-all border border-gray-700 shadow-lg group">
                    <svg class="w-8 h-8 group-hover:scale-110 transition-transform" viewBox="0 0 512 512"
                        fill="currentColor">
                        <path
                            d="M325.3 234.3L104.6 13l280.8 161.2-60.1 60.1zM47 0C34 6.8 25.3 19.2 25.3 35.3v441.3c0 16.1 8.7 28.5 21.7 35.3l256.6-256L47 0zm425.2 225.6l-58.9-34.1-65.7 64.5 65.7 64.5 60.1-34.1c18-10.3 18-27.4-1.2-36.3zM104.6 499l220.7-127.3-60.1-60.1L104.6 499z" />
                    </svg>
                    <div class="text-left">
                        <div class="text-[10px] uppercase font-bold text-gray-400 leading-tight">Get it on</div>
                        <div class="text-lg font-bold leading-tight">Google Play</div>
                    </div>
                </a>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Why Choose Shift Matrix?</h2>
                <div class="w-20 h-1 bg-blue-600 mx-auto rounded-full"></div>
                <p class="mt-4 text-xl text-gray-600">Excellence in every shift, transparency in every report.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Feature 1 -->
                <div
                    class="p-8 rounded-2xl bg-gray-50 hover:bg-white hover:shadow-2xl hover:shadow-gray-200 transition-all duration-300 border border-transparent hover:border-gray-100 group">
                    <div
                        class="w-14 h-14 bg-blue-100 rounded-xl flex items-center justify-center text-blue-600 mb-6 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                            </path>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">Top-Tier Security</h3>
                    <p class="text-gray-600 leading-relaxed">
                        We vet every guard rigorously to ensure peace of mind for our clients. Security is our priority.
                    </p>
                </div>

                <!-- Feature 2 -->
                <div
                    class="p-8 rounded-2xl bg-gray-50 hover:bg-white hover:shadow-2xl hover:shadow-gray-200 transition-all duration-300 border border-transparent hover:border-gray-100 group">
                    <div
                        class="w-14 h-14 bg-indigo-100 rounded-xl flex items-center justify-center text-indigo-600 mb-6 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01">
                            </path>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">Smart Scheduling</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Our advanced rostering system ensures zero gaps in coverage and efficient employee management.
                    </p>
                </div>

                <!-- Feature 3 -->
                <div
                    class="p-8 rounded-2xl bg-gray-50 hover:bg-white hover:shadow-2xl hover:shadow-gray-200 transition-all duration-300 border border-transparent hover:border-gray-100 group">
                    <div
                        class="w-14 h-14 bg-cyan-100 rounded-xl flex items-center justify-center text-cyan-600 mb-6 group-hover:scale-110 transition-transform duration-300">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">Rapid Response</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Real-time reporting and communication tools keep everyone connected when it matters most.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action Section -->
    <section class="py-20 bg-gray-900 relative overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-r from-blue-900/50 to-purple-900/50"></div>
        <div class="max-w-4xl mx-auto px-4 text-center relative z-10">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">Ready to Join the Team?</h2>
            <p class="text-xl text-gray-300 mb-8">
                We are always looking for dedicated professionals to join our ranks. Apply today and start your career with
                Shift Matrix.
            </p>
            <a href="<?php echo e(route('become-guard')); ?>"
                class="inline-block px-10 py-4 rounded-full bg-white text-gray-900 font-bold text-lg hover:bg-gray-100 transition-colors shadow-[0_0_20px_rgba(255,255,255,0.3)]">
                Apply as a Guard
            </a>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/welcome.blade.php ENDPATH**/ ?>