

<?php $__env->startSection('title', 'Operational Reports'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <!-- Company Header -->
        <?php if($company): ?>
            <div class="flex flex-col gap-1 mb-4">
                <h2 class="text-xl font-bold text-gray-900 tracking-tight uppercase"><?php echo e($company->name); ?></h2>
                <p class="text-sm text-gray-500 font-medium italic">
                    <?php echo e($company->address_1); ?><?php echo e($company->address_2 ? ', ' . $company->address_2 : ''); ?>

                </p>
            </div>
        <?php endif; ?>
        <!-- Filters and Actions -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="<?php echo e(route('reports.operational.index')); ?>" class="space-y-6">
                <input type="hidden" name="type" value="<?php echo e($reportType); ?>">

                <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-end">
                    <!-- Date Range -->
                    <div class="md:col-span-2">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                        <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                        <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>"
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                    </div>

                    <!-- Site & Employee -->
                    <!-- Site Filter (Searchable) -->
                    <div class="md:col-span-2" x-data="searchableSelect({
                                    options: <?php echo e($sites->map(fn($s) => ['value' => $s->id, 'label' => $s->name])->values()->toJson()); ?>,
                                    value: '<?php echo e(request('site_id')); ?>',
                                    placeholder: 'All Sites'
                                })" @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                        <div class="relative">
                            <div @click="open = !open"
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="site_id" :value="value">

                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search site..."
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Sites'})"
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Sites
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                            x-text="option.label">
                                        </li>
                                    </template>
                                    <li x-show="filteredOptions.length === 0"
                                        class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                        No sites found
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Employee Filter (Searchable) -->
                    <div class="md:col-span-2" x-data="searchableSelect({
                                    options: <?php echo e($employees->map(fn($e) => ['value' => $e->id, 'label' => $e->first_name . ' ' . $e->last_name])->values()->toJson()); ?>,
                                    value: '<?php echo e(request('employee_id')); ?>',
                                    placeholder: 'All Employees'
                                })" @click.outside="open = false">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                        <div class="relative">
                            <div @click="open = !open"
                                class="w-full bg-white border border-gray-300 rounded-lg px-3 py-2 text-sm shadow-sm cursor-pointer flex justify-between items-center h-[38px] hover:border-blue-400 transition-colors">
                                <span x-text="selectedLabel" class="truncate text-gray-700"></span>
                                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                            <input type="hidden" name="employee_id" :value="value">

                            <div x-show="open" x-transition.origin.top.left x-cloak
                                class="absolute z-50 w-full bg-white border border-gray-300 rounded-lg mt-1 shadow-xl max-h-60 overflow-hidden flex flex-col">
                                <div class="p-2 border-b border-gray-100 bg-gray-50/50">
                                    <input type="text" x-model="search" placeholder="Search employee..."
                                        class="w-full text-xs border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 py-1.5 px-2">
                                </div>
                                <ul class="overflow-y-auto flex-1 p-1">
                                    <li @click="select({value: '', label: 'All Employees'})"
                                        class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer transition-colors"
                                        :class="{'bg-blue-50 text-blue-700 font-medium': value === ''}">
                                        All Employees
                                    </li>
                                    <template x-for="option in filteredOptions" :key="option.value">
                                        <li @click="select(option)"
                                            class="px-3 py-2 text-sm rounded-md hover:bg-blue-50 hover:text-blue-700 cursor-pointer truncate transition-colors"
                                            :class="{'bg-blue-50 text-blue-700 font-medium': value == option.value}"
                                            x-text="option.label">
                                        </li>
                                    </template>
                                    <li x-show="filteredOptions.length === 0"
                                        class="px-3 py-4 text-xs text-gray-400 text-center italic">
                                        No employees found
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Search -->
                    <div class="md:col-span-2">
                        <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Search</label>
                        <div class="relative">
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Duty #..."
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 pl-8 py-2 shadow-sm">
                            <svg class="w-4 h-4 text-gray-400 absolute left-2.5 top-2.5" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="md:col-span-2 flex items-center justify-end gap-2">
                        <button type="submit"
                            class="h-[38px] px-4 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors shadow-sm">
                            Apply
                        </button>

                        <div class="flex gap-1">
                            <a href="<?php echo e(route('reports.operational.export.excel', request()->all())); ?>" title="Export Excel"
                                class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-green-600 transition-colors shadow-sm">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                    </path>
                                </svg>
                            </a>
                            <a href="<?php echo e(route('reports.operational.export.pdf', request()->all())); ?>" title="Export PDF"
                                class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-red-600 transition-colors shadow-sm">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                                    </path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-gray-100 p-1 rounded-xl w-fit">
            <?php
                $queryParams = request()->except('type');
            ?>
            <a href="<?php echo e(route('reports.operational.index', array_merge($queryParams, ['type' => 'checkin']))); ?>"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e($reportType === 'checkin' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700'); ?>">
                Check-in Report
            </a>
            <a href="<?php echo e(route('reports.operational.index', array_merge($queryParams, ['type' => 'checkout']))); ?>"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e($reportType === 'checkout' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700'); ?>">
                Checkout Report
            </a>
            <a href="<?php echo e(route('reports.operational.index', array_merge($queryParams, ['type' => 'combined']))); ?>"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e($reportType === 'combined' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700'); ?>">
                Check-IN/OUT Report
            </a>
            <a href="<?php echo e(route('reports.operational.index', array_merge($queryParams, ['type' => 'scans_history']))); ?>"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e($reportType === 'scans_history' ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700'); ?>">
                Scan History
            </a>
            <a href="<?php echo e(route('reports.operational.banned')); ?>"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e(request()->routeIs('reports.operational.banned') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700'); ?>">
                Banned Employees
            </a>
            <a href="<?php echo e(route('reports.operational.passwords')); ?>"
                class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e(request()->routeIs('reports.operational.passwords') ? 'bg-white text-slate-900 shadow-sm' : 'text-slate-500 hover:text-slate-700'); ?>">
                Credentials
            </a>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <?php if($reportType === 'scans_history'): ?>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Mission / Site</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Scheduled Start</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Scheduled End</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Actual Start</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Actual End</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Total Scans</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Detailed History</th>
                            <?php else: ?>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Duty #</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Employee</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Site</th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sched. Start
                                </th>
                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Sched. End
                                </th>

                                <?php if($reportType === 'checkin' || $reportType === 'combined'): ?>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. Start
                                    </th>
                                <?php endif; ?>

                                <?php if($reportType === 'checkout' || $reportType === 'combined'): ?>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Act. End</th>
                                <?php endif; ?>

                                <?php if($reportType === 'checkout' || $reportType === 'combined'): ?>
                                    <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Total Hours
                                    </th>
                                <?php endif; ?>

                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider">Status</th>

                                <th class="px-4 py-3 text-[10px] font-bold text-gray-500 uppercase tracking-wider text-right">
                                    Actions</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50/80 transition-colors">
                            <?php if($reportType === 'scans_history'): ?>
                                <td class="px-4 py-3">
                                    <div class="flex flex-col">
                                        <span class="text-sm font-bold text-gray-900"><?php echo e($row->duty_number); ?></span>
                                        <span class="text-xs text-gray-500"><?php echo e($row->site_name); ?></span>
                                    </div>
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-500">
                                    <?php echo e(\Carbon\Carbon::parse($row->from_datetime)->format('M d, H:i')); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-500">
                                    <?php echo e(\Carbon\Carbon::parse($row->to_datetime)->format('M d, H:i')); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-900">
                                    <?php echo e($row->actual_start_at ? \Carbon\Carbon::parse($row->actual_start_at)->format('H:i') : '--'); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-900">
                                    <?php echo e($row->actual_end_at ? \Carbon\Carbon::parse($row->actual_end_at)->format('H:i') : '--'); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold bg-blue-100 text-blue-800">
                                        <?php echo e($row->total_scans); ?> Scans
                                    </span>
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap">
                                    <?php
                                        $statusConfig = [
                                            'completed' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'label' => 'Completed'],
                                            'active' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-700', 'label' => 'Active'],
                                            'upcoming' => ['bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'label' => 'Upcoming'],
                                            'missed' => ['bg' => 'bg-red-100', 'text' => 'text-red-700', 'label' => 'Missed'],
                                        ];
                                        $config = $statusConfig[$row->status] ?? ['bg' => 'bg-gray-100', 'text' => 'text-gray-700', 'label' => ucfirst($row->status)];
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-medium <?php echo e($config['bg']); ?> <?php echo e($config['text']); ?>">
                                        <?php echo e($config['label']); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-3 whitespace-nowrap">
                                    <div class="flex flex-col gap-1">
                                        <?php if($row->total_scans > 0): ?>
                                            <div class="flex items-center gap-2 mt-1">
                                                <span class="text-[10px] font-semibold text-gray-500 uppercase tracking-wider">Report</span>
                                                <a href="<?php echo e(route('reports.operational.single.pdf', ['id' => $row->employee_schedule_id, 'type' => 'scans_history'])); ?>"
                                                   class="text-red-600 hover:text-red-800" title="Download Scan History PDF" target="_blank" download>
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                                    </svg>
                                                </a>
                                                <form action="<?php echo e(route('reports.operational.email-scans', $row->employee_schedule_id)); ?>" method="POST" class="inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="text-blue-600 hover:text-blue-800" title="Email Scan History to Client">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                                        </svg>
                                                    </button>
                                                </form>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400 italic">--</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            <?php else: ?>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-600">
                                    <?php echo e(\Carbon\Carbon::parse($row->schedule_date)->format('M d, Y')); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs font-medium text-gray-500">
                                    #<?php echo e($row->duty_number); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm font-bold text-gray-900">
                                    <?php echo e($row->employee_name); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-600">
                                    <?php echo e($row->site_name); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-500">
                                    <?php echo e(\Carbon\Carbon::parse($row->from_datetime)->format('H:i')); ?>

                                </td>
                                <td class="px-4 py-3 whitespace-nowrap text-xs text-gray-500">
                                    <?php echo e(\Carbon\Carbon::parse($row->to_datetime)->format('H:i')); ?>

                                </td>

                                <?php if($reportType === 'checkin' || $reportType === 'combined'): ?>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <?php if($row->actual_start_at): ?>
                                            <span
                                                class="text-xs font-bold text-emerald-700 bg-emerald-50 px-2 py-1 rounded border border-emerald-100">
                                                <?php echo e(\Carbon\Carbon::parse($row->actual_start_at)->format('H:i')); ?>

                                                <?php if(\Carbon\Carbon::parse($row->from_datetime)->format('Y-m-d') !== \Carbon\Carbon::parse($row->actual_start_at)->format('Y-m-d')): ?>
                                                    <span
                                                        class="text-[9px] text-gray-500 ml-1">(<?php echo e(\Carbon\Carbon::parse($row->actual_start_at)->format('d/m')); ?>)</span>
                                                <?php endif; ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400 italic">--</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>

                                <?php if($reportType === 'checkout' || $reportType === 'combined'): ?>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <?php if($row->actual_end_at): ?>
                                            <span
                                                class="text-xs font-bold text-indigo-700 bg-indigo-50 px-2 py-1 rounded border border-indigo-100">
                                                <?php echo e(\Carbon\Carbon::parse($row->actual_end_at)->format('H:i')); ?>

                                                <?php if(\Carbon\Carbon::parse($row->to_datetime)->format('Y-m-d') !== \Carbon\Carbon::parse($row->actual_end_at)->format('Y-m-d')): ?>
                                                    <span
                                                        class="text-[9px] text-gray-500 ml-1">(<?php echo e(\Carbon\Carbon::parse($row->actual_end_at)->format('d/m')); ?>)</span>
                                                <?php endif; ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400 italic">--</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>

                                <?php if($reportType === 'checkout' || $reportType === 'combined'): ?>
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <?php if($row->actual_start_at && $row->actual_end_at): ?>
                                            <?php
                                                $start = \Carbon\Carbon::parse($row->actual_start_at);
                                                $end = \Carbon\Carbon::parse($row->actual_end_at);
                                                $diffInMinutes = $start->diffInMinutes($end);
                                                $decimalHours = $diffInMinutes / 60;
                                            ?>
                                            <span class="text-xs font-bold text-gray-700"><?php echo e(number_format($decimalHours, 2)); ?> hrs</span>
                                        <?php else: ?>
                                            <span class="text-xs text-gray-400 italic">--</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>

                                <td class="px-4 py-3 whitespace-nowrap">
                                    <?php
                                        $statusConfig = [
                                            'completed' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'label' => 'Completed'],
                                            'active' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-700', 'label' => 'Active'],
                                            'upcoming' => ['bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'label' => 'Upcoming'],
                                            'missed' => ['bg' => 'bg-red-100', 'text' => 'text-red-700', 'label' => 'Missed'],
                                        ];
                                        $config = $statusConfig[$row->status] ?? ['bg' => 'bg-gray-100', 'text' => 'text-gray-700', 'label' => ucfirst($row->status)];
                                    ?>
                                    <span
                                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[10px] font-medium <?php echo e($config['bg']); ?> <?php echo e($config['text']); ?>">
                                        <?php echo e($config['label']); ?>

                                    </span>
                                </td>

                                <td class="px-4 py-3 whitespace-nowrap text-right text-sm font-medium">
                                    <div class="flex items-center justify-end gap-2">
                                        
                                        <a href="<?php echo e(route('reports.operational.single.pdf', $row->report_id)); ?>"
                                            target="_blank" download
                                            title="Download PDF"
                                            class="p-2 text-slate-400 hover:text-red-600 hover:bg-slate-50 rounded-lg transition-colors">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                </path>
                                            </svg>
                                        </a>

                                        
                                        <?php if($reportType === 'combined'): ?>
                                            <form action="<?php echo e(route('reports.operational.email-shift-user', [$row->schedule_id, $row->employee_id])); ?>" method="POST" class="inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" title="Email Comprehensive Report to Me"
                                                    class="p-2 text-slate-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-colors">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                                        </path>
                                                    </svg>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="px-6 py-12 text-center text-gray-400">
                                    <div
                                        class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 border border-gray-200">
                                        <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                    </div>
                                    <p class="text-xs font-bold uppercase tracking-wider">No records found for this report type
                                    </p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($reports->hasPages()): ?>
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    <?php echo e($reports->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/shiftmatrix.ca/resources/views/reports/operational/index.blade.php ENDPATH**/ ?>