<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});

Broadcast::channel('user.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});

Broadcast::channel('meeting.{uuid}', function ($user, $uuid) {
    $meeting = \App\Models\Meeting::where('uuid', $uuid)->first();
    if (!$meeting)
        return false;

    // Check if user is the creator OR an approved participant
    $isAuthorized = ($meeting->creator_id == $user->id) ||
        \App\Models\MeetingParticipant::where('meeting_id', $meeting->id)
            ->where('user_id', $user->id)
            ->where('status', 'approved')
            ->exists();

    if ($isAuthorized) {
        return ['id' => $user->id, 'name' => $user->name];
    }

    return false;
});

Broadcast::channel('waiting-room.{uuid}', function ($user, $uuid) {
    $meeting = \App\Models\Meeting::where('uuid', $uuid)->first();
    return $meeting && (int) $meeting->creator_id === (int) $user->id;
});
