<?php
use App\Http\Controllers\Api\EmployeeAPIController;
use App\Http\Controllers\Api\PatrollerAPIController;
use App\Http\Controllers\Api\EmployeeAuthController;
use App\Models\Employee;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\PublicAPIController;

// Public Routes
Route::post('/submit-guard-application', [PublicAPIController::class, 'storeGuardApplication']);
Route::post('/webhooks/mailgun', [\App\Http\Controllers\Webhook\MailgunWebhookController::class, 'handle'])->name('webhooks.mailgun');

Route::prefix('employee')->group(function () {
    // Auth Routes
    Route::post('/login', [EmployeeAuthController::class, 'login']);
    Route::post('/forgot-password', [EmployeeAuthController::class, 'forgotPassword']);
    Route::post('/reset-password', [EmployeeAuthController::class, 'resetPassword']);
    Route::get('/user', function (Request $request) {
        $employee = $request->user();

        if (!$employee instanceof Employee) {
            $employee = Employee::where('email', $employee->email)->first();
        }

        return $employee;
    })->middleware('auth:sanctum');

    Route::middleware('auth:sanctum')->group(function () {

        Route::post('/logout', [EmployeeAuthController::class, 'logout']);
        Route::post('/fcm-token', [EmployeeAuthController::class, 'updateFcmToken']);
        Route::get('/profile', [EmployeeAPIController::class, 'profile']);
        Route::post('/profile', [EmployeeAPIController::class, 'updateProfile']);
        Route::get('/jobs', [EmployeeAPIController::class, 'jobs']);
        Route::get('/patroller-jobs', [PatrollerAPIController::class, 'index']);
        Route::post('/patroller-jobs/{id}/start', [PatrollerAPIController::class, 'start']);
        Route::get('/patroller-jobs/{id}/report', [PatrollerAPIController::class, 'getJobReport']);
        Route::get('/patroller-jobs/{id}/export/pdf', [PatrollerAPIController::class, 'exportPdf'])->name('api.employee.patroller.export.pdf');

        // Patroller Execution Routes
        Route::post('/patroller-jobs/{id}/site-checkin', [PatrollerAPIController::class, 'siteCheckin']);
        Route::post('/patroller-jobs/{id}/site-checkout', [PatrollerAPIController::class, 'siteCheckout']);
        Route::post('/patroller-jobs/{id}/issueticket', [PatrollerAPIController::class, 'reportIncident']);
        Route::get('/patroller-jobs/{id}/issuetickets', [PatrollerAPIController::class, 'getIncidents']);
        Route::post('/patroller-jobs/{id}/issuetickets/{ticketId}/update', [PatrollerAPIController::class, 'updateIssueTicket']);
        Route::delete('/patroller-jobs/{id}/issuetickets/{ticketId}/delete-image', [PatrollerAPIController::class, 'deleteIssueTicketImage']);
        Route::delete('/patroller-jobs/{id}/issuetickets/{ticketId}', [PatrollerAPIController::class, 'deleteIssueTicket']);
        Route::post('/patroller-jobs/{id}/end', [PatrollerAPIController::class, 'endJob']);
        Route::post('/patroller-jobs/{id}/cancel', [PatrollerAPIController::class, 'requestCancellation']);
        Route::get('/dashboard', [EmployeeAPIController::class, 'dashboard']);
        Route::get('/analytics', [EmployeeAPIController::class, 'analytics']);

        Route::get('/requests', [EmployeeAPIController::class, 'listRequests']);
        Route::get('/requests/meta', [EmployeeAPIController::class, 'requestsMeta']);
        Route::get('/requests/{id}', [EmployeeAPIController::class, 'showRequest']);
        Route::post('/requests', [EmployeeAPIController::class, 'storeRequest']);

        Route::post('/requests/{id}/reply', [EmployeeAPIController::class, 'replyToRequest']);

        Route::get('/uniforms', [EmployeeAPIController::class, 'uniforms']);
        Route::get('/incident-categories', [EmployeeAPIController::class, 'incidentCategories']);

        Route::get('/notifications', [EmployeeAPIController::class, 'notifications']);
        Route::post('/notifications/{id}/read', [EmployeeAPIController::class, 'markNotificationAsRead']);

        Route::get('/settings', [EmployeeAPIController::class, 'settings']);


        Route::post('/settings/password', [EmployeeAPIController::class, 'updatePassword']);

        // Job Management Routes
        Route::post('/jobs/{id}/start', [EmployeeAPIController::class, 'startJob']);
        Route::post('/jobs/{id}/checkin', [EmployeeAPIController::class, 'checkin']);
        Route::post('/jobs/{id}/incident', [EmployeeAPIController::class, 'reportIncident']);
        Route::post('/jobs/{id}/checkout-evidence', [EmployeeAPIController::class, 'uploadCheckoutEvidence']);
        Route::post('/jobs/{id}/end', [EmployeeAPIController::class, 'endJob']);
        Route::delete('/jobs/{id}/evidence/{type}/{index}', [EmployeeAPIController::class, 'deleteEvidence']);
        Route::post('/jobs/{id}/cancel', [EmployeeAPIController::class, 'requestCancellation']);
        Route::get('/jobs/{id}/reliever', [EmployeeAPIController::class, 'getRelieverInfo']);
        Route::get('/jobs/{id}/report', [EmployeeAPIController::class, 'getJobReport']);
        Route::post('/jobs/{id}/scan', [EmployeeAPIController::class, 'scanCheckpoint']);
        Route::post('/jobs/{id}/location', [EmployeeAPIController::class, 'logLocation']);

        // Notes & Tour Progress
        Route::get('/jobs/{id}/notes', [EmployeeAPIController::class, 'getNotes']);
        Route::post('/jobs/{id}/notes', [EmployeeAPIController::class, 'storeNote']);
        Route::get('/jobs/{id}/tour-progress', [EmployeeAPIController::class, 'getTourProgress']);
        // Operational Reports
        Route::get('/operational-reports', [EmployeeAPIController::class, 'operationalReports']);
        Route::get('/operational-reports/filters', [EmployeeAPIController::class, 'operationalReportFilters']);
        Route::get('/operational-reports/export/pdf', [EmployeeAPIController::class, 'operationalReportExportPdf'])->name('api.employee.reports.export.pdf');
        Route::get('/operational-reports/export/excel', [EmployeeAPIController::class, 'operationalReportExportExcel'])->name('api.employee.reports.export.excel');

        // Payouts
        Route::get('/payouts', [EmployeeAPIController::class, 'payouts']);
        Route::get('/payouts/export/pdf', [EmployeeAPIController::class, 'payoutsExportPdf'])->name('api.employee.payouts.export.pdf');
    });
});

// Public or differently protected route for listing employees (if needed for mobile dev)
// Route::get('/employee/search', [EmployeeAPIController::class, 'index']);
