@extends('layouts.user')

@section('title', 'Vehicle Details')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div
            class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl">
            <div>
                <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                    <a href="{{ route('vehicles.index') }}" class="hover:text-white transition-colors">Vehicles</a>
                    <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                    <span class="text-white">{{ $vehicle->vehicle_id }}</span>
                </div>
                <h1 class="text-3xl font-black tracking-tight">{{ $vehicle->make }} {{ $vehicle->model }}</h1>
                <p class="text-xs text-slate-400 font-medium mt-1">{{ $vehicle->year }} • {{ $vehicle->vin_number }}</p>
            </div>

            <div class="flex items-center gap-3">
                <a href="{{ route('vehicles.edit', $vehicle) }}"
                    class="flex items-center gap-2 px-6 py-2.5 bg-blue-600 hover:bg-blue-700 text-white text-xs font-bold rounded-2xl transition-all">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                        </path>
                    </svg>
                    Edit Vehicle
                </a>
                <a href="{{ route('vehicles.index') }}"
                    class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18">
                        </path>
                    </svg>
                    Back to List
                </a>
            </div>
        </div>

        <!-- Vehicle Details -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Info -->
            <div class="lg:col-span-2 space-y-6">
                <div class="bg-white border border-slate-100 rounded-[2rem] shadow-xl p-8">
                    <h2 class="text-lg font-black text-slate-900 mb-6">Vehicle Information</h2>
                    <div class="grid grid-cols-2 gap-6">
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Vehicle ID</p>
                            <p class="text-sm font-bold text-slate-900">{{ $vehicle->vehicle_id }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Make</p>
                            <p class="text-sm font-bold text-slate-900">{{ $vehicle->make ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Model</p>
                            <p class="text-sm font-bold text-slate-900">{{ $vehicle->model ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Year</p>
                            <p class="text-sm font-bold text-slate-900">{{ $vehicle->year ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">VIN Number</p>
                            <p class="text-sm font-bold text-slate-900 font-mono">{{ $vehicle->vin_number ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">License Plate</p>
                            <p class="text-sm font-bold text-slate-900">{{ $vehicle->license_plate ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Color</p>
                            <p class="text-sm font-bold text-slate-900">{{ $vehicle->color ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Acquisition Date
                            </p>
                            <p class="text-sm font-bold text-slate-900">
                                {{ $vehicle->acquisition_date ? $vehicle->acquisition_date->format('M d, Y') : 'N/A' }}
                            </p>
                        </div>
                    </div>

                    @if($vehicle->comments)
                        <div class="mt-6 pt-6 border-t border-slate-100">
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-2">Comments</p>
                            <p class="text-sm text-slate-700">{{ $vehicle->comments }}</p>
                        </div>
                    @endif
                </div>

                <!-- Images -->
                @if($vehicle->images && count($vehicle->images) > 0)
                    <div class="bg-white border border-slate-100 rounded-[2rem] shadow-xl p-8">
                        <h2 class="text-lg font-black text-slate-900 mb-6">Vehicle Images</h2>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                            @foreach($vehicle->images as $image)
                                <div class="aspect-square rounded-xl overflow-hidden border border-slate-200">
                                    <img src="{{ asset('storage/' . $image) }}" alt="Vehicle Image"
                                        class="w-full h-full object-cover hover:scale-110 transition-transform duration-300 cursor-pointer"
                                        onclick="window.open('{{ asset('storage/' . $image) }}', '_blank')">
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <div class="bg-white border border-slate-100 rounded-[2rem] shadow-xl p-6">
                    <h3 class="text-sm font-black text-slate-900 mb-4">Status</h3>
                    <div class="space-y-3">
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-2">Ownership</p>
                            <span class="px-3 py-1.5 rounded-lg text-xs font-bold 
                                    {{ $vehicle->ownership == 'Purchased' ? 'bg-green-100 text-green-700' : '' }}
                                    {{ $vehicle->ownership == 'Leased' ? 'bg-blue-100 text-blue-700' : '' }}
                                    {{ $vehicle->ownership == 'Rented' ? 'bg-purple-100 text-purple-700' : '' }}">
                                {{ $vehicle->ownership }}
                            </span>
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-2">Status</p>
                            <span class="px-3 py-1.5 rounded-lg text-xs font-bold 
                                    {{ $vehicle->status == 'Active' ? 'bg-emerald-100 text-emerald-700' : '' }}
                                    {{ $vehicle->status == 'Inactive' ? 'bg-gray-100 text-gray-700' : '' }}
                                    {{ $vehicle->status == 'Maintenance' ? 'bg-amber-100 text-amber-700' : '' }}
                                    {{ $vehicle->status == 'Sold' ? 'bg-red-100 text-red-700' : '' }}">
                                {{ $vehicle->status }}
                            </span>
                        </div>
                    </div>
                </div>

                <div class="bg-white border border-slate-100 rounded-[2rem] shadow-xl p-6">
                    <h3 class="text-sm font-black text-slate-900 mb-4">Actions</h3>
                    <div class="space-y-2">
                        <a href="{{ route('vehicles.edit', $vehicle) }}"
                            class="block w-full px-4 py-2.5 bg-blue-600 text-white text-center text-xs font-bold rounded-xl hover:bg-blue-700 transition-all">
                            Edit Vehicle
                        </a>
                        <form action="{{ route('vehicles.destroy', $vehicle) }}" method="POST"
                            onsubmit="return confirm('Are you sure you want to delete this vehicle?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit"
                                class="block w-full px-4 py-2.5 bg-red-600 text-white text-center text-xs font-bold rounded-xl hover:bg-red-700 transition-all">
                                Delete Vehicle
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection