@extends('layouts.user')

@section('title', 'Company Uniform Inventory')

@section('content')
    <div class="max-w-7xl mx-auto" x-data="{ activeTab: 'issued' }">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4">
            <div>
                <h1 class="text-3xl font-black text-slate-900 tracking-tight">Company Uniform Inventory</h1>
                <p class="text-slate-500 font-bold mt-1">Manage and view uniform assignments across all employees.</p>
            </div>
        </div>

        <!-- Tab Navigation -->
        <div class="flex space-x-4 mb-6 border-b border-gray-200">
            <button @click="activeTab = 'issued'"
                :class="{ 'border-blue-500 text-blue-600': activeTab === 'issued', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'issued' }"
                class="py-2 px-4 border-b-2 font-medium text-sm transition-colors duration-200 focus:outline-none">
                Issued Uniforms Log
            </button>
            <button @click="activeTab = 'stock'"
                :class="{ 'border-blue-500 text-blue-600': activeTab === 'stock', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'stock' }"
                class="py-2 px-4 border-b-2 font-medium text-sm transition-colors duration-200 focus:outline-none">
                Current Stock Levels
            </button>
        </div>

        <!-- Issued Uniforms Table -->
        <div x-show="activeTab === 'issued'" x-cloak
            class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden mb-10 transition-all duration-300">
            <div class="px-8 py-6 border-b border-gray-50 bg-slate-50/50 flex flex-col md:flex-row justify-between items-center gap-4">
                <div>
                    <h2 class="text-xl font-black text-slate-800 flex items-center gap-2">
                        <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z">
                            </path>
                        </svg>
                        Issued Uniforms Log
                    </h2>
                    <p class="text-xs font-bold text-slate-400 uppercase tracking-wider mt-1">List of all uniforms currently
                        assigned to employees</p>
                </div>

                <div class="flex items-center gap-2">
                    <a href="{{ route('user.uniforms.issued.export.pdf') }}" id="btn-export-pdf"
                        class="flex items-center gap-2 px-4 py-2 bg-white border border-gray-200 rounded-xl text-xs font-black text-slate-600 hover:bg-slate-50 hover:text-blue-600 transition-all shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                        Export to PDF
                    </a>
                    <a href="{{ route('user.uniforms.issued.export.excel') }}" id="btn-export-excel"
                        class="flex items-center gap-2 px-4 py-2 bg-white border border-gray-200 rounded-xl text-xs font-black text-slate-600 hover:bg-slate-50 hover:text-green-600 transition-all shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                        Export to Excel
                    </a>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-xs text-left">
                    <thead
                        class="bg-white text-slate-500 font-black uppercase text-[10px] tracking-widest border-b border-gray-100/50">
                        <tr>
                            <th class="px-6 py-3">
                                <input type="checkbox" id="select-all"
                                    class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                            </th>
                            <th class="px-6 py-3">Employee</th>
                            <th class="px-6 py-3">Uniform Item</th>
                            <th class="px-6 py-3">Variant Details</th>
                            <th class="px-6 py-3 text-center">Quantity</th>
                            <th class="px-6 py-3">Issued Date</th>
                            <th class="px-6 py-3">Notes</th>
                            <th class="px-6 py-3 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @forelse($allIssuedUniforms as $issued)
                            <tr class="hover:bg-blue-50/30 transition-colors group">
                                <td class="px-6 py-3">
                                    <input type="checkbox" class="record-checkbox w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                                        value="{{ $issued->id }}">
                                </td>
                                <td class="px-6 py-3">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="w-6 h-6 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center font-bold text-[10px]">
                                            {{ substr($issued->employee->first_name, 0, 1) }}{{ substr($issued->employee->last_name, 0, 1) }}
                                        </div>
                                        <div>
                                            <div class="font-bold text-slate-900">{{ $issued->employee->first_name }}
                                                {{ $issued->employee->last_name }}
                                            </div>
                                            <div class="text-[9px] text-slate-400 font-bold">
                                                {{ $issued->employee->employee_id }}
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-3 font-bold text-slate-700">{{ $issued->variant->uniform->name }}</td>
                                <td class="px-6 py-3">
                                    <div class="flex items-center gap-2">
                                        @if($issued->variant->size)
                                            <span
                                                class="px-1.5 py-0.5 bg-slate-100 text-slate-600 rounded text-[10px] font-bold">{{ $issued->variant->size }}</span>
                                        @endif
                                        @if($issued->variant->color)
                                            <span class="text-[10px] font-bold text-slate-500">{{ $issued->variant->color }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-3 text-center font-black text-slate-900">{{ $issued->quantity }}</td>
                                <td class="px-6 py-3 text-slate-600 font-medium">{{ $issued->issued_at->format('M d, Y') }}</td>
                                <td class="px-6 py-3 text-[10px] text-slate-400 italic">{{ $issued->notes ?? '-' }}</td>
                                <td class="px-6 py-3 text-right">
                                    <a href="{{ route('employees.show', ['employee' => $issued->employee->id, 'tab' => 'uniforms']) }}"
                                        class="text-blue-600 font-bold text-[10px] hover:underline">Manage</a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-6 py-8 text-center">
                                    <div class="flex flex-col items-center justify-center text-slate-400">
                                        <svg class="w-10 h-10 mb-2 text-slate-200" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                        </svg>
                                        <p class="font-bold text-xs">No uniforms have been issued yet.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Available Inventory Section -->
        <div x-show="activeTab === 'stock'" x-cloak
            class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden transition-all duration-300">
            <div class="px-8 py-6 border-b border-gray-50 flex justify-between items-center bg-slate-50/50">
                <h2 class="text-xl font-bold text-slate-800">Current Stock Levels</h2>
                <a href="{{ route('user.uniforms.export.pdf') }}"
                    class="flex items-center gap-2 px-4 py-2 bg-white border border-gray-200 rounded-xl text-xs font-black text-slate-600 hover:bg-slate-50 hover:text-blue-600 transition-all shadow-sm">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Export to PDF
                </a>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-xs text-left">
                    <thead
                        class="bg-white text-slate-500 font-black uppercase text-[10px] tracking-widest border-b border-gray-100/50">
                        <tr>
                            <th class="px-6 py-3">Uniform Name</th>
                            <th class="px-6 py-3">Type</th>
                            <th class="px-6 py-3">Variant</th>
                            <th class="px-6 py-3">Stock Quantity</th>
                            <th class="px-6 py-3">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @foreach($inventory as $item)
                            <tr class="hover:bg-slate-50/50 transition-colors">
                                <td class="px-6 py-3 font-bold text-slate-900">{{ $item->uniform->name }}</td>
                                <td class="px-6 py-3 text-[10px] font-bold uppercase text-slate-400">
                                    {{ $item->uniform->code ?? '-' }}</td>
                                <td class="px-6 py-3">
                                    <div class="flex items-center gap-2">
                                        @if($item->size)
                                            <span
                                                class="px-1.5 py-0.5 bg-slate-100 text-slate-600 rounded text-[10px] font-bold">{{ $item->size }}</span>
                                        @endif
                                        @if($item->color)
                                            <span class="text-[10px] font-bold text-slate-500">{{ $item->color }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-3">
                                    <div class="flex items-center gap-2">
                                        <span
                                            class="font-black {{ $item->stock_quantity <= 5 ? 'text-red-600' : 'text-slate-900' }}">{{ $item->stock_quantity }}</span>
                                        @if($item->stock_quantity <= 5)
                                            <span
                                                class="px-1.5 py-0.5 bg-red-100 text-red-600 rounded text-[9px] font-bold uppercase">Low
                                                Stock</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-3">
                                    <span
                                        class="px-1.5 py-0.5 bg-green-100 text-green-700 rounded text-[9px] font-bold uppercase">Active</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(document).ready(function() {
                const $selectAll = $('#select-all');
                const $checkboxes = $('.record-checkbox');
                const $btnExportPdf = $('#btn-export-pdf');
                const $btnExportExcel = $('#btn-export-excel');

                const basePdfUrl = "{{ route('user.uniforms.issued.export.pdf') }}";
                const baseExcelUrl = "{{ route('user.uniforms.issued.export.excel') }}";

                function updateExportUrls() {
                    const selectedIds = [];
                    $('.record-checkbox:checked').each(function() {
                        selectedIds.push($(this).val());
                    });

                    const idSuffix = selectedIds.length > 0 ? '?ids=' + selectedIds.join(',') : '';
                    $btnExportPdf.attr('href', basePdfUrl + idSuffix);
                    $btnExportExcel.attr('href', baseExcelUrl + idSuffix);
                }

                $selectAll.on('change', function() {
                    $checkboxes.prop('checked', $(this).prop('checked'));
                    updateExportUrls();
                });

                $checkboxes.on('change', function() {
                    updateExportUrls();
                    if ($('.record-checkbox:checked').length === $checkboxes.length) {
                        $selectAll.prop('checked', true);
                    } else {
                        $selectAll.prop('checked', false);
                    }
                });
            });
        </script>
    @endpush

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
@endsection