@extends('layouts.user')

@section('title', 'Schedule Details')

@section('content')
    <div class="p-6">
        <div class="mb-6 flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Schedule Details</h1>
                <p class="text-gray-500">Details for Duty #{{ $schedule->duty_number }}</p>
            </div>
            <div class="flex gap-3">
                @if($schedule->status !== 'active' && $schedule->status !== 'completed')
                <a href="{{ route('schedules.edit', $schedule) }}"
                    class="px-6 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all flex items-center gap-2 text-sm shadow-md shadow-blue-500/20">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Edit Duty
                </a>
                @endif
                <a href="{{ route('schedules.index') }}"
                    class="px-6 py-2 bg-gray-100 text-gray-600 font-bold rounded-lg hover:bg-gray-200 transition-all text-sm">
                    Back to List
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Details Card -->
            <div class="lg:col-span-2 space-y-6">
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-8">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div class="space-y-4">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest">Duty Information</h3>
                            <div class="flex items-center gap-4">
                                <div>
                                    <div class="text-[10px] font-bold text-gray-400 uppercase">Status</div>
                                    <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-[10px] font-bold uppercase tracking-wider">{{ $schedule->status }}</span>
                                </div>
                                <div>
                                    <div class="text-[10px] font-bold text-gray-400 uppercase">Schedule Date</div>
                                    <div class="text-sm font-bold text-gray-900">{{ $schedule->schedule_date->format('M d, Y') }}</div>
                                </div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">From Date & Time</div>
                                <div class="text-sm font-bold text-gray-900">
                                    {{ $schedule->from_datetime->format('M d, Y - h:i A') }}
                                </div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">To Date & Time</div>
                                <div class="text-sm font-bold text-gray-900">
                                    {{ $schedule->to_datetime->format('M d, Y - h:i A') }}
                                </div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Duration</div>
                                <div class="text-sm font-bold text-blue-600">
                                    @php
                                        $duration = $schedule->from_datetime->diffInMinutes($schedule->to_datetime) / 60;
                                        $h = floor($duration);
                                        $m = round(($duration - $h) * 60);
                                    @endphp
                                    {{ $h }}h {{ $m }}m ({{ number_format($duration, 2) }} hrs)
                                    <span class="text-[10px] text-gray-400 ml-2">({{ $schedule->time_zone }})</span>
                                </div>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest">Billing Details</h3>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Site Rate</div>
                                <div class="text-sm font-bold text-emerald-600">${{ number_format($schedule->site_rate, 2) }} /hr</div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Total Billing (Est.)</div>
                                <div class="text-lg font-black text-slate-900">${{ number_format($duration * $schedule->site_rate, 2) }}</div>
                            </div>
                            <div>
                                <div class="text-[10px] font-bold text-gray-400 uppercase">Customer Ref</div>
                                <div class="text-sm font-bold text-gray-900">{{ $schedule->customer_reference ?: 'None' }}</div>
                            </div>
                        </div>

                        <!-- Personnel & Individual Rates Table -->
                        <div class="md:col-span-2 border-t border-gray-100 pt-8">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-6">Assigned Guards & Rates</h3>
                            <div class="space-y-6">
                                @foreach($schedule->employees as $employee)
                                    <div class="bg-gray-50 rounded-3xl p-6 border border-gray-100">
                                        <div class="flex flex-col md:flex-row md:items-center justify-between gap-6">
                                            <!-- Guard Identity -->
                                            <div class="flex items-center gap-4">
                                                @if($employee->profile_picture)
                                                    <img src="{{ asset('storage/' . $employee->profile_picture) }}" class="w-12 h-12 rounded-full object-cover ring-4 ring-white shadow-sm">
                                                @else
                                                    <div class="w-12 h-12 rounded-full bg-gray-200 text-gray-400 flex items-center justify-center font-bold text-xs border border-white shadow-sm">
                                                        {{ substr($employee->first_name, 0, 1) }}{{ substr($employee->last_name, 0, 1) }}
                                                    </div>
                                                @endif
                                                <div>
                                                    <div class="text-sm font-bold text-gray-900">{{ $employee->first_name }} {{ $employee->last_name }}</div>
                                                    <div class="text-[10px] text-gray-400 font-bold uppercase">{{ $employee->employee_id }}</div>
                                                </div>
                                            </div>

                                            <!-- Rates Row -->
                                            <div class="flex items-center gap-8 border-l border-gray-200 pl-8">
                                                @php
                                                    $employeeWageTypes = json_decode($employee->pivot->wage_types, true) ?: [];
                                                    $totalGuardPayout = 0;
                                                    foreach($employeeWageTypes as $ewt) {
                                                        $totalGuardPayout += ($ewt['rate'] ?? 0) * ($ewt['allocated_hours'] ?? 0);
                                                    }
                                                    $totalGuardPayout += ($employee->pivot->gas_rate ?? 0);
                                                @endphp
                                                <div>
                                                    <div class="text-[10px] font-bold text-gray-400 uppercase mb-1">Total Payout</div>
                                                    <div class="text-sm font-bold text-blue-600">${{ number_format($totalGuardPayout, 2) }}</div>
                                                </div>

                                                @if($employee->pivot->gas_rate)
                                                    <div>
                                                        <div class="text-[10px] font-bold text-gray-400 uppercase mb-1">GAS Rate</div>
                                                        <div class="text-sm font-bold text-amber-600">${{ number_format($employee->pivot->gas_rate, 2) }}</div>
                                                    </div>
                                                @endif
                                                
                                                <!-- Ban Button -->
                                                <form action="{{ route('sites.ban', ['site' => $schedule->site, 'employee' => $employee]) }}" method="POST" onsubmit="return confirm('Are you sure you want to BAN this employee from this site? This action will prevent future assignments.');">
                                                    @csrf
                                                    <button type="submit" class="px-3 py-1 bg-red-50 text-red-600 hover:bg-red-100 rounded-lg text-[10px] font-bold uppercase tracking-wider transition-colors border border-red-100 flex items-center gap-1">
                                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                                        Ban From Site
                                                    </button>
                                                </form>
                                            </div>
                                        </div>

                                        <!-- Wage Components List -->
                                        @if(!empty($employeeWageTypes))
                                            <div class="mt-6 pt-4 border-t border-gray-100/50">
                                                <div class="text-[10px] font-bold text-gray-400 uppercase mb-3 px-1">Active Components</div>
                                                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3">
                                                    @foreach($employeeWageTypes as $ewt)
                                                        <div class="p-3 bg-white border border-gray-100 rounded-xl shadow-sm space-y-2">
                                                            <div class="flex justify-between items-center">
                                                                <span class="text-[11px] font-bold text-gray-700">{{ $ewt['name'] ?? 'Wage Component' }}</span>
                                                                <span class="text-[10px] font-bold text-blue-500">${{ number_format($ewt['rate'], 2) }}/hr</span>
                                                            </div>
                                                            <div class="flex justify-between items-center text-[10px]">
                                                                <span class="text-gray-400 uppercase font-bold">Allocation</span>
                                                                <span class="text-gray-900 font-bold">{{ $ewt['allocated_hours'] ?? 0 }} hrs</span>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        @if($schedule->comments)
                            <div class="md:col-span-2 border-t border-gray-100 pt-6">
                                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Instructions / Comments</h3>
                                <div class="p-4 bg-amber-50 text-amber-800 rounded-xl text-sm italic border border-amber-100">
                                    "{{ $schedule->comments }}"
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Sidebar Info -->
            <div class="space-y-6">
                <!-- Location Card -->
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-4 bg-slate-800 text-white font-bold text-xs uppercase tracking-widest">Site Information</div>
                    <div class="p-8">
                        <div class="w-12 h-12 bg-blue-50 text-blue-600 rounded-xl flex items-center justify-center font-bold text-lg mb-4">
                            {{ substr($schedule->site->name, 0, 1) }}
                        </div>
                        <h4 class="text-lg font-bold text-gray-900 mb-2">{{ $schedule->site->name }}</h4>
                        <div class="flex items-start gap-2 text-gray-500 mb-6">
                             <svg class="w-4 h-4 mt-0.5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                             <p class="text-xs leading-relaxed">{{ $schedule->site->address_line_1 }}, {{ $schedule->site->city }}</p>
                        </div>
                        <div class="p-4 bg-gray-50 rounded-xl flex justify-between items-center">
                            <span class="text-[10px] font-bold font-gray-400 uppercase">Site ID</span>
                            <span class="text-xs font-bold text-gray-900">{{ $schedule->site->site_id }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection