<!DOCTYPE html>
<html>

<head>
    <title>Route Masters List</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="company-name">{{ $company->name }}</div>
        <h2>Route Masters List</h2>
        <p>Generated on: {{ date('Y-m-d H:i:s') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Route Code</th>
                <th>Route Name</th>
                <th>Rate</th>
                <th>Sites</th>
            </tr>
        </thead>
        <tbody>
            @foreach($routes as $route)
                <tr>
                    <td>{{ $route->route_code }}</td>
                    <td>{{ $route->name }}</td>
                    <td>{{ number_format($route->rate, 2) }}</td>
                    <td>
                        {{ $route->sites->pluck('name')->implode(', ') }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>