@extends('layouts.user')

@section('title', 'Edit Route Master')

@section('content')
    <div class="max-w-7xl mx-auto" x-data="{
        selectedSites: @js($route->sites),
        allSites: @js($sites),
        searchTerm: '',
        showDropdown: false,
        toggleSite(site) {
            const index = this.selectedSites.findIndex(s => s.id === site.id);
            if (index > -1) {
                this.selectedSites.splice(index, 1);
            } else {
                this.selectedSites.push(site);
            }
        },
        removeSite(siteId) {
            this.selectedSites = this.selectedSites.filter(s => s.id !== siteId);
        },
        get filteredSites() {
            return this.allSites.filter(s => s.name.toLowerCase().includes(this.searchTerm.toLowerCase()));
        }
    }">
        <!-- Breadcrumb -->
        <div class="mb-4">
            <div class="flex items-center gap-2 text-xs text-gray-400 mb-1">
                <a href="{{ route('routes.index') }}" class="hover:text-blue-600">Route Masters</a>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-gray-900 font-medium">Edit Route: {{ $route->name }}</span>
            </div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Route Master</h1>
        </div>

        <form action="{{ route('routes.update', $route) }}" method="POST" class="space-y-6">
            @csrf
            @method('PUT')

            <div class="bg-white border border-gray-200 rounded-xl shadow-sm p-8">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                    <!-- Route Code -->
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Route
                            Code</label>
                        <input type="text" value="{{ $route->route_code }}" readonly
                            class="w-full px-4 py-2.5 bg-gray-50 border border-gray-200 rounded-lg text-sm text-gray-500 font-mono focus:outline-none cursor-not-allowed">
                    </div>

                    <!-- Route Name -->
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Route
                            Name<span class="text-red-500">*</span></label>
                        <input type="text" name="name" value="{{ $route->name }}" required placeholder="Enter route name"
                            class="w-full px-4 py-2.5 bg-white border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Sites (Custom Multi-select with Chips) -->
                    <div class="relative">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Sites</label>
                        <div @click.away="showDropdown = false" class="relative">
                            <div @click="showDropdown = !showDropdown"
                                class="min-h-[42px] w-full px-2 py-1.5 bg-white border border-gray-300 rounded-lg flex flex-wrap gap-1 cursor-pointer hover:border-blue-400 transition-colors">
                                <template x-for="site in selectedSites" :key="site.id">
                                    <span
                                        class="bg-blue-50 text-blue-700 px-2 py-0.5 rounded text-[11px] font-bold flex items-center gap-1 border border-blue-100">
                                        <span x-text="site.name"></span>
                                        <button type="button" @click.stop="removeSite(site.id)"
                                            class="hover:text-red-500">&times;</button>
                                    </span>
                                </template>
                                <span x-show="selectedSites.length === 0" class="text-gray-400 text-sm pl-2 py-1">Select an
                                    option</span>
                                <div class="flex-1 min-w-[20px]"></div>
                                <svg class="w-4 h-4 text-gray-400 ml-auto self-center mr-1" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>

                            <!-- Dropdown -->
                            <div x-show="showDropdown" x-transition
                                class="absolute z-50 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-xl max-h-64 overflow-y-auto">
                                <div class="sticky top-0 bg-gray-50 p-2 border-b border-gray-100">
                                    <input type="text" x-model="searchTerm" placeholder="Search sites..."
                                        class="w-full px-3 py-1.5 text-xs border border-gray-200 rounded focus:outline-none focus:ring-1 focus:ring-blue-500">
                                </div>
                                <div class="py-1">
                                    <template x-for="site in filteredSites" :key="site.id">
                                        <div @click="toggleSite(site)"
                                            class="px-4 py-2 text-sm hover:bg-blue-50 cursor-pointer flex items-center justify-between"
                                            :class="selectedSites.some(s => s.id === site.id) ? 'bg-blue-50/50 text-blue-700 font-bold' : 'text-gray-700'">
                                            <span x-text="site.name"></span>
                                            <svg x-show="selectedSites.some(s => s.id === site.id)"
                                                class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd"
                                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                    clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>
                        <!-- Hidden Inputs for Form Submission -->
                        <template x-for="site in selectedSites" :key="'input-'+site.id">
                            <input type="hidden" name="sites[]" :value="site.id">
                        </template>
                    </div>

                    <!-- Rate -->
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Rate</label>
                        <input type="number" step="0.01" name="rate" value="{{ $route->rate }}" placeholder="0.00"
                            class="w-full px-4 py-2.5 bg-white border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                    </div>
                </div>

                <!-- Description -->
                <div>
                    <label
                        class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Description</label>
                    <textarea name="description" rows="4"
                        class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all resize-none">{{ $route->description }}</textarea>
                </div>
            </div>

            <div class="flex items-center gap-3">
                <button type="submit"
                    class="px-8 py-2.5 bg-blue-600 text-white rounded-lg font-bold text-xs hover:bg-blue-700 transition-all shadow-md shadow-blue-100">Update
                    Route</button>
                <a href="{{ route('routes.index') }}"
                    class="px-8 py-2.5 bg-white border border-gray-300 text-gray-700 rounded-lg font-bold text-xs hover:bg-gray-50 transition-all">Cancel</a>
            </div>
        </form>
    </div>
@endsection