@extends('layouts.user')

@section('title', 'Create Route Master')

@section('content')
    <div class="max-w-7xl mx-auto" x-data="{
            selectedSites: [],
            allSites: @js($sites),
            searchTerm: '',
            showDropdown: false,
            toggleSite(site) {
                const index = this.selectedSites.findIndex(s => s.id === site.id);
                if (index > -1) {
                    this.selectedSites.splice(index, 1);
                } else {
                    this.selectedSites.push(site);
                }
            },
            removeSite(siteId) {
                this.selectedSites = this.selectedSites.filter(s => s.id !== siteId);
            },
            get filteredSites() {
                return this.allSites.filter(s => s.name.toLowerCase().includes(this.searchTerm.toLowerCase()));
            }
        }">
        <!-- Breadcrumb & Header -->
        <div
            class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl mb-6">
            <div>
                <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                    <a href="{{ route('routes.index') }}" class="hover:text-white transition-colors">Route Masters</a>
                    <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                    <span class="text-white">Create</span>
                </div>
                <h1 class="text-3xl font-black tracking-tight">Create Route Master</h1>
                <p class="text-xs text-slate-400 font-medium mt-1">Configure your new route and assign sites.
                </p>
            </div>

            <a href="{{ route('routes.index') }}"
                class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
                Back to List
            </a>
        </div>

        <form action="{{ route('routes.store') }}" method="POST" class="space-y-6">
            @csrf

            <div class="bg-white border border-gray-200 rounded-xl shadow-sm p-8">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                    <!-- Route Code -->
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Route
                            Code<span class="text-red-500">*</span></label>
                        <input type="text" name="route_code" value="{{ $generatedId }}" readonly
                            class="w-full px-4 py-2.5 bg-gray-50 border border-gray-200 rounded-lg text-sm text-gray-500 font-mono focus:outline-none">
                    </div>

                    <!-- Route Name -->
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Route
                            Name<span class="text-red-500">*</span></label>
                        <input type="text" name="name" required placeholder="Enter route name"
                            class="w-full px-4 py-2.5 bg-white border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                    </div>

                    <!-- Sites (Custom Multi-select with Chips) -->
                    <div class="relative">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Sites</label>
                        <div @click.away="showDropdown = false" class="relative">
                            <div @click="showDropdown = !showDropdown"
                                class="min-h-[42px] w-full px-2 py-1.5 bg-white border border-gray-300 rounded-lg flex flex-wrap gap-1 cursor-pointer hover:border-blue-400 transition-colors">
                                <template x-for="site in selectedSites" :key="site.id">
                                    <span
                                        class="bg-blue-50 text-blue-700 px-2 py-0.5 rounded text-[11px] font-bold flex items-center gap-1 border border-blue-100">
                                        <span x-text="site.name"></span>
                                        <button type="button" @click.stop="removeSite(site.id)"
                                            class="hover:text-red-500">&times;</button>
                                    </span>
                                </template>
                                <span x-show="selectedSites.length === 0" class="text-gray-400 text-sm pl-2 py-1">Select an
                                    option</span>
                                <div class="flex-1 min-w-[20px]"></div>
                                <svg class="w-4 h-4 text-gray-400 ml-auto self-center mr-1" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>

                            <!-- Dropdown -->
                            <div x-show="showDropdown" x-transition
                                class="absolute z-50 mt-1 w-full bg-white border border-gray-200 rounded-lg shadow-xl max-h-64 overflow-y-auto">
                                <div class="sticky top-0 bg-gray-50 p-2 border-b border-gray-100">
                                    <input type="text" x-model="searchTerm" placeholder="Search sites..."
                                        class="w-full px-3 py-1.5 text-xs border border-gray-200 rounded focus:outline-none focus:ring-1 focus:ring-blue-500">
                                </div>
                                <div class="py-1">
                                    <template x-for="site in filteredSites" :key="site.id">
                                        <div @click="toggleSite(site)"
                                            class="px-4 py-2 text-sm hover:bg-blue-50 cursor-pointer flex items-center justify-between"
                                            :class="selectedSites.some(s => s.id === site.id) ? 'bg-blue-50/50 text-blue-700 font-bold' : 'text-gray-700'">
                                            <span x-text="site.name"></span>
                                            <svg x-show="selectedSites.some(s => s.id === site.id)"
                                                class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd"
                                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                    clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>
                        <!-- Hidden Inputs for Form Submission -->
                        <template x-for="site in selectedSites" :key="'input-'+site.id">
                            <input type="hidden" name="sites[]" :value="site.id">
                        </template>
                    </div>

                    <!-- Rate -->
                    <div>
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Rate</label>
                        <input type="number" step="0.01" name="rate" placeholder="0.00"
                            class="w-full px-4 py-2.5 bg-white border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                    </div>
                </div>

                <!-- Description -->
                <div>
                    <label
                        class="text-[11px] font-bold text-gray-500 uppercase tracking-wider mb-2 block">Description</label>
                    <textarea name="description" rows="4"
                        class="w-full px-4 py-3 bg-white border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all resize-none"></textarea>
                </div>
            </div>

            <div class="flex items-center gap-3">
                <button type="submit"
                    class="px-8 py-2.5 bg-blue-600 text-white rounded-lg font-bold text-xs hover:bg-blue-700 transition-all shadow-md shadow-blue-100">Create</button>
                <button type="submit" name="create_another" value="1"
                    class="px-8 py-2.5 bg-white border border-gray-300 text-gray-700 rounded-lg font-bold text-xs hover:bg-gray-50 transition-all">Create
                    & create another</button>
                <a href="{{ route('routes.index') }}"
                    class="px-8 py-2.5 bg-white border border-gray-300 text-gray-700 rounded-lg font-bold text-xs hover:bg-gray-50 transition-all">Cancel</a>
            </div>
        </form>
    </div>
@endsection