<!DOCTYPE html>
<html>
<head>
    <title>Issued Uniforms Log</title>
    <style>
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            font-size: 11px;
            color: #334155;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #e2e8f0;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #1e293b;
            font-size: 24px;
            margin: 0;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .header p {
            margin: 5px 0 0;
            color: #64748b;
            font-size: 12px;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th {
            background-color: #f1f5f9;
            color: #475569;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 10px;
            letter-spacing: 0.5px;
            padding: 12px 8px;
            border: 1px solid #e2e8f0;
            text-align: left;
        }
        td {
            padding: 10px 8px;
            border: 1px solid #f1f5f9;
            vertical-align: middle;
        }
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        .employee-name {
            font-weight: bold;
            color: #0f172a;
        }
        .uniform-name {
            font-weight: bold;
            color: #334155;
        }
        .variant-details {
            color: #64748b;
            font-size: 10px;
        }
        .quantity {
            font-weight: bold;
            text-align: center;
        }
        .date {
            color: #475569;
            text-align: center;
        }
        .notes {
            color: #94a3b8;
            font-style: italic;
            font-size: 9px;
        }
        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 10px;
            color: #94a3b8;
            border-top: 1px solid #f1f5f9;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Issued Uniforms Log</h1>
        <p>{{ $companyName }}</p>
        <p style="font-size: 10px; color: #94a3b8; font-weight: normal; margin-top: 5px;">Generated on: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th width="20%">Employee</th>
                <th width="20%">Uniform Item</th>
                <th width="15%">Variant</th>
                <th width="10%" style="text-align: center;">Qty</th>
                <th width="15%" style="text-align: center;">Issued Date</th>
                <th width="20%">Notes</th>
            </tr>
        </thead>
        <tbody>
            @forelse($allIssuedUniforms as $issued)
                <tr>
                    <td>
                        <div class="employee-name">{{ $issued->employee->first_name }} {{ $issued->employee->last_name }}</div>
                        <div style="font-size: 9px; color: #94a3b8;">#{{ $issued->employee->employee_id }}</div>
                    </td>
                    <td class="uniform-name">{{ $issued->variant->uniform->name }}</td>
                    <td class="variant-details">
                        @if($issued->variant->size) {{ $issued->variant->size }} @endif
                        @if($issued->variant->size && $issued->variant->color) / @endif
                        @if($issued->variant->color) {{ $issued->variant->color }} @endif
                        @if(!$issued->variant->size && !$issued->variant->color) Standard @endif
                    </td>
                    <td class="quantity">{{ $issued->quantity }}</td>
                    <td class="date">{{ $issued->issued_at->format('M d, Y') }}</td>
                    <td class="notes">{{ $issued->notes ?: '-' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" style="text-align: center; padding: 40px; color: #94a3b8;">No uniforms issued yet.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        ShiftMatrix Workforce Management System
    </div>
</body>
</html>
