@extends('layouts.user')

@section('title', 'Incident Analysis')

@section('content')
    <div class="space-y-6">
        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.incident_analysis') }}" class="space-y-6">
                <div class="flex flex-col gap-6">
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Date Range -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start
                                Date</label>
                            <input type="date" name="start_date" value="{{ request('start_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End
                                Date</label>
                            <input type="date" name="end_date" value="{{ request('end_date') }}"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Site Filter -->
                        <div class="w-full md:w-56">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                            <select name="site_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                                <option value="">All Sites</option>
                                @foreach($sites as $site)
                                    <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                        {{ $site->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Employee Filter -->
                        <div class="w-full md:w-56">
                            <label
                                class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                            <select name="employee_id"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 px-3 py-2 shadow-sm">
                                <option value="">All Employees</option>
                                @foreach($employees as $emp)
                                    <option value="{{ $emp->id }}" {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                        {{ $emp->first_name }} {{ $emp->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="flex items-end gap-2">
                            <button type="submit"
                                class="h-[38px] px-6 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors whitespace-nowrap shadow-sm">
                                Apply
                            </button>
                            <a href="{{ route('reports.operational.incidents') }}"
                                class="h-[38px] px-6 bg-white border border-gray-300 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors flex items-center justify-center gap-2 whitespace-nowrap shadow-sm">
                                Return to List
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Charts Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Parent Category Distribution -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Incidents by Type</h3>
                <div class="relative h-64">
                    <canvas id="parentCategoryChart"></canvas>
                </div>
            </div>

            <!-- Top Categories -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Top Specific Categories</h3>
                <div class="relative h-64">
                    <canvas id="topCategoriesChart"></canvas>
                </div>
            </div>

            <!-- Site Distribution -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Top Sites</h3>
                <div class="relative h-64">
                    <canvas id="siteChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Trend Chart -->
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Incidents Over Time</h3>
            <div class="relative h-72">
                <canvas id="trendChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // 1. Parent Category Chart (Doughnut)
            const parentStats = @json($parentStats);
            new Chart(document.getElementById('parentCategoryChart'), {
                type: 'doughnut',
                data: {
                    labels: parentStats.map(item => item.label),
                    datasets: [{
                        data: parentStats.map(item => item.count),
                        backgroundColor: [
                            '#3b82f6', '#10b981', '#ef4444', '#f59e0b', '#8b5cf6', '#ec4899', '#6366f1'
                        ],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { position: 'right', labels: { font: { size: 10 }, boxWidth: 10 } }
                    },
                    cutout: '60%'
                }
            });

            // 2. Top Specific Categories (Bar - Horizontal)
            const topCategories = @json($topCategories);
            new Chart(document.getElementById('topCategoriesChart'), {
                type: 'bar',
                data: {
                    labels: topCategories.map(item => item.label),
                    datasets: [{
                        label: 'Incidents',
                        data: topCategories.map(item => item.count),
                        backgroundColor: '#8b5cf6',
                        borderRadius: 4
                    }]
                },
                options: {
                    indexAxis: 'y',
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        x: { beginAtZero: true, grid: { display: false } },
                        y: { grid: { display: false } }
                    },
                    plugins: { legend: { display: false } }
                }
            });

            // 3. Site Distribution (Pie)
            const siteStats = @json($siteStats);
            new Chart(document.getElementById('siteChart'), {
                type: 'pie',
                data: {
                    labels: siteStats.map(item => item.name),
                    datasets: [{
                        data: siteStats.map(item => item.count),
                        backgroundColor: [
                            '#ef4444', '#f59e0b', '#10b981', '#3b82f6', '#6366f1'
                        ],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { position: 'right', labels: { font: { size: 10 }, boxWidth: 10 } }
                    }
                }
            });

            // 4. Trend Chart (Line)
            const incidentsOverTime = @json($incidentsOverTime);
            new Chart(document.getElementById('trendChart'), {
                type: 'line',
                data: {
                    labels: incidentsOverTime.map(item => item.date),
                    datasets: [{
                        label: 'Daily Incidents',
                        data: incidentsOverTime.map(item => item.count),
                        borderColor: '#3b82f6',
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        fill: true,
                        tension: 0.3,
                        pointRadius: 3,
                        pointHoverRadius: 5
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: { beginAtZero: true, ticks: { stepSize: 1 } },
                        x: { grid: { display: false } }
                    },
                    interaction: {
                        intersect: false,
                        mode: 'index',
                    },
                }
            });
        });
    </script>
@endsection