<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Quotation {{ $quotation->quotation_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 11px;
            line-height: 1.5;
            color: #333;
        }

        .container {
            padding: 30px;
        }

        .header {
            margin-bottom: 30px;
            border-bottom: 3px solid #1e293b;
            padding-bottom: 20px;
        }

        .header h1 {
            font-size: 28px;
            color: #1e293b;
            margin-bottom: 5px;
        }

        .header .quote-number {
            font-size: 14px;
            color: #64748b;
        }

        .company-info {
            margin-bottom: 30px;
        }

        .company-info h2 {
            font-size: 16px;
            color: #1e293b;
            margin-bottom: 8px;
        }

        .info-row {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .info-col {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .info-col h3 {
            font-size: 12px;
            color: #64748b;
            text-transform: uppercase;
            margin-bottom: 8px;
            font-weight: 600;
        }

        .info-col p {
            margin-bottom: 3px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        table thead {
            background-color: #f1f5f9;
        }

        table thead th {
            padding: 12px 10px;
            text-align: left;
            font-size: 10px;
            text-transform: uppercase;
            color: #64748b;
            font-weight: 700;
            border-bottom: 2px solid #cbd5e1;
        }

        table tbody td {
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
        }

        table tbody tr:last-child td {
            border-bottom: none;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .totals {
            margin-top: 20px;
            float: right;
            width: 300px;
        }

        .totals table {
            margin: 0;
        }

        .totals table td {
            padding: 8px 10px;
            border: none;
        }

        .totals .total-row {
            font-weight: bold;
            font-size: 14px;
            background-color: #1e293b;
            color: white;
        }

        .notes {
            clear: both;
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e2e8f0;
        }

        .notes h3 {
            font-size: 12px;
            color: #64748b;
            margin-bottom: 8px;
        }

        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #e2e8f0;
            text-align: center;
            color: #94a3b8;
            font-size: 9px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1>QUOTATION</h1>
            <div class="quote-number">{{ $quotation->quotation_number }}</div>
        </div>

        <div class="company-info">
            <h2>{{ $quotation->company->name ?? 'Company Not Set' }}</h2>
            <p>{{ $quotation->company && $quotation->company->address ? $quotation->company->address : '' }}</p>
            @if($quotation->company && $quotation->company->phone)
                <p>Phone: {{ $quotation->company->phone }}</p>
            @endif
            @if($quotation->company && $quotation->company->email)
                <p>Email: {{ $quotation->company->email }}</p>
            @endif
        </div>

        <div class="info-row">
            <div class="info-col">
                <h3>Bill To</h3>
                <p><strong>{{ $quotation->client_name }}</strong></p>
                @if($quotation->client_email)
                    <p>{{ $quotation->client_email }}</p>
                @endif
                @if($quotation->client_phone)
                    <p>{{ $quotation->client_phone }}</p>
                @endif
                @if($quotation->client_address)
                    <p>{{ $quotation->client_address }}</p>
                @endif
            </div>
            <div class="info-col">
                <h3>Quotation Details</h3>
                <p><strong>Issue Date:</strong> {{ $quotation->issue_date->format('M d, Y') }}</p>
                @if($quotation->valid_until)
                    <p><strong>Valid Until:</strong> {{ $quotation->valid_until->format('M d, Y') }}</p>
                @endif
                <p><strong>Prepared By:</strong> {{ $quotation->user->name ?? 'System' }}</p>
            </div>
        </div>

        <table>
            <thead>
                <tr>
                    <th style="width: 50%">Description</th>
                    <th class="text-center" style="width: 10%">Qty</th>
                    <th class="text-center" style="width: 10%">Hours</th>
                    <th class="text-right" style="width: 15%">Rate</th>
                    <th class="text-right" style="width: 15%">Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach($quotation->items as $item)
                    <tr>
                        <td>
                            <strong>{{ $item->description }}</strong>
                            @if($item->type === 'product')
                                <br><span style="font-size: 9px; color: #64748b;">(Product)</span>
                            @endif
                        </td>
                        <td class="text-center">{{ $item->quantity }}</td>
                        <td class="text-center">{{ $item->hours > 0 ? $item->hours : '-' }}</td>
                        <td class="text-right">${{ number_format($item->unit_price, 2) }}</td>
                        <td class="text-right">${{ number_format($item->total_price, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="totals">
            <table>
                <tr>
                    <td>Subtotal:</td>
                    <td class="text-right">${{ number_format($quotation->subtotal, 2) }}</td>
                </tr>
                @if($quotation->tax_rate > 0)
                    <tr>
                        <td>Tax ({{ $quotation->tax_rate }}%):</td>
                        <td class="text-right">${{ number_format($quotation->tax_amount, 2) }}</td>
                    </tr>
                @endif
                <tr class="total-row">
                    <td>Total:</td>
                    <td class="text-right">${{ number_format($quotation->total_amount, 2) }}</td>
                </tr>
            </table>
        </div>

        @if($quotation->notes)
            <div class="notes">
                <h3>Notes / Terms & Conditions</h3>
                <p>{{ $quotation->notes }}</p>
            </div>
        @endif

        <div class="footer">
            <p>&copy; {{ date('Y') }} {{ $quotation->company->name ?? 'Company' }}. All rights reserved.</p>
            <p>This quotation is valid until
                {{ $quotation->valid_until ? $quotation->valid_until->format('M d, Y') : 'further notice' }}.
            </p>
        </div>
    </div>
</body>

</html>