@extends('layouts.user')

@section('title', 'Change Password')

@section('content')
    <div class="p-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Change Password</h1>
            <p class="text-gray-500">Ensure your account is secure with a strong password.</p>
        </div>

        <div class="max-w-xl">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-8">
                <form action="{{ route('profile.password.update') }}" method="POST" class="space-y-6" x-data="{ 
                        password: '', 
                        confirm: '',
                        showCurrent: false,
                        showNew: false,
                        showConfirm: false,
                        strength: 0,
                        validations: {
                            length: false,
                            capital: false,
                            number: false,
                            special: false
                        },
                        generatePassword() {
                            const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+';
                            let gen = '';
                            const length = 12;
                            // Ensure requirements
                            gen += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.charAt(Math.floor(Math.random() * 26)); // Capital
                            gen += 'abcdefghijklmnopqrstuvwxyz'.charAt(Math.floor(Math.random() * 26)); // Lower
                            gen += '0123456789'.charAt(Math.floor(Math.random() * 10)); // Number
                            gen += '!@#$%^&*()_+'.charAt(Math.floor(Math.random() * 12)); // Special

                            for (let i = 4; i < length; i++) {
                                 gen += chars.charAt(Math.floor(Math.random() * chars.length));
                            }
                            this.password = gen.split('').sort(() => 0.5 - Math.random()).join('');
                            this.confirm = this.password;
                            this.checkStrength();
                        },
                        checkStrength() {
                            this.validations.length = this.password.length >= 8;
                            this.validations.capital = /[A-Z]/.test(this.password);
                            this.validations.number = /[0-9]/.test(this.password);
                            this.validations.special = /[^A-Za-z0-9]/.test(this.password);

                            let s = 0;
                            if (this.validations.length) s++;
                            if (this.validations.capital) s++;
                            if (this.validations.number) s++;
                            if (this.validations.special) s++;
                            this.strength = s;
                        }
                    }">
                    @csrf
                    @method('PUT')

                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-1">Current Password</label>
                        <div class="relative">
                            <input :type="showCurrent ? 'text' : 'password'" name="current_password" required
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-bold text-sm pr-10">
                            <button type="button" @click="showCurrent = !showCurrent"
                                class="absolute inset-y-0 right-0 px-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                <svg x-show="!showCurrent" class="w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                    </path>
                                </svg>
                                <svg x-show="showCurrent" class="w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24" style="display: none;">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a10.05 10.05 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.542 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21">
                                    </path>
                                </svg>
                            </button>
                        </div>
                        @error('current_password')
                            <p class="mt-1 text-xs text-red-600 font-bold">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <div class="flex justify-between items-center mb-1">
                            <label class="block text-sm font-bold text-gray-700">New Password</label>
                            <button type="button" @click="generatePassword()"
                                class="text-xs text-blue-600 font-bold hover:text-blue-800 hover:underline">
                                Generate Secure Password
                            </button>
                        </div>
                        <div class="relative">
                            <input :type="showNew ? 'text' : 'password'" name="password" required x-model="password"
                                @input="checkStrength()"
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-bold text-sm pr-10">
                            <button type="button" @click="showNew = !showNew"
                                class="absolute inset-y-0 right-0 px-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                <svg x-show="!showNew" class="w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                    </path>
                                </svg>
                                <svg x-show="showNew" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                    style="display: none;">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a10.05 10.05 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.542 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21">
                                    </path>
                                </svg>
                            </button>
                        </div>

                        <!-- Strength Meter -->
                        <div class="mt-2 h-1.5 w-full bg-gray-100 rounded-full overflow-hidden flex">
                            <div class="h-full transition-all duration-300" :class="{
                                        'bg-red-500 w-1/4': strength === 1,
                                        'bg-orange-500 w-2/4': strength === 2,
                                        'bg-yellow-500 w-3/4': strength === 3,
                                        'bg-emerald-500 w-full': strength === 4
                                     }"></div>
                        </div>
                        <p class="text-[10px] font-bold mt-1 text-right" :class="{
                                   'text-gray-400': strength === 0,
                                   'text-red-500': strength === 1,
                                   'text-orange-500': strength === 2,
                                   'text-yellow-500': strength === 3,
                                   'text-emerald-500': strength === 4
                               }" x-text="['None', 'Weak', 'Fair', 'Good', 'Strong'][strength]"></p>

                        <!-- Validation Rules -->
                        <div class="mt-3 grid grid-cols-2 gap-2 text-[10px] font-bold text-gray-400">
                            <div class="flex items-center gap-1" :class="validations.length ? 'text-emerald-600' : ''">
                                <span x-text="validations.length ? '✓' : '○'"></span> 8+ Characters
                            </div>
                            <div class="flex items-center gap-1" :class="validations.capital ? 'text-emerald-600' : ''">
                                <span x-text="validations.capital ? '✓' : '○'"></span> Uppercase Letter
                            </div>
                            <div class="flex items-center gap-1" :class="validations.number ? 'text-emerald-600' : ''">
                                <span x-text="validations.number ? '✓' : '○'"></span> Number
                            </div>
                            <div class="flex items-center gap-1" :class="validations.special ? 'text-emerald-600' : ''">
                                <span x-text="validations.special ? '✓' : '○'"></span> Special Character
                            </div>
                        </div>

                        @error('password')
                            <p class="mt-1 text-xs text-red-600 font-bold">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-1">Confirm New Password</label>
                        <div class="relative">
                            <input :type="showConfirm ? 'text' : 'password'" name="password_confirmation" required
                                x-model="confirm"
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all font-bold text-sm pr-10">
                            <button type="button" @click="showConfirm = !showConfirm"
                                class="absolute inset-y-0 right-0 px-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none">
                                <svg x-show="!showConfirm" class="w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                    </path>
                                </svg>
                                <svg x-show="showConfirm" class="w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24" style="display: none;">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a10.05 10.05 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.542 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21">
                                    </path>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <div x-show="password !== '' && confirm !== '' && password !== confirm"
                        class="text-xs text-red-600 font-bold animate-pulse">
                        Passwords do not match
                    </div>

                    <div class="pt-4">
                        <button type="submit"
                            class="w-full px-6 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/30">
                            Update Password
                        </button>
                        <p class="text-center mt-4 text-xs text-gray-400">
                            Note: You will stay logged in after changing your password.
                        </p>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection