<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Job Mission Notes Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
        }

        .header h1 {
            font-size: 20px;
            margin: 0;
            text-transform: uppercase;
        }

        .duty-group {
            margin-bottom: 30px;
            border: 1px solid #eee;
            border-radius: 8px;
            overflow: hidden;
        }

        .duty-header {
            background-color: #f8fafc;
            padding: 10px;
            border-bottom: 1px solid #eee;
        }

        .duty-header h2 {
            margin: 0;
            font-size: 12px;
            color: #1e40af;
        }

        .duty-info {
            font-size: 9px;
            color: #64748b;
            margin-top: 4px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #f1f5f9;
            vertical-align: top;
        }

        th {
            background-color: #f1f5f9;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 8px;
            letter-spacing: 0.05em;
        }

        .note-text {
            font-style: italic;
            color: #475569;
        }

        .evidence-img {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 4px;
            border: 1px solid #e2e8f0;
        }

        .timestamp {
            font-weight: bold;
            white-space: nowrap;
        }

        .employee-name {
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Job Mission Notes Report</h1>
        <p>Generated on {{ now()->format('M d, Y H:i A') }}</p>
    </div>

    @foreach($groupedNotes as $group)
        <div class="duty-group">
            <div class="duty-header">
                <h2>{{ $group['site_route'] }} ({{ ucfirst($group['job_type']) }})</h2>
                <div class="duty-info">Duty Number: #{{ $group['duty_number'] }}</div>
            </div>
            <table>
                <thead>
                    <tr>
                        <th width="15%">Time</th>
                        <th width="20%">Employee</th>
                        <th width="45%">Mission Note</th>
                        <th width="20%">Evidence</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($group['notes'] as $note)
                        <tr>
                            <td class="timestamp">
                                {{ $note->created_at->format('M d, Y') }}<br>
                                <span style="color: #94a3b8;">{{ $note->created_at->format('H:i A') }}</span>
                            </td>
                            <td class="employee-name">
                                {{ $note->employee->full_name ?? ($note->employee->first_name . ' ' . $note->employee->last_name) }}
                            </td>
                            <td class="note-text">
                                "{{ $note->note }}"
                            </td>
                            <td>
                                @if($note->image)
                                    <img src="{{ public_path('storage/' . $note->image) }}" class="evidence-img">
                                @else
                                    <span style="color: #cbd5e1;">No image</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endforeach
</body>

</html>