@extends('layouts.user')

@section('title', 'Meetings & Discussions')

@section('page_title', 'Real-time Meetings')

@section('content')
    <div class="space-y-8" x-data="{ 
            showModal: false,
            roomId: '',
            copyingId: null,
            async copyToClipboard(id) {
                try {
                    await navigator.clipboard.writeText(id);
                    this.copyingId = id;
                    setTimeout(() => this.copyingId = null, 2000);
                } catch (err) {
                    console.error('Failed to copy: ', err);
                }
            }
        }">
        <!-- Header/Hero -->
        <div class="bg-slate-900 rounded-3xl p-8 text-white relative overflow-hidden shadow-2xl">
            <div class="absolute -top-24 -right-24 w-64 h-64 bg-blue-600/20 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -left-24 w-64 h-64 bg-blue-600/10 rounded-full blur-3xl"></div>

            <div class="relative z-10 flex flex-col md:flex-row items-center justify-between gap-8">
                <div class="max-w-xl">
                    <h2 class="text-4xl font-black tracking-tight mb-4">Host Real-time Discussions</h2>
                    <p class="text-blue-100/70 text-lg leading-relaxed">
                        Connect with your team instantly. Premium video meetings, encrypted chat, and real-time screen
                        sharing powered by Laravel Reverb.
                    </p>
                    <div class="mt-8 flex flex-wrap gap-4">
                        <a href="{{ route('meetings.create') }}"
                            class="px-8 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/30 flex items-center gap-2 transform hover:-translate-y-0.5">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4">
                                </path>
                            </svg>
                            Start New Meeting
                        </a>
                        <button @click="showModal = true; $nextTick(() => document.getElementById('join-input').focus())"
                            class="px-8 py-3 bg-white/10 text-white font-bold rounded-xl hover:bg-white/20 transition-all backdrop-blur-md border border-white/10 flex items-center gap-2 transform hover:-translate-y-0.5">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1">
                                </path>
                            </svg>
                            Join Meeting Room
                        </button>
                    </div>
                </div>
                <div class="w-full md:w-auto">
                    <div class="glass p-4 rounded-3xl border border-white/10 shadow-2xl bg-white/5 backdrop-blur-xl">
                        <img src="https://img.freepik.com/free-vector/video-conferencing-concept-illustration_114360-3103.jpg?t=st=1716654000~exp=1716657600~hmac=6b9e2c8e3c8d9e2c8e3c8d9e2c8e3c8d9e2c8e3c8d9e2c8e3c8d9e2c8e3c8d9e"
                            alt="Meetings" class="w-64 h-auto rounded-2xl grayscale brightness-125 opacity-80">
                    </div>
                </div>
            </div>
        </div>

        <!-- Meetings Lists -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Active Sessions -->
            <div class="lg:col-span-2 space-y-6">
                <h3 class="text-xl font-bold text-gray-800 flex items-center gap-3">
                    <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span>
                    Active Sessions
                </h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @forelse($meetings->where('status', 'active') as $meeting)
                        <div
                            class="bg-white p-6 rounded-2xl border border-gray-100 shadow-sm hover:shadow-xl transition-all group">
                            <div class="flex items-start justify-between mb-4">
                                <div
                                    class="w-12 h-12 bg-blue-50 rounded-xl flex items-center justify-center text-blue-600 font-bold text-xl group-hover:bg-blue-600 group-hover:text-white transition-colors">
                                    {{ $meeting->title[0] }}
                                </div>
                                <span
                                    class="px-3 py-1 bg-green-50 text-green-600 text-[10px] font-bold uppercase rounded-full tracking-wider">Active</span>
                            </div>
                            <h4 class="text-lg font-bold text-gray-900 mb-1">{{ $meeting->title }}</h4>
                            <p class="text-xs text-gray-500 mb-6">Hosted by {{ $meeting->creator->name }}</p>

                            <div class="flex items-center justify-between">
                                <div class="text-[10px] text-gray-400 font-bold uppercase">
                                    {{ $meeting->created_at->diffForHumans() }}
                                </div>
                                <div class="flex gap-2">
                                    <button @click="copyToClipboard('{{ $meeting->uuid }}')"
                                        class="p-2 bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200 transition-all flex items-center gap-1"
                                        title="Copy Room ID">
                                        <svg x-show="copyingId !== '{{ $meeting->uuid }}'" class="w-4 h-4" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z">
                                            </path>
                                        </svg>
                                        <svg x-show="copyingId === '{{ $meeting->uuid }}'" class="w-4 h-4 text-green-600"
                                            fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M5 13l4 4L19 7"></path>
                                        </svg>
                                        <span class="text-[10px] font-bold"
                                            x-text="copyingId === '{{ $meeting->uuid }}' ? 'COPIED' : 'SHARE'"></span>
                                    </button>
                                    <a href="{{ route('meetings.join', $meeting->uuid) }}"
                                        class="px-4 py-2 bg-slate-900 text-white text-xs font-bold rounded-lg hover:bg-black transition-all">Join
                                        Room</a>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div
                            class="col-span-2 bg-gray-50 border-2 border-dashed border-gray-200 rounded-3xl flex flex-col items-center justify-center py-12 text-center">
                            <div
                                class="w-16 h-16 bg-white rounded-2xl shadow-sm flex items-center justify-center text-gray-300 mb-4">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z">
                                    </path>
                                </svg>
                            </div>
                            <p class="text-gray-500 font-medium">No active sessions found.</p>
                            <a href="{{ route('meetings.create') }}"
                                class="text-blue-600 text-sm font-bold mt-2 hover:underline">Start the first one &rarr;</a>
                        </div>
                    @endforelse
                </div>
            </div>

            <!-- Past Logs -->
            <div class="space-y-6">
                <h3 class="text-xl font-bold text-gray-800">Recent Logs</h3>
                <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
                    @forelse($meetings->where('status', 'finished')->take(5) as $meeting)
                        <div class="p-4 border-b border-gray-50 hover:bg-gray-50 transition-colors last:border-0">
                            <div class="flex items-center gap-3">
                                <div
                                    class="w-8 h-8 bg-gray-100 rounded-lg flex items-center justify-center text-xs font-bold text-gray-500 uppercase">
                                    {{ $meeting->title[0] }}
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h5 class="text-sm font-bold text-gray-900 truncate">{{ $meeting->title }}</h5>
                                    <p class="text-[10px] text-gray-400 font-bold uppercase">
                                        {{ $meeting->ends_at?->format('F d, Y') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="p-8 text-center">
                            <p class="text-xs text-gray-400 font-bold uppercase">No history found</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Join Modal (Simplified, no teleport) -->
        <div x-show="showModal"
            class="fixed inset-0 bg-slate-900/95 backdrop-blur-3xl flex items-center justify-center p-6 z-[1000]"
            style="display: none;" x-cloak @keydown.escape.window="showModal = false">
            <div @click.away="showModal = false"
                class="bg-white w-full max-w-md rounded-[2.5rem] p-10 shadow-[0_35px_60px_-15px_rgba(0,0,0,0.5)] space-y-8 transform transition-all border border-gray-100 relative">

                <button @click="showModal = false"
                    class="absolute top-6 right-6 text-gray-300 hover:text-gray-500 transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>

                <div class="text-center space-y-2">
                    <div
                        class="w-20 h-20 bg-blue-50 text-blue-600 rounded-3xl flex items-center justify-center mx-auto mb-6 shadow-sm border border-blue-100/50">
                        <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z">
                            </path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-black text-gray-900 tracking-tight">Access Room</h3>
                    <p class="text-sm text-gray-400 font-medium">Please enter the 12-digit Meeting Room ID.</p>
                </div>

                <div class="space-y-4">
                    <div class="relative group">
                        <input type="text" x-model="roomId" id="join-input"
                            class="w-full bg-gray-50/50 border-gray-200 border-2 rounded-2xl px-6 py-5 text-center font-mono text-2xl tracking-[0.2em] focus:border-blue-500 focus:bg-white focus:ring-8 focus:ring-blue-500/5 transition-all text-gray-900 outline-none placeholder:text-gray-200"
                            placeholder="UUID-ROOM-ID">
                    </div>

                    <button @click="if(roomId) window.location.href = '/meetings/join/' + roomId"
                        class="w-full py-5 bg-blue-600 text-white font-black rounded-2xl shadow-2xl shadow-blue-600/30 hover:bg-blue-700 hover:-translate-y-0.5 transform transition-all uppercase tracking-[0.2em] text-sm active:scale-95 disabled:opacity-50 disabled:cursor-not-allowed"
                        :disabled="!roomId">
                        Initialize Session
                    </button>

                    <button @click="showModal = false"
                        class="w-full py-4 text-gray-400 font-bold hover:text-gray-600 transition-colors uppercase tracking-widest text-[10px]">
                        Return to Dashboard
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection