@extends(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user')

@section('content')
<div class="p-6 max-w-7xl mx-auto grid grid-cols-1 lg:grid-cols-3 gap-6">

    <!-- Left Column: Lead Information -->
    <div class="lg:col-span-1 space-y-6">
        
        <!-- Status Card -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center justify-between mb-4">
                <span class="text-xs font-black text-gray-400 uppercase tracking-widest">Current Status</span>
                @php
                    $colors = [
                        'new' => 'bg-blue-100 text-blue-700',
                        'contacted' => 'bg-amber-100 text-amber-700',
                        'matured' => 'bg-purple-100 text-purple-700',
                        'proposal' => 'bg-indigo-100 text-indigo-700',
                        'won' => 'bg-emerald-100 text-emerald-700',
                        'lost' => 'bg-gray-100 text-gray-500',
                        'disqualified' => 'bg-red-100 text-red-700',
                    ];
                @endphp
                <span class="px-3 py-1 rounded-full text-xs font-black uppercase tracking-wider {{ $colors[$lead->status] ?? 'bg-gray-100 text-gray-600' }}">
                    {{ ucfirst($lead->status) }}
                </span>
            </div>
            
            <form action="{{ route('leads.update', $lead) }}" method="POST">
                @csrf
                @method('PUT')
                <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Update Stage</label>
                <select name="status" onchange="this.form.submit()" class="w-full px-3 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-800 focus:border-blue-500 outline-none">
                    <option value="new" {{ $lead->status == 'new' ? 'selected' : '' }}>New Inquiry</option>
                    <option value="contacted" {{ $lead->status == 'contacted' ? 'selected' : '' }}>Contacted</option>
                    <option value="matured" {{ $lead->status == 'matured' ? 'selected' : '' }}>Matured (Qualified)</option>
                    <option value="proposal" {{ $lead->status == 'proposal' ? 'selected' : '' }}>Proposal Sent</option>
                    <option value="won" {{ $lead->status == 'won' ? 'selected' : '' }}>Won (Closed)</option>
                    <option value="lost" {{ $lead->status == 'lost' ? 'selected' : '' }}>Lost</option>
                    <option value="disqualified" {{ $lead->status == 'disqualified' ? 'selected' : '' }}>Disqualified</option>
                </select>
            </form>
        </div>

        <!-- Contact Info -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <h3 class="text-xs font-black text-gray-400 uppercase tracking-widest mb-4 border-b border-gray-100 pb-2">Client Details</h3>
            
            <div class="space-y-4">
                <div>
                    <label class="block text-[10px] font-bold text-gray-400 uppercase">Contact Name</label>
                    <div class="font-bold text-gray-800">{{ $lead->name }}</div>
                    <div class="text-xs text-gray-500">{{ $lead->job_title }}</div>
                </div>
                
                <div>
                    <label class="block text-[10px] font-bold text-gray-400 uppercase">Company</label>
                    <div class="font-bold text-gray-800">{{ $lead->company_name ?? 'N/A' }}</div>
                </div>

                <div>
                    <label class="block text-[10px] font-bold text-gray-400 uppercase">Contact Methods</label>
                    @if($lead->email)
                        <div class="flex items-center gap-2 mt-1">
                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                            <a href="mailto:{{ $lead->email }}" class="text-sm font-medium text-blue-600 hover:underline">{{ $lead->email }}</a>
                        </div>
                    @endif
                    @if($lead->phone)
                        <div class="flex items-center gap-2 mt-1">
                            <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                            <a href="tel:{{ $lead->phone }}" class="text-sm font-medium text-blue-600 hover:underline">{{ $lead->phone }}</a>
                        </div>
                    @endif
                </div>

                <div>
                    <label class="block text-[10px] font-bold text-gray-400 uppercase">Location</label>
                    <div class="text-sm font-medium text-gray-800">{{ $lead->site_location ?? 'N/A' }}</div>
                    <div class="text-xs text-gray-500">{{ $lead->property_type }}</div>
                </div>

                <div>
                    <label class="block text-[10px] font-bold text-gray-400 uppercase">Lead Owner</label>
                    <form action="{{ route('leads.update', $lead) }}" method="POST" class="mt-1">
                        @csrf
                        @method('PUT')
                        <div class="flex items-center gap-2">
                            <div class="w-6 h-6 rounded-full bg-gray-200 flex items-center justify-center text-[10px] font-bold flex-shrink-0">
                                {{ substr($lead->assignee->name ?? '?', 0, 1) }}
                            </div>
                            <input type="text" name="assigned_to" value="{{ $lead->assigned_to }}" 
                                class="text-sm font-medium text-gray-800 bg-transparent border-0 border-b border-dashed border-gray-300 focus:ring-0 focus:border-blue-500 py-0 pl-0 w-24 cursor-text hover:text-blue-600"
                                placeholder="User ID"
                                onchange="this.form.submit()">
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Next Actions -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
             <h3 class="text-xs font-black text-gray-400 uppercase tracking-widest mb-4 border-b border-gray-100 pb-2">Plan Next Step</h3>
             
             <form action="{{ route('leads.update', $lead) }}" method="POST" class="space-y-4">
                @csrf
                @method('PUT')
                <div>
                     <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">Next Follow-up Date</label>
                     <input type="date" name="next_follow_up_date" value="{{ $lead->next_follow_up_date ? $lead->next_follow_up_date->format('Y-m-d') : '' }}" class="w-full px-3 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-800 focus:border-blue-500">
                </div>
                 <div>
                     <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">Action Description</label>
                     <input type="text" name="next_action" value="{{ $lead->next_action }}" placeholder="e.g. Call to discuss contract" class="w-full px-3 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-800 focus:border-blue-500">
                </div>
                <button type="submit" class="w-full py-2 bg-blue-600 text-white text-xs font-bold uppercase tracking-wider rounded-lg hover:bg-blue-700">Update Plan</button>
             </form>
        </div>
    </div>

    <!-- Center/Right: Activity Stream -->
    <div class="lg:col-span-2 space-y-6">
        
        <!-- Add Remark Box -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
            <h3 class="text-xs font-black text-gray-400 uppercase tracking-widest mb-4">Log Activity</h3>
            
            <form action="{{ route('leads.remarks.store', $lead) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="flex gap-4 mb-4">
                    <div class="flex-1">
                        <select name="type" class="w-full px-3 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-800 focus:border-blue-500">
                            <option value="note">General Note</option>
                            <option value="call">Phone Call</option>
                            <option value="email">Email Sent</option>
                            <option value="meeting">Meeting / Site Visit</option>
                        </select>
                    </div>
                     <div class="flex-1">
                        <select name="disposition" class="w-full px-3 py-2 bg-gray-50 border border-gray-200 rounded-lg text-sm font-bold text-gray-800 focus:border-blue-500">
                            <option value="">-- Outcome (Optional) --</option>
                            <option value="connected">Connected / Spoke</option>
                            <option value="left_voicemail">Left Voicemail</option>
                            <option value="busy">No Answer / Busy</option>
                            <option value="sent">Sent / Delivered</option>
                            <option value="bounced">Bounced</option>
                        </select>
                    </div>
                </div>

                <textarea name="content" rows="3" required placeholder="Type notes here..." class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 outline-none transition-all font-medium text-gray-700 mb-4"></textarea>
                
                <div class="flex justify-between items-center">
                    <input type="file" name="attachment" class="text-xs text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                    <button type="submit" class="px-6 py-2 bg-slate-800 text-white font-bold rounded-lg hover:bg-slate-900 transition-all">Add Log</button>
                </div>
            </form>
        </div>

        <!-- Activity Timeline -->
        <div class="space-y-4">
            @forelse($lead->remarks as $remark)
                <div class="flex gap-4 p-4 bg-white rounded-xl border border-gray-100 shadow-sm relative hover:border-blue-200 transition-colors">
                    <!-- Icon -->
                    <div class="flex-shrink-0">
                        @if($remark->type == 'call')
                            <div class="w-10 h-10 rounded-full bg-green-50 text-green-600 flex items-center justify-center"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg></div>
                        @elseif($remark->type == 'email')
                             <div class="w-10 h-10 rounded-full bg-blue-50 text-blue-600 flex items-center justify-center"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg></div>
                        @elseif($remark->type == 'meeting')
                             <div class="w-10 h-10 rounded-full bg-purple-50 text-purple-600 flex items-center justify-center"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg></div>
                        @else
                             <div class="w-10 h-10 rounded-full bg-gray-50 text-gray-600 flex items-center justify-center"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg></div>
                        @endif
                    </div>
                    
                    <div class="flex-1">
                        <div class="flex justify-between items-start">
                            <div>
                                <span class="text-sm font-bold text-gray-900">{{ ucfirst($remark->type) }}</span>
                                @if($remark->disposition)
                                    <span class="text-xs font-bold text-gray-500 uppercase tracking-wide bg-gray-100 px-2 py-0.5 rounded ml-2">{{ ucfirst(str_replace('_', ' ', $remark->disposition)) }}</span>
                                @endif
                            </div>
                            <span class="text-xs font-bold text-gray-400">{{ $remark->created_at->diffForHumans() }}</span>
                        </div>
                        
                        <div class="mt-2 text-sm text-gray-700 whitespace-pre-wrap">{{ $remark->content }}</div>
                        
                        @if($remark->attachment_path)
                            <div class="mt-3">
                                <a href="{{ Storage::url($remark->attachment_path) }}" target="_blank" class="inline-flex items-center gap-2 px-3 py-1.5 bg-gray-50 hover:bg-gray-100 rounded-lg text-xs font-bold text-blue-600 transition-colors border border-gray-200">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path></svg>
                                    View Attachment
                                </a>
                            </div>
                        @endif

                        <div class="mt-2 text-xs font-bold text-gray-300">Logged by {{ $remark->user->name ?? 'System' }}</div>
                    </div>
                </div>
            @empty
                <div class="text-center py-12 bg-gray-50 rounded-2xl border border-dashed border-gray-200">
                    <p class="text-gray-400 font-bold">No activity logged yet.</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
@endsection
