@extends('layouts.user')

@section('title', 'Employee Import Settings')

@section('content')
    @if(session('success'))
        <div class="mb-6 mx-6 p-4 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded-2xl flex items-center gap-3 shadow-sm animate-fade-in-down">
            <div class="w-8 h-8 bg-emerald-500 rounded-full flex items-center justify-center text-white shrink-0">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"></path>
                </svg>
            </div>
            <p class="text-xs font-bold uppercase tracking-wider">{{ session('success') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="mb-6 mx-6 p-4 bg-red-50 border border-red-100 text-red-700 rounded-2xl flex items-center gap-3 shadow-sm animate-fade-in-down">
            <div class="w-8 h-8 bg-red-500 rounded-full flex items-center justify-center text-white shrink-0">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </div>
            <p class="text-xs font-bold uppercase tracking-wider">{{ session('error') }}</p>
        </div>
    @endif

    <div class="flex flex-col h-full bg-gray-50">
        <!-- Header -->
        <div class="bg-white border-b border-gray-100 px-6 py-4">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-black text-gray-900 tracking-tight">Employee Import Settings</h1>
                    <p class="text-sm text-gray-500 mt-1">Import employees from CSV or Excel files with custom column mapping</p>
                </div>
                <a href="{{ route('employees.index') }}" 
                   class="px-4 py-2 bg-gray-100 text-gray-700 font-bold rounded-xl hover:bg-gray-200 transition-all flex items-center gap-2 text-xs uppercase tracking-wider">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Employees
                </a>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto p-6">
            <div class="max-w-7xl mx-auto">
                <!-- Upload and Instructions Row -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                    <!-- Upload Section -->
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="bg-gradient-to-r from-blue-600 to-blue-700 px-6 py-4">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-white/20 rounded-xl flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                              d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-black text-white tracking-tight">Step 1: Upload File</h3>
                                    <p class="text-xs text-blue-100">Select your CSV or Excel file</p>
                                </div>
                            </div>
                        </div>
                        <div class="p-6">
                            <form action="{{ route('employees.import.preview') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="mb-6">
                                    <label for="csv_file" class="block text-xs font-bold text-gray-700 uppercase tracking-wider mb-2">
                                        Select File
                                    </label>
                                    <div class="relative">
                                        <input type="file" 
                                               class="block w-full text-sm text-gray-500 file:mr-4 file:py-3 file:px-4 file:rounded-xl file:border-0 file:text-xs file:font-bold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer border border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 transition-all @error('csv_file') border-red-500 @enderror" 
                                               id="csv_file" 
                                               name="csv_file" 
                                               accept=".csv,.xlsx,.xls" 
                                               required>
                                    </div>
                                    @error('csv_file')
                                        <p class="mt-2 text-xs text-red-600 font-medium">{{ $message }}</p>
                                    @enderror
                                    <p class="mt-2 text-xs text-gray-500 flex items-center gap-1">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        Supported: CSV, XLSX, XLS (Max: 10MB)
                                    </p>
                                </div>

                                <button type="submit" 
                                        class="w-full px-6 py-3.5 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20 flex items-center justify-center gap-2 text-sm uppercase tracking-wider">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                    </svg>
                                    Preview & Map Columns
                                </button>
                            </form>

                            <div class="relative my-6">
                                <div class="absolute inset-0 flex items-center">
                                    <div class="w-full border-t border-gray-200"></div>
                                </div>
                                <div class="relative flex justify-center text-xs uppercase">
                                    <span class="px-2 bg-white text-gray-500 font-bold">Or</span>
                                </div>
                            </div>

                            <a href="{{ route('employees.import.template') }}" 
                               class="w-full px-6 py-3 bg-green-50 text-green-700 font-bold rounded-xl hover:bg-green-100 transition-all border border-green-200 flex items-center justify-center gap-2 text-sm uppercase tracking-wider">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Download Sample Template
                            </a>
                        </div>
                    </div>

                    <!-- Instructions Section -->
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="bg-gradient-to-r from-indigo-600 to-indigo-700 px-6 py-4">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-white/20 rounded-xl flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-black text-white tracking-tight">Import Instructions</h3>
                                    <p class="text-xs text-indigo-100">Follow these steps</p>
                                </div>
                            </div>
                        </div>
                        <div class="p-6">
                            <h4 class="text-xs font-black text-gray-700 uppercase tracking-wider mb-3">How to Import:</h4>
                            <ol class="space-y-2 mb-6">
                                <li class="flex items-start gap-3 text-sm text-gray-600">
                                    <span class="flex-shrink-0 w-6 h-6 bg-indigo-100 text-indigo-700 rounded-full flex items-center justify-center text-xs font-bold">1</span>
                                    <span>Download the sample template or prepare your CSV/Excel file</span>
                                </li>
                                <li class="flex items-start gap-3 text-sm text-gray-600">
                                    <span class="flex-shrink-0 w-6 h-6 bg-indigo-100 text-indigo-700 rounded-full flex items-center justify-center text-xs font-bold">2</span>
                                    <span>Fill in employee data according to the column headers</span>
                                </li>
                                <li class="flex items-start gap-3 text-sm text-gray-600">
                                    <span class="flex-shrink-0 w-6 h-6 bg-indigo-100 text-indigo-700 rounded-full flex items-center justify-center text-xs font-bold">3</span>
                                    <span>Upload your file using the form on the left</span>
                                </li>
                                <li class="flex items-start gap-3 text-sm text-gray-600">
                                    <span class="flex-shrink-0 w-6 h-6 bg-indigo-100 text-indigo-700 rounded-full flex items-center justify-center text-xs font-bold">4</span>
                                    <span>Map your CSV columns to database fields</span>
                                </li>
                                <li class="flex items-start gap-3 text-sm text-gray-600">
                                    <span class="flex-shrink-0 w-6 h-6 bg-indigo-100 text-indigo-700 rounded-full flex items-center justify-center text-xs font-bold">5</span>
                                    <span>Review the preview and confirm import</span>
                                </li>
                            </ol>

                            <h4 class="text-xs font-black text-gray-700 uppercase tracking-wider mb-3">Important Notes:</h4>
                            <div class="space-y-2">
                                <div class="flex items-start gap-2 text-xs text-gray-600 bg-emerald-50 p-3 rounded-lg border border-emerald-100">
                                    <svg class="w-4 h-4 text-emerald-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                    <span><strong class="font-bold text-emerald-900">Required:</strong> Employee ID, First Name, Email, Phone, Gender</span>
                                </div>
                                <div class="flex items-start gap-2 text-xs text-gray-600 bg-amber-50 p-3 rounded-lg border border-amber-100">
                                    <svg class="w-4 h-4 text-amber-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                    </svg>
                                    <span><strong class="font-bold text-amber-900">Unique:</strong> Employee ID and Email must be unique</span>
                                </div>
                                <div class="flex items-start gap-2 text-xs text-gray-600 bg-blue-50 p-3 rounded-lg border border-blue-100">
                                    <svg class="w-4 h-4 text-blue-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                    <span><strong class="font-bold text-blue-900">Dates:</strong> Use YYYY-MM-DD format (e.g., 2024-01-15)</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Available Columns Reference -->
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="bg-gradient-to-r from-slate-700 to-slate-800 px-6 py-4">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-white/20 rounded-xl flex items-center justify-center">
                                <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M3 14h18m-9-4v8m-7 0h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-lg font-black text-white tracking-tight">Available Database Columns</h3>
                                <p class="text-xs text-slate-300">All fields you can import</p>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <p class="text-sm text-gray-600 mb-6">
                            Below are all available columns in the employee database. You can map your CSV columns to any of these fields during import.
                        </p>

                        @php
                            $groupedColumns = collect($employeeColumns)->groupBy('category');
                        @endphp

                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            @foreach($groupedColumns as $category => $columns)
                                <div class="bg-gray-50 rounded-xl border border-gray-200 overflow-hidden hover:shadow-md transition-all">
                                    <div class="bg-gradient-to-r from-gray-100 to-gray-50 px-4 py-3 border-b border-gray-200">
                                        <h4 class="text-xs font-black text-gray-800 uppercase tracking-wider">{{ $category }}</h4>
                                    </div>
                                    <div class="p-4">
                                        <div class="space-y-3">
                                            @foreach($columns as $column)
                                                <div class="flex items-start justify-between gap-2 pb-3 border-b border-gray-100 last:border-0 last:pb-0">
                                                    <div class="flex-1 min-w-0">
                                                        <p class="text-xs font-bold text-gray-900 truncate">{{ $column['label'] }}</p>
                                                        <code class="text-[10px] text-gray-500 bg-gray-100 px-1.5 py-0.5 rounded">{{ $column['name'] }}</code>
                                                        @if(isset($column['note']))
                                                            <p class="text-[10px] text-blue-600 mt-1 flex items-center gap-1">
                                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                                </svg>
                                                                {{ $column['note'] }}
                                                            </p>
                                                        @endif
                                                    </div>
                                                    <div class="flex-shrink-0">
                                                        @if($column['required'])
                                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-black uppercase tracking-wider bg-red-100 text-red-700 border border-red-200">
                                                                Required
                                                            </span>
                                                        @else
                                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-black uppercase tracking-wider bg-gray-100 text-gray-600 border border-gray-200">
                                                                Optional
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection