<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Employee ID Card</title>
    <style>
        @page {
            margin: 0;
            size: 153pt 243pt;
        }
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5; /* Light background to make card shadow visible */
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .card {
            width: 153pt;
            height: 243pt;
            background: #ffffff;
            position: relative;
            overflow: hidden;
            margin: 0 auto;
            /* Box shadow for premium look - DomPDF support varies, using a subtle border as fallback */
            border: 0.5pt solid #e2e8f0;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        /* Lanyard Slot */
        .slot-container {
            height: 18pt;
            text-align: center;
            padding-top: 6pt;
        }
        .slot {
            width: 30pt;
            height: 6pt;
            background: #e2e8f0;
            border-radius: 3pt;
            margin: 0 auto;
        }

        /* Header */
        .header {
            text-align: center;
            height: 35pt;
            padding: 0 8pt;
        }
        .header-content {
            display: inline-block;
            margin-top: 2pt;
        }
        .company-logo {
            height: 14pt;
            vertical-align: middle;
            margin-right: 3pt;
        }
        .company-text {
            display: inline-block;
            vertical-align: middle;
            text-align: left;
        }
        .company-name {
            font-size: 8.5pt;
            font-weight: 900;
            color: #000;
            text-transform: uppercase;
            margin: 0;
            line-height: 1;
        }
        .company-tagline {
            font-size: 5pt;
            color: #5b8ab1;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.2pt;
            margin: 0;
        }

        /* Middle Section: Photo & Barcode */
        .middle-section {
            height: 95pt;
            padding: 5pt 10pt;
            position: relative;
        }
        .photo-container {
            width: 75pt; /* Smaller photo */
            height: 85pt;
            border: 0.5pt solid #ddd; /* Thin gray border */
            border-radius: 4pt; /* Rounded corners */
            float: left;
            background: #f8fafc;
            overflow: hidden;
        }
        .profile-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .placeholder-text {
            line-height: 85pt;
            text-align: center;
            font-size: 30pt;
            color: #cbd5e1;
            font-weight: bold;
        }

        .barcode-sidebar {
            float: right;
            width: 30pt;
            height: 85pt;
            text-align: center;
        }
        .barcode-img {
            width: 25pt;
            height: 85pt;
        }

        /* Info Section */
        .info-section {
            padding: 0pt 12pt;
            clear: both;
            text-align: left;
        }
        .emp-fullname {
            font-size: 11pt;
            font-weight: 900;
            color: #000000;
            text-transform: uppercase;
            margin: 0;
            line-height: 1.1;
        }
        .emp-role {
            font-size: 7.5pt;
            color: #1a1a1a;
            font-weight: 700;
            text-transform: uppercase;
            margin-top: 2pt;
        }
        .emp-joining {
            font-size: 6.5pt;
            color: #444;
            font-weight: 600;
            margin-top: 1pt;
        }
        .emp-details {
            margin-top: 4pt;
            border-top: 0.2pt solid #eee;
            padding-top: 3pt;
        }
        .detail-row {
            font-size: 6.5pt;
            color: #1a1a1a;
            font-weight: 700;
            text-transform: uppercase;
            margin-bottom: 1pt;
        }

        /* Blue Footer */
        .footer {
            position: absolute;
            bottom: 0;
            width: 100%;
            height: 32pt;
            background-color: #6189ad;
            text-align: center;
        }
        .footer-label {
            color: #ffffff;
            font-size: 22pt;
            font-weight: 900;
            text-transform: uppercase;
            line-height: 32pt;
            letter-spacing: 3pt;
        }
    </style>
</head>
<body>
    @php
        $toBase64 = function($path) {
            if (!$path) return null;
            $fullPath = storage_path('app/public/' . $path);
            if (file_exists($fullPath)) {
                return 'data:image/' . pathinfo($fullPath, PATHINFO_EXTENSION) . ';base64,' . base64_encode(file_get_contents($fullPath));
            }
            return null;
        };

        $profileBase64 = $toBase64($employee->profile_picture);
        $logoBase64 = $toBase64($employee->company->logo ?? null);

        // Barcode data
        $dataStr = "NAME:" . $employee->getFullNameAttribute() . "|ID:" . $employee->employee_id . "|PH:" . ($employee->phone_number ?? 'N/A') . "|E:" . $employee->email;
        
        try {
            $barcodeUrl = "https://bwipjs-api.metafloor.com/?bcid=code128&text=" . urlencode($dataStr) . "&scale=2&rotate=R&includetext=false";
            $barcodeContent = @file_get_contents($barcodeUrl);
            if ($barcodeContent) {
                $barcodeBase64 = 'data:image/png;base64,' . base64_encode($barcodeContent);
            } else {
                $barcodeBase64 = null;
            }
        } catch (\Exception $e) {
            $barcodeBase64 = null;
        }
    @endphp

    <div class="card">
        <div class="slot-container">
            <div class="slot"></div>
        </div>

        <div class="header">
            <div class="header-content">
                @if($logoBase64)
                    <img src="{{ $logoBase64 }}" class="company-logo">
                @endif
                <div class="company-text">
                    <p class="company-name">{{ $employee->company->name ?? 'PUBLIC COMPANY' }}</p>
                    <p class="company-tagline">{{ $employee->company->tagline ?? 'SECURITY SOLUTIONS' }}</p>
                </div>
            </div>
        </div>

        <div class="middle-section">
            <div class="photo-container">
                @if($profileBase64)
                    <img src="{{ $profileBase64 }}" class="profile-img">
                @else
                    <div class="placeholder-text">{{ substr($employee->first_name, 0, 1) }}</div>
                @endif
            </div>

            <div class="barcode-sidebar">
                @if($barcodeBase64)
                    <img src="{{ $barcodeBase64 }}" class="barcode-img">
                @else
                    <div style="font-size: 5pt; color: #ccc; margin-top: 35pt; transform: rotate(-90deg);">NO BARCODE</div>
                @endif
            </div>
        </div>

        <div class="info-section">
            <h1 class="emp-fullname">{{ $employee->first_name }} {{ $employee->last_name }}</h1>
            <p class="emp-role">{{ $employee->jobRole->name ?? 'SECURITY GUARD' }}</p>
            <p class="emp-joining">Joining Date: {{ $employee->employment_date ? \Carbon\Carbon::parse($employee->employment_date)->format('d M, Y') : 'N/A' }}</p>
            
            <div class="emp-details">
                <div class="detail-row">ID: #{{ $employee->employee_id }}</div>
                <div class="detail-row">License Expiry: {{ $employee->license_expiry ? \Carbon\Carbon::parse($employee->license_expiry)->format('d/m/Y') : 'PERMANENT' }}</div>
            </div>
        </div>

        <div class="footer">
            <div class="footer-label">SECURITY</div>
        </div>
    </div>
</body>
</html>