@extends('layouts.user')

@section('title', 'Edit Employee')

@section('content')
    @php
        $selectedWageTypesData = $employee->wageTypes->map(function ($wt) {
            return ['id' => $wt->id, 'name' => $wt->name];
        })->values();

        $wageRates = [];
        foreach ($employee->wageTypes as $wt) {
            $wageRates[$wt->id] = $wt->pivot->rate ?? 0;
        }

        $initialData = [
            'first_name' => $employee->first_name ?? '',
            'middle_name' => $employee->middle_name ?? '',
            'last_name' => $employee->last_name ?? '',
            'gender' => $employee->gender ?? '',
            'email' => $employee->email ?? '',
            'dob' => $employee->dob ? (\Carbon\Carbon::parse($employee->dob)->format('Y-m-d')) : '',
            'marital_status' => $employee->marital_status ?? '',
            'job_role_id' => (string) $employee->job_role_id,
            'department_id' => (string) $employee->department_id,
            'zone_id' => (string) $employee->zone_id,
            'phone_number' => $employee->phone_number ?? '',
            'cell_number' => $employee->cell_number ?? '',
            'licence_province_name' => $employee->licence_issuing_province ?? '',
            'perm_address_1' => $employee->permanent_address_line_1 ?? '',
            'perm_address_2' => $employee->permanent_address_line_2 ?? '',
            'perm_city' => $employee->permanent_city ?? '',
            'perm_zip' => $employee->permanent_zip_code ?? '',
            'perm_country_id' => (string) $employee->permanent_country_id,
            'perm_state_id' => (string) $employee->permanent_state_id,
            'cors_address_1' => $employee->corresponding_address_line_1 ?? '',
            'cors_address_2' => $employee->corresponding_address_line_2 ?? '',
            'cors_city' => $employee->corresponding_city ?? '',
            'cors_zip' => $employee->corresponding_zip_code ?? '',
            'cors_country_id' => (string) $employee->corresponding_country_id,
            'cors_state_id' => (string) $employee->corresponding_state_id,
            'license_number' => $employee->license_number ?? '',
            'license_expiry' => $employee->license_expiry ?? '',
            'hiring_date' => $employee->employment_date ?? '',
            'termination_date' => $employee->terminated_date ?? '',
            'file_license' => true,
            'file_id' => true,
            'file_contract' => true,
            'profile_picture' => !!($employee->profile_picture),
            'wage_rates' => (object) $wageRates,
            'sin_number' => $employee->sin_number ?? '',
            'has_car' => (bool) $employee->has_car,
        ];
    @endphp

    <div class="max-w-7xl mx-auto" x-data="employeeEdit()">
        <!-- Header Section (Dark Blue) -->
        <div class="bg-[#1e293b] text-white px-8 pt-10 pb-0 rounded-t-3xl mb-0 shadow-xl relative overflow-hidden">
            <!-- Subtle background decorative element -->
            <div class="absolute -right-20 -top-20 w-64 h-64 bg-blue-500/10 rounded-full blur-3xl"></div>

            <div class="flex flex-col md:flex-row md:items-center gap-6 mb-8 relative z-10">
                <div class="relative group">
                    <div
                        class="w-20 h-20 rounded-2xl bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-3xl font-bold border-4 border-slate-800 shadow-2xl overflow-hidden transition-transform group-hover:scale-105">
                        <template x-if="profilePictureUrl">
                            <img :src="profilePictureUrl" class="w-full h-full object-cover">
                        </template>
                        <template x-if="!profilePictureUrl">
                            <span
                                class="text-white">{{ substr($employee->first_name, 0, 1) }}{{ substr($employee->last_name, 0, 1) }}</span>
                        </template>
                    </div>
                </div>
                <div>
                    <div class="flex items-center gap-3">
                        <h1 class="text-3xl font-extrabold tracking-tight">{{ $employee->first_name }}
                            {{ $employee->last_name }}
                        </h1>
                        <span
                            class="px-3 py-1 bg-blue-500/20 text-blue-300 text-[10px] font-bold uppercase rounded-full border border-blue-500/30">Employee</span>
                    </div>
                    <div class="flex flex-wrap items-center gap-4 mt-2 text-sm text-slate-400">
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                </path>
                            </svg>
                            {{ $employee->phone_number }}
                        </span>
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            {{ $employee->employee_id }}
                        </span>
                    </div>
                </div>

                <div class="md:ml-auto flex items-center gap-2">
                    <a href="{{ route('employees.index') }}"
                        class="px-5 py-2.5 bg-slate-800 text-slate-300 text-xs font-bold rounded-2xl border border-slate-700 hover:bg-slate-700 transition-all uppercase tracking-wider flex items-center gap-2 shadow-xl">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        Back to List
                    </a>
                </div>
            </div>

            <!-- Primary Tabs -->
            <div class="flex items-center gap-8 text-sm font-bold relative z-10 overflow-x-auto">
                <a href="{{ route('employees.show', $employee->id) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all whitespace-nowrap">Overview</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'documents']) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all whitespace-nowrap">Documents</a>

                <a href="{{ route('employees.schedules', $employee->id) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all flex items-center gap-2 whitespace-nowrap">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                    Schedules
                </a>

                <a href="{{ route('employees.id_card', $employee->id) }}" target="_blank"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all flex items-center gap-2 whitespace-nowrap">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                    </svg>
                    View ID Card
                </a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'uniforms']) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all whitespace-nowrap">Uniforms</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'banned']) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all whitespace-nowrap">Banned
                    Sites</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'availability']) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all whitespace-nowrap">Availability</a>

                <a href="{{ route('employees.show', ['employee' => $employee->id, 'tab' => 'devices']) }}"
                    class="pb-4 border-b-2 border-transparent text-slate-400 hover:text-white transition-all whitespace-nowrap">Devices</a>

                <a href="#" class="pb-4 border-b-4 border-blue-500 text-white whitespace-nowrap">Edit Profile</a>
            </div>
        </div>


        <div class="flex flex-col lg:flex-row gap-6">
            <!-- Sidebar Navigation -->
            <div class="w-full lg:w-72 flex-shrink-0">
                <div class="bg-[#1e293b] border border-slate-700 rounded-3xl shadow-xl overflow-hidden sticky top-6">
                    <div class="px-6 py-5 bg-slate-800/50 border-b border-slate-700">
                        <span class="text-[11px] font-bold uppercase text-slate-400 tracking-widest leading-none">Settings
                            Menu</span>
                    </div>
                    <nav class="flex flex-col p-3 space-y-1">
                        <button @click="activeTab = 'general'"
                            :class="activeTab === 'general' ? 'bg-blue-600 text-white shadow-lg' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                            class="px-5 py-3.5 text-left text-xs font-bold rounded-2xl transition-all flex items-center gap-3">
                            <span class="w-1.5 h-1.5 rounded-full"
                                :class="activeTab === 'general' ? 'bg-white' : 'bg-slate-600'"></span>
                            General Information
                        </button>
                        <button @click="activeTab = 'address'"
                            :class="activeTab === 'address' ? 'bg-blue-600 text-white shadow-lg' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                            class="px-5 py-3.5 text-left text-xs font-bold rounded-2xl transition-all flex items-center gap-3">
                            <span class="w-1.5 h-1.5 rounded-full"
                                :class="activeTab === 'address' ? 'bg-white' : 'bg-slate-600'"></span>
                            Address Details
                        </button>
                        <button @click="activeTab = 'licence'"
                            :class="activeTab === 'licence' ? 'bg-blue-600 text-white shadow-lg' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                            class="px-5 py-3.5 text-left text-xs font-bold rounded-2xl transition-all flex items-center gap-3">
                            <span class="w-1.5 h-1.5 rounded-full"
                                :class="activeTab === 'licence' ? 'bg-white' : 'bg-slate-600'"></span>
                            Licence Details
                        </button>
                        <button @click="activeTab = 'other'"
                            :class="activeTab === 'other' ? 'bg-blue-600 text-white shadow-lg' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                            class="px-5 py-3.5 text-left text-xs font-bold rounded-2xl transition-all flex items-center gap-3">
                            <span class="w-1.5 h-1.5 rounded-full"
                                :class="activeTab === 'other' ? 'bg-white' : 'bg-slate-600'"></span>
                            Work Fields
                        </button>
                        <button @click="activeTab = 'skills'"
                            :class="activeTab === 'skills' ? 'bg-blue-600 text-white shadow-lg' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                            class="px-5 py-3.5 text-left text-xs font-bold rounded-2xl transition-all flex items-center gap-3">
                            <span class="w-1.5 h-1.5 rounded-full"
                                :class="activeTab === 'skills' ? 'bg-white' : 'bg-slate-600'"></span>
                            Skills & Attributes
                        </button>
                        <button @click="activeTab = 'password'"
                            :class="activeTab === 'password' ? 'bg-blue-600 text-white shadow-lg' : 'text-slate-400 hover:bg-slate-800 hover:text-white'"
                            class="px-5 py-3.5 text-left text-xs font-bold rounded-2xl transition-all flex items-center gap-3">
                            <span class="w-1.5 h-1.5 rounded-full"
                                :class="activeTab === 'password' ? 'bg-white' : 'bg-slate-600'"></span>
                            Authentication
                        </button>
                    </nav>

                    <div class="px-6 py-4 bg-slate-800/80 border-t border-slate-700">
                        <span class="text-[10px] font-bold uppercase text-slate-500 tracking-widest">Form Status</span>
                        <div class="mt-4 space-y-3">
                            <div class="flex items-center justify-between text-[11px]"
                                :class="isComplete('first_name') ? 'text-blue-400' : 'text-slate-500'">
                                <span>Core Info</span>
                                <svg x-show="isComplete('first_name')" class="w-3.5 h-3.5" fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                        clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="flex items-center justify-between text-[11px]"
                                :class="isComplete('profile_picture') ? 'text-blue-400' : 'text-slate-500'">
                                <span>Assets Uploaded</span>
                                <svg x-show="isComplete('profile_picture')" class="w-3.5 h-3.5" fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                        clip-rule="evenodd"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Required Fields -->
            <div class="bg-white border border-gray-200 rounded shadow-sm overflow-hidden mt-6 sticky top-6">
                <div class="px-4 py-3 bg-gray-50 border-b border-gray-200">
                    <span class="text-[10px] font-bold uppercase text-gray-400 tracking-widest leading-none">Required
                        Fields</span>
                </div>
                <div class="p-4 space-y-3">
                    <template
                        x-for="(label, field) in {
                                                                                                                                first_name: 'First Name',
                                                                                                                                gender: 'Gender',
                                                                                                                                email: 'Email-ID',
                                                                                                                                job_role_id: 'Job Role',
                                                                                                                                phone_number: 'Phone Number',
                                                                                                                                licence_province_name: 'Licence Province',
                                                                                                                                license_number: 'License Number',
                                                                                                                                license_expiry: 'License Expiry',
                                                                                                                                file_license: 'License File',
                                                                                                                                file_contract: 'Contract File'
                                                                                                                            }">
                        <div class="flex items-center justify-between text-xs transition-colors duration-200"
                            :class="isComplete(field) ? 'text-green-600 font-medium' : 'text-gray-500'">
                            <span x-text="label"></span>
                            <div x-show="isComplete(field)"
                                class="w-4 h-4 rounded-full bg-green-500 flex items-center justify-center"
                                x-transition.scale.origin.center>
                                <svg class="w-2.5 h-2.5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                        d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <span x-show="!isComplete(field)"
                                class="w-3 h-3 block rounded-full border border-gray-300"></span>
                        </div>
                    </template>
                    <!-- Special case for file_id -->
                    <div class="flex items-center justify-between text-xs transition-colors duration-200"
                        :class="isComplete('file_id') ? 'text-green-600 font-medium' : 'text-gray-500'">
                        <span>ID File</span>
                        <div x-show="isComplete('file_id')"
                            class="w-4 h-4 rounded-full bg-green-500 flex items-center justify-center"
                            x-transition.scale.origin.center>
                            <svg class="w-2.5 h-2.5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                            </svg>
                        </div>
                        <span x-show="!isComplete('file_id')"
                            class="w-3 h-3 block rounded-full border border-gray-300"></span>
                    </div>

                    <!-- Wage Rates -->
                    <template x-for="item in selectedWageTypes" :key="item.id">
                        <div class="flex items-center justify-between text-xs transition-colors duration-200"
                            :class="isRateComplete(item.id) ? 'text-green-600 font-medium' : 'text-gray-500'">
                            <span x-text="item.name + ' Rate'"></span>
                            <div x-show="isRateComplete(item.id)"
                                class="w-4 h-4 rounded-full bg-green-500 flex items-center justify-center"
                                x-transition.scale.origin.center>
                                <svg class="w-2.5 h-2.5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                        d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <span x-show="!isRateComplete(item.id)"
                                class="w-3 h-3 block rounded-full border border-gray-300"></span>
                        </div>
                    </template>
                </div>
            </div>

            <!-- Main Form Area -->
            <div class="flex-1">
                <div x-show="activeTab !== 'password'"
                    class="bg-white border border-gray-100 rounded-3xl shadow-xl p-10 min-h-[600px]">
                    @if ($errors->any())
                        <div
                            class="mb-8 p-4 bg-red-50 border border-red-100 text-red-700 rounded-2xl shadow-sm animate-fade-in-down">
                            <div class="flex items-center gap-3 mb-2">
                                <div
                                    class="w-6 h-6 bg-red-500 rounded-full flex items-center justify-center text-white shrink-0">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                            d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </div>
                                <p class="text-xs font-bold uppercase tracking-wider">Please fix the following errors:</p>
                            </div>
                            <ul class="list-disc list-inside text-xs space-y-1 ml-9">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form id="employee-form" action="{{ route('employees.update', $employee->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <!-- General Information Tab -->
                        <div x-show="activeTab === 'general'" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Employee
                                        ID</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0c0 .884-.2 1.41-.5 2" />
                                            </svg>
                                        </div>
                                        <input type="text" name="employee_id" value="{{ $employee->employee_id }}" readonly
                                            class="w-full text-sm border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-2.5 px-4 pl-10 bg-gray-100 text-gray-500 cursor-not-allowed uppercase">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">First Name
                                        <span class="text-red-500">*</span></label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="first_name" required x-model="formData.first_name"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Middle
                                        Name</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="middle_name" x-model="formData.middle_name"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Last
                                        Name</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="last_name" x-model="formData.last_name"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Gender <span
                                            class="text-red-500">*</span></label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                                            </svg>
                                        </div>
                                        <select name="gender" required x-model="formData.gender"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            <option value="">Select Gender</option>
                                            <option value="Male" {{ $employee->gender == 'Male' ? 'selected' : '' }}>Male
                                            </option>
                                            <option value="Female" {{ $employee->gender == 'Female' ? 'selected' : '' }}>
                                                Female</option>
                                            <option value="Other" {{ $employee->gender == 'Other' ? 'selected' : '' }}>
                                                Other
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label
                                        class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Car
                                        Available</label>
                                    <div class="flex items-center gap-4 py-3">
                                        <label class="relative inline-flex items-center cursor-pointer group">
                                            <input type="checkbox" name="has_car" x-model="formData.has_car" value="1"
                                                class="sr-only peer">
                                            <div
                                                class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600">
                                            </div>
                                            <span
                                                class="ml-3 text-xs font-bold text-slate-600 group-hover:text-slate-900 transition-colors"
                                                x-text="formData.has_car ? 'Yes, car available' : 'No car available'"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Profile Picture</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                        <input type="file" name="profile_picture" @change="handlePhotoChange($event)"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                        <template x-if="profilePictureUrl">
                                            <div class="mt-2 flex items-center gap-2">
                                                <img :src="profilePictureUrl"
                                                    class="w-10 h-10 rounded-full object-cover border border-gray-200">
                                            </div>
                                        </template>
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Email-ID <span
                                            class="text-red-500">*</span></label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207" />
                                            </svg>
                                        </div>
                                        <input type="email" name="email" required x-model="formData.email"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Date of
                                        Birth</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2-2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                        <input type="date" name="dob"
                                            value="{{ $employee->dob ? \Carbon\Carbon::parse($employee->dob)->format('Y-m-d') : '' }}"
                                            x-model="formData.dob"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Marital
                                        Status</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                                            </svg>
                                        </div>
                                        <select name="marital_status"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                            <option value="">Select Status</option>
                                            <option value="Single" {{ $employee->marital_status == 'Single' ? 'selected' : '' }}>
                                                Single</option>
                                            <option value="Married" {{ $employee->marital_status == 'Married' ? 'selected' : '' }}>
                                                Married</option>
                                            <option value="Divorced" {{ $employee->marital_status == 'Divorced' ? 'selected' : '' }}>
                                                Divorced</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Job Role (Searchable Select) -->
                                <div class="flex flex-col relative"
                                    x-data="{ open: false, search: '', selected: '', value: '{{ $employee->job_role_id }}' }"
                                    x-init="selected = {{ json_encode($employee->jobRole ? $employee->jobRole->name : 'Select Job Role') }};">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Job Role <span
                                            class="text-red-500">*</span></label>
                                    <input type="hidden" name="job_role_id" :value="value" x-model="formData.job_role_id">
                                    <button type="button" @click="open = !open" @click.outside="open = false"
                                        class="w-full text-sm border-slate-400 focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm flex justify-between items-center rounded-md">
                                        <span x-text="selected" :class="value ? 'text-gray-900' : 'text-gray-500'"></span>
                                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </button>
                                    <div x-show="open"
                                        class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                        x-cloak>
                                        <div class="p-2 border-b border-gray-100">
                                            <input type="text" x-model="search" placeholder="Search..."
                                                class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                        </div>
                                        <ul class="overflow-y-auto flex-1">
                                            @foreach($jobRoles as $role)
                                                <li x-show="'{{ strtolower($role->name) }}'.includes(search.toLowerCase())"
                                                    @click="selected = '{{ $role->name }}'; value = '{{ $role->id }}'; formData.job_role_id = '{{ $role->id }}'; open = false; search = ''"
                                                    class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                    {{ $role->name }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>

                                <!-- Department (Searchable Select) -->
                                <div class="flex flex-col relative"
                                    x-data="{ open: false, search: '', selected: '', value: '{{ $employee->department_id }}' }"
                                    x-init="selected = {{ json_encode($employee->department ? $employee->department->name : 'Select Department') }};">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Department</label>
                                    <input type="hidden" name="department_id" :value="value">
                                    <button type="button" @click="open = !open" @click.outside="open = false"
                                        class="w-full text-sm border-slate-400 focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm flex justify-between items-center rounded-md">
                                        <span x-text="selected" :class="value ? 'text-gray-900' : 'text-gray-500'"></span>
                                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </button>
                                    <div x-show="open"
                                        class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                        x-cloak>
                                        <div class="p-2 border-b border-gray-100">
                                            <input type="text" x-model="search" placeholder="Search..."
                                                class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                        </div>
                                        <ul class="overflow-y-auto flex-1">
                                            @foreach($departments as $dept)
                                                <li x-show="'{{ strtolower($dept->name) }}'.includes(search.toLowerCase())"
                                                    @click="selected = '{{ $dept->name }}'; value = '{{ $dept->id }}'; formData.department_id = '{{ $dept->id }}'; open = false; search = ''"
                                                    class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                    {{ $dept->name }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>

                                <!-- Wage Type (Multi-select) -->
                                <div class="flex flex-col relative" x-data="{ open: false, search: ''}">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Wage
                                        Type</label>
                                    <!-- Hidden input to store values -->
                                    <template x-for="item in selectedWageTypes">
                                        <input type="hidden" name="wage_types[]" :value="item.id">
                                    </template>

                                    <button type="button" @click="open = !open" @click.outside="open = false"
                                        class="w-full text-sm border border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-2 px-3 bg-white text-left flex justify-between items-center min-h-[38px] relative">
                                        <span x-show="selectedWageTypes.length === 0" class="text-gray-400">Select Wage
                                            Types</span>
                                        <div x-show="selectedWageTypes.length > 0" class="flex flex-wrap gap-1">
                                            <template x-for="item in selectedWageTypes" :key="item.id">
                                                <span
                                                    class="bg-blue-100 text-blue-700 px-2 py-0.5 rounded text-[10px] flex items-center gap-1">
                                                    <span x-text="item.name"></span>
                                                    <span
                                                        @click.stop="selectedWageTypes = selectedWageTypes.filter(i => i.id !== item.id); delete formData.wage_rates[item.id]"
                                                        class="cursor-pointer hover:text-blue-900">&times;</span>
                                                </span>
                                            </template>
                                        </div>
                                        <svg class="w-4 h-4 text-gray-400 ml-2" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </button>

                                    <div x-show="open"
                                        class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                        x-cloak>
                                        <div class="p-2 border-b border-gray-100">
                                            <input type="text" x-model="search" placeholder="Search..."
                                                class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                        </div>
                                        <ul class="overflow-y-auto flex-1">
                                            @foreach($wageTypes as $type)
                                                <li x-show="'{{ strtolower($type->name) }}'.includes(search.toLowerCase()) && !selectedWageTypes.some(s => s.id === {{ $type->id }})"
                                                    @click="selectedWageTypes.push({id: {{ $type->id }}, name: '{{ $type->name }}'})"
                                                    class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                    {{ $type->name }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>

                                <!-- Dynamic Wage Rates -->
                                <template x-for="item in selectedWageTypes" :key="item.id">
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2"
                                            x-text="item.name + ' Rate'"></label>
                                        <div class="relative">
                                            <input type="number" step="0.01" :name="'wage_rates[' + item.id + ']'" required
                                                x-model="formData.wage_rates[item.id]"
                                                class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                        </div>
                                    </div>
                                </template>

                                <!-- Zone (Searchable Select) -->
                                <div class="flex flex-col relative"
                                    x-data="{ open: false, search: '', selected: '', value: '{{ $employee->zone_id }}' }"
                                    x-init="selected = {{ json_encode($employee->zone ? $employee->zone->name : 'Select Zone') }};">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Zone</label>
                                    <input type="hidden" name="zone_id" :value="value">
                                    <button type="button" @click="open = !open" @click.outside="open = false"
                                        class="w-full text-sm border-slate-400 focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm flex justify-between items-center rounded-md">
                                        <span x-text="selected" :class="value ? 'text-gray-900' : 'text-gray-500'"></span>
                                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </button>
                                    <div x-show="open"
                                        class="absolute top-full left-0 w-full mt-1 bg-white border border-gray-200 rounded-md shadow-lg z-50 max-h-60 overflow-hidden flex flex-col"
                                        x-cloak>
                                        <div class="p-2 border-b border-gray-100">
                                            <input type="text" x-model="search" placeholder="Search..."
                                                class="w-full text-xs border border-gray-200 rounded px-2 py-1.5 focus:outline-none focus:border-blue-500">
                                        </div>
                                        <ul class="overflow-y-auto flex-1">
                                            @foreach($zones as $zone)
                                                <li x-show="'{{ strtolower($zone->name) }}'.includes(search.toLowerCase())"
                                                    @click="selected = '{{ $zone->name }}'; value = '{{ $zone->id }}'; formData.zone_id = '{{ $zone->id }}'; open = false; search = ''"
                                                    class="px-4 py-2 hover:bg-blue-50 hover:text-blue-600 text-sm cursor-pointer text-gray-700">
                                                    {{ $zone->name }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Address Tab -->
                        <div x-show="activeTab === 'address'" class="space-y-8" x-cloak>
                            <!-- Permanent Address -->
                            <div class="bg-slate-50 p-6 rounded-lg border border-slate-200">
                                <h3
                                    class="text-xs font-bold text-slate-400 uppercase tracking-widest mb-6 flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                    </svg>
                                    Permanent Address
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6">
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Street 1</label>
                                        <input type="text" name="perm_address_1" x-model="formData.perm_address_1"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Street 2</label>
                                        <input type="text" name="perm_address_2" x-model="formData.perm_address_2"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">City</label>
                                        <input type="text" name="perm_city" x-model="formData.perm_city"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Zip Code</label>
                                        <input type="text" name="perm_zip" x-model="formData.perm_zip"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">State/Province</label>
                                        <select name="perm_state_id" x-model="formData.perm_state_id"
                                            :disabled="!formData.perm_country_id"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm disabled:opacity-50">
                                            <option value="">Select State</option>
                                            <template x-for="state in permStates" :key="state.id">
                                                <option :value="state.id" x-text="state.name"
                                                    :selected="state.id == formData.perm_state_id"></option>
                                            </template>
                                        </select>
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Country</label>
                                        <select name="perm_country_id" x-model="formData.perm_country_id"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                            <option value="">Select Country</option>
                                            @foreach($countries as $co)
                                                <option value="{{ $co->id }}">{{ $co->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Same as Permanent Checkbox -->
                            <div class="px-6">
                                <label class="flex items-center gap-3 cursor-pointer group">
                                    <input type="checkbox" x-model="sameAsPermanent"
                                        class="w-5 h-5 rounded border-slate-300 text-blue-600 focus:ring-blue-500 transition-all">
                                    <span
                                        class="text-sm font-semibold text-slate-600 group-hover:text-slate-900 transition-colors">Same
                                        as Permanent Address</span>
                                </label>
                            </div>

                            <!-- Corresponding Address -->
                            <div class="bg-indigo-50/30 p-6 rounded-lg border border-indigo-100"
                                :class="{'opacity-60 grayscale-[0.5]': sameAsPermanent}">
                                <h3
                                    class="text-xs font-bold text-indigo-400 uppercase tracking-widest mb-6 flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                    Corresponding Address
                                </h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-6">
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Street 1</label>
                                        <input type="text" name="cors_address_1" x-model="formData.cors_address_1"
                                            :readonly="sameAsPermanent"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Street 2</label>
                                        <input type="text" name="cors_address_2" x-model="formData.cors_address_2"
                                            :readonly="sameAsPermanent"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">City</label>
                                        <input type="text" name="cors_city" x-model="formData.cors_city"
                                            :readonly="sameAsPermanent"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Zip Code</label>
                                        <input type="text" name="cors_zip" x-model="formData.cors_zip"
                                            :readonly="sameAsPermanent"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">State/Province</label>
                                        <select name="cors_state_id" x-model="formData.cors_state_id"
                                            :disabled="sameAsPermanent || !formData.cors_country_id"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm disabled:opacity-50">
                                            <option value="">Select State</option>
                                            <template x-for="state in corsStates" :key="state.id">
                                                <option :value="state.id" x-text="state.name"
                                                    :selected="state.id == formData.cors_state_id"></option>
                                            </template>
                                        </select>
                                    </div>
                                    <div class="flex flex-col">
                                        <label class="text-sm font-bold text-slate-700 mb-2">Country</label>
                                        <select name="cors_country_id" x-model="formData.cors_country_id"
                                            :disabled="sameAsPermanent"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                            <option value="">Select Country</option>
                                            @foreach($countries as $co)
                                                <option value="{{ $co->id }}">{{ $co->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Licence Tab -->
                        <div x-show="activeTab === 'licence'" class="space-y-6" x-cloak>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                <!-- Phone Number -->
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Phone Number
                                        <span class="text-red-500">*</span></label>
                                    <input type="text" name="phone_number" required x-model="formData.phone_number"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Cell
                                        Number</label>
                                    <input type="text" name="cell_number" x-model="formData.cell_number"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>

                                <!-- Licence Province -->
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Licence
                                        Issuing Province</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-4 w-4 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="licence_province_name"
                                            x-model="formData.licence_province_name"
                                            class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 pl-10 bg-white transition-all shadow-sm">
                                    </div>
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">License Number
                                        <span class="text-red-500">*</span></label>
                                    <input type="text" name="license_number" required x-model="formData.license_number"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">License Expiry
                                        <span class="text-red-500">*</span></label>
                                    <input type="date" name="license_expiry" required x-model="formData.license_expiry"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Emergency
                                        Number</label>
                                    <input type="text" name="emergency_number" value="{{ $employee->emergency_number }}"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">License
                                        File</label>
                                    <input type="file" name="file_license"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    @if($employee->file_license)
                                        <a href="{{ asset('storage/' . $employee->file_license) }}" target="_blank"
                                            class="text-[10px] text-blue-600 hover:underline mt-1 block">Current:
                                            {{ basename($employee->file_license) }}</a>
                                    @endif
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Employment
                                        Contract</label>
                                    <input type="file" name="file_contract"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                    @if($employee->file_contract)
                                        <a href="{{ asset('storage/' . $employee->file_contract) }}" target="_blank"
                                            class="text-[10px] text-blue-600 hover:underline mt-1 block">Current:
                                            {{ basename($employee->file_contract) }}</a>
                                    @endif
                                </div>

                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Identification
                                        Files
                                        (Multiple)</label>
                                    <input type="file" name="file_id[]" multiple
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                            </div>
                        </div>

                        <!-- Other Tab -->
                        <div x-show="activeTab === 'other'" class="space-y-6" x-cloak>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-4">
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Hiring
                                        Date</label>
                                    <input type="date" name="hiring_date" x-model="formData.hiring_date"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Termination
                                        Date</label>
                                    <input type="date" name="termination_date" x-model="formData.termination_date"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Reporting
                                        Manager</label>
                                    <input type="text" name="reporting_manager" value="{{ $employee->reporting_manager }}"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">SIN
                                        Number</label>
                                    <input type="text" name="sin_number" value="{{ $employee->sin_number }}"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Fax</label>
                                    <input type="text" name="fax" value="{{ $employee->fax }}"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Tags</label>
                                    <input type="text" name="tags" value="{{ $employee->tags }}"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">
                                </div>



                                <div class="col-span-1 md:col-span-2 flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Additional
                                        Remarks</label>
                                    <textarea name="additional_remarks" rows="3"
                                        class="w-full text-sm border-slate-400 rounded-md focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-2.5 px-4 bg-white transition-all shadow-sm">{{ $employee->additional_remarks }}</textarea>
                                </div>

                                <!-- Direct Deposit Form -->
                                <div class="flex flex-col">
                                    <label class="text-sm font-bold text-slate-700 mb-2">Direct Deposit Form</label>
                                    <div class="flex items-center gap-2">
                                        <div
                                            class="flex-1 border border-gray-300 rounded bg-gray-50 px-3 py-1.5 text-sm text-gray-500">
                                            <input type="file" name="file_direct_deposit"
                                                class="w-full text-xs text-slate-500
                                                                                                                    file:mr-4 file:py-1 file:px-2
                                                                                                                    file:rounded-full file:border-0
                                                                                                                    file:text-xs file:font-semibold
                                                                                                                    file:bg-blue-50 file:text-blue-700
                                                                                                                    hover:file:bg-blue-100">
                                        </div>
                                    </div>
                                    @if($employee->file_direct_deposit)
                                        <a href="{{ asset('storage/' . $employee->file_direct_deposit) }}" target="_blank"
                                            class="text-[10px] text-blue-600 hover:underline mt-1 block">Current:
                                            {{ basename($employee->file_direct_deposit) }}</a>
                                    @endif
                                </div>

                                <!-- Experience Details Section -->
                                <div class="col-span-1 md:col-span-2 border-t border-gray-200 mt-4 pt-4"
                                    x-data='{ experiences: {!! json_encode($experiencesData) !!} }'>
                                    <div class="flex items-center justify-between mb-4">
                                        <label class="text-sm font-bold text-gray-700">Enter Experience Details (If
                                            any)</label>
                                        <button type="button" @click="experiences.push({id: 'new_' + Date.now()})"
                                            class="text-xs bg-blue-50 text-blue-600 px-3 py-1 rounded font-medium hover:bg-blue-100 transition-colors">
                                            + Add Record
                                        </button>
                                    </div>

                                    <template x-for="(exp, index) in experiences" :key="exp.id">
                                        <div class="bg-gray-50 border border-gray-200 rounded p-4 mb-4 relative group">
                                            <button type="button"
                                                @click="experiences = experiences.filter(e => e.id !== exp.id)"
                                                class="absolute top-2 right-2 text-gray-400 hover:text-red-500"
                                                x-show="experiences.length > 1">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                            </button>
                                            <input type="hidden" :name="`experience[${index}][id]`" x-model="exp.id">
                                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                                <div class="flex flex-col">
                                                    <label class="text-[10px] font-medium text-gray-500 uppercase">Company
                                                        Name</label>
                                                    <div class="relative">
                                                        <div
                                                            class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                            <svg class="h-3 w-3 text-gray-400"
                                                                xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                                            </svg>
                                                        </div>
                                                        <input type="text" :name="`experience[${index}][company]`"
                                                            x-model="exp.company"
                                                            class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                    </div>
                                                </div>
                                                <div class="flex flex-col">
                                                    <label class="text-[10px] font-medium text-gray-500 uppercase">Document
                                                        Proof</label>
                                                    <input type="file" :name="`experience[${index}][proof]`"
                                                        class="w-full text-xs text-gray-500 file:mr-2 file:py-0.5 file:px-2 file:rounded-full file:border-0 file:text-[10px] file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                                </div>
                                                <div class="flex flex-col">
                                                    <label class="text-[10px] font-medium text-gray-500 uppercase">Start
                                                        Date</label>
                                                    <div class="relative">
                                                        <div
                                                            class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                            <svg class="h-3 w-3 text-gray-400"
                                                                xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                            </svg>
                                                        </div>
                                                        <input type="date" :name="`experience[${index}][start_date]`"
                                                            x-model="exp.start_date"
                                                            class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                    </div>
                                                </div>
                                                <div class="flex flex-col">
                                                    <label class="text-[10px] font-medium text-gray-500 uppercase">End
                                                        Date</label>
                                                    <div class="relative">
                                                        <div
                                                            class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                            <svg class="h-3 w-3 text-gray-400"
                                                                xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                            </svg>
                                                        </div>
                                                        <input type="date" :name="`experience[${index}][end_date]`"
                                                            x-model="exp.end_date"
                                                            class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                    </div>
                                                </div>
                                                <div class="flex flex-col col-span-1 md:col-span-2">
                                                    <label class="text-[10px] font-medium text-gray-500 uppercase">Reason
                                                        for Leaving</label>
                                                    <div class="relative">
                                                        <div
                                                            class="absolute inset-y-0 left-0 pl-2 flex items-center pointer-events-none">
                                                            <svg class="h-3 w-3 text-gray-400"
                                                                xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke="currentColor">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                            </svg>
                                                        </div>
                                                        <input type="text" :name="`experience[${index}][reason]`"
                                                            x-model="exp.reason"
                                                            class="w-full text-xs border-gray-300 rounded focus:ring-blue-500 focus:border-blue-500 py-1 pl-7 px-2">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>

                        <!-- Skills & Attributes Tab -->
                        <div x-show="activeTab === 'skills'" class="space-y-6" x-cloak>
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                @forelse($skills as $skill)
                                    <div
                                        class="flex items-center gap-3 p-4 border border-gray-100 rounded hover:bg-gray-50 transition-colors">
                                        <input type="checkbox" name="skills[]" value="{{ $skill->id }}"
                                            id="skill_{{ $skill->id }}" {{ $employee->skills->contains($skill->id) ? 'checked' : '' }} class="rounded text-blue-600 focus:ring-blue-500 w-4 h-4">
                                        <label for="skill_{{ $skill->id }}"
                                            class="text-xs font-medium text-gray-700 cursor-pointer flex-1">
                                            {{ $skill->name }}
                                            @if ($skill->category)
                                                <span
                                                    class="block text-[10px] text-gray-400 font-normal">{{ $skill->category }}</span>
                                            @endif
                                        </label>
                                    </div>
                                @empty
                                    <div class="col-span-full text-center py-12">
                                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24"
                                            stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                d="M13 10V3L4 14h7v7l9-11h-7z" />
                                        </svg>
                                        <h3 class="mt-2 text-sm font-medium text-gray-900">No skills found</h3>
                                        <p class="mt-1 text-sm text-gray-500">Skills added in admin panel will appear here.
                                        </p>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                    </form>
                </div>
                <!-- Password Tab -->
                <div x-show="activeTab === 'password'" class="invisible" :class="{ 'invisible': false }" x-cloak>
                    <div class="bg-white border border-gray-100 rounded-3xl shadow-xl p-10 min-h-[600px]">
                        <div class="flex items-center gap-2 mb-8">
                            <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                            <h2 class="text-lg font-bold text-gray-900">Change Password</h2>
                        </div>

                        <form action="{{ route('employees.change_password', $employee->id) }}" method="POST"
                            class="max-w-md">
                            @csrf
                            @method('PUT')
                            <div class="flex flex-col gap-6">
                                <div>
                                    <label
                                        class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">New
                                        Password</label>
                                    <div class="flex gap-2">
                                        <input type="text" name="password" x-model="passwordForm.password"
                                            @input="checkStrength" required minlength="8"
                                            class="w-full text-sm border-slate-400 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 py-3 px-4 bg-gray-50 transition-all">
                                        <button type="button" @click="generatePassword"
                                            class="px-4 py-2 border border-slate-200 text-xs font-bold rounded-xl text-slate-600 bg-white hover:bg-slate-50 transition-all">
                                            Generate
                                        </button>
                                    </div>
                                    <!-- Strength Indicator -->
                                    <div class="mt-4">
                                        <div class="flex items-center justify-between text-[10px] mb-2">
                                            <span class="font-bold uppercase tracking-widest text-slate-400">Strength</span>
                                            <span class="font-bold uppercase tracking-widest"
                                                :class="{
                                                                                                                                                                    'text-red-500': passwordForm.strength <= 1,
                                                                                                                                                                    'text-yellow-500': passwordForm.strength == 2,
                                                                                                                                                                    'text-blue-500': passwordForm.strength == 3,
                                                                                                                                                                    'text-green-500': passwordForm.strength >= 4
                                                                                                                                                                }"
                                                x-text="['Very Weak', 'Weak', 'Good', 'Strong', 'Very Strong'][passwordForm.strength]"></span>
                                        </div>
                                        <div class="w-full bg-slate-100 rounded-full h-1.5">
                                            <div class="h-1.5 rounded-full transition-all duration-300"
                                                :class="{
                                                                                                                                                                    'bg-red-500': passwordForm.strength <= 1,
                                                                                                                                                                    'bg-yellow-500': passwordForm.strength == 2,
                                                                                                                                                                    'bg-blue-500': passwordForm.strength == 3,
                                                                                                                                                                    'bg-green-500': passwordForm.strength >= 4
                                                                                                                                                                }"
                                                :style="'width: ' + Math.max(5, (passwordForm.strength / 4) * 100) + '%'">
                                            </div>
                                        </div>
                                        <p class="text-[10px] text-slate-400 mt-2">At least 8 characters, including Case,
                                            Number and Symbol.</p>
                                    </div>
                                </div>
                                <div class="pt-4">
                                    <button type="submit"
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-8 py-3 rounded-xl text-xs font-bold uppercase tracking-wider transition-all shadow-md">
                                        Update Authentication
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Unified Form Actions (Sticky Footer) -->
                <div
                    class="mt-8 flex items-center justify-between bg-white border border-slate-200 rounded-2xl p-4 sticky bottom-6 shadow-xl z-20">
                    <div class="flex items-center gap-4">
                        <a href="{{ route('employees.index') }}"
                            class="px-6 py-2.5 rounded-xl border border-slate-200 text-slate-600 font-bold text-xs hover:bg-slate-50 transition-all">Cancel</a>
                    </div>
                    <div class="flex items-center gap-4">
                        <button type="submit" form="employee-form" x-show="activeTab !== 'password'"
                            class="bg-blue-600 hover:bg-blue-700 text-white px-10 py-3 rounded-xl text-xs font-bold uppercase tracking-wider transition-all shadow-lg shadow-blue-200 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                    d="M5 13l4 4L19 7" />
                            </svg>
                            Save Employee Changes
                        </button>
                    </div>
                </div>
            </div>
        </div>


        <script>
            function employeeEdit() {
                return {
                    activeTab: "general",
                    showPasswordModal: false,
                    passwordForm: {
                        password: "",
                        strength: 0
                    },
                    generatePassword() {
                        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*";
                        let pass = "";
                        for (let i = 0; i < 16; i++) pass += chars.charAt(Math.floor(Math.random() * chars.length));
                        this.passwordForm.password = pass;
                        this.checkStrength();
                    },
                    checkStrength() {
                        let p = this.passwordForm.password;
                        let s = 0;
                        if (p.length >= 8) s++;
                        if (p.match(/[A-Z]/)) s++;
                        if (p.match(/[0-9]/)) s++;
                        if (p.match(/[^A-Za-z0-9]/)) s++;
                        this.passwordForm.strength = s;
                    },
                    permStates: [],
                    corsStates: [],
                    sameAsPermanent: false,
                    async fetchPermStates(isInitial = false) {
                        if (!this.formData.perm_country_id) {
                            this.permStates = [];
                            return;
                        }
                        const response = await fetch(`/api/countries/${this.formData.perm_country_id}/states`);
                        this.permStates = await response.json();
                        if (!isInitial && !this.sameAsPermanent) {
                            this.formData.perm_state_id = '';
                        }
                    },
                    async fetchCorsStates(isInitial = false) {
                        if (this.sameAsPermanent) return;
                        if (!this.formData.cors_country_id) {
                            this.corsStates = [];
                            return;
                        }
                        const response = await fetch(`/api/countries/${this.formData.cors_country_id}/states`);
                        this.corsStates = await response.json();
                        if (!isInitial) {
                            this.formData.cors_state_id = '';
                        }
                    },
                    sync() {
                        if (this.sameAsPermanent) {
                            this.formData.cors_address_1 = this.formData.perm_address_1;
                            this.formData.cors_address_2 = this.formData.perm_address_2;
                            this.formData.cors_city = this.formData.perm_city;
                            this.formData.cors_zip = this.formData.perm_zip;
                            this.formData.cors_country_id = this.formData.perm_country_id;
                            this.formData.cors_state_id = this.formData.perm_state_id;
                            this.corsStates = [...this.permStates];
                        }
                    },
                    init() {
                        if (window.location.hash === "#password") {
                            this.activeTab = "password";
                        }

                        this.fetchPermStates(true);
                        this.fetchCorsStates(true);

                        this.$watch('sameAsPermanent', value => {
                            if (value) this.sync();
                        });

                        this.$watch('formData.perm_country_id', () => {
                            this.fetchPermStates().then(() => {
                                if (this.sameAsPermanent) this.sync();
                            });
                        });

                        this.$watch('formData.cors_country_id', () => {
                            if (!this.sameAsPermanent) this.fetchCorsStates();
                        });

                        this.$watch('formData.perm_address_1', () => {
                            if (this.sameAsPermanent) this.sync();
                        });
                        this.$watch('formData.perm_address_2', () => {
                            if (this.sameAsPermanent) this.sync();
                        });
                        this.$watch('formData.perm_city', () => {
                            if (this.sameAsPermanent) this.sync();
                        });
                        this.$watch('formData.perm_zip', () => {
                            if (this.sameAsPermanent) this.sync();
                        });
                        this.$watch('formData.perm_state_id', () => {
                            if (this.sameAsPermanent) this.sync();
                        });
                    },
                    selectedWageTypes: @json($selectedWageTypesData),
                    formData: @js($initialData),
                    isComplete(field) {
                        return !!this.formData[field];
                    },
                    isRateComplete(id) {
                        return !!this.formData.wage_rates[id];
                    },
                    updateFile(field, event) {
                        this.formData[field] = event.target.files.length > 0;
                    },
                    profilePictureUrl: "{{ $employee->profile_picture ? asset('storage/' . $employee->profile_picture) : '' }}",
                    handlePhotoChange(event) {
                        const file = event.target.files[0];
                        if (file) {
                            // Preview
                            const reader = new FileReader();
                            reader.onload = (e) => {
                                this.profilePictureUrl = e.target.result;
                            };
                            reader.readAsDataURL(file);

                            // Immediate upload
                            const formData = new FormData();
                            formData.append('profile_picture', file);
                            formData.append('_token', '{{ csrf_token() }}');

                            fetch('{{ route('employees.upload_photo', $employee->id) }}', {
                                method: 'POST',
                                body: formData,
                                headers: {
                                    'X-Requested-With': 'XMLHttpRequest'
                                }
                            })
                                .then(response => response.json())
                                .then(data => {
                                    if (data.success) {
                                        // Update URL from server to ensure it's correct
                                        this.profilePictureUrl = data.url;
                                        // Optional: Show a small toast or notification
                                        console.log('Photo updated successfully');
                                    } else {
                                        alert(data.message || 'Upload failed');
                                    }
                                })
                                .catch(error => {
                                    console.error('Error:', error);
                                    alert('An error occurred during upload');
                                });
                        }
                    }
                }
            }
        </script>
        <style>
            [x-cloak] {
                display: none !important;
            }
        </style>
@endsection