@php
    if (!function_exists('sortUrl')) {
        function sortUrl($field)
        {
            $currentSort = request('sort');
            $currentDirection = request('direction', 'desc');
            $newDirection = ($currentSort === $field && $currentDirection === 'asc') ? 'desc' : 'asc';
            return request()->fullUrlWithQuery(['sort' => $field, 'direction' => $newDirection]);
        }
    }

    if (!function_exists('sortIcon')) {
        function sortIcon($field)
        {
            $currentSort = request('sort');
            $currentDirection = request('direction', 'desc');
            if ($currentSort !== $field) {
                return '<svg class="w-3 h-3 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"></path></svg>';
            }
            if ($currentDirection === 'asc') {
                return '<svg class="w-3 h-3 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 15l7-7 7 7"></path></svg>';
            }
            return '<svg class="w-3 h-3 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19 9l-7 7-7-7"></path></svg>';
        }
    }
@endphp
<div class="flex-1 overflow-auto bg-white">
    <table class="min-w-full divide-y divide-gray-200 border-separate border-spacing-0">
        <thead class="bg-[#1e293b] text-white">
            <tr>
                <th scope="col" class="px-2 py-3 text-left border-b border-slate-700 w-8">
                    <input type="checkbox" id="select-all" onclick="toggleSelectAll()"
                        class="rounded border-slate-700 bg-slate-800 text-blue-500 focus:ring-blue-500/20">
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider w-16">
                    <a href="{{ sortUrl('employee_id') }}"
                        class="ajax-sort flex items-center gap-1 hover:text-blue-400 transition-colors">
                        Emp ID
                        {!! sortIcon('employee_id') !!}
                    </a>
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">
                    <a href="{{ sortUrl('first_name') }}"
                        class="ajax-sort flex items-center gap-1 hover:text-blue-400 transition-colors">
                        First Name
                        {!! sortIcon('first_name') !!}
                    </a>
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">
                    <a href="{{ sortUrl('last_name') }}"
                        class="ajax-sort flex items-center gap-1 hover:text-blue-400 transition-colors">
                        Last Name
                        {!! sortIcon('last_name') !!}
                    </a>
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">
                    <a href="{{ sortUrl('department_id') }}"
                        class="ajax-sort flex items-center gap-1 hover:text-blue-400 transition-colors">
                        Department
                        {!! sortIcon('department_id') !!}
                    </a>
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">
                    <a href="{{ sortUrl('job_role_id') }}"
                        class="ajax-sort flex items-center gap-1 hover:text-blue-400 transition-colors">
                        Job Role
                        {!! sortIcon('job_role_id') !!}
                    </a>
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">Wage
                    Types
                </th>
                <th scope="col" class="px-2 py-3 text-center text-[11px] font-bold uppercase tracking-wider">Car
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">Contact
                    Info
                </th>
                <th scope="col" class="px-2 py-3 text-left text-[11px] font-bold uppercase tracking-wider">Status
                </th>
                <th scope="col" class="px-2 py-3 text-right text-[11px] font-bold uppercase tracking-wider">Actions
                </th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-100">
            @forelse($employees as $employee)
                <tr class="hover:bg-gray-50 transition-colors group">
                    <td class="px-2 py-3 whitespace-nowrap">
                        <input type="checkbox" name="employee_ids[]" value="{{ $employee->id }}"
                            data-name="{{ $employee->first_name }} {{ $employee->last_name }}"
                            data-job-role="{{ $employee->job_role_id }}"
                            data-wages="{{ htmlspecialchars($employee->wageTypes->map(fn($w) => ['type_id' => $w->id, 'rate' => $w->pivot->rate, 'name' => $w->name])->toJson()) }}"
                            data-license-number="{{ $employee->license_number }}"
                            data-license-expiry="{{ $employee->license_expiry ? (is_string($employee->license_expiry) ? date('Y-m-d', strtotime($employee->license_expiry)) : $employee->license_expiry->format('Y-m-d')) : '' }}"
                            onchange="updateBulkButton()"
                            class="employee-checkbox rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                    </td>

                    <td class="px-2 py-3 whitespace-nowrap">
                        <span
                            class="bg-blue-50 text-blue-700 px-1.5 py-0.5 rounded text-[11px] font-bold border border-blue-100 shadow-sm">
                            {{ $employee->employee_id }}
                        </span>
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-xs font-bold text-gray-900">
                        <div class="flex flex-col">
                            <span>{{ $employee->first_name }}</span>
                            @if(!$employee->isProfileComplete())
                                <span
                                    class="text-[8px] text-amber-600 font-black uppercase tracking-widest mt-0.5 flex items-center gap-1">
                                    <div class="w-1 h-1 rounded-full bg-amber-500 animate-pulse"></div>
                                    Complete Info
                                </span>
                            @else
                                <span
                                    class="text-[8px] text-emerald-600 font-black uppercase tracking-widest mt-0.5 flex items-center gap-1">
                                    <div class="w-1 h-1 rounded-full bg-emerald-500"></div>
                                    Complete
                                </span>
                            @endif
                        </div>
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-xs font-bold text-gray-900">
                        {{ $employee->last_name }}
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-xs text-gray-500 font-medium">
                        {{ $employee->department ? $employee->department->name : 'N/A' }}
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-xs text-gray-500 font-medium">
                        {{ $employee->jobRole ? $employee->jobRole->name : 'N/A' }}
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap">
                        <div class="flex flex-wrap gap-1">
                            @forelse($employee->wageTypes as $type)
                                <span
                                    class="inline-flex items-center px-1.5 py-0.5 rounded text-[9px] font-bold bg-slate-100 text-slate-600 border border-slate-200 uppercase tracking-tighter">
                                    {{ $type->name }}: ${{ number_format($type->pivot->rate, 2) }}
                                </span>
                            @empty
                                <span class="text-[10px] text-slate-400">N/A</span>
                            @endforelse
                        </div>
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-center">
                        @if($employee->has_car)
                            <div class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-green-50 text-green-600 border border-green-100 shadow-sm"
                                title="Car Available">
                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                            </div>
                        @else
                            <div class="inline-flex items-center justify-center w-6 h-6 rounded-full bg-red-50 text-red-600 border border-red-100 shadow-sm"
                                title="No Car">
                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                        d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </div>
                        @endif
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-xs text-gray-600 font-medium">
                        <div class="flex flex-col gap-1">
                            <div class="flex items-center gap-2" title="{{ $employee->phone_number }}">
                                <div
                                    class="w-5 h-5 bg-gray-50 rounded flex items-center justify-center border border-gray-100 shrink-0">
                                    <svg class="w-3 h-3 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                        </path>
                                    </svg>
                                </div>
                                <span class="truncate max-w-[120px]">{{ $employee->phone_number }}</span>
                            </div>
                            <div class="flex items-center gap-2 group/email">
                                <div
                                    class="w-5 h-5 bg-gray-50 rounded flex items-center justify-center border border-gray-100 shrink-0">
                                    <svg class="w-3 h-3 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                </div>
                                <span class="truncate max-w-[120px]"
                                    title="{{ $employee->email }}">{{ $employee->email }}</span>
                                <button onclick="copyToClipboard('{{ $employee->email }}')"
                                    class="opacity-0 group-hover/email:opacity-100 text-blue-500 hover:text-blue-700 transition-opacity">
                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-center">
                        <button type="button"
                            onclick="toggleEmployeeStatus('{{ route('employees.toggle-status', $employee) }}', this)"
                            class="relative inline-flex h-5 w-9 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 {{ $employee->active ? 'bg-blue-600' : 'bg-gray-200' }}"
                            role="switch" aria-checked="{{ $employee->active ? 'true' : 'false' }}">
                            <span aria-hidden="true"
                                class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $employee->active ? 'translate-x-4' : 'translate-x-0' }}"></span>
                        </button>
                    </td>
                    <td class="px-2 py-3 whitespace-nowrap text-right">
                        <div class="flex items-center justify-end gap-1">
                            <a href="{{ route('employees.analytics', $employee->id) }}"
                                class="p-1.5 text-slate-400 hover:text-indigo-600 hover:bg-indigo-50 rounded-lg transition-all"
                                title="Analytics">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z">
                                    </path>
                                </svg>
                            </a>
                            <a href="{{ route('employees.show', $employee->id) }}"
                                class="p-1.5 text-slate-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                            </a>
                            <a href="{{ route('employees.edit', $employee->id) }}"
                                class="p-1.5 text-slate-400 hover:text-amber-600 hover:bg-amber-50 rounded-lg transition-all">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                </svg>
                            </a>
                        </div>
                    </td>

                </tr>
            @empty
                <tr>
                    <td colspan="11" class="px-6 py-12 text-center text-gray-500 text-xs">
                        No employees found.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

<!-- Pagination -->
@if($employees->hasPages())
    <div class="table-pagination px-4 py-3 border-t border-gray-200 bg-gray-50">
        {{ $employees->links() }}
    </div>
@endif
