@extends('layouts.employee')

@section('title', 'Submit Request')

@section('content')
    <div class="px-4 py-6 max-w-lg mx-auto">
        <div class="mb-6 flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">New Request</h1>
            <a href="{{ route('employee.requests.index') }}"
                class="text-sm font-bold text-gray-500 hover:text-gray-900">Cancel</a>
        </div>

        <form action="{{ route('employee.requests.store') }}" method="POST" class="space-y-6" x-data="{ 
                        type: '', 
                        message: '',
                        templates: {{ json_encode($requestTypes->pluck('template', 'key')) }},
                        updateTemplate() {
                            if (this.templates[this.type]) {
                                this.message = this.templates[this.type];
                            } else {
                                this.message = '';
                            }
                        }
                    }">
            @csrf

            <div>
                <label class="block text-sm font-bold text-gray-700 mb-2">Request Type</label>
                <select name="type" x-model="type" @change="updateTemplate()"
                    class="w-full border-gray-200 rounded-xl py-3 px-4 focus:ring-blue-500 focus:border-blue-500 bg-white shadow-sm appearance-none"
                    required>
                    <option value="">Select Option...</option>
                    @foreach($requestTypes as $type)
                        <option value="{{ $type->key }}">{{ $type->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-bold text-gray-700 mb-2">Subject (Optional)</label>
                <input type="text" name="subject"
                    class="w-full border-gray-200 rounded-xl py-3 px-4 focus:ring-blue-500 focus:border-blue-500 shadow-sm"
                    placeholder="Brief subject line...">
            </div>

            <div>
                <label class="block text-sm font-bold text-gray-700 mb-2">Additional Information / Message</label>
                <textarea name="message" x-model="message" rows="8"
                    class="w-full border-gray-200 rounded-xl py-3 px-4 focus:ring-blue-500 focus:border-blue-500 shadow-sm font-mono text-sm"
                    required placeholder="Please provide detailed information regarding your request..."></textarea>
                <p class="text-xs text-gray-400 mt-2">You can edit the text above to fit your specific situation.</p>
            </div>

            <button type="submit"
                class="w-full bg-blue-600 text-white font-bold py-4 rounded-xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all active:scale-95">
                Submit Request
            </button>
        </form>
    </div>
@endsection