<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Patrol Report - {{ $schedule->duty_number }}</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 12px;
            color: #333;
            line-height: 1.4;
        }

        .header {
            margin-bottom: 20px;
            border-bottom: 2px solid #555;
            padding-bottom: 10px;
        }

        .title {
            font-size: 18px;
            font-weight: bold;
            color: #1a1a1a;
        }

        .subtitle {
            font-size: 14px;
            color: #666;
            margin-top: 5px;
        }

        .meta-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }

        .meta-table th {
            text-align: left;
            width: 15%;
            padding: 4px;
            color: #666;
            font-size: 11px;
        }

        .meta-table td {
            padding: 4px;
            font-weight: bold;
        }

        .section-title {
            font-size: 14px;
            font-weight: bold;
            margin-top: 25px;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
            color: #444;
        }

        .stats-grid {
            width: 100%;
            margin-bottom: 20px;
        }

        .stat-box {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
            background: #f9f9f9;
        }

        .stat-value {
            font-size: 18px;
            font-weight: bold;
            display: block;
            margin-top: 5px;
        }

        .stat-label {
            font-size: 10px;
            text-transform: uppercase;
            color: #666;
        }

        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 11px;
        }

        table.data-table th,
        table.data-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        table.data-table th {
            background-color: #f5f5f5;
            text-transform: uppercase;
            font-size: 10px;
        }

        .ticket-card {
            border: 1px solid #eee;
            padding: 10px;
            margin-bottom: 10px;
            page-break-inside: avoid;
        }

        .ticket-header {
            margin-bottom: 5px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }

        .status-badge {
            font-weight: bold;
            padding: 2px 5px;
            border-radius: 3px;
            font-size: 10px;
            text-transform: uppercase;
        }

        .status-good {
            color: green;
            background: #e6fffa;
        }

        .status-bad {
            color: red;
            background: #fff5f5;
        }

        .image-gallery {
            margin-top: 10px;
        }

        .ticket-image {
            width: 100px;
            height: 100px;
            object-fit: cover;
            border: 1px solid #ccc;
            margin-right: 5px;
            display: inline-block;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            font-size: 9px;
            text-align: center;
            color: #999;
            border-top: 1px solid #eee;
            padding-top: 5px;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
    @php
        /**
         * Helper to handle image rendering in PDF views.
         * Converts images (including WebP) to base64 JPEGs to ensure compatibility with DomPDF.
         */
        $renderJobImage = function ($img) {
            $fullPath = public_path('storage/' . $img);
            if (!file_exists($fullPath)) {
                return '';
            }

            $extension = strtolower(pathinfo($fullPath, PATHINFO_EXTENSION));

            try {
                if ($extension === 'webp' && function_exists('imagecreatefromwebp')) {
                    $image = @imagecreatefromwebp($fullPath);
                    if ($image) {
                        ob_start();
                        imagejpeg($image, null, 70);
                        $data = ob_get_clean();
                        imagedestroy($image);
                        return 'data:image/jpeg;base64,' . base64_encode($data);
                    }
                }
                $mime = 'image/' . ($extension === 'jpg' ? 'jpeg' : $extension);
                return 'data:' . $mime . ';base64,' . base64_encode(file_get_contents($fullPath));
            } catch (\Exception $e) {
                return '';
            }
        };
    @endphp
</head>

<body>
<div class="header">
    <div class="title">Patrol Report</div>
    <div class="subtitle">{{ $schedule->route->name }} (Duty #{{ $schedule->duty_number }})</div>
</div>

<table class="meta-table">
    <tr>
        <th>Scheduled Date:</th>
        <td>{{ $schedule->scheduled_date->format('M d, Y') }}</td>
        <th>Scheduled Time:</th>
        <td>{{ $schedule->from_time->format('H:i') }} - {{ $schedule->to_time->format('H:i') }}</td>
    </tr>
    <tr>
        <th>Actual Start:</th>
        <td>{{ $schedule->job_started_at ? $schedule->job_started_at->format('M d, Y H:i') : 'N/A' }}</td>
        <th>Actual End:</th>
        <td>{{ $schedule->job_ended_at ? $schedule->job_ended_at->format('M d, Y H:i') : 'N/A' }}</td>
    </tr>
    <tr>
        <th>Total Duration:</th>
        <td>
            @if($schedule->job_started_at && $schedule->job_ended_at)
                {{ number_format($schedule->job_started_at->diffInSeconds($schedule->job_ended_at) / 3600, 2) }} hours
            @else
                -
            @endif
        </td>
        <th>Customer Ref:</th>
        <td>{{ $schedule->customer_reference ?? 'N/A' }}</td>
    </tr>
    <tr>
        <th>Gas:</th>
        <td>${{ number_format($pivot->gas_rate ?? 0, 2) }}</td>
        <th>Allowance:</th>
        <td>${{ number_format($pivot->allowance ?? 0, 2) }}</td>
    </tr>
    <tr>
        <th>Other Expense:</th>
        <td>${{ number_format($pivot->other_expense ?? 0, 2) }}</td>
        <th>Comments:</th>
        <td>{{ $schedule->comments ?? 'N/A' }}</td>
    </tr>
</table>

<table class="stats-grid">
    <tr>
        <td width="33%">
            <div class="stat-box">
                <span class="stat-label">Total Tickets</span>
                <span class="stat-value" style="color: #333;">{{ $totalTickets }}</span>
            </div>
        </td>
        <td width="33%">
            <div class="stat-box">
                <span class="stat-label">Good Tickets</span>
                <span class="stat-value" style="color: green;">{{ $goodTickets }}</span>
            </div>
        </td>
        <td width="33%">
            <div class="stat-box">
                <span class="stat-label">Bad Tickets</span>
                <span class="stat-value" style="color: red;">{{ $badTickets }}</span>
            </div>
        </td>
    </tr>
</table>

<div class="section-title">Visit Timeline</div>
<table class="data-table">
    <thead>
    <tr>
        <th>Site</th>
        <th>Check In</th>
        <th>Check Out</th>
        <th>Duration</th>
        <th>Issues</th>
    </tr>
    </thead>
    <tbody>
    @foreach($schedule->jobSites->where('status', '!=', 'pending')->sortBy('checked_in_at') as $visit)
        <tr>
            <td>{{ $visit->site->name }}</td>
            <td>{{ $visit->checked_in_at ? $visit->checked_in_at->format('H:i') : '-' }}</td>
            <td>{{ $visit->checked_out_at ? $visit->checked_out_at->format('H:i') : '-' }}</td>
            <td>
                @if($visit->checked_in_at && $visit->checked_out_at)
                    {{ number_format($visit->checked_in_at->diffInSeconds($visit->checked_out_at) / 60, 2) }}m
                @else
                    -
                @endif
            </td>
            <td>{{ $visit->issueTickets->count() }}</td>
        </tr>
    @endforeach
    </tbody>
</table>

<div class="page-break"></div>

<div class="section-title">Detailed Issue Tickets</div>

@foreach($ticketsBySite as $siteId => $tickets)
    @php $site = $tickets->first()->site; @endphp
    <h3 style="margin-top: 20px; font-size: 14px; border-bottom: 1px solid #ccc;">{{ $site->name }}</h3>

    @foreach($tickets as $ticket)
        <div class="ticket-card">
            <div class="ticket-header">
                <strong>#{{ $ticket->ticket_number }}</strong>
                <span style="float: right;"
                      class="status-badge {{ $ticket->status == 'good' ? 'status-good' : 'status-bad' }}">
                        {{ strtoupper($ticket->status) }}
                    </span>
                <br>
                <span style="font-size: 10px; color: #666;">{{ $ticket->created_at->format('M d, Y H:i') }}</span>
            </div>

            <div style="font-size: 11px; margin-bottom: 5px;">
                {{ $ticket->description }}
            </div>

            @if($ticket->images && count($ticket->images) > 0)
                <div class="image-gallery">
                    @foreach($ticket->images as $image)
                        <img src="{{ $renderJobImage($image) }}" class="ticket-image">
                    @endforeach
                </div>
            @endif
        </div>
    @endforeach
@endforeach

<div class="footer">
    Generated on {{ now()->format('Y-m-d H:i') }} | Crimson Vanguard Intelligence System
</div>
</body>

</html>
