@extends('layouts.employee')

@section('title', 'Tactical Dashboard')

@section('content')
    <!-- License Expiry Alert -->
    @if(isset($birthdayWish))
        <div class="bg-purple-50 border-l-4 border-purple-500 p-4 mb-4 rounded-r-lg shadow-sm">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-white rounded-lg shadow-sm text-purple-500">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.701 2.701 0 00-1.5-.454M9 6v2m3-2v2m3-2v2M9 3h.01M12 3h.01M15 3h.01M21 21v-7a2 2 0 00-2-2H5a2 2 0 00-2 2v7h18zm-3-9v-2a2 2 0 00-2-2H8a2 2 0 00-2 2v2h12z">
                        </path>
                    </svg>
                </div>
                <div>
                    <h3 class="text-sm font-bold text-purple-800 uppercase tracking-wide">Celebration Time!</h3>
                    <p class="text-xs text-purple-600 font-medium mt-1">{{ $birthdayWish }}</p>
                </div>
            </div>
        </div>
    @endif

    @if(isset($hiringAnniversaryWish))
        <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-4 rounded-r-lg shadow-sm">
            <div class="flex items-center gap-3">
                <div class="p-2 bg-white rounded-lg shadow-sm text-blue-500">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-7.714 2.143L11 21l-2.286-6.857L1 12l7.714-2.143L11 3z">
                        </path>
                    </svg>
                </div>
                <div>
                    <h3 class="text-sm font-bold text-blue-800 uppercase tracking-wide">Work Anniversary!</h3>
                    <p class="text-xs text-blue-600 font-medium mt-1">{{ $hiringAnniversaryWish }}</p>
                </div>
            </div>
        </div>
    @endif
    @if($employee->license_expiry && \Carbon\Carbon::parse($employee->license_expiry)->isPast())
        <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-8 rounded-r-lg shadow-sm">
            <div class="flex items-start justify-between">
                <div class="flex items-center gap-3">
                    <div class="p-2 bg-white rounded-lg shadow-sm text-red-500">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                            </path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-sm font-bold text-red-800 uppercase tracking-wide">Security License Expired</h3>
                        <p class="text-xs text-red-600 font-medium mt-1">Your security license expired on
                            {{ \Carbon\Carbon::parse($employee->license_expiry)->format('d M, Y') }}. Immediate action is
                            required to maintain operational status.
                        </p>
                    </div>
                </div>
                <a href="{{ route('employee.profile') }}"
                    class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-xs font-bold rounded-lg uppercase tracking-wider shadow-sm transition-colors flex items-center gap-2">
                    Update License
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3">
                        </path>
                    </svg>
                </a>
            </div>
        </div>
    @endif

    <!-- Welcome Stats -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6 mb-8">
        <a href="{{ route('employee.notifications.index') }}"
            class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden group hover:border-blue-400 border-t-4 border-t-blue-500 transition-all hover:shadow-md">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-slate-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110">
            </div>
            @php
                $unreadCountDashboard = \App\Models\Notification::where('employee_id', '=', auth('employee')->id(), 'and')->whereNull('read_at')->count();
            @endphp
            <div class="relative">
                <div class="flex items-center justify-between mb-2">
                    <div class="text-xs font-bold text-gray-500 uppercase tracking-wider">Messages</div>
                    @if($unreadCountDashboard > 0)
                        <span class="flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-2 w-2 rounded-full bg-red-400 opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-red-500"></span>
                        </span>
                    @endif
                </div>
                <div class="flex items-baseline gap-2">
                    <div class="text-4xl font-bold text-gray-900 tracking-tight">{{ $unreadCountDashboard }}</div>
                    <svg class="w-6 h-6 text-slate-300 group-hover:text-slate-900 transition-colors" fill="none"
                        stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9">
                        </path>
                    </svg>
                </div>
            </div>
        </a>

        <div
            class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden group border-t-4 border-t-slate-800 hover:shadow-md transition-all">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-slate-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110">
            </div>
            <div class="relative">
                <div class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Jobs</div>
                <div class="text-4xl font-bold text-gray-900 tracking-tight">{{ $employee->schedules()->count() }}</div>
            </div>
        </div>

        <div
            class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden group border-t-4 border-t-emerald-500 hover:shadow-md transition-all">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-slate-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110">
            </div>
            <div class="relative">
                <div class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Active</div>
                <div class="text-4xl font-bold text-gray-900 tracking-tight">{{ $activeJobs->count() }}</div>
            </div>
        </div>

        <div
            class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden group border-t-4 border-t-amber-500 hover:shadow-md transition-all">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-slate-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110">
            </div>
            <div class="relative">
                <div class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Shift Hours (30d)</div>
                <div class="text-4xl font-bold text-gray-900 tracking-tight">
                    {{ $shiftHours30d }}<span class="text-xl ml-1 text-gray-400">h</span>
                </div>
            </div>
        </div>

        <div
            class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden group border-t-4 border-t-indigo-500 hover:shadow-md transition-all">
            <div
                class="absolute top-0 right-0 w-24 h-24 bg-slate-50 rounded-full -mr-10 -mt-10 transition-transform group-hover:scale-110">
            </div>
            <div class="relative">
                <div class="text-xs font-bold text-gray-500 uppercase tracking-wider mb-2">Income (30d)</div>
                <div class="text-4xl font-bold text-gray-900 tracking-tight">${{ number_format($currentMonthIncome, 1) }}
                </div>
            </div>
        </div>
    </div>

    <!-- Income Analytics & Highest Month -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
        <div class="lg:col-span-2 bg-white p-8 rounded-2xl border border-gray-100 shadow-sm">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Income Statistics</h3>
                    <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">12-Month Performance
                        Trend</p>
                </div>
                <div class="flex items-center gap-2">
                    <span class="w-3 h-3 rounded-full bg-slate-900"></span>
                    <span class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Gross Earnings</span>
                </div>
            </div>
            <div class="relative h-64">
                <canvas id="dashboardIncomeChart"></canvas>
            </div>
        </div>

        <div
            class="bg-white p-8 rounded-2xl border border-gray-100 shadow-sm relative overflow-hidden flex flex-col justify-center">
            <div class="absolute top-0 right-0 w-32 h-32 bg-slate-50 rounded-full -mr-16 -mt-16"></div>
            <div class="relative z-10">
                <div class="w-12 h-12 bg-slate-900 rounded-xl flex items-center justify-center text-white mb-6">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-7.714 2.143L11 21l-2.286-6.857L1 12l7.714-2.143L11 3z">
                        </path>
                    </svg>
                </div>
                <h3 class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-2">Highest Earning Month</h3>
                <div class="text-4xl font-bold text-gray-900 mb-2">${{ number_format($highestIncome, 2) }}</div>
                <p
                    class="text-sm font-bold text-slate-900 bg-slate-100 inline-block px-3 py-1 rounded-full uppercase tracking-wider">
                    {{ $highestMonth }}
                </p>
                <div class="mt-8 pt-8 border-t border-gray-100">
                    <p class="text-[10px] text-gray-400 font-medium leading-relaxed italic">"Peak performance achieved
                        through consistent operational excellence and route density."</p>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Active Jobs List -->
        <div
            class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden flex flex-col h-full hover:shadow-md transition-all">
            <div class="px-8 py-6 border-b border-gray-100 flex items-center justify-between bg-slate-50/50">
                <div>
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Active Operations</h3>
                    <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Current & Upcoming
                        Today</p>
                </div>
                <span
                    class="px-3 py-1 bg-slate-900 text-white text-[10px] font-bold rounded-full uppercase tracking-wider shadow-sm">Live</span>
            </div>

            <div class="p-8 flex-1">
                @if($activeJobs->count() > 0)
                    <div class="space-y-6">
                        @foreach($activeJobs as $job)
                            @php
                                $pivot = $job->pivot;
                                $hasStarted = !empty($pivot->actual_start_at);
                                $hasCheckedIn = !empty($pivot->checkin_images);
                                $hasCheckedOut = !empty($pivot->actual_end_at);
                            @endphp
                            <div x-data="{ reportIncident: false, checkout: false, checkin: false, gallery: false, selectedParent: '', selectedChild: '' }"
                                class="flex flex-col p-6 rounded-xl border border-gray-100 hover:border-slate-300 transition-all group bg-white relative">
                                <div class="flex items-start gap-5">
                                    <div
                                        class="w-12 h-12 bg-gray-100 rounded-xl flex flex-col items-center justify-center text-gray-700 border border-gray-100">
                                        <span
                                            class="text-[10px] font-bold leading-none uppercase">{{ $job->from_datetime->format('M') }}</span>
                                        <span class="text-lg font-bold">{{ $job->from_datetime->format('d') }}</span>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center justify-between mb-1">
                                            <div class="text-[10px] font-bold text-slate-500 uppercase tracking-wider">
                                                {{ $job->duty_number }}
                                            </div>
                                            <div class="flex items-center gap-2">
                                                @if($hasCheckedIn || $hasCheckedOut)
                                                    <button type="button" @click="gallery = true"
                                                        class="w-7 h-7 flex items-center justify-center bg-gray-50 rounded-lg text-gray-400 hover:bg-slate-900 hover:text-white transition-all"
                                                        title="View Job Evidence Gallery">
                                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                            </path>
                                                        </svg>
                                                    </button>
                                                @endif
                                                @if($hasStarted && !$hasCheckedOut)
                                                    <div
                                                        class="flex items-center gap-1.5 text-emerald-600 font-bold text-[10px] uppercase tracking-wider bg-emerald-50 px-2.5 py-1 rounded-full border border-emerald-100">
                                                        <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                                                        Active
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                        <h4 class="text-sm font-bold text-gray-900 truncate">{{ $job->site->name }}</h4>
                                        <div class="flex items-center gap-3 mt-2 text-xs font-semibold text-gray-500">
                                            <div class="flex items-center gap-1.5">
                                                <svg class="w-3.5 h-3.5 text-gray-400" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                </svg>
                                                {{ $job->from_datetime->format('H:i') }} -
                                                {{ $job->to_datetime->format('H:i') }}
                                            </div>
                                            <div class="flex items-center gap-1.5 truncate">
                                                <svg class="w-3.5 h-3.5 text-gray-400" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                </svg>
                                                {{ $job->site->city }}
                                            </div>
                                        </div>

                                        @php
                                            $companions = $job->employees->where('id', '!=', $employee->id);
                                        @endphp
                                        <div class="mt-4 pt-3 border-t border-gray-50">
                                            @if($companions->count() > 0)
                                                <div class="flex flex-col gap-2">
                                                    <span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Team
                                                        Members</span>
                                                    <div class="flex flex-wrap gap-2">
                                                        @foreach($companions as $comp)
                                                            <div
                                                                class="flex items-center gap-2 px-2.5 py-1 bg-gray-50 rounded border border-gray-100">
                                                                <div
                                                                    class="w-4 h-4 rounded-full bg-slate-200 flex items-center justify-center text-[9px] font-bold text-slate-600">
                                                                    {{ substr($comp->first_name, 0, 1) }}{{ substr($comp->last_name, 0, 1) }}
                                                                </div>
                                                                <span
                                                                    class="text-[11px] font-semibold text-gray-700">{{ $comp->first_name }}
                                                                    {{ $comp->last_name }}</span>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @else
                                                <div class="flex items-center gap-2">
                                                    <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                                                    <span class="text-[10px] font-bold text-gray-400 uppercase tracking-wider">Solo
                                                        Deployment</span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-5 pt-4 border-t border-gray-100 flex flex-wrap gap-3">
                                    @if(!$hasStarted)
                                        <form action="{{ route('employee.jobs.start', $job->id) }}" method="POST"
                                            class="location-required w-full">
                                            @csrf
                                            <button type="submit"
                                                class="w-full bg-slate-900 hover:bg-black text-white text-xs font-bold px-6 py-3 rounded-lg uppercase tracking-wider shadow-sm transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                                </svg>
                                                Start Job
                                            </button>
                                        </form>
                                    @elseif(!$hasCheckedOut)
                                        <div class="flex flex-wrap gap-3 w-full">
                                            @if(!$hasCheckedIn)
                                                <button type="button" @click="checkin = true"
                                                    class="w-full bg-amber-600 hover:bg-amber-700 text-white text-xs font-bold px-6 py-3 rounded-lg uppercase tracking-wider shadow-sm transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z">
                                                        </path>
                                                    </svg>
                                                    Submit Check-In Evidence
                                                </button>
                                            @endif

                                            <button type="button" @click="reportIncident = true"
                                                class="flex-1 bg-white border border-gray-100 text-gray-700 text-[10px] font-bold px-4 py-3 rounded-lg uppercase tracking-wider hover:bg-gray-50 hover:text-gray-900 transition-all flex items-center justify-center gap-2">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                                    </path>
                                                </svg>
                                                Report Incident
                                            </button>

                                            <button type="button" @click="checkout = true"
                                                class="flex-1 bg-slate-900 hover:bg-black text-white text-[10px] font-bold px-4 py-3 rounded-lg uppercase tracking-wider shadow-sm transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                    </path>
                                                </svg>
                                                Upload Evidence
                                            </button>

                                            <form action="{{ route('employee.jobs.end', $job->id) }}" method="POST"
                                                class="flex-1 location-required">
                                                @csrf
                                                <button type="submit"
                                                    class="w-full h-full bg-red-600 hover:bg-red-700 text-white text-[10px] font-bold px-4 py-3 rounded-lg uppercase tracking-wider shadow-sm transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M17 16l4-4m0 0l-4-4m4 4H7"></path>
                                                    </svg>
                                                    End Job
                                                </button>
                                            </form>
                                        </div>
                                    @else
                                        <div class="flex gap-2 w-full">
                                            <a href="{{ route('employee.jobs.report.view', $job->id) }}" target="_blank"
                                                class="flex-1 bg-gray-100 hover:bg-gray-200 text-gray-800 text-xs font-bold px-4 py-3 rounded-lg uppercase tracking-wider transition-all flex items-center justify-center gap-2">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                                View
                                            </a>
                                            <a href="{{ route('employee.jobs.report', $job->id) }}"
                                                class="flex-[2] bg-slate-900 hover:bg-black text-white text-xs font-bold px-4 py-3 rounded-lg uppercase tracking-wider shadow-sm transition-all flex items-center justify-center gap-2">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                    </path>
                                                </svg>
                                                Download PDF
                                            </a>
                                        </div>
                                    @endif
                                </div>

                                <!-- Modals -->
                                <div x-show="checkin" x-cloak
                                    class="fixed inset-0 z-[100] flex items-center justify-center p-6 bg-slate-900/60 backdrop-blur-sm">
                                    <div @click.away="checkin = false"
                                        class="bg-white rounded-2xl w-full max-w-lg shadow-xl overflow-hidden">
                                        <div
                                            class="px-6 py-5 bg-gray-50 border-b border-gray-100 flex justify-between items-center">
                                            <h3 class="font-bold uppercase tracking-tight text-gray-800">Job Evidence: Check-In
                                            </h3>
                                            <button type="button" @click="checkin = false"
                                                class="text-gray-400 hover:text-slate-900">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                            </button>
                                        </div>
                                        <form action="{{ route('employee.jobs.checkin', $job->id) }}" method="POST"
                                            enctype="multipart/form-data" class="p-6 space-y-5"
                                            x-data="{ fileCount: 0, uploading: false, progress: 0, startUpload() { this.uploading = true; let interval = setInterval(() => { this.progress += 5; if(this.progress >= 90) clearInterval(interval); }, 100); } }"
                                            @submit="startUpload()">
                                            @csrf
                                            <div
                                                class="p-8 border-2 border-dashed border-gray-100 rounded-xl text-center bg-slate-50/50 relative hover:bg-gray-50 transition-colors">
                                                <label class="cursor-pointer block">
                                                    <input type="file" name="images[]" multiple
                                                        class="absolute inset-0 w-full h-full opacity-0 cursor-pointer" required
                                                        @change="fileCount = $event.target.files.length">
                                                    <div
                                                        class="w-12 h-12 bg-gray-100 rounded-xl flex items-center justify-center text-gray-500 mx-auto mb-3">
                                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                            </path>
                                                        </svg>
                                                    </div>
                                                    <p class="text-gray-500 font-bold uppercase tracking-wider text-xs"
                                                        x-text="fileCount > 0 ? fileCount + ' PHOTOS SELECTED' : 'SELECT PHOTOS'">
                                                    </p>
                                                </label>
                                            </div>
                                            <div x-show="uploading" x-transition class="w-full bg-gray-100 rounded-full h-2 mt-4">
                                                <div class="bg-slate-900 h-2 rounded-full transition-all duration-300"
                                                    :style="'width: ' + progress + '%'"></div>
                                            </div>
                                            <button type="submit" :disabled="uploading"
                                                class="w-full bg-slate-900 text-white font-bold py-4 rounded-xl uppercase tracking-wider shadow-sm active:scale-[0.98] transition-all disabled:opacity-50">
                                                <span x-show="!uploading">upload check in images</span>
                                                <span x-show="uploading">Processing...</span>
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <div x-show="reportIncident" x-cloak
                                    class="fixed inset-0 z-[100] flex items-center justify-center p-6 bg-slate-900/60 backdrop-blur-sm">
                                    <div @click.away="reportIncident = false"
                                        class="bg-white rounded-2xl w-full max-w-lg shadow-xl overflow-hidden">
                                        <div
                                            class="px-6 py-5 bg-gray-50 border-b border-gray-100 flex justify-between items-center">
                                            <h3 class="font-bold uppercase tracking-tight text-gray-800 text-left">Tactical
                                                Briefing:
                                                Report Incident</h3>
                                            <button type="button" @click="reportIncident = false"
                                                class="text-gray-400 hover:text-slate-900"><span
                                                    class="text-2xl">&times;</span></button>
                                        </div>
                                        <form action="{{ route('employee.jobs.incident', $job->id) }}" method="POST"
                                            enctype="multipart/form-data" class="p-6 space-y-4"
                                            x-data="{ fileCount: 0, uploading: false, progress: 0, startUpload() { this.uploading = true; let interval = setInterval(() => { this.progress += 5; if(this.progress >= 90) clearInterval(interval); }, 100); } }"
                                            @submit="startUpload()">
                                            @csrf
                                            <div class="space-y-4 mb-6">
                                                <div>
                                                    <label
                                                        class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Category
                                                        Type</label>
                                                    <select x-model="selectedParent" name="incident_parent_category_id" required
                                                        class="w-full px-4 py-3 bg-gray-50 border border-gray-100 rounded-lg text-sm font-semibold focus:outline-none focus:border-slate-500 transition-colors">
                                                        <option value="">Select Category Type</option>
                                                        <template x-for="cat in window.incidentCategories" :key="cat.id">
                                                            <option :value="cat.id" x-text="cat.code + ' - ' + cat.description">
                                                            </option>
                                                        </template>
                                                    </select>
                                                </div>
                                                <div x-show="selectedParent">
                                                    <label
                                                        class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Specific
                                                        Category</label>
                                                    <select name="incident_category_id" x-model="selectedChild" required
                                                        class="w-full px-4 py-3 bg-gray-50 border border-gray-100 rounded-lg text-sm font-semibold focus:outline-none focus:border-slate-500 transition-colors">
                                                        <option value="">Select Specific Category</option>
                                                        <template
                                                            x-for="child in (window.incidentCategories.find(c => c.id == selectedParent)?.incident_categories || [])"
                                                            :key="child.id">
                                                            <option :value="child.id"
                                                                x-text="child.code ? (child.code + ' - ' + child.description) : child.description">
                                                            </option>
                                                        </template>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label
                                                        class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Incident
                                                        Title</label>
                                                    <input type="text" name="subject" required
                                                        class="w-full bg-gray-50 border border-gray-100 rounded-xl px-4 py-3 font-bold text-gray-800 focus:outline-none focus:ring-1 focus:ring-slate-900 transition-all uppercase text-sm">
                                                </div>
                                                <div>
                                                    <label
                                                        class="block text-[10px] font-bold text-gray-500 uppercase tracking-widest mb-2">Details</label>
                                                    <textarea name="description" required placeholder="Description..." rows="4"
                                                        class="w-full bg-gray-50 border border-gray-100 rounded-xl px-4 py-3 font-medium text-gray-800 focus:outline-none focus:ring-1 focus:ring-slate-900 transition-all text-sm"></textarea>
                                                </div>
                                                <div
                                                    class="p-4 border-2 border-dashed border-gray-100 rounded-xl bg-slate-50/50 relative text-left">
                                                    <label class="cursor-pointer block">
                                                        <input type="file" name="images[]" multiple
                                                            class="absolute inset-0 w-full h-full opacity-0 cursor-pointer"
                                                            @change="fileCount = $event.target.files.length">
                                                        <p class="text-gray-500 font-bold uppercase tracking-wider text-[10px]"
                                                            x-text="fileCount > 0 ? fileCount + ' FILES' : 'ATTACH PHOTOS'"></p>
                                                    </label>
                                                </div>
                                            </div>
                                            <div x-show="uploading" x-transition
                                                class="w-full bg-gray-100 rounded-full h-2 mt-4 mb-4">
                                                <div class="bg-slate-900 h-2 rounded-full transition-all duration-300"
                                                    :style="'width: ' + progress + '%'"></div>
                                            </div>
                                            <button type="submit" :disabled="uploading"
                                                class="w-full bg-slate-900 text-white font-bold py-4 rounded-xl uppercase tracking-wider shadow-sm active:scale-[0.98] transition-all disabled:opacity-50">
                                                <span x-show="!uploading">Submit Report</span>
                                                <span x-show="uploading">Processing...</span>
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <div x-show="checkout" x-cloak
                                    class="fixed inset-0 z-[100] flex items-center justify-center p-6 bg-slate-900/60 backdrop-blur-sm">
                                    <div @click.away="checkout = false"
                                        class="bg-white rounded-2xl w-full max-w-lg shadow-xl overflow-hidden">
                                        <div
                                            class="px-6 py-5 bg-gray-50 border-b border-gray-100 flex justify-between items-center">
                                            <h3 class="font-bold uppercase tracking-tight text-gray-800 text-left">Mission Evidence:
                                                Extraction</h3>
                                            <button type="button" @click="checkout = false"
                                                class="text-gray-400 hover:text-slate-900"><span
                                                    class="text-2xl">&times;</span></button>
                                        </div>
                                        <form action="{{ route('employee.jobs.checkout.evidence', $job->id) }}" method="POST"
                                            enctype="multipart/form-data" class="p-6 space-y-5"
                                            x-data="{ fileCount: 0, uploading: false, progress: 0, startUpload() { this.uploading = true; let interval = setInterval(() => { this.progress += 5; if(this.progress >= 90) clearInterval(interval); }, 100); } }"
                                            @submit="startUpload()">
                                            @csrf
                                            <div
                                                class="p-8 border-2 border-dashed border-gray-100 rounded-xl text-left bg-slate-50/50 relative hover:bg-gray-50 transition-colors">
                                                <label class="cursor-pointer block">
                                                    <input type="file" name="images[]" multiple
                                                        class="absolute inset-0 w-full h-full opacity-0 cursor-pointer" required
                                                        @change="fileCount = $event.target.files.length">
                                                    <div
                                                        class="w-12 h-12 bg-slate-900 rounded-xl flex items-center justify-center text-white mx-auto mb-3">
                                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                                            </path>
                                                        </svg>
                                                    </div>
                                                    <p class="text-gray-500 font-bold uppercase tracking-wider text-xs"
                                                        x-text="fileCount > 0 ? fileCount + ' PHOTOS SELECTED' : 'SELECT PHOTOS'">
                                                    </p>
                                                </label>
                                            </div>
                                            <div x-show="uploading" x-transition class="w-full bg-gray-100 rounded-full h-2 mt-4">
                                                <div class="bg-slate-900 h-2 rounded-full transition-all duration-300"
                                                    :style="'width: ' + progress + '%'"></div>
                                            </div>
                                            <button type="submit" :disabled="uploading"
                                                class="w-full bg-slate-900 text-white font-bold py-4 rounded-xl uppercase tracking-wider shadow-sm active:scale-[0.98] transition-all disabled:opacity-50">
                                                <span x-show="!uploading">check out images</span>
                                                <span x-show="uploading">Processing...</span>
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <div x-show="gallery" x-cloak
                                    class="fixed inset-0 z-[120] flex items-center justify-center p-6 bg-slate-900/80 backdrop-blur-md">
                                    <div @click.away="gallery = false"
                                        class="bg-white rounded-2xl w-full max-w-4xl shadow-2xl overflow-hidden flex flex-col max-h-[90vh]">
                                        <div
                                            class="px-8 py-6 bg-slate-50 border-b border-gray-100 flex justify-between items-center">
                                            <div>
                                                <h3 class="font-bold uppercase tracking-tight text-gray-900">Mission Evidence
                                                    Gallery</h3>
                                                <p class="text-[10px] text-gray-500 font-bold uppercase tracking-wider">Intel
                                                    Log #{{ $job->duty_number }}</p>
                                            </div>
                                            <button type="button" @click="gallery = false"
                                                class="text-gray-400 hover:text-slate-900 transition-colors">
                                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                            </button>
                                        </div>
                                        <div class="p-8 overflow-y-auto">
                                            <div class="space-y-10">
                                                @php
                                                    $inImgs = json_decode($pivot->checkin_images, true) ?? [];
                                                    $outImgs = json_decode($pivot->checkout_images, true) ?? [];
                                                @endphp
                                                @if(count($inImgs) > 0)
                                                    <section>
                                                        <h4
                                                            class="text-xs font-bold text-gray-900 uppercase tracking-widest mb-4 flex items-center gap-3">
                                                            <span class="w-6 h-px bg-slate-300"></span> Infiltration Evidence
                                                        </h4>
                                                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                                                            @foreach($inImgs as $idx => $img)
                                                                <div
                                                                    class="aspect-square rounded-xl overflow-hidden bg-gray-100 border border-gray-100 group relative">
                                                                    <img src="{{ asset('storage/' . $img) }}"
                                                                        class="w-full h-full object-cover">

                                                                    <!-- Delete Button -->
                                                                    <form
                                                                        action="{{ route('employee.jobs.evidence.delete', [$job->id, 'checkin', $idx]) }}"
                                                                        method="POST" class="absolute top-2 right-2 z-10"
                                                                        onsubmit="return confirm('Are you sure you want to delete this evidence?');">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button type="submit"
                                                                            class="w-8 h-8 flex items-center justify-center bg-red-600 hover:bg-red-700 text-white rounded-lg shadow-md border border-white transition-colors">
                                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                                                viewBox="0 0 24 24">
                                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                                    stroke-width="2"
                                                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                                                </path>
                                                                            </svg>
                                                                        </button>
                                                                    </form>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </section>
                                                @endif
                                                @if(count($outImgs) > 0)
                                                    <section>
                                                        <h4
                                                            class="text-xs font-bold text-gray-900 uppercase tracking-widest mb-4 flex items-center gap-3">
                                                            <span class="w-6 h-px bg-slate-300"></span> Extraction Evidence
                                                        </h4>
                                                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                                                            @foreach($outImgs as $idx => $img)
                                                                <div
                                                                    class="aspect-square rounded-xl overflow-hidden bg-gray-100 border border-gray-100 group relative">
                                                                    <img src="{{ asset('storage/' . $img) }}"
                                                                        class="w-full h-full object-cover">

                                                                    <!-- Delete Button -->
                                                                    <form
                                                                        action="{{ route('employee.jobs.evidence.delete', [$job->id, 'checkout', $idx]) }}"
                                                                        method="POST" class="absolute top-2 right-2 z-10"
                                                                        onsubmit="return confirm('Are you sure you want to delete this evidence?');">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button type="submit"
                                                                            class="w-8 h-8 flex items-center justify-center bg-red-600 hover:bg-red-700 text-white rounded-lg shadow-md border border-white transition-colors">
                                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                                                viewBox="0 0 24 24">
                                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                                    stroke-width="2"
                                                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                                                </path>
                                                                            </svg>
                                                                        </button>
                                                                    </form>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </section>
                                                @endif
                                                @if(count($inImgs) == 0 && count($outImgs) == 0)
                                                    <div class="py-12 text-center text-gray-400">
                                                        <p class="text-xs font-bold uppercase tracking-wider">No visual evidence
                                                            available</p>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="h-64 flex flex-col items-center justify-center text-center">
                        <div
                            class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mb-4 border border-dashed border-gray-300">
                            <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4">
                                </path>
                            </svg>
                        </div>
                        <p class="text-gray-400 font-bold uppercase tracking-wider text-xs">No active operations</p>
                    </div>
                @endif
            </div>
            <div class="px-8 py-5 border-t border-gray-100 bg-gray-50 text-center">
                <a href="{{ route('employee.jobs.index') }}"
                    class="text-xs font-bold text-slate-900 hover:text-black hover:underline transition-all uppercase tracking-wider">View
                    All Jobs</a>
            </div>
        </div>

        <!-- Today Jobs Summary -->
        <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden flex flex-col h-full">
            <div class="px-8 py-6 border-b border-gray-100 flex items-center justify-between bg-slate-50/50">
                <div>
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Today's Duty</h3>
                    <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Scheduled for
                        {{ Carbon\Carbon::today()->format('d M Y') }}
                    </p>
                </div>
                <div class="w-8 h-8 bg-white rounded-lg flex items-center justify-center shadow-sm border border-gray-100">
                    <svg class="w-4 h-4 text-slate-800" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                        </path>
                    </svg>
                </div>
            </div>

            <div class="p-8 flex-1">
                @if($todayJobs->count() > 0)
                    <div class="space-y-6">
                        @foreach($todayJobs as $job)
                            <div
                                class="p-6 rounded-xl border border-gray-100 bg-white shadow-sm relative group hover:border-slate-300 transition-all">
                                <div class="flex items-center justify-between mb-3">
                                    <span
                                        class="px-2.5 py-1 bg-gray-100 text-gray-600 text-[10px] font-bold rounded uppercase tracking-wider">Duty
                                        #{{ $job->duty_number }}</span>
                                    <span
                                        class="text-[10px] font-bold text-gray-400">{{ $job->from_datetime->diffForHumans() }}</span>
                                </div>
                                <h4 class="text-lg font-bold text-gray-900 mb-2 truncate">{{ $job->site->name }}</h4>
                                <div class="flex items-center gap-3 text-xs font-semibold text-gray-500">
                                    <div class="flex items-center gap-1.5">
                                        <svg class="w-3.5 h-3.5 text-slate-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        {{ $job->from_datetime->format('H:i') }}
                                    </div>
                                    <span>at</span>
                                    <div class="flex items-center gap-1.5 truncate">
                                        <svg class="w-3.5 h-3.5 text-slate-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                            </path>
                                        </svg>
                                        {{ $job->site->city }}
                                    </div>
                                </div>

                                <div class="mt-6">
                                    @if($job->status === 'active')
                                        <div
                                            class="flex items-center gap-3 text-emerald-600 font-bold text-[10px] uppercase tracking-wider bg-emerald-50 px-4 py-3 rounded-lg border border-emerald-100 justify-center">
                                            <span class="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></span>
                                            In Progress
                                        </div>
                                    @else
                                        <form action="{{ route('employee.jobs.start', $job->id) }}" method="POST">
                                            @csrf
                                            <button type="submit"
                                                class="w-full bg-slate-900 hover:bg-black text-white text-xs font-bold py-3 rounded-lg uppercase tracking-wider shadow-sm transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                                                Start Job
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="h-64 flex items-center justify-center text-center">
                        <p class="text-gray-400 text-xs uppercase tracking-wider font-medium">No duties scheduled for today
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden flex flex-col">
        <div class="px-8 py-6 border-b border-gray-100 flex items-center justify-between bg-slate-50/50">
            <div>
                <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Reports</h3>
                <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Completed Operations
                </p>
            </div>
            <div class="w-8 h-8 bg-white rounded-lg flex items-center justify-center shadow-sm border border-gray-100">
                <svg class="w-4 h-4 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                    </path>
                </svg>
            </div>
        </div>
        <div class="flex-1 p-0">
            @if($completedJobs->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b border-gray-100">
                            <tr>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Mission</th>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Times</th>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            @foreach($completedJobs as $cJob)
                                <tr class="group hover:bg-slate-50/50 transition-colors">
                                    <td class="px-8 py-5">
                                        <div class="flex flex-col gap-1">
                                            <span
                                                class="text-[10px] font-bold text-slate-500 tracking-wider uppercase">#{{ $cJob->duty_number }}</span>
                                            <span class="text-sm font-bold text-gray-900">{{ $cJob->site->name }}</span>
                                            <span
                                                class="text-[10px] text-gray-400 uppercase">{{ $cJob->from_datetime->format('d M Y') }}</span>
                                        </div>
                                    </td>
                                    <td class="px-8 py-5 text-left">
                                        <div class="flex items-center justify-start gap-2">
                                            <span
                                                class="text-[10px] font-mono font-bold text-gray-600 bg-gray-100 px-2 py-1 rounded">{{ $cJob->pivot->actual_start_at ? \Carbon\Carbon::parse($cJob->pivot->actual_start_at)->format('H:i') : '--:--' }}</span>
                                            <span class="text-gray-300">-</span>
                                            <span
                                                class="text-[10px] font-mono font-bold text-gray-600 bg-gray-100 px-2 py-1 rounded">{{ $cJob->pivot->actual_end_at ? \Carbon\Carbon::parse($cJob->pivot->actual_end_at)->format('H:i') : '--:--' }}</span>
                                        </div>
                                    </td>
                                    <td class="px-8 py-5 text-left">
                                        <div class="relative inline-block text-left" x-data="{ open: false }">
                                            <button @click="open = !open" type="button"
                                                class="inline-flex justify-center items-center gap-2 rounded-lg border border-gray-100 shadow-sm px-4 py-2 bg-white text-xs font-bold text-gray-700 hover:bg-gray-50 focus:outline-none">
                                                Options
                                                <svg class="-mr-1 h-3.5 w-3.5 text-gray-400" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                    <path fill-rule="evenodd"
                                                        d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            </button>
                                            <div x-show="open" @click.away="open = false" x-cloak
                                                class="origin-top-right absolute right-0 mt-2 w-48 rounded-xl shadow-lg bg-white ring-1 ring-black ring-opacity-5 focus:outline-none z-50">
                                                <div class="py-1" role="menu" aria-orientation="vertical"
                                                    aria-labelledby="options-menu">
                                                    <a href="{{ route('employee.jobs.report', $cJob->id) }}"
                                                        class="block px-4 py-2 text-xs text-gray-700 hover:bg-gray-50 font-medium"
                                                        role="menuitem">Full Report</a>
                                                    <a href="{{ route('employee.jobs.report.payout', $cJob->id) }}"
                                                        class="block px-4 py-2 text-xs text-emerald-700 hover:bg-emerald-50 font-medium"
                                                        role="menuitem">Payout Report</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="p-12 text-center">
                    <p class="text-gray-400 text-xs uppercase tracking-wider font-medium">No completed missions found</p>
                </div>
            @endif
        </div>
    </div>

    {{-- Patroller Jobs Section --}}
    @if(isset($activePatrollerJobs) && ($activePatrollerJobs->count() > 0 || $todayPatrollerJobs->count() > 0))
        <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden mt-8">
            <div class="px-8 py-6 border-b border-gray-100 flex items-center justify-between bg-purple-50/50">
                <div>
                    <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight flex items-center gap-2">
                        <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7">
                            </path>
                        </svg>
                        Patrol Roaster
                    </h3>
                    <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Route Patrols</p>
                </div>
                <span
                    class="px-3 py-1 bg-purple-600 text-white text-[10px] font-bold rounded-full uppercase tracking-wider shadow-sm">Patrol</span>
            </div>

            <div class="p-8">
                @if($activePatrollerJobs->count() > 0)
                    <div class="space-y-6 mb-8">
                        @foreach($activePatrollerJobs as $job)
                            <div
                                class="flex flex-col p-6 rounded-xl border border-purple-200 hover:border-purple-300 transition-all group bg-purple-50/30 relative">
                                <div class="flex items-start gap-5">
                                    <div
                                        class="w-12 h-12 bg-purple-100 rounded-xl flex flex-col items-center justify-center text-purple-700 border border-purple-200">
                                        <span
                                            class="text-[10px] font-bold leading-none uppercase">{{ $job->from_time->format('M') }}</span>
                                        <span class="text-lg font-bold">{{ $job->from_time->format('d') }}</span>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center justify-between mb-1">
                                            <h4 class="text-sm font-bold text-gray-900 truncate">[PATROLLER] {{ $job->route->name }}
                                            </h4>
                                            <span
                                                class="px-2 py-1 rounded-full text-[10px] font-bold uppercase {{ $job->status_classes }}">
                                                {{ $job->calculated_status }}
                                            </span>
                                        </div>
                                        <p class="text-xs text-gray-600 mb-2">Duty #{{ $job->duty_number }}</p>
                                        <div class="flex items-center gap-4 text-[11px] text-gray-500">
                                            <span class="flex items-center gap-1">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                {{ $job->from_time->format('h:i A') }} - {{ $job->to_time->format('h:i A') }}
                                            </span>
                                            <span class="flex items-center gap-1">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                </svg>
                                                {{ $job->route->sites->count() }} Sites
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-4 pt-4 border-t border-purple-200">
                                    @if($job->job_status === 'pending')
                                        <button onclick="startPatrollerJob({{ $job->id }})"
                                            class="w-full bg-purple-600 text-white font-bold py-3 rounded-lg hover:bg-purple-700 transition-all text-sm">
                                            Start Patrol Job
                                        </button>
                                    @elseif($job->job_status === 'in_progress')
                                        <a href="{{ route('employee.patroller-jobs.show', $job->id) }}"
                                            class="block w-full bg-purple-600 text-white font-bold py-3 rounded-lg hover:bg-purple-700 transition-all text-sm text-center">
                                            Continue Patrol
                                        </a>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif

                @if($todayPatrollerJobs->count() > 0)
                    <div class="space-y-4">
                        <h4 class="text-xs font-bold text-gray-500 uppercase tracking-wider">Upcoming Today</h4>
                        @foreach($todayPatrollerJobs as $job)
                            <div
                                class="flex items-center justify-between p-4 rounded-lg border border-gray-100 bg-white hover:border-purple-200 transition-colors">
                                <div>
                                    <p class="text-sm font-bold text-gray-900">[PATROLLER] {{ $job->route->name }}</p>
                                    <p class="text-xs text-gray-500">{{ $job->from_time->format('h:i A') }} -
                                        {{ $job->to_time->format('h:i A') }} • {{ $job->route->sites->count() }} sites
                                    </p>
                                </div>
                                <span class="px-2 py-1 rounded-full text-[10px] font-bold uppercase {{ $job->status_classes }}">
                                    {{ $job->calculated_status }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                @endif

                @if($activePatrollerJobs->count() === 0 && $todayPatrollerJobs->count() === 0)
                    <div class="text-center py-12">
                        <svg class="w-16 h-16 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7">
                            </path>
                        </svg>
                        <p class="text-sm text-gray-500 font-medium">No patrol jobs today</p>
                    </div>
                @endif
            </div>
        </div>
    @endif

    {{-- Completed Patroller Jobs --}}
    @if(isset($completedPatrollerJobs) && $completedPatrollerJobs->count() > 0)
        <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden mt-8">
            <div class="px-8 py-6 border-b border-gray-100 bg-slate-50/50">
                <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Completed Patrols</h3>
                <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Recent patrol reports</p>
            </div>
            <div class="p-8">
                <div class="space-y-3">
                    @foreach($completedPatrollerJobs as $job)
                        <div
                            class="flex items-center justify-between p-4 rounded-lg border border-gray-100 bg-white hover:border-purple-200 transition-colors">
                            <div>
                                <p class="font-bold text-gray-900 text-sm">[PATROLLER] {{ $job->route->name }}</p>
                                <p class="text-xs text-gray-500">{{ $job->from_time->format('M d, Y h:i A') }} • Duty
                                    #{{ $job->duty_number }}</p>
                            </div>
                            <a href="{{ route('employee.patroller-jobs.report', $job->id) }}"
                                class="px-4 py-2 bg-purple-600 text-white text-xs font-bold rounded-lg hover:bg-purple-700 transition-colors">
                                View Report
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Issued Uniforms Section -->
    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden flex flex-col mt-8">
        <div class="px-8 py-6 border-b border-gray-100 flex items-center justify-between bg-slate-50/50">
            <div>
                <h3 class="text-base font-bold text-gray-900 uppercase tracking-tight">Issued Uniforms</h3>
                <p class="text-[10px] text-gray-500 font-semibold tracking-wider uppercase mt-1">Equipment Inventory
                </p>
            </div>
            <div class="w-8 h-8 bg-white rounded-lg flex items-center justify-center shadow-sm border border-gray-100">
                <svg class="w-4 h-4 text-slate-800" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                </svg>
            </div>
        </div>
        <div class="flex-1 p-0">
            @if($issuedUniforms->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b border-gray-100">
                            <tr>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Item</th>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Variant</th>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Qty</th>
                                <th class="px-8 py-4 text-left text-[10px] font-bold text-gray-400 uppercase tracking-wider">
                                    Issued Date</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            @foreach($issuedUniforms as $issued)
                                <tr class="group hover:bg-slate-50/50 transition-colors">
                                    <td class="px-8 py-5">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-10 h-10 bg-slate-100 rounded-lg flex items-center justify-center text-slate-600 border border-slate-200">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                                </svg>
                                            </div>
                                            <div>
                                                <span
                                                    class="text-sm font-bold text-gray-900">{{ $issued->variant->uniform->name }}</span>
                                                @if($issued->notes)
                                                    <p class="text-[10px] text-gray-400 mt-0.5">{{ Str::limit($issued->notes, 30) }}</p>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-8 py-5 text-left">
                                        <div class="flex items-center justify-start gap-2">
                                            <span
                                                class="px-2 py-1 bg-blue-50 text-blue-700 text-[10px] font-bold rounded uppercase">{{ $issued->variant->size }}</span>
                                            <span
                                                class="px-2 py-1 bg-purple-50 text-purple-700 text-[10px] font-bold rounded uppercase">{{ $issued->variant->color }}</span>
                                        </div>
                                    </td>
                                    <td class="px-8 py-5 text-left">
                                        <span
                                            class="inline-flex items-center justify-center w-8 h-8 bg-slate-900 text-white text-xs font-bold rounded-lg">{{ $issued->quantity }}</span>
                                    </td>
                                    <td class="px-8 py-5 text-left">
                                        <span
                                            class="text-xs font-semibold text-gray-600">{{ $issued->issued_at->format('M d, Y') }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="h-64 flex flex-col items-center justify-center text-center">
                    <div
                        class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mb-4 border border-dashed border-gray-300">
                        <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                    </div>
                    <p class="text-gray-400 font-bold uppercase tracking-wider text-xs">No uniforms issued yet</p>
                </div>
            @endif
        </div>
        <div class="px-8 py-5 border-t border-gray-100 bg-gray-50 text-center">
            <a href="{{ route('employee.uniforms.index') }}"
                class="text-xs font-bold text-slate-900 hover:text-black hover:underline transition-all uppercase tracking-wider">View
                All Uniforms</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const ctx = document.getElementById('dashboardIncomeChart');
            if (ctx) {
                new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: @json($incomeLabels),
                        datasets: [{
                            data: @json($incomeValues),
                            borderColor: '#0f172a',
                            backgroundColor: 'rgba(15, 23, 42, 0.05)',
                            borderWidth: 3,
                            tension: 0.4,
                            fill: true,
                            pointRadius: 0,
                            pointHoverRadius: 6,
                            pointHoverBackgroundColor: '#0f172a',
                            pointHoverBorderColor: '#fff',
                            pointHoverBorderWidth: 2
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: { display: false },
                            tooltip: {
                                mode: 'index',
                                intersect: false,
                                callbacks: {
                                    label: function (context) {
                                        return 'Income: $' + context.parsed.y.toLocaleString();
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                grid: { color: '#f3f4f6', drawBorder: false },
                                ticks: { font: { weight: 'bold', size: 10 }, color: '#9ca3af' }
                            },
                            x: {
                                grid: { display: false },
                                ticks: { font: { weight: 'bold', size: 10 }, color: '#9ca3af' }
                            }
                        }
                    }
                });
            }
        });

        window.incidentCategories = @json($categories);

        function startPatrollerJob(scheduleId) {
            if (!navigator.geolocation) {
                alert('Geolocation is not supported by your browser');
                return;
            }

            if (!confirm('Start this patrol job?')) {
                return;
            }

            navigator.geolocation.getCurrentPosition(async (position) => {
                try {
                    const response = await fetch(`/employee/patroller-jobs/${scheduleId}/start`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            latitude: position.coords.latitude,
                            longitude: position.coords.longitude
                        })
                    });

                    const data = await response.json();

                    if (response.ok && data.success) {
                        window.location.href = data.redirect;
                    } else {
                        alert(data.error || 'Failed to start job');
                    }
                } catch (error) {
                    alert('Error: ' + error.message);
                }
            }, (error) => {
                alert('Location access denied. Please enable location services.');
            });
        }
    </script>
@endsection