@extends('layouts.public')
@if(\App\Models\Setting::where('key', 'recaptcha_enabled')->value('value') == '1' && app()->environment('production'))
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endif

@section('content')
    <style>
        /* Scoped styles for this page */
        .employee-login-wrapper {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: #f8fafc;
            min-height: calc(100vh - 15rem);
            /* Adjust for header/footer */
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3rem 1rem;
        }

        .container-custom {
            max-width: 28rem;
            width: 100%;
        }

        .logo-section {
            text-center;
            margin-bottom: 2rem;
        }

        .logo-box {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 5rem;
            height: 5rem;
            background-color: #0f172a;
            border-radius: 1rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            margin-bottom: 1.5rem;
            border: 4px solid white;
        }

        .logo-box svg {
            width: 2.5rem;
            height: 2.5rem;
            color: white;
        }

        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #0f172a;
            letter-spacing: -0.025em;
        }

        .subtitle {
            color: #64748b;
            margin-top: 0.5rem;
            font-weight: 500;
            font-size: 0.875rem;
        }

        .card {
            background: white;
            border-radius: 0.75rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border: 1px solid #f1f5f9;
            padding: 2rem;
        }

        .error-box {
            margin-bottom: 1.5rem;
            padding: 1rem;
            background-color: #fef2f2;
            border-left: 4px solid #ef4444;
            border-radius: 0 0.5rem 0.5rem 0;
        }

        .error-title {
            font-size: 0.75rem;
            font-weight: 700;
            color: #dc2626;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-bottom: 0.25rem;
        }

        .error-message {
            font-size: 0.75rem;
            color: #b91c1c;
            font-weight: 500;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .input-label {
            display: block;
            font-size: 0.75rem;
            font-weight: 700;
            color: #64748b;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-bottom: 0.5rem;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            top: 50%;
            left: 1rem;
            transform: translateY(-50%);
            width: 1.25rem;
            height: 1.25rem;
            color: #94a3b8;
            pointer-events: none;
        }

        .input-wrapper:focus-within .input-icon {
            color: #0f172a;
        }

        .custom-input {
            display: block;
            width: 100%;
            padding: 0.75rem 1rem 0.75rem 2.75rem;
            background-color: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 0.5rem;
            color: #0f172a;
            font-weight: 700;
            font-size: 0.875rem;
            transition: all 0.2s;
        }

        .custom-input::placeholder {
            color: #cbd5e1;
        }

        .custom-input:focus {
            outline: none;
            border-color: #0f172a;
            box-shadow: 0 0 0 3px rgba(15, 23, 42, 0.1);
        }

        .password-toggle {
            position: absolute;
            top: 50%;
            right: 1rem;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #94a3b8;
            cursor: pointer;
            padding: 0;
            transition: color 0.2s;
        }

        .password-toggle:hover {
            color: #0f172a;
        }

        .password-toggle svg {
            width: 1.25rem;
            height: 1.25rem;
        }

        .remember-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 0.25rem;
            margin-bottom: 1.5rem;
        }

        .checkbox-label {
            display: flex;
            align-items: center;
            cursor: pointer;
        }

        .custom-checkbox {
            width: 1rem;
            height: 1rem;
            border-radius: 0.25rem;
            border: 1px solid #d1d5db;
            cursor: pointer;
        }

        .checkbox-text {
            margin-left: 0.5rem;
            font-size: 0.75rem;
            font-weight: 700;
            color: #64748b;
        }

        .checkbox-label:hover .checkbox-text {
            color: #475569;
        }

        .forgot-link {
            font-size: 0.75rem;
            font-weight: 700;
            color: #64748b;
            text-decoration: none;
        }

        .forgot-link:hover {
            color: #0f172a;
            text-decoration: underline;
        }

        .submit-btn {
            width: 100%;
            background-color: #0f172a;
            color: white;
            font-weight: 700;
            padding: 1rem;
            border-radius: 0.75rem;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-size: 0.75rem;
            transition: all 0.2s;
        }

        .submit-btn:hover {
            background-color: #000000;
        }

        .submit-btn:active {
            transform: scale(0.98);
        }

        .submit-btn svg {
            width: 1.25rem;
            height: 1.25rem;
        }

        /* Portal footer (different from main site footer) */
        .portal-footer {
            text-align: center;
            margin-top: 2rem;
            color: #cbd5e1;
            font-size: 0.625rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }
    </style>

    <div class="employee-login-wrapper">
        <div class="container-custom">


            <!-- Login Card -->
            <div class="card">
                @if($errors->any())
                    <div class="error-box">
                        <p class="error-title">Access Denied</p>
                        <p class="error-message">{{ $errors->first() }}</p>
                    </div>
                @endif

                @if(session('status'))
                    <div class="mb-4 p-4 bg-green-50 border-l-4 border-green-500 rounded">
                        <p class="text-sm font-bold text-green-800">{{ session('status') }}</p>
                    </div>
                @endif

                <form action="{{ route('employee.login.post') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label class="input-label">Email Address or Employee ID</label>
                        <div class="input-wrapper">
                            <svg class="input-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.206">
                                </path>
                            </svg>
                            <input type="text" name="login_id" value="{{ old('login_id') }}" required autofocus
                                placeholder="Enter Email or Employee ID" class="custom-input">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="input-label">Access Key</label>
                        <div class="input-wrapper">
                            <svg class="input-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                </path>
                            </svg>
                            <input id="emp-password" type="password" name="password" required
                                placeholder="Enter your ID password" class="custom-input">
                            <button type="button" onclick="toggleEmpPassword()" class="password-toggle">
                                <svg fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                            </button>
                        </div>
                    </div>

                    @if(\App\Models\Setting::where('key', 'recaptcha_enabled')->value('value') == '1' && \App\Models\Setting::where('key', 'recaptcha_site_key')->value('value') && app()->environment('production'))
                        <div class="form-group">
                            <div class="g-recaptcha"
                                data-sitekey="{{ \App\Models\Setting::where('key', 'recaptcha_site_key')->value('value') }}">
                            </div>
                        </div>
                    @endif

                    <div class="remember-row">
                        <label class="checkbox-label">
                            <input type="checkbox" class="custom-checkbox">
                            <span class="checkbox-text">Stay Signed In</span>
                        </label>
                        <a href="{{ route('employee.password.request') }}" class="forgot-link">Lost access?</a>
                    </div>

                    <button type="submit" class="submit-btn">
                        Initiate Clearance
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                        </svg>
                    </button>
                </form>
            </div>

            <p class="portal-footer">
                &copy; {{ date('Y') }} {{ config('app.name', 'Portal') }} Security
                <br>
                Developed by <a href="https://softbuiltsolutions.com/" target="_blank"
                    class="text-blue-500 hover:text-blue-400 font-medium lowercase">Soft Built Solutions</a>
            </p>
        </div>
    </div>

    <script>
        function toggleEmpPassword() {
            const passwordInput = document.getElementById('emp-password');
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
            } else {
                passwordInput.type = 'password';
            }
        }
    </script>
@endsection