@extends('layouts.user')

@section('title', 'Edit Email Template')

@section('content')
    <!-- Breadcrumb & Header -->
    <div
        class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl mb-6">
        <div>
            <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                <a href="{{ route('email-templates.index') }}" class="hover:text-white transition-colors">Email
                    Templates</a>
                <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-white">Edit Template</span>
            </div>
            <h1 class="text-3xl font-black tracking-tight">Edit: {{ $emailTemplate->name }}</h1>
            <p class="text-xs text-slate-400 font-medium mt-1">Update your email template content and settings.</p>
        </div>
        <a href="{{ route('email-templates.index') }}"
            class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                </path>
            </svg>
            Back to List
        </a>
    </div>

    <div class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden">
        <form action="{{ route('email-templates.update', $emailTemplate) }}" method="POST" class="p-10 space-y-8">
            @csrf
            @method('PUT')

            <!-- Basic Information Section -->
            <div>
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Template Details</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Template
                            Name <span class="text-red-500 ml-1">*</span></label>
                        <input type="text" name="name" required value="{{ old('name', $emailTemplate->name) }}"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm">
                        <p class="text-[10px] text-slate-400 mt-1.5 font-medium">Internal name for identifying this
                            template.</p>
                    </div>

                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Subject Line
                            <span class="text-red-500 ml-1">*</span></label>
                        <input type="text" name="subject" required value="{{ old('subject', $emailTemplate->subject) }}"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm">
                    </div>
                </div>
            </div>

            <!-- Content Section -->
            <div class="pt-6 border-t border-slate-100">
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Email Content</h2>
                </div>

                <div>
                    <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Template Content
                        <span class="text-red-500 ml-1">*</span></label>
                    <div id="content-editor" style="height: 400px; background: white;"></div>
                    <textarea name="content" id="content-hidden" style="display: none;"></textarea>
                    <div class="mt-3 text-[10px] text-slate-500 bg-slate-50 p-4 rounded-xl border border-slate-200">
                        <div class="flex items-start gap-2">
                            <svg class="w-4 h-4 mt-0.5 text-blue-600 flex-shrink-0" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <span class="font-bold text-slate-700">Available Placeholders:</span>
                                <div class="mt-1 flex flex-wrap gap-2">
                                    <code
                                        class="px-2 py-1 bg-white border border-slate-300 rounded text-blue-600 font-bold">@{{name}}</code>
                                    <code
                                        class="px-2 py-1 bg-white border border-slate-300 rounded text-blue-600 font-bold">@{{first_name}}</code>
                                    <code
                                        class="px-2 py-1 bg-white border border-slate-300 rounded text-blue-600 font-bold">@{{last_name}}</code>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="pt-8 border-t border-slate-100 flex items-center gap-4">
                <button type="submit"
                    class="px-10 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20 flex items-center gap-2 text-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path>
                    </svg>
                    Update Template
                </button>
                <a href="{{ route('email-templates.index') }}"
                    class="px-8 py-3 bg-slate-100 text-slate-600 font-bold rounded-xl hover:bg-slate-200 transition-all text-sm">
                    Cancel
                </a>
            </div>
        </form>
    </div>

    <!-- Quill Editor CSS -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

    <!-- Quill Editor JS -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Initialize Quill Editor with existing content
            var quill = new Quill('#content-editor', {
                theme: 'snow',
                modules: {
                    toolbar: [
                        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                        ['bold', 'italic', 'underline', 'strike'],
                        [{ 'color': [] }, { 'background': [] }],
                        [{ 'align': [] }],
                        [{ 'list': 'ordered' }, { 'list': 'bullet' }],
                        ['blockquote', 'code-block'],
                        ['link', 'image'],
                        ['clean']
                    ]
                },
                placeholder: 'Start typing your email content here...'
            });

            // Set existing content
            const existingContent = {!! json_encode(old('content', $emailTemplate->content)) !!};
            if (existingContent) {
                quill.root.innerHTML = existingContent;
            }

            // Get the hidden textarea
            const form = document.querySelector('form');
            const hiddenInput = document.getElementById('content-hidden');

            // Set initial value in hidden field
            if (existingContent && hiddenInput) {
                hiddenInput.value = existingContent;
            }

            // Update hidden textarea whenever content changes
            quill.on('text-change', function () {
                hiddenInput.value = quill.root.innerHTML;
            });

            // Also update on form submission
            form.addEventListener('submit', function (e) {
                const content = quill.root.innerHTML;
                const textContent = quill.getText().trim();

                // Update hidden field
                hiddenInput.value = content;

                // Check if editor has actual content (not just empty tags)
                if (!textContent || textContent.length === 0) {
                    e.preventDefault();
                    alert('Please enter email content before submitting.');
                    return false;
                }
            });
        });
    </script>
@endsection