@extends('layouts.user')

@section('title', 'Check-in History')

@section('content')
<div class="space-y-6">
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-bold text-gray-800">Check-in History</h1>
        <div class="flex gap-3">
            <a href="{{ route('care.history.export', request()->query()) }}" class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-semibold text-sm rounded-lg transition-colors flex items-center gap-2 shadow-sm">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Export PDF
            </a>
            <a href="{{ route('care.active-guards') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-semibold text-sm transition-colors">
                Back to Active Guards
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-4">
        <form action="{{ route('care.history') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Date</label>
                <input type="date" name="date" value="{{ request('date') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Employee</label>
                <select name="employee_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                    <option value="">All Employees</option>
                    @foreach($employees as $emp)
                        <option value="{{ $emp->id }}" {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                            {{ $emp->first_name }} {{ $emp->last_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm">
                    <option value="">All</option>
                    <option value="verified" {{ request('status') == 'verified' ? 'selected' : '' }}>Verified Only</option>
                    <option value="unverified" {{ request('status') == 'unverified' ? 'selected' : '' }}>Unverified Only</option>
                </select>
            </div>
            <div class="flex gap-2">
                <button type="submit" class="flex-1 px-4 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-900 transition-colors text-sm font-medium">
                    Filter
                </button>
                <a href="{{ route('care.history') }}" class="px-4 py-2 bg-gray-100 text-gray-700 rounded-md hover:bg-gray-200 transition-colors text-sm font-medium">
                    Reset
                </a>
            </div>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left text-sm text-gray-600">
                <thead class="bg-gray-50 text-xs uppercase font-semibold text-gray-500">
                    <tr>
                        <th class="px-6 py-4">Time</th>
                        <th class="px-6 py-4">Caller</th>
                        <th class="px-6 py-4">Guard</th>
                        <th class="px-6 py-4">Site / Job</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Notes</th>
                        <th class="px-6 py-4">Evidence</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($checkins as $checkin)
                        <tr class="hover:bg-gray-50/50 transition-colors">
                            <td class="px-6 py-4">
                                <div class="font-medium text-gray-900">{{ $checkin->created_at->format('M d, Y') }}</div>
                                <div class="text-xs text-gray-500">{{ $checkin->created_at->format('H:i') }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-medium text-gray-800">{{ $checkin->user?->name ?? 'System' }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-bold text-gray-900">{{ $checkin->employee->first_name }} {{ $checkin->employee->last_name }}</div>
                                <div class="text-xs text-gray-500">{{ $checkin->employee->phone_number }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @if($checkin->schedule)
                                    <div class="text-blue-600 font-medium">
                                        @if($checkin->location_reported)
                                            <a href="{{ $checkin->maps_link ?? 'javascript:void(0)' }}" target="{{ $checkin->maps_link ? '_blank' : '_self' }}" class="flex items-center gap-1 hover:underline">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path></svg>
                                                {{ $checkin->location_reported }}
                                            </a>
                                        @else
                                            {{ $checkin->schedule->site->name }}
                                        @endif
                                    </div>
                                    <div class="text-xs text-gray-500">Static • #{{ $checkin->schedule->duty_number }}</div>
                                @elseif($checkin->patrollerSchedule)
                                    <div class="text-purple-600 font-medium">
                                         @if($checkin->location_reported)
                                            <a href="{{ $checkin->maps_link ?? 'javascript:void(0)' }}" target="{{ $checkin->maps_link ? '_blank' : '_self' }}" class="flex items-center gap-1 hover:underline">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path></svg>
                                                {{ $checkin->location_reported }}
                                            </a>
                                        @else
                                            {{ $checkin->patrollerSchedule->route->name }}
                                        @endif
                                    </div>
                                    <div class="text-xs text-gray-500">Patrol • #{{ $checkin->patrollerSchedule->id }}</div>
                                @else
                                    <span class="text-gray-400 italic">Unknown Job</span>
                                @endif
                                @if($checkin->latitude && $checkin->longitude)
                                    <div class="mt-1 text-xs text-gray-500">
                                        <span class="font-mono">GPS: {{ number_format($checkin->latitude, 6) }}, {{ number_format($checkin->longitude, 6) }}</span>
                                        <div class="mt-1">
                                            @php
                                                $mapLink = $checkin->maps_link ?: "https://www.google.com/maps?q={$checkin->latitude},{$checkin->longitude}";
                                            @endphp
                                            <a href="{{ $mapLink }}" target="_blank" class="inline-flex items-center gap-1 px-2 py-0.5 bg-blue-50 text-blue-600 rounded hover:bg-blue-100 transition-colors">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                                Live Location
                                            </a>
                                        </div>
                                    </div>
                                @elseif($checkin->maps_link)
                                    <div class="mt-1">
                                        <a href="{{ $checkin->maps_link }}" target="_blank" class="inline-flex items-center gap-1 px-2 py-0.5 bg-blue-50 text-blue-600 rounded hover:bg-blue-100 transition-colors">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                            Shared Location
                                        </a>
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if($checkin->is_verified)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        Verified
                                    </span>
                                @else
                                    <form action="{{ route('care.history.verify', $checkin->id) }}" method="POST">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="group flex items-center gap-2 text-yellow-700 bg-yellow-50 hover:bg-yellow-100 px-2 py-1 rounded transition-colors" title="Mark as Verified">
                                            <span class="inline-flex items-center px-1.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 group-hover:bg-yellow-200">
                                                Unverified
                                            </span>
                                            <div class="h-4 w-4 rounded border-yellow-400 border flex items-center justify-center bg-white group-hover:border-yellow-600">
                                                <svg class="h-3 w-3 text-yellow-600 hidden group-hover:block" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" /></svg>
                                            </div>
                                        </button>
                                    </form>
                                @endif
                                <div class="mt-1 text-xs text-gray-500 capitalize">Method: {{ $checkin->checkin_type }}</div>
                            </td>
                            <td class="px-6 py-4 max-w-xs truncate">
                                <span title="{{ $checkin->notes }}">{{ $checkin->notes ?: '--' }}</span>
                            </td>
                            <td class="px-6 py-4">
                                @if(!empty($checkin->images))
                                    <div class="flex -space-x-2">
                                        @foreach($checkin->images as $img)
                                            <a href="{{ asset('storage/' . $img) }}" target="_blank" class="w-8 h-8 rounded-full border-2 border-white overflow-hidden hover:scale-110 transition-transform bg-gray-100 block">
                                                <img src="{{ asset('storage/' . $img) }}" alt="Evidence" class="w-full h-full object-cover">
                                            </a>
                                        @endforeach
                                    </div>
                                @else
                                    <span class="text-xs text-gray-400">No images</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center text-gray-400 italic">
                                No check-in records found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($checkins->hasPages())
            <div class="px-6 py-4 border-t border-gray-100 bg-gray-50/50">
                {{ $checkins->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
