@extends('layouts.user')

@section('title', 'Active Guards Check-in')

@section('content')
    <div x-data="{ 
                            showModal: false, 
                            guards: {{ \Illuminate\Support\Js::from($activeGuards) }},
                            selectedGuard: null, 
                            checkinType: 'call',
                            locationReported: '',
                            notes: '',
                            verified: false,

                            openModal(index) {
                                this.selectedGuard = this.guards[index];
                                this.showModal = true;
                                this.checkinType = 'call';
                                this.locationReported = '';
                                this.notes = '';
                                this.verified = false;
                            },
                            closeModal() {
                                this.showModal = false;
                                this.selectedGuard = null;
                            },
                            init() {
                                setInterval(() => {
                                    if (!this.showModal) {
                                        window.location.reload();
                                    }
                                }, 300000); // 5 minutes
                            }
                        }">

        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Active Guards Check-in</h1>
            <div class="flex gap-3">
                <a href="{{ route('care.active-guards.export') }}"
                    class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-semibold text-sm rounded-lg transition-colors flex items-center gap-2 shadow-sm">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                    Export PDF
                </a>
                <a href="{{ route('care.history') }}"
                    class="px-4 py-2 bg-white border border-gray-300 hover:bg-gray-50 text-gray-700 font-semibold text-sm rounded-lg transition-colors flex items-center gap-2 shadow-sm">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    View History
                </a>
            </div>
        </div>

        @if($activeGuards->isEmpty())
            <div class="bg-white rounded-xl shadow-sm p-8 text-center border border-gray-100">
                <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gray-100 mb-4">
                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z">
                        </path>
                    </svg>
                </div>
                <h3 class="text-lg font-medium text-gray-900">No Active Guards</h3>
                <p class="text-gray-500 mt-1">There are no active shifts or patrols at the moment.</p>
            </div>
        @else
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($activeGuards as $index => $guard)
                    <div
                        class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden hover:shadow-md transition-shadow">
                        <div class="p-6">
                            <div class="flex items-start justify-between mb-4">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold text-lg">
                                        {{ substr($guard->employee->first_name, 0, 1) }}
                                    </div>
                                    <div>
                                        <h3 class="font-bold text-gray-900">{{ $guard->employee->first_name }}
                                            {{ $guard->employee->last_name }}
                                        </h3>
                                        <span
                                            class="inline-flex items-center px-2 py-0.5 rounded textxs font-medium {{ $guard->type === 'static' ? 'bg-blue-100 text-blue-800' : 'bg-purple-100 text-purple-800' }}">
                                            {{ ucfirst($guard->type) }}
                                        </span>
                                    </div>
                                </div>
                                @if($guard->phone)
                                    <a href="tel:{{ $guard->phone }}"
                                        class="p-2 bg-green-50 text-green-600 rounded-lg hover:bg-green-100 transition-colors"
                                        title="Call">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                            </path>
                                        </svg>
                                    </a>
                                @endif
                            </div>

                            <div class="space-y-3 text-sm text-gray-600 mb-6 bg-gray-50 rounded-lg p-3 border border-gray-100">
                                <div class="flex items-start gap-2">
                                    <svg class="w-4 h-4 text-gray-400 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                        </path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    <span class="font-medium text-gray-800">{{ $guard->site_name }}</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <span>{{ $guard->schedule_time }} <span
                                            class="text-xs text-gray-500 font-medium">({{ $guard->total_hours }} hrs)</span></span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <svg class="w-4 h-4 {{ $guard->checkin_time !== 'N/A' ? 'text-green-500' : 'text-gray-400' }}"
                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7">
                                        </path>
                                    </svg>
                                    <span class="text-xs">Guard Check-in: <span
                                            class="font-semibold">{{ $guard->checkin_time }}</span></span>
                                </div>
                            </div>

                            <div class="flex justify-between items-center text-xs text-gray-500 border-t border-gray-100 pt-3 mb-4">
                                <div>
                                    <div class="uppercase tracking-wider font-bold text-[10px] text-gray-400">Last Called</div>
                                    <div class="font-medium text-gray-700 mt-1 flex items-center gap-1">
                                        @if($guard->last_call !== 'Never')
                                            <span>{{ $guard->last_call }}</span>
                                            <span class="text-[9px] text-gray-400">({{ $guard->last_call_relative }})</span>
                                        @else
                                            <span>Never</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="uppercase tracking-wider font-bold text-[10px] text-gray-400">Next Call By</div>
                                    <div
                                        class="font-bold mt-1 text-sm {{ $guard->next_call_is_overdue ? 'text-red-600 animate-pulse' : 'text-blue-600' }}">
                                        {{ $guard->next_call }}
                                    </div>
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-2">
                                <button @click="openModal({{ $index }})"
                                    class="py-2.5 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg shadow-sm transition-colors flex items-center justify-center gap-2">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                    Log Check-in
                                </button>

                                <form action="{{ route('location-request.send') }}" method="POST" class="inline">
                                    @csrf
                                    <input type="hidden" name="employee_id" value="{{ $guard->employee->id }}">
                                    <input type="hidden" name="type" value="{{ $guard->type }}">
                                    <input type="hidden" name="job_id" value="{{ $guard->job_id }}">
                                    <button type="submit"
                                        class="w-full py-2.5 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg shadow-sm transition-colors flex items-center justify-center gap-2">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9">
                                            </path>
                                        </svg>
                                        Request Location
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif

        <!-- Modal -->
        <div x-show="showModal" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;" x-cloak>
            <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">

                <div x-show="showModal" class="fixed inset-0 transition-opacity" aria-hidden="true" @click="closeModal">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="showModal"
                    class="inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-xl w-full relative z-10 border border-gray-100">
                    <form action="{{ route('care.check-in.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="employee_id" :value="selectedGuard?.employee.id">
                        <input type="hidden" name="type" :value="selectedGuard?.type">
                        <input type="hidden" name="job_id" :value="selectedGuard?.job_id">

                        <div class="bg-white px-6 py-6">
                            <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-100">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-xl bg-blue-600 flex items-center justify-center text-white shadow-lg shadow-blue-200">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                        </svg>
                                    </div>
                                    <div>
                                        <h3 class="text-xl font-bold text-gray-900">Log Check-in</h3>
                                        <p class="text-sm text-gray-500 font-medium">For <span
                                                x-text="selectedGuard?.employee.first_name" class="text-blue-600"></span>
                                        </p>
                                    </div>
                                </div>
                                <button type="button" @click="closeModal"
                                    class="text-gray-400 hover:text-gray-600 transition-colors">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>

                            <div class="space-y-6">
                                {{-- Check-in Type Section --}}
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-3 flex items-center gap-2">
                                        <svg class="w-4 h-4 text-blue-500" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                            </path>
                                        </svg>
                                        Check-in Type
                                    </label>
                                    <div class="grid grid-cols-3 gap-3">
                                        <label class="relative cursor-pointer">
                                            <input type="radio" name="checkin_type" value="call" x-model="checkinType"
                                                class="peer sr-only">
                                            <div
                                                class="p-3 text-center rounded-xl border-2 border-gray-100 bg-gray-50 peer-checked:border-blue-600 peer-checked:bg-blue-50 transition-all hover:bg-gray-100">
                                                <div class="flex justify-center mb-1">
                                                    <svg class="w-6 h-6 text-gray-400 peer-checked:text-blue-600"
                                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                                        </path>
                                                    </svg>
                                                </div>
                                                <span class="text-xs font-bold text-gray-700">Call</span>
                                            </div>
                                        </label>
                                        <label class="relative cursor-pointer">
                                            <input type="radio" name="checkin_type" value="video" x-model="checkinType"
                                                class="peer sr-only">
                                            <div
                                                class="p-3 text-center rounded-xl border-2 border-gray-100 bg-gray-50 peer-checked:border-blue-600 peer-checked:bg-blue-50 transition-all hover:bg-gray-100">
                                                <div class="flex justify-center mb-1">
                                                    <svg class="w-6 h-6 text-gray-400 peer-checked:text-blue-600"
                                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z">
                                                        </path>
                                                    </svg>
                                                </div>
                                                <span class="text-xs font-bold text-gray-700">Video</span>
                                            </div>
                                        </label>
                                        <label class="relative cursor-pointer">
                                            <input type="radio" name="checkin_type" value="visit" x-model="checkinType"
                                                class="peer sr-only">
                                            <div
                                                class="p-3 text-center rounded-xl border-2 border-gray-100 bg-gray-50 peer-checked:border-blue-600 peer-checked:bg-blue-50 transition-all hover:bg-gray-100">
                                                <div class="flex justify-center mb-1">
                                                    <svg class="w-6 h-6 text-gray-400 peer-checked:text-blue-600"
                                                        fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                    </svg>
                                                </div>
                                                <span class="text-xs font-bold text-gray-700">Visit</span>
                                            </div>
                                        </label>
                                    </div>
                                </div>

                                {{-- Verification Section --}}
                                <div class="bg-amber-50 rounded-xl p-4 border border-amber-100">
                                    <div class="flex items-start gap-3">
                                        <div class="mt-1">
                                            <input type="checkbox" name="is_verified" x-model="verified"
                                                id="verify-presence"
                                                class="h-5 w-5 text-blue-600 focus:ring-blue-500 border-amber-300 rounded-md cursor-pointer transition-all">
                                        </div>
                                        <label for="verify-presence" class="cursor-pointer">
                                            <span class="block text-sm font-bold text-amber-900">Verified Presence?</span>
                                            <span class="block text-xs text-amber-700 mt-0.5">Check this if you have
                                                visually or verbally confirmed the guard is at the site.</span>
                                        </label>
                                    </div>
                                </div>

                                {{-- Location Section --}}
                                <div class="space-y-4 p-4 bg-gray-50 rounded-2xl border border-gray-100">
                                    <div class="flex items-center gap-2 mb-1">
                                        <span class="w-1.5 h-4 bg-blue-600 rounded-full"></span>
                                        <h4 class="text-sm font-bold text-gray-800">Location Details</h4>
                                    </div>

                                    <div>
                                        <label
                                            class="block text-xs font-bold text-gray-600 mb-1 uppercase tracking-wider">Reported
                                            Spot</label>
                                        <input type="text" name="location_reported" x-model="locationReported"
                                            class="w-full px-4 py-2.5 bg-white border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all text-sm"
                                            placeholder="e.g. Main Gate, Building B, Patrol Point #4">
                                    </div>

                                    <div class="grid grid-cols-2 gap-4">
                                        <div>
                                            <label
                                                class="block text-xs font-bold text-gray-600 mb-1 uppercase tracking-wider">Latitude</label>
                                            <input type="text" name="latitude"
                                                class="w-full px-4 py-2.5 bg-white border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all text-sm font-mono"
                                                placeholder="28.7041">
                                        </div>
                                        <div>
                                            <label
                                                class="block text-xs font-bold text-gray-600 mb-1 uppercase tracking-wider">Longitude</label>
                                            <input type="text" name="longitude"
                                                class="w-full px-4 py-2.5 bg-white border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all text-sm font-mono"
                                                placeholder="77.1025">
                                        </div>
                                    </div>

                                    <div>
                                        <label
                                            class="block text-xs font-bold text-gray-600 mb-1 uppercase tracking-wider flex items-center justify-between">
                                            Google Maps Link
                                            <span class="text-[10px] text-blue-600 normal-case font-medium">Auto-fills GPS
                                                info</span>
                                        </label>
                                        <div class="relative">
                                            <div
                                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg class="h-4 w-4 text-gray-400" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M10.172 13.828a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.102 1.101" />
                                                </svg>
                                            </div>
                                            <input type="url" name="maps_link"
                                                class="w-full pl-10 pr-4 py-2.5 bg-white border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all text-sm"
                                                placeholder="Paste live location link here">
                                        </div>
                                    </div>
                                </div>

                                {{-- Notes Section --}}
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2 flex items-center gap-2">
                                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                            </path>
                                        </svg>
                                        Notes / Remarks
                                    </label>
                                    <textarea name="notes" rows="3" x-model="notes"
                                        class="w-full px-4 py-2.5 border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all text-sm"
                                        placeholder="Any observations, incidents or additional info..."></textarea>
                                </div>

                                {{-- Evidence Section --}}
                                <div>
                                    <label class="block text-sm font-bold text-gray-700 mb-2 flex items-center gap-2">
                                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z">
                                            </path>
                                        </svg>
                                        Evidence (Photos / Screenshots)
                                    </label>
                                    <div
                                        class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-200 border-dashed rounded-2xl bg-gray-50 hover:bg-gray-100 transition-colors cursor-pointer group relative">
                                        <div class="space-y-1 text-center">
                                            <svg class="mx-auto h-10 w-10 text-gray-400 group-hover:text-blue-500 transition-colors"
                                                stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true">
                                                <path
                                                    d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                            <div class="flex text-sm text-gray-600">
                                                <span
                                                    class="relative cursor-pointer rounded-md font-bold text-blue-600 hover:text-blue-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-blue-500">
                                                    Upload files
                                                </span>
                                                <p class="pl-1">or drag and drop</p>
                                            </div>
                                            <p class="text-xs text-gray-500">PNG, JPG up to 10MB</p>
                                        </div>
                                        <input type="file" name="images[]" multiple
                                            class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="bg-gray-50 px-6 py-4 flex flex-col sm:flex-row-reverse gap-3">
                            <button type="submit"
                                class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-3 border border-transparent text-sm font-bold rounded-xl shadow-lg shadow-blue-200 text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7" />
                                </svg>
                                Submit Check-in Log
                            </button>
                            <button type="button" @click="closeModal"
                                class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-3 border border-gray-200 text-sm font-bold rounded-xl text-gray-700 bg-white hover:bg-gray-50 hover:text-gray-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const mapsLinkInput = document.querySelector('input[name="maps_link"]');
            const latitudeInput = document.querySelector('input[name="latitude"]');
            const longitudeInput = document.querySelector('input[name="longitude"]');

            if (mapsLinkInput && latitudeInput && longitudeInput) {
                mapsLinkInput.addEventListener('input', function (e) {
                    const url = e.target.value.trim();
                    if (!url) return;

                    // Extract coordinates from various Google Maps URL formats
                    let lat = null, lng = null;

                    // Format 1: https://maps.google.com/?q=28.7041,77.1025
                    // Format 2: https://www.google.com/maps?q=28.7041,77.1025
                    let match = url.match(/[?&]q=(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                    if (match) {
                        lat = match[1];
                        lng = match[2];
                    }

                    // Format 3: https://maps.app.goo.gl/... or https://goo.gl/maps/...
                    // Format 4: https://www.google.com/maps/@28.7041,77.1025,15z
                    if (!lat) {
                        match = url.match(/@(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                        if (match) {
                            lat = match[1];
                            lng = match[2];
                        }
                    }

                    // Format 5: https://www.google.com/maps/place/.../@28.7041,77.1025
                    if (!lat) {
                        match = url.match(/place\/[^/]+\/@(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                        if (match) {
                            lat = match[1];
                            lng = match[2];
                        }
                    }

                    // Format 6: https://maps.google.com/maps?ll=28.7041,77.1025
                    if (!lat) {
                        match = url.match(/[?&]ll=(-?\d+\.?\d*),(-?\d+\.?\d*)/);
                        if (match) {
                            lat = match[1];
                            lng = match[2];
                        }
                    }

                    // If coordinates found, auto-fill the fields
                    if (lat && lng) {
                        latitudeInput.value = lat;
                        longitudeInput.value = lng;

                        // Visual feedback
                        latitudeInput.classList.add('bg-green-50', 'border-green-300');
                        longitudeInput.classList.add('bg-green-50', 'border-green-300');

                        setTimeout(() => {
                            latitudeInput.classList.remove('bg-green-50', 'border-green-300');
                            longitudeInput.classList.remove('bg-green-50', 'border-green-300');
                        }, 2000);
                    }
                });
            }
        });
    </script>
@endpush