@extends('layouts.public')

@section('content')
    <div class="flex flex-col justify-center py-12 sm:px-6 lg:px-8 min-h-[calc(100vh-5rem)] bg-gray-50">
        <div class="sm:mx-auto sm:w-full sm:max-w-md">
            <div class="flex justify-center mb-6">
                <div
                    class="w-16 h-16 bg-blue-600 rounded-2xl flex items-center justify-center shadow-lg shadow-blue-500/30">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
            </div>
            <h2 class="text-center text-3xl font-extrabold text-gray-900 tracking-tight">Set up Authenticator</h2>
            <p class="mt-2 text-center text-sm text-gray-600 max-w">
                To enhance your account security, please link your account with an Authenticator app (Google Authenticator,
                Microsoft Authenticator, etc.)
            </p>
        </div>

        <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
            <div class="bg-white py-8 px-4 shadow-xl sm:rounded-2xl sm:px-10 border border-gray-100">
                <div class="space-y-6">
                    <div class="flex flex-col items-center">
                        <div class="p-4 bg-gray-50 rounded-xl border-2 border-dashed border-gray-200">
                            {!! $qrCode !!}
                        </div>
                        <p class="mt-4 text-xs font-bold text-gray-400 uppercase tracking-widest">Scan this QR Code</p>
                    </div>

                    <div class="bg-blue-50 p-4 rounded-xl border border-blue-100">
                        <p class="text-[10px] font-black text-blue-600 uppercase mb-1">Manual Entry Key</p>
                        <code class="text-sm font-mono text-blue-900 break-all">{{ $secret }}</code>
                    </div>

                    <form action="{{ route('2fa.storeSetup') }}" method="POST">
                        @csrf
                        <div>
                            <label for="code" class="block text-sm font-bold text-gray-700 mb-2">Verification Code</label>
                            <input id="code" name="code" type="text" required maxlength="6"
                                class="block w-full px-4 py-3 text-center text-2xl font-black tracking-[0.5em] border border-gray-300 rounded-xl shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all placeholder-gray-300"
                                placeholder="000000" autocomplete="one-time-code">
                            @error('code')
                                <p class="mt-2 text-sm text-red-600 font-medium">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mt-6">
                            <button type="submit"
                                class="w-full flex justify-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-sm font-black text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all">
                                Verify & Complete Setup
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="mt-6 text-center">
                <form action="{{ route('logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="text-sm font-medium text-gray-500 hover:text-gray-700 transition-colors">
                        Back to Login
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection