@extends('layouts.user')

@section('title', 'Admin Performance Analytics')
@section('page_title', 'Analytics: ' . $user->name)

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Performance Analytics</h1>
                <p class="text-sm text-gray-500 mt-1">Detailed performance metrics for {{ $user->name }}</p>
            </div>
            <div>
                <span class="text-sm font-medium text-gray-500">Period:</span>
                <select class="ml-2 border-gray-200 rounded-md text-sm shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <option>Last 30 Days</option>
                    <option>Last 3 Months</option>
                    <option>Last Year</option>
                    <option>All Time</option>
                </select>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Stat 1 -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Total Actions</h3>
                    <span class="p-2 bg-blue-50 text-blue-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">1,284</span>
                    <span class="ml-2 text-sm font-medium text-green-600">+12%</span>
                </div>
            </div>

            <!-- Stat 2 -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Login Activity</h3>
                    <span class="p-2 bg-purple-50 text-purple-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1">
                            </path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">45</span>
                    <span class="ml-2 text-sm font-medium text-gray-500">sessions</span>
                </div>
            </div>

            <!-- Stat 3 -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Avg. Response Time</h3>
                    <span class="p-2 bg-amber-50 text-amber-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">2.4m</span>
                    <span class="ml-2 text-sm font-medium text-green-600">-8%</span>
                </div>
            </div>

            <!-- Stat 4 -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-sm font-medium text-gray-500">Efficiency Score</h3>
                    <span class="p-2 bg-emerald-50 text-emerald-600 rounded-lg">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </span>
                </div>
                <div class="flex items-baseline">
                    <span class="text-2xl font-bold text-gray-800">94%</span>
                    <span class="ml-2 text-sm font-medium text-green-600">Excellent</span>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Activity Chart -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Activity Overview</h3>
                <div class="relative h-72">
                    <canvas id="activityChart"></canvas>
                </div>
            </div>

            <!-- Performance Radar -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Performance Metrics</h3>
                <div class="relative h-72">
                    <canvas id="performanceChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Charts Row 2 -->
        <div class="grid grid-cols-1 gap-6">
            <!-- Monthly Trends -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Monthly Action Trends</h3>
                <div class="relative h-72">
                    <canvas id="trendsChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Activity Chart (Bar)
            const ctxActivity = document.getElementById('activityChart').getContext('2d');
            new Chart(ctxActivity, {
                type: 'bar',
                data: {
                    labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                    datasets: [{
                        label: 'Actions Performed',
                        data: [12, 19, 3, 5, 2, 3, 10], // Placeholder data
                        backgroundColor: 'rgba(59, 130, 246, 0.5)',
                        borderColor: 'rgba(59, 130, 246, 1)',
                        borderWidth: 1,
                        borderRadius: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                display: false
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });

            // Performance Chart (Radar)
            const ctxPerformance = document.getElementById('performanceChart').getContext('2d');
            new Chart(ctxPerformance, {
                type: 'radar',
                data: {
                    labels: ['Efficiency', 'Speed', 'Accuracy', 'Availability', 'Communication'],
                    datasets: [{
                        label: 'Current Period',
                        data: [90, 85, 95, 80, 88], // Placeholder data
                        fill: true,
                        backgroundColor: 'rgba(16, 185, 129, 0.2)',
                        borderColor: 'rgb(16, 185, 129)',
                        pointBackgroundColor: 'rgb(16, 185, 129)',
                        pointBorderColor: '#fff',
                        pointHoverBackgroundColor: '#fff',
                        pointHoverBorderColor: 'rgb(16, 185, 129)'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        r: {
                            angleLines: {
                                display: false
                            },
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }
                }
            });

            // Trends Chart (Line)
            const ctxTrends = document.getElementById('trendsChart').getContext('2d');
            new Chart(ctxTrends, {
                type: 'line',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                    datasets: [{
                        label: 'Task Completions',
                        data: [65, 59, 80, 81, 56, 55],
                        fill: true,
                        backgroundColor: 'rgba(99, 102, 241, 0.1)',
                        borderColor: 'rgb(99, 102, 241)',
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                borderDash: [2, 4]
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
        });
    </script>
@endsection