@extends('layouts.admin')

@section('title', 'Edit Uniform')
@section('page_title', 'Edit Uniform')

@section('content')
    <div class="max-w-4xl mx-auto" x-data="{
        variants: {{ $uniform->variants->isEmpty() ? '[{ id: null, size: \'\', color: \'\', stock_quantity: 0 }]' : $uniform->variants->map(fn($v) => ['id' => $v->id, 'size' => $v->size, 'color' => $v->color, 'stock_quantity' => $v->stock_quantity])->toJson() }},
        addVariant() {
            this.variants.push({ id: null, size: '', color: '', stock_quantity: 0 });
        },
        removeVariant(index) {
            if(this.variants.length > 1) {
                this.variants.splice(index, 1);
            } else {
                // If deleting the last one, just clear values
                this.variants[0] = { id: null, size: '', color: '', stock_quantity: 0 };
            }
        }
    }">
        <div class="flex items-center gap-4 mb-8">
            <a href="{{ route('admin.uniforms.index') }}"
                class="p-2 bg-white border border-gray-200 rounded-xl hover:border-gray-300 text-slate-500 hover:text-slate-700 transition-all shadow-sm">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
            </a>
            <div>
                <h1 class="text-3xl font-black text-slate-900 tracking-tight">Edit Uniform</h1>
                <p class="text-slate-500 font-bold mt-1">Update details and manage inventory for {{ $uniform->name }}.</p>
            </div>
        </div>

        <form action="{{ route('admin.uniforms.update', $uniform) }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Base Uniform Details -->
            <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8 mb-8">
                <h2 class="text-xl font-black text-slate-900 mb-6">Uniform Details</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="md:col-span-2">
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Uniform Type
                            Name <span class="text-red-500">*</span></label>
                        <input type="text" name="name" value="{{ old('name', $uniform->name) }}" required
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 font-bold text-slate-900 placeholder-slate-300 transition-all">
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Uniform Code
                            (Optional)</label>
                        <input type="text" name="code" value="{{ old('code', $uniform->code) }}"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 font-bold text-slate-900 placeholder-slate-300 transition-all">
                    </div>
                    <div class="md:col-span-2">
                        <label
                            class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Description</label>
                        <textarea name="description" rows="3"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 font-bold text-slate-900 placeholder-slate-300 transition-all">{{ old('description', $uniform->description) }}</textarea>
                    </div>
                </div>
            </div>

            <!-- Variations -->
            <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8 mb-8">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-xl font-black text-slate-900">Variations & Inventory</h2>
                    <button type="button" @click="addVariant()"
                        class="text-xs font-bold bg-blue-50 text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-100 transition-colors uppercase tracking-wide">
                        + Add Variation
                    </button>
                </div>

                <div class="space-y-4">
                    <template x-for="(variant, index) in variants" :key="index">
                        <div
                            class="grid grid-cols-12 gap-4 items-end bg-slate-50 p-4 rounded-2xl border border-slate-100 relative group">
                            <!-- Hidden ID input for updates -->
                            <input type="hidden" :name="`variants[${index}][id]`" :value="variant.id">

                            <div class="col-span-4 md:col-span-4">
                                <label
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Color</label>
                                <input type="text" :name="`variants[${index}][color]`" x-model="variant.color"
                                    class="w-full px-3 py-2 bg-white border border-slate-200 rounded-lg focus:outline-none focus:border-blue-500 text-sm font-bold text-slate-800">
                            </div>
                            <div class="col-span-4 md:col-span-4">
                                <label
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Size</label>
                                <input type="text" :name="`variants[${index}][size]`" x-model="variant.size"
                                    class="w-full px-3 py-2 bg-white border border-slate-200 rounded-lg focus:outline-none focus:border-blue-500 text-sm font-bold text-slate-800">
                            </div>
                            <div class="col-span-3 md:col-span-3">
                                <label
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-wider mb-1">Stock</label>
                                <input type="number" :name="`variants[${index}][stock_quantity]`"
                                    x-model="variant.stock_quantity" min="0"
                                    class="w-full px-3 py-2 bg-white border border-slate-200 rounded-lg focus:outline-none focus:border-blue-500 text-sm font-bold text-slate-800">
                            </div>
                            <div class="col-span-1 md:col-span-1 text-center">
                                <button type="button" @click="removeVariant(index)"
                                    class="p-2 text-slate-400 hover:text-red-500 hover:bg-red-50 rounded-lg transition-all"
                                    title="Remove Variation">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </template>
                </div>
                <p class="text-xs text-slate-400 mt-4 font-medium italic">Removing a row and saving will delete that
                    variation.</p>
            </div>

            <div class="flex justify-end gap-4">
                <a href="{{ route('admin.uniforms.index') }}"
                    class="px-8 py-4 bg-white border border-gray-200 text-slate-600 font-bold rounded-xl hover:bg-gray-50 transition-all uppercase tracking-wider text-sm shadow-sm">Cancel</a>
                <button type="submit"
                    class="px-8 py-4 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/30 uppercase tracking-wider text-sm transform hover:-translate-y-0.5">Update
                    Uniform</button>
            </div>
        </form>
    </div>
@endsection